/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.pop.ssme.SignalNaming;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.pop.ssme.SignalNaming} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SignalNamingItemProvider
	extends SignalElementItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalNamingItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addIdentifierPropertyDescriptor(object);
			addInitValuePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Identifier feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdentifierPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SignalNaming_identifier_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SignalNaming_identifier_feature", "_UI_SignalNaming_type"),
				 SsmePackage.eINSTANCE.getSignalNaming_Identifier(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Init Value feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addInitValuePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SignalNaming_initValue_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SignalNaming_initValue_feature", "_UI_SignalNaming_type"),
				 SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(SsmePackage.eINSTANCE.getSignalNaming_Identifier());
			childrenFeatures.add(SsmePackage.eINSTANCE.getSignalNaming_InitValue());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns SignalNaming.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/SignalNaming"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_SignalNaming_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(SignalNaming.class)) {
			case SsmePackage.SIGNAL_NAMING__IDENTIFIER:
			case SsmePackage.SIGNAL_NAMING__INIT_VALUE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_Identifier(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createAfter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createAnd()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createArrayElem()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createArrayElementsEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createArrayProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createArrayRestructuration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createAssertSignal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createCartesianProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createCell()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createClockDifference()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createClockProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createClockUnion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createComplexConstructor()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConcatenation()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantCharacter()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantDoubleReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantEnum()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantInteger()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantLogical()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConstantReal()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createConversion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createCount()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createDefault()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createDelay()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createDiv()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createElemDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createEqualEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createFieldAccess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createFrom()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createGreater()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createGreaterOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createIdentifier()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createIfThenElse()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createIndex()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createLess()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createLessLessEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createLessOrEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createListFlows()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createModulo()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createNot()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createNotEqual()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createNullClock()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createOr()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createPower()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createPreviousIterationRef()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createProcessCall()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createProcessExpansion()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createProduct()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createRecover()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createRepetition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createSequentialDefinition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createStateVariableValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createStringValue()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createTransposition()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createUnaryMinus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createUnaryPlus()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createUnaryWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createVar()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createWhen()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createWindow()));

		newChildDescriptors.add
			(createChildParameter
				(SsmePackage.eINSTANCE.getSignalNaming_InitValue(),
				 SsmeFactory.eINSTANCE.createXor()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPre() ||
			childFeature == SsmePackage.eINSTANCE.getSignalElement_CommentPost() ||
			childFeature == SsmePackage.eINSTANCE.getSignalNaming_Identifier() ||
			childFeature == SsmePackage.eINSTANCE.getSignalNaming_InitValue();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2",
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
