/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.pop.ssme.util.SsmeAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SsmeItemProviderAdapterFactory extends SsmeAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmeItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.After} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AfterItemProvider afterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.After}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAfterAdapter() {
		if (afterItemProvider == null) {
			afterItemProvider = new AfterItemProvider(this);
		}

		return afterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.And} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AndItemProvider andItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.And}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAndAdapter() {
		if (andItemProvider == null) {
			andItemProvider = new AndItemProvider(this);
		}

		return andItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayElem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayElemItemProvider arrayElemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayElem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayElemAdapter() {
		if (arrayElemItemProvider == null) {
			arrayElemItemProvider = new ArrayElemItemProvider(this);
		}

		return arrayElemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayElementsEnumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayElementsEnumerationItemProvider arrayElementsEnumerationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayElementsEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayElementsEnumerationAdapter() {
		if (arrayElementsEnumerationItemProvider == null) {
			arrayElementsEnumerationItemProvider = new ArrayElementsEnumerationItemProvider(this);
		}

		return arrayElementsEnumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayIndex} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayIndexItemProvider arrayIndexItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayIndex}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayIndexAdapter() {
		if (arrayIndexItemProvider == null) {
			arrayIndexItemProvider = new ArrayIndexItemProvider(this);
		}

		return arrayIndexItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayProcessItemProvider arrayProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayProcessAdapter() {
		if (arrayProcessItemProvider == null) {
			arrayProcessItemProvider = new ArrayProcessItemProvider(this);
		}

		return arrayProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayProduct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayProductItemProvider arrayProductItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayProduct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayProductAdapter() {
		if (arrayProductItemProvider == null) {
			arrayProductItemProvider = new ArrayProductItemProvider(this);
		}

		return arrayProductItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayRestructuration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayRestructurationItemProvider arrayRestructurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayRestructuration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayRestructurationAdapter() {
		if (arrayRestructurationItemProvider == null) {
			arrayRestructurationItemProvider = new ArrayRestructurationItemProvider(this);
		}

		return arrayRestructurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ArrayType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayTypeItemProvider arrayTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ArrayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayTypeAdapter() {
		if (arrayTypeItemProvider == null) {
			arrayTypeItemProvider = new ArrayTypeItemProvider(this);
		}

		return arrayTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.AssertProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssertProcessItemProvider assertProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.AssertProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssertProcessAdapter() {
		if (assertProcessItemProvider == null) {
			assertProcessItemProvider = new AssertProcessItemProvider(this);
		}

		return assertProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.AssertSignal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssertSignalItemProvider assertSignalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.AssertSignal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssertSignalAdapter() {
		if (assertSignalItemProvider == null) {
			assertSignalItemProvider = new AssertSignalItemProvider(this);
		}

		return assertSignalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Bounds} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoundsItemProvider boundsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Bounds}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBoundsAdapter() {
		if (boundsItemProvider == null) {
			boundsItemProvider = new BoundsItemProvider(this);
		}

		return boundsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.CartesianProduct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CartesianProductItemProvider cartesianProductItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.CartesianProduct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCartesianProductAdapter() {
		if (cartesianProductItemProvider == null) {
			cartesianProductItemProvider = new CartesianProductItemProvider(this);
		}

		return cartesianProductItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.CaseEnumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseEnumerationItemProvider caseEnumerationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.CaseEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCaseEnumerationAdapter() {
		if (caseEnumerationItemProvider == null) {
			caseEnumerationItemProvider = new CaseEnumerationItemProvider(this);
		}

		return caseEnumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.CaseInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseIntervalItemProvider caseIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.CaseInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCaseIntervalAdapter() {
		if (caseIntervalItemProvider == null) {
			caseIntervalItemProvider = new CaseIntervalItemProvider(this);
		}

		return caseIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.CaseProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseProcessItemProvider caseProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.CaseProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCaseProcessAdapter() {
		if (caseProcessItemProvider == null) {
			caseProcessItemProvider = new CaseProcessItemProvider(this);
		}

		return caseProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.CaseBranch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CaseBranchItemProvider caseBranchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.CaseBranch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCaseBranchAdapter() {
		if (caseBranchItemProvider == null) {
			caseBranchItemProvider = new CaseBranchItemProvider(this);
		}

		return caseBranchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Cell} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CellItemProvider cellItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Cell}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCellAdapter() {
		if (cellItemProvider == null) {
			cellItemProvider = new CellItemProvider(this);
		}

		return cellItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Clock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockItemProvider clockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Clock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockAdapter() {
		if (clockItemProvider == null) {
			clockItemProvider = new ClockItemProvider(this);
		}

		return clockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockDifference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockDifferenceItemProvider clockDifferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockDifference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockDifferenceAdapter() {
		if (clockDifferenceItemProvider == null) {
			clockDifferenceItemProvider = new ClockDifferenceItemProvider(this);
		}

		return clockDifferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockEquality} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockEqualityItemProvider clockEqualityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockEquality}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockEqualityAdapter() {
		if (clockEqualityItemProvider == null) {
			clockEqualityItemProvider = new ClockEqualityItemProvider(this);
		}

		return clockEqualityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockExclusiveRelation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockExclusiveRelationItemProvider clockExclusiveRelationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockExclusiveRelation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockExclusiveRelationAdapter() {
		if (clockExclusiveRelationItemProvider == null) {
			clockExclusiveRelationItemProvider = new ClockExclusiveRelationItemProvider(this);
		}

		return clockExclusiveRelationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockInfRelation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockInfRelationItemProvider clockInfRelationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockInfRelation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockInfRelationAdapter() {
		if (clockInfRelationItemProvider == null) {
			clockInfRelationItemProvider = new ClockInfRelationItemProvider(this);
		}

		return clockInfRelationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockProduct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockProductItemProvider clockProductItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockProduct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockProductAdapter() {
		if (clockProductItemProvider == null) {
			clockProductItemProvider = new ClockProductItemProvider(this);
		}

		return clockProductItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockSupRelation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockSupRelationItemProvider clockSupRelationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockSupRelation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockSupRelationAdapter() {
		if (clockSupRelationItemProvider == null) {
			clockSupRelationItemProvider = new ClockSupRelationItemProvider(this);
		}

		return clockSupRelationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ClockUnion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockUnionItemProvider clockUnionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ClockUnion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockUnionAdapter() {
		if (clockUnionItemProvider == null) {
			clockUnionItemProvider = new ClockUnionItemProvider(this);
		}

		return clockUnionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Comment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentItemProvider commentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Comment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentAdapter() {
		if (commentItemProvider == null) {
			commentItemProvider = new CommentItemProvider(this);
		}

		return commentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ComplexConstructor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplexConstructorItemProvider complexConstructorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ComplexConstructor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplexConstructorAdapter() {
		if (complexConstructorItemProvider == null) {
			complexConstructorItemProvider = new ComplexConstructorItemProvider(this);
		}

		return complexConstructorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Composition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositionItemProvider compositionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Composition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositionAdapter() {
		if (compositionItemProvider == null) {
			compositionItemProvider = new CompositionItemProvider(this);
		}

		return compositionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Concatenation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConcatenationItemProvider concatenationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Concatenation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConcatenationAdapter() {
		if (concatenationItemProvider == null) {
			concatenationItemProvider = new ConcatenationItemProvider(this);
		}

		return concatenationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConditionedDependence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionedDependenceItemProvider conditionedDependenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConditionedDependence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionedDependenceAdapter() {
		if (conditionedDependenceItemProvider == null) {
			conditionedDependenceItemProvider = new ConditionedDependenceItemProvider(this);
		}

		return conditionedDependenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantCharacter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantCharacterItemProvider constantCharacterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantCharacter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantCharacterAdapter() {
		if (constantCharacterItemProvider == null) {
			constantCharacterItemProvider = new ConstantCharacterItemProvider(this);
		}

		return constantCharacterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantDescriptionItemProvider constantDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantDescriptionAdapter() {
		if (constantDescriptionItemProvider == null) {
			constantDescriptionItemProvider = new ConstantDescriptionItemProvider(this);
		}

		return constantDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantDoubleReal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantDoubleRealItemProvider constantDoubleRealItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantDoubleReal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantDoubleRealAdapter() {
		if (constantDoubleRealItemProvider == null) {
			constantDoubleRealItemProvider = new ConstantDoubleRealItemProvider(this);
		}

		return constantDoubleRealItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantEnum} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantEnumItemProvider constantEnumItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantEnum}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantEnumAdapter() {
		if (constantEnumItemProvider == null) {
			constantEnumItemProvider = new ConstantEnumItemProvider(this);
		}

		return constantEnumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantInteger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantIntegerItemProvider constantIntegerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantInteger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantIntegerAdapter() {
		if (constantIntegerItemProvider == null) {
			constantIntegerItemProvider = new ConstantIntegerItemProvider(this);
		}

		return constantIntegerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantLogical} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantLogicalItemProvider constantLogicalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantLogical}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantLogicalAdapter() {
		if (constantLogicalItemProvider == null) {
			constantLogicalItemProvider = new ConstantLogicalItemProvider(this);
		}

		return constantLogicalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantReal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantRealItemProvider constantRealItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantReal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantRealAdapter() {
		if (constantRealItemProvider == null) {
			constantRealItemProvider = new ConstantRealItemProvider(this);
		}

		return constantRealItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantsDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantsDeclarationItemProvider constantsDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantsDeclarationAdapter() {
		if (constantsDeclarationItemProvider == null) {
			constantsDeclarationItemProvider = new ConstantsDeclarationItemProvider(this);
		}

		return constantsDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ConstantString} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantStringItemProvider constantStringItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ConstantString}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantStringAdapter() {
		if (constantStringItemProvider == null) {
			constantStringItemProvider = new ConstantStringItemProvider(this);
		}

		return constantStringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Conversion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConversionItemProvider conversionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Conversion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConversionAdapter() {
		if (conversionItemProvider == null) {
			conversionItemProvider = new ConversionItemProvider(this);
		}

		return conversionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Count} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CountItemProvider countItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Count}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCountAdapter() {
		if (countItemProvider == null) {
			countItemProvider = new CountItemProvider(this);
		}

		return countItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Default} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultItemProvider defaultItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Default}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultAdapter() {
		if (defaultItemProvider == null) {
			defaultItemProvider = new DefaultItemProvider(this);
		}

		return defaultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Delay} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelayItemProvider delayItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Delay}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelayAdapter() {
		if (delayItemProvider == null) {
			delayItemProvider = new DelayItemProvider(this);
		}

		return delayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Description} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescriptionItemProvider descriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Description}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDescriptionAdapter() {
		if (descriptionItemProvider == null) {
			descriptionItemProvider = new DescriptionItemProvider(this);
		}

		return descriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Div} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DivItemProvider divItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Div}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDivAdapter() {
		if (divItemProvider == null) {
			divItemProvider = new DivItemProvider(this);
		}

		return divItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ElemDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElemDefinitionItemProvider elemDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ElemDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElemDefinitionAdapter() {
		if (elemDefinitionItemProvider == null) {
			elemDefinitionItemProvider = new ElemDefinitionItemProvider(this);
		}

		return elemDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ElemDefinitionEnumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElemDefinitionEnumerationItemProvider elemDefinitionEnumerationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ElemDefinitionEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElemDefinitionEnumerationAdapter() {
		if (elemDefinitionEnumerationItemProvider == null) {
			elemDefinitionEnumerationItemProvider = new ElemDefinitionEnumerationItemProvider(this);
		}

		return elemDefinitionEnumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.EnumerationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumerationTypeItemProvider enumerationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.EnumerationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumerationTypeAdapter() {
		if (enumerationTypeItemProvider == null) {
			enumerationTypeItemProvider = new EnumerationTypeItemProvider(this);
		}

		return enumerationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Equal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EqualItemProvider equalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Equal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEqualAdapter() {
		if (equalItemProvider == null) {
			equalItemProvider = new EqualItemProvider(this);
		}

		return equalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.EqualEqual} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EqualEqualItemProvider equalEqualItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.EqualEqual}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEqualEqualAdapter() {
		if (equalEqualItemProvider == null) {
			equalEqualItemProvider = new EqualEqualItemProvider(this);
		}

		return equalEqualItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ExternalAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalAttributeItemProvider externalAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ExternalAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalAttributeAdapter() {
		if (externalAttributeItemProvider == null) {
			externalAttributeItemProvider = new ExternalAttributeItemProvider(this);
		}

		return externalAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ExternalGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalGraphItemProvider externalGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ExternalGraph}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalGraphAdapter() {
		if (externalGraphItemProvider == null) {
			externalGraphItemProvider = new ExternalGraphItemProvider(this);
		}

		return externalGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ExternalReferences} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalReferencesItemProvider externalReferencesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ExternalReferences}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalReferencesAdapter() {
		if (externalReferencesItemProvider == null) {
			externalReferencesItemProvider = new ExternalReferencesItemProvider(this);
		}

		return externalReferencesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.FieldAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldAccessItemProvider fieldAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.FieldAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFieldAccessAdapter() {
		if (fieldAccessItemProvider == null) {
			fieldAccessItemProvider = new FieldAccessItemProvider(this);
		}

		return fieldAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.FormalProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FormalProcessItemProvider formalProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.FormalProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFormalProcessAdapter() {
		if (formalProcessItemProvider == null) {
			formalProcessItemProvider = new FormalProcessItemProvider(this);
		}

		return formalProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.From} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FromItemProvider fromItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.From}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFromAdapter() {
		if (fromItemProvider == null) {
			fromItemProvider = new FromItemProvider(this);
		}

		return fromItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.GraphSpecification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GraphSpecificationItemProvider graphSpecificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.GraphSpecification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGraphSpecificationAdapter() {
		if (graphSpecificationItemProvider == null) {
			graphSpecificationItemProvider = new GraphSpecificationItemProvider(this);
		}

		return graphSpecificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Greater} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GreaterItemProvider greaterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Greater}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGreaterAdapter() {
		if (greaterItemProvider == null) {
			greaterItemProvider = new GreaterItemProvider(this);
		}

		return greaterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.GreaterOrEqual} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GreaterOrEqualItemProvider greaterOrEqualItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.GreaterOrEqual}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGreaterOrEqualAdapter() {
		if (greaterOrEqualItemProvider == null) {
			greaterOrEqualItemProvider = new GreaterOrEqualItemProvider(this);
		}

		return greaterOrEqualItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Identifier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierItemProvider identifierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Identifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIdentifierAdapter() {
		if (identifierItemProvider == null) {
			identifierItemProvider = new IdentifierItemProvider(this);
		}

		return identifierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.IdentityEquation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentityEquationItemProvider identityEquationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.IdentityEquation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIdentityEquationAdapter() {
		if (identityEquationItemProvider == null) {
			identityEquationItemProvider = new IdentityEquationItemProvider(this);
		}

		return identityEquationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.IfThenElse} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfThenElseItemProvider ifThenElseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.IfThenElse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfThenElseAdapter() {
		if (ifThenElseItemProvider == null) {
			ifThenElseItemProvider = new IfThenElseItemProvider(this);
		}

		return ifThenElseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Index} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IndexItemProvider indexItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Index}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIndexAdapter() {
		if (indexItemProvider == null) {
			indexItemProvider = new IndexItemProvider(this);
		}

		return indexItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.IOProfile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IOProfileItemProvider ioProfileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.IOProfile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIOProfileAdapter() {
		if (ioProfileItemProvider == null) {
			ioProfileItemProvider = new IOProfileItemProvider(this);
		}

		return ioProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Iteration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterationItemProvider iterationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Iteration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIterationAdapter() {
		if (iterationItemProvider == null) {
			iterationItemProvider = new IterationItemProvider(this);
		}

		return iterationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.IterationProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterationProcessItemProvider iterationProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.IterationProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIterationProcessAdapter() {
		if (iterationProcessItemProvider == null) {
			iterationProcessItemProvider = new IterationProcessItemProvider(this);
		}

		return iterationProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.LabelledProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelledProcessItemProvider labelledProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.LabelledProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelledProcessAdapter() {
		if (labelledProcessItemProvider == null) {
			labelledProcessItemProvider = new LabelledProcessItemProvider(this);
		}

		return labelledProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Labels} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelsItemProvider labelsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Labels}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelsAdapter() {
		if (labelsItemProvider == null) {
			labelsItemProvider = new LabelsItemProvider(this);
		}

		return labelsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Less} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LessItemProvider lessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Less}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLessAdapter() {
		if (lessItemProvider == null) {
			lessItemProvider = new LessItemProvider(this);
		}

		return lessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.LessLessEqual} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LessLessEqualItemProvider lessLessEqualItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.LessLessEqual}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLessLessEqualAdapter() {
		if (lessLessEqualItemProvider == null) {
			lessLessEqualItemProvider = new LessLessEqualItemProvider(this);
		}

		return lessLessEqualItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.LessOrEqual} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LessOrEqualItemProvider lessOrEqualItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.LessOrEqual}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLessOrEqualAdapter() {
		if (lessOrEqualItemProvider == null) {
			lessOrEqualItemProvider = new LessOrEqualItemProvider(this);
		}

		return lessOrEqualItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ListExprSignal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListExprSignalItemProvider listExprSignalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ListExprSignal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListExprSignalAdapter() {
		if (listExprSignalItemProvider == null) {
			listExprSignalItemProvider = new ListExprSignalItemProvider(this);
		}

		return listExprSignalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ListFlows} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListFlowsItemProvider listFlowsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ListFlows}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListFlowsAdapter() {
		if (listFlowsItemProvider == null) {
			listFlowsItemProvider = new ListFlowsItemProvider(this);
		}

		return listFlowsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ListModule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListModuleItemProvider listModuleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ListModule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListModuleAdapter() {
		if (listModuleItemProvider == null) {
			listModuleItemProvider = new ListModuleItemProvider(this);
		}

		return listModuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Masking} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaskingItemProvider maskingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Masking}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaskingAdapter() {
		if (maskingItemProvider == null) {
			maskingItemProvider = new MaskingItemProvider(this);
		}

		return maskingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Minus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MinusItemProvider minusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Minus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMinusAdapter() {
		if (minusItemProvider == null) {
			minusItemProvider = new MinusItemProvider(this);
		}

		return minusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Module} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleItemProvider moduleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Module}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ModuleDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleDescriptionItemProvider moduleDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ModuleDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleDescriptionAdapter() {
		if (moduleDescriptionItemProvider == null) {
			moduleDescriptionItemProvider = new ModuleDescriptionItemProvider(this);
		}

		return moduleDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ModulesImport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModulesImportItemProvider modulesImportItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ModulesImport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModulesImportAdapter() {
		if (modulesImportItemProvider == null) {
			modulesImportItemProvider = new ModulesImportItemProvider(this);
		}

		return modulesImportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Modulo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuloItemProvider moduloItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Modulo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuloAdapter() {
		if (moduloItemProvider == null) {
			moduloItemProvider = new ModuloItemProvider(this);
		}

		return moduloItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Not} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotItemProvider notItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Not}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNotAdapter() {
		if (notItemProvider == null) {
			notItemProvider = new NotItemProvider(this);
		}

		return notItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.NotEqual} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotEqualItemProvider notEqualItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.NotEqual}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNotEqualAdapter() {
		if (notEqualItemProvider == null) {
			notEqualItemProvider = new NotEqualItemProvider(this);
		}

		return notEqualItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.NullClock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullClockItemProvider nullClockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.NullClock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullClockAdapter() {
		if (nullClockItemProvider == null) {
			nullClockItemProvider = new NullClockItemProvider(this);
		}

		return nullClockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.NullProc} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullProcItemProvider nullProcItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.NullProc}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullProcAdapter() {
		if (nullProcItemProvider == null) {
			nullProcItemProvider = new NullProcItemProvider(this);
		}

		return nullProcItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Operator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperatorItemProvider operatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Operator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperatorAdapter() {
		if (operatorItemProvider == null) {
			operatorItemProvider = new OperatorItemProvider(this);
		}

		return operatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.OperatorModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperatorModelItemProvider operatorModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.OperatorModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperatorModelAdapter() {
		if (operatorModelItemProvider == null) {
			operatorModelItemProvider = new OperatorModelItemProvider(this);
		}

		return operatorModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Or} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrItemProvider orItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Or}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrAdapter() {
		if (orItemProvider == null) {
			orItemProvider = new OrItemProvider(this);
		}

		return orItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.PartialIteration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartialIterationItemProvider partialIterationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.PartialIteration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartialIterationAdapter() {
		if (partialIterationItemProvider == null) {
			partialIterationItemProvider = new PartialIterationItemProvider(this);
		}

		return partialIterationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Plus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlusItemProvider plusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Plus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlusAdapter() {
		if (plusItemProvider == null) {
			plusItemProvider = new PlusItemProvider(this);
		}

		return plusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Power} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PowerItemProvider powerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Power}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPowerAdapter() {
		if (powerItemProvider == null) {
			powerItemProvider = new PowerItemProvider(this);
		}

		return powerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Pragma} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PragmaItemProvider pragmaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Pragma}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPragmaAdapter() {
		if (pragmaItemProvider == null) {
			pragmaItemProvider = new PragmaItemProvider(this);
		}

		return pragmaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.PredefinedType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PredefinedTypeItemProvider predefinedTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.PredefinedType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPredefinedTypeAdapter() {
		if (predefinedTypeItemProvider == null) {
			predefinedTypeItemProvider = new PredefinedTypeItemProvider(this);
		}

		return predefinedTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.PreviousIterationRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PreviousIterationRefItemProvider previousIterationRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.PreviousIterationRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPreviousIterationRefAdapter() {
		if (previousIterationRefItemProvider == null) {
			previousIterationRefItemProvider = new PreviousIterationRefItemProvider(this);
		}

		return previousIterationRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessAttributeItemProvider processAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessAttributeAdapter() {
		if (processAttributeItemProvider == null) {
			processAttributeItemProvider = new ProcessAttributeItemProvider(this);
		}

		return processAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessCallItemProvider processCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessCallAdapter() {
		if (processCallItemProvider == null) {
			processCallItemProvider = new ProcessCallItemProvider(this);
		}

		return processCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessExpansion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessExpansionItemProvider processExpansionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessExpansion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessExpansionAdapter() {
		if (processExpansionItemProvider == null) {
			processExpansionItemProvider = new ProcessExpansionItemProvider(this);
		}

		return processExpansionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessModelItemProvider processModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessModelAdapter() {
		if (processModelItemProvider == null) {
			processModelItemProvider = new ProcessModelItemProvider(this);
		}

		return processModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessModelInterface} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessModelInterfaceItemProvider processModelInterfaceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessModelInterface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessModelInterfaceAdapter() {
		if (processModelInterfaceItemProvider == null) {
			processModelInterfaceItemProvider = new ProcessModelInterfaceItemProvider(this);
		}

		return processModelInterfaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.ProcessType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessTypeItemProvider processTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.ProcessType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessTypeAdapter() {
		if (processTypeItemProvider == null) {
			processTypeItemProvider = new ProcessTypeItemProvider(this);
		}

		return processTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Product} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProductItemProvider productItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Product}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProductAdapter() {
		if (productItemProvider == null) {
			productItemProvider = new ProductItemProvider(this);
		}

		return productItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Recover} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RecoverItemProvider recoverItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Recover}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRecoverAdapter() {
		if (recoverItemProvider == null) {
			recoverItemProvider = new RecoverItemProvider(this);
		}

		return recoverItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Repetition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepetitionItemProvider repetitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Repetition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRepetitionAdapter() {
		if (repetitionItemProvider == null) {
			repetitionItemProvider = new RepetitionItemProvider(this);
		}

		return repetitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.RestrictionProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RestrictionProcessItemProvider restrictionProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.RestrictionProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRestrictionProcessAdapter() {
		if (restrictionProcessItemProvider == null) {
			restrictionProcessItemProvider = new RestrictionProcessItemProvider(this);
		}

		return restrictionProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SequentialDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequentialDefinitionItemProvider sequentialDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SequentialDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequentialDefinitionAdapter() {
		if (sequentialDefinitionItemProvider == null) {
			sequentialDefinitionItemProvider = new SequentialDefinitionItemProvider(this);
		}

		return sequentialDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SharedVariablesDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SharedVariablesDeclarationItemProvider sharedVariablesDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SharedVariablesDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSharedVariablesDeclarationAdapter() {
		if (sharedVariablesDeclarationItemProvider == null) {
			sharedVariablesDeclarationItemProvider = new SharedVariablesDeclarationItemProvider(this);
		}

		return sharedVariablesDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalElementItemProvider signalElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalElementAdapter() {
		if (signalElementItemProvider == null) {
			signalElementItemProvider = new SignalElementItemProvider(this);
		}

		return signalElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalNaming} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalNamingItemProvider signalNamingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalNaming}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalNamingAdapter() {
		if (signalNamingItemProvider == null) {
			signalNamingItemProvider = new SignalNamingItemProvider(this);
		}

		return signalNamingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Signals} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalsItemProvider signalsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Signals}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsAdapter() {
		if (signalsItemProvider == null) {
			signalsItemProvider = new SignalsItemProvider(this);
		}

		return signalsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalsDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalsDeclarationItemProvider signalsDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsDeclarationAdapter() {
		if (signalsDeclarationItemProvider == null) {
			signalsDeclarationItemProvider = new SignalsDeclarationItemProvider(this);
		}

		return signalsDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalsDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalsDefinitionItemProvider signalsDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalsDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsDefinitionAdapter() {
		if (signalsDefinitionItemProvider == null) {
			signalsDefinitionItemProvider = new SignalsDefinitionItemProvider(this);
		}

		return signalsDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalsPartialDefaultDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalsPartialDefaultDefinitionItemProvider signalsPartialDefaultDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalsPartialDefaultDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsPartialDefaultDefinitionAdapter() {
		if (signalsPartialDefaultDefinitionItemProvider == null) {
			signalsPartialDefaultDefinitionItemProvider = new SignalsPartialDefaultDefinitionItemProvider(this);
		}

		return signalsPartialDefaultDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.SignalsPartialDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalsPartialDefinitionItemProvider signalsPartialDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.SignalsPartialDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsPartialDefinitionAdapter() {
		if (signalsPartialDefinitionItemProvider == null) {
			signalsPartialDefinitionItemProvider = new SignalsPartialDefinitionItemProvider(this);
		}

		return signalsPartialDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.StateVariablesDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateVariablesDeclarationItemProvider stateVariablesDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.StateVariablesDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateVariablesDeclarationAdapter() {
		if (stateVariablesDeclarationItemProvider == null) {
			stateVariablesDeclarationItemProvider = new StateVariablesDeclarationItemProvider(this);
		}

		return stateVariablesDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.StateVariableValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateVariableValueItemProvider stateVariableValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.StateVariableValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateVariableValueAdapter() {
		if (stateVariableValueItemProvider == null) {
			stateVariableValueItemProvider = new StateVariableValueItemProvider(this);
		}

		return stateVariableValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.StringValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringValueItemProvider stringValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.StringValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringValueAdapter() {
		if (stringValueItemProvider == null) {
			stringValueItemProvider = new StringValueItemProvider(this);
		}

		return stringValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Transposition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TranspositionItemProvider transpositionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Transposition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTranspositionAdapter() {
		if (transpositionItemProvider == null) {
			transpositionItemProvider = new TranspositionItemProvider(this);
		}

		return transpositionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.TupleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleTypeItemProvider tupleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.TupleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleTypeAdapter() {
		if (tupleTypeItemProvider == null) {
			tupleTypeItemProvider = new TupleTypeItemProvider(this);
		}

		return tupleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.TypeDescription} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeDescriptionItemProvider typeDescriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.TypeDescription}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeDescriptionAdapter() {
		if (typeDescriptionItemProvider == null) {
			typeDescriptionItemProvider = new TypeDescriptionItemProvider(this);
		}

		return typeDescriptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.TypeMorphism} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeMorphismItemProvider typeMorphismItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.TypeMorphism}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeMorphismAdapter() {
		if (typeMorphismItemProvider == null) {
			typeMorphismItemProvider = new TypeMorphismItemProvider(this);
		}

		return typeMorphismItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.TypesDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypesDeclarationItemProvider typesDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.TypesDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypesDeclarationAdapter() {
		if (typesDeclarationItemProvider == null) {
			typesDeclarationItemProvider = new TypesDeclarationItemProvider(this);
		}

		return typesDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.UnaryMinus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnaryMinusItemProvider unaryMinusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.UnaryMinus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnaryMinusAdapter() {
		if (unaryMinusItemProvider == null) {
			unaryMinusItemProvider = new UnaryMinusItemProvider(this);
		}

		return unaryMinusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.UnaryPlus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnaryPlusItemProvider unaryPlusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.UnaryPlus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnaryPlusAdapter() {
		if (unaryPlusItemProvider == null) {
			unaryPlusItemProvider = new UnaryPlusItemProvider(this);
		}

		return unaryPlusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.UnaryWhen} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnaryWhenItemProvider unaryWhenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.UnaryWhen}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnaryWhenAdapter() {
		if (unaryWhenItemProvider == null) {
			unaryWhenItemProvider = new UnaryWhenItemProvider(this);
		}

		return unaryWhenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.UnconditionedDependences} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnconditionedDependencesItemProvider unconditionedDependencesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.UnconditionedDependences}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnconditionedDependencesAdapter() {
		if (unconditionedDependencesItemProvider == null) {
			unconditionedDependencesItemProvider = new UnconditionedDependencesItemProvider(this);
		}

		return unconditionedDependencesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Var} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VarItemProvider varItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Var}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVarAdapter() {
		if (varItemProvider == null) {
			varItemProvider = new VarItemProvider(this);
		}

		return varItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.When} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WhenItemProvider whenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.When}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWhenAdapter() {
		if (whenItemProvider == null) {
			whenItemProvider = new WhenItemProvider(this);
		}

		return whenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Window} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WindowItemProvider windowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Window}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWindowAdapter() {
		if (windowItemProvider == null) {
			windowItemProvider = new WindowItemProvider(this);
		}

		return windowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.pop.ssme.Xor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XorItemProvider xorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.pop.ssme.Xor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXorAdapter() {
		if (xorItemProvider == null) {
			xorItemProvider = new XorItemProvider(this);
		}

		return xorItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (afterItemProvider != null) afterItemProvider.dispose();
		if (andItemProvider != null) andItemProvider.dispose();
		if (arrayElemItemProvider != null) arrayElemItemProvider.dispose();
		if (arrayElementsEnumerationItemProvider != null) arrayElementsEnumerationItemProvider.dispose();
		if (arrayIndexItemProvider != null) arrayIndexItemProvider.dispose();
		if (arrayProcessItemProvider != null) arrayProcessItemProvider.dispose();
		if (arrayProductItemProvider != null) arrayProductItemProvider.dispose();
		if (arrayRestructurationItemProvider != null) arrayRestructurationItemProvider.dispose();
		if (arrayTypeItemProvider != null) arrayTypeItemProvider.dispose();
		if (assertProcessItemProvider != null) assertProcessItemProvider.dispose();
		if (assertSignalItemProvider != null) assertSignalItemProvider.dispose();
		if (boundsItemProvider != null) boundsItemProvider.dispose();
		if (cartesianProductItemProvider != null) cartesianProductItemProvider.dispose();
		if (caseEnumerationItemProvider != null) caseEnumerationItemProvider.dispose();
		if (caseIntervalItemProvider != null) caseIntervalItemProvider.dispose();
		if (caseProcessItemProvider != null) caseProcessItemProvider.dispose();
		if (caseBranchItemProvider != null) caseBranchItemProvider.dispose();
		if (cellItemProvider != null) cellItemProvider.dispose();
		if (clockItemProvider != null) clockItemProvider.dispose();
		if (clockDifferenceItemProvider != null) clockDifferenceItemProvider.dispose();
		if (clockEqualityItemProvider != null) clockEqualityItemProvider.dispose();
		if (clockExclusiveRelationItemProvider != null) clockExclusiveRelationItemProvider.dispose();
		if (clockInfRelationItemProvider != null) clockInfRelationItemProvider.dispose();
		if (clockProductItemProvider != null) clockProductItemProvider.dispose();
		if (clockSupRelationItemProvider != null) clockSupRelationItemProvider.dispose();
		if (clockUnionItemProvider != null) clockUnionItemProvider.dispose();
		if (commentItemProvider != null) commentItemProvider.dispose();
		if (complexConstructorItemProvider != null) complexConstructorItemProvider.dispose();
		if (compositionItemProvider != null) compositionItemProvider.dispose();
		if (concatenationItemProvider != null) concatenationItemProvider.dispose();
		if (conditionedDependenceItemProvider != null) conditionedDependenceItemProvider.dispose();
		if (constantCharacterItemProvider != null) constantCharacterItemProvider.dispose();
		if (constantDescriptionItemProvider != null) constantDescriptionItemProvider.dispose();
		if (constantDoubleRealItemProvider != null) constantDoubleRealItemProvider.dispose();
		if (constantEnumItemProvider != null) constantEnumItemProvider.dispose();
		if (constantIntegerItemProvider != null) constantIntegerItemProvider.dispose();
		if (constantLogicalItemProvider != null) constantLogicalItemProvider.dispose();
		if (constantRealItemProvider != null) constantRealItemProvider.dispose();
		if (constantsDeclarationItemProvider != null) constantsDeclarationItemProvider.dispose();
		if (constantStringItemProvider != null) constantStringItemProvider.dispose();
		if (conversionItemProvider != null) conversionItemProvider.dispose();
		if (countItemProvider != null) countItemProvider.dispose();
		if (defaultItemProvider != null) defaultItemProvider.dispose();
		if (delayItemProvider != null) delayItemProvider.dispose();
		if (descriptionItemProvider != null) descriptionItemProvider.dispose();
		if (divItemProvider != null) divItemProvider.dispose();
		if (elemDefinitionItemProvider != null) elemDefinitionItemProvider.dispose();
		if (elemDefinitionEnumerationItemProvider != null) elemDefinitionEnumerationItemProvider.dispose();
		if (enumerationTypeItemProvider != null) enumerationTypeItemProvider.dispose();
		if (equalItemProvider != null) equalItemProvider.dispose();
		if (equalEqualItemProvider != null) equalEqualItemProvider.dispose();
		if (externalAttributeItemProvider != null) externalAttributeItemProvider.dispose();
		if (externalGraphItemProvider != null) externalGraphItemProvider.dispose();
		if (externalReferencesItemProvider != null) externalReferencesItemProvider.dispose();
		if (fieldAccessItemProvider != null) fieldAccessItemProvider.dispose();
		if (formalProcessItemProvider != null) formalProcessItemProvider.dispose();
		if (fromItemProvider != null) fromItemProvider.dispose();
		if (graphSpecificationItemProvider != null) graphSpecificationItemProvider.dispose();
		if (greaterItemProvider != null) greaterItemProvider.dispose();
		if (greaterOrEqualItemProvider != null) greaterOrEqualItemProvider.dispose();
		if (identifierItemProvider != null) identifierItemProvider.dispose();
		if (identityEquationItemProvider != null) identityEquationItemProvider.dispose();
		if (ifThenElseItemProvider != null) ifThenElseItemProvider.dispose();
		if (indexItemProvider != null) indexItemProvider.dispose();
		if (ioProfileItemProvider != null) ioProfileItemProvider.dispose();
		if (iterationItemProvider != null) iterationItemProvider.dispose();
		if (iterationProcessItemProvider != null) iterationProcessItemProvider.dispose();
		if (labelledProcessItemProvider != null) labelledProcessItemProvider.dispose();
		if (labelsItemProvider != null) labelsItemProvider.dispose();
		if (lessItemProvider != null) lessItemProvider.dispose();
		if (lessLessEqualItemProvider != null) lessLessEqualItemProvider.dispose();
		if (lessOrEqualItemProvider != null) lessOrEqualItemProvider.dispose();
		if (listExprSignalItemProvider != null) listExprSignalItemProvider.dispose();
		if (listFlowsItemProvider != null) listFlowsItemProvider.dispose();
		if (listModuleItemProvider != null) listModuleItemProvider.dispose();
		if (maskingItemProvider != null) maskingItemProvider.dispose();
		if (minusItemProvider != null) minusItemProvider.dispose();
		if (moduleItemProvider != null) moduleItemProvider.dispose();
		if (moduleDescriptionItemProvider != null) moduleDescriptionItemProvider.dispose();
		if (modulesImportItemProvider != null) modulesImportItemProvider.dispose();
		if (moduloItemProvider != null) moduloItemProvider.dispose();
		if (notItemProvider != null) notItemProvider.dispose();
		if (notEqualItemProvider != null) notEqualItemProvider.dispose();
		if (nullClockItemProvider != null) nullClockItemProvider.dispose();
		if (nullProcItemProvider != null) nullProcItemProvider.dispose();
		if (operatorItemProvider != null) operatorItemProvider.dispose();
		if (operatorModelItemProvider != null) operatorModelItemProvider.dispose();
		if (orItemProvider != null) orItemProvider.dispose();
		if (partialIterationItemProvider != null) partialIterationItemProvider.dispose();
		if (plusItemProvider != null) plusItemProvider.dispose();
		if (powerItemProvider != null) powerItemProvider.dispose();
		if (pragmaItemProvider != null) pragmaItemProvider.dispose();
		if (predefinedTypeItemProvider != null) predefinedTypeItemProvider.dispose();
		if (previousIterationRefItemProvider != null) previousIterationRefItemProvider.dispose();
		if (processAttributeItemProvider != null) processAttributeItemProvider.dispose();
		if (processCallItemProvider != null) processCallItemProvider.dispose();
		if (processExpansionItemProvider != null) processExpansionItemProvider.dispose();
		if (processModelItemProvider != null) processModelItemProvider.dispose();
		if (processModelInterfaceItemProvider != null) processModelInterfaceItemProvider.dispose();
		if (processTypeItemProvider != null) processTypeItemProvider.dispose();
		if (productItemProvider != null) productItemProvider.dispose();
		if (recoverItemProvider != null) recoverItemProvider.dispose();
		if (repetitionItemProvider != null) repetitionItemProvider.dispose();
		if (restrictionProcessItemProvider != null) restrictionProcessItemProvider.dispose();
		if (sequentialDefinitionItemProvider != null) sequentialDefinitionItemProvider.dispose();
		if (sharedVariablesDeclarationItemProvider != null) sharedVariablesDeclarationItemProvider.dispose();
		if (signalElementItemProvider != null) signalElementItemProvider.dispose();
		if (signalNamingItemProvider != null) signalNamingItemProvider.dispose();
		if (signalsItemProvider != null) signalsItemProvider.dispose();
		if (signalsDeclarationItemProvider != null) signalsDeclarationItemProvider.dispose();
		if (signalsDefinitionItemProvider != null) signalsDefinitionItemProvider.dispose();
		if (signalsPartialDefaultDefinitionItemProvider != null) signalsPartialDefaultDefinitionItemProvider.dispose();
		if (signalsPartialDefinitionItemProvider != null) signalsPartialDefinitionItemProvider.dispose();
		if (stateVariablesDeclarationItemProvider != null) stateVariablesDeclarationItemProvider.dispose();
		if (stateVariableValueItemProvider != null) stateVariableValueItemProvider.dispose();
		if (stringValueItemProvider != null) stringValueItemProvider.dispose();
		if (transpositionItemProvider != null) transpositionItemProvider.dispose();
		if (tupleTypeItemProvider != null) tupleTypeItemProvider.dispose();
		if (typeDescriptionItemProvider != null) typeDescriptionItemProvider.dispose();
		if (typeMorphismItemProvider != null) typeMorphismItemProvider.dispose();
		if (typesDeclarationItemProvider != null) typesDeclarationItemProvider.dispose();
		if (unaryMinusItemProvider != null) unaryMinusItemProvider.dispose();
		if (unaryPlusItemProvider != null) unaryPlusItemProvider.dispose();
		if (unaryWhenItemProvider != null) unaryWhenItemProvider.dispose();
		if (unconditionedDependencesItemProvider != null) unconditionedDependencesItemProvider.dispose();
		if (varItemProvider != null) varItemProvider.dispose();
		if (whenItemProvider != null) whenItemProvider.dispose();
		if (windowItemProvider != null) windowItemProvider.dispose();
		if (xorItemProvider != null) xorItemProvider.dispose();
	}

}
