/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

/**
 * Class to indicate a pointer on an AST and potentially to indicate a son of the tree. It is used principally by the
 * return of n_getDeclaration method declared in SignalTreeExploring.
 */
public class DeclarationValue {
	/** An index to indicate a son of the tree */
	public int	index;
	public long	tree;
	
	/**
	 * @param tree
	 */
	public DeclarationValue(long tree) {
		this(tree, -1);
	}
	
	/**
	 * @param tree
	 * @param index
	 *        indicates a son of the tree
	 */
	public DeclarationValue(long tree, int index) {
		this.index = index;
		this.tree = tree;
	}
}
