/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

/**
 * Class for containing the return of tree2IGraph method declared in PKServices.
 */
public class GraphValue {
	/** The return code of the tree2IGraph operation */
	private int		returnCode;
	/** The generated graph */
	private long	graph;
	
	/**
	 * @param returnCode
	 *        the return code of the tree2IGraph operation
	 * @param graph
	 *        the generated graph
	 */
	public GraphValue(int returnCode, long graph) {
		this.setReturnCode(returnCode);
		this.setGraph(graph);
	}
	
	public void setGraph(long graph) {
		this.graph = graph;
	}
	
	public long getGraph() {
		return graph;
	}
	
	public void setReturnCode(int returnCode) {
		this.returnCode = returnCode;
	}
	
	public int getReturnCode() {
		return returnCode;
	}
	
	public boolean isOk() {
		return  (returnCode == ExitStatus.NO_ERROR);
	}
}
