/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

public enum ModelKind implements Enumerator {
	ACTION_LITERAL(517, "opact", "action"), ACTION_P_LITERAL(518, "opactp", "private action"), FUNCTION_LITERAL(506,
			"opfunc", "function"), FUNCTION_P_LITERAL(507, "opfuncp", "private function"), NODE_LITERAL(522, "opnode",
			"node"), NODE_P_LITERAL(523, "opnodep", "private node"), PROCESS_LITERAL(511, "opprocess", "process"),
	PROCESS_P_LITERAL(512, "opprocessp", "private process"), MODULE_LITERAL(243, "opmodu", "module"), L_MODULE_LITERAL(
			441, "oplmodu", "l_module");
	
	public static final int				ACTION			= 517;
	public static final int				ACTION_P		= 518;
	public static final int				FUNCTION		= 506;
	public static final int				FUNCTION_P		= 507;
	public static final int				NODE			= 522;
	public static final int				NODE_P			= 523;
	public static final int				PROCESS			= 511;
	public static final int				PROCESS_P		= 512;
	public static final int				MODULE			= 243;
	public static final int				L_MODULE		= 441;
	
	private static final ModelKind[]	VALUES_ARRAY	= new ModelKind[] { ACTION_LITERAL, ACTION_P_LITERAL,
			FUNCTION_LITERAL, FUNCTION_P_LITERAL, NODE_LITERAL, NODE_P_LITERAL, PROCESS_LITERAL, PROCESS_P_LITERAL,
			MODULE_LITERAL, L_MODULE_LITERAL,			};
	
	public static final List<ModelKind>	VALUES			= Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
	
	private final int					value;
	private final String				name;
	private final String				literal;
	
	public static ModelKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ModelKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}
	
	public static ModelKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ModelKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}
	
	public static ModelKind get(int value) {
		switch (value) {
			case ACTION:
				return ACTION_LITERAL;
			case ACTION_P:
				return ACTION_P_LITERAL;
			case FUNCTION:
				return FUNCTION_LITERAL;
			case FUNCTION_P:
				return FUNCTION_P_LITERAL;
			case NODE:
				return NODE_LITERAL;
			case NODE_P:
				return NODE_P_LITERAL;
			case PROCESS:
				return PROCESS_LITERAL;
			case PROCESS_P:
				return PROCESS_P_LITERAL;
			case MODULE:
				return MODULE_LITERAL;
			case L_MODULE:
				return L_MODULE_LITERAL;
			default:
				return null;
		}
	}
	
	/**
	 * @param value
	 * @param name
	 * @param literal
	 */
	private ModelKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getLiteral()
	 */
	public String getLiteral() {
		return literal;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getName()
	 */
	public String getName() {
		return name;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.util.Enumerator#getValue()
	 */
	public int getValue() {
		return value;
	}
}
