/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

public class PKOptionManager {
	public PKOptionManager() { }
	
	public synchronized native int compile(long vtree, long graph, String outputFileName, String currentDir);

	
	
	// The following native functions are unused now (LBesnard).
	public synchronized native void setOptGenDot(boolean b);
	
	public synchronized native void setOptAlwaysCode(boolean b);
	
	public synchronized native void setOptDelayMultiplexing(boolean b);
	
	public synchronized native void setOptDelayOptimizing(boolean b);
	
	public synchronized native void setOptSubstitute(int value);
	
	public synchronized native void setOptExclusiveClock(boolean b, int vlevel);
	
	public synchronized native void setOptTestFunctionality(boolean b);
	
	public synchronized native void setOptClustering(boolean b);
	
	public synchronized native void setOptUnification(boolean b);
	
	public synchronized native void setOptGenCBody(boolean b);
	
	public synchronized native void setOptGenCMain(boolean b);
	
	public synchronized native void setOptGenCIO(boolean b);
	
	public synchronized native void setOptGenCModules(boolean b);
	
	public synchronized native void setOptGenCPPBody(boolean b);
	
	public synchronized native void setOptGenCPPMain(boolean b);
	
	public synchronized native void setOptGenCPPIO(boolean b);
	
	public synchronized native void setOptGenCPPModules(boolean b);
	
	public synchronized native void setOptGenJava(boolean b);
	
	public synchronized native void setOptGenJavaBody(boolean b);
	
	public synchronized native void setOptGenJavaMain(boolean b);
	
	public synchronized native void setOptGenThreads(boolean b);
	
	public synchronized native void setOptGenJavaIO(boolean b);
	
	public synchronized native void setOptGenJavaModules(boolean b);
	
	public synchronized native void setOptGenList(boolean b);
	
	public synchronized native void setOptGenTrace(boolean b);
	
	public synchronized native void setOptGenFlatTrace(boolean b);
	
	public synchronized native void setOptGenz3z(boolean b);
	
	public synchronized native void setOptGenSyndex(boolean b);
	
	public synchronized native void setOptSeparateBooleansOthers(boolean b);
	
	public synchronized native void setOptSeparateStatesOthers(boolean b);
	
	public synchronized native void setOptUserPartitioning(boolean b);
	
	public synchronized native void setOptVerbose(boolean b);
	
	public synchronized native void setOptStat(boolean b);
	
	public synchronized native void setOptWarn(boolean b);
	
	public synchronized native void setOptDebug(boolean b);
	
	public synchronized native void setOptCrew(boolean b);
	
	public synchronized native void setOptSolvingDepth(int depth);
	
	public synchronized native void setOptGenBF(boolean b);
	
	public synchronized native void setOptGenSBF(boolean b);
	
	public synchronized native void setOptGenFBF(boolean b);
	
	public synchronized native void setOptRetiming(boolean b);
	
	public synchronized native void setOptAbstraction(boolean b);
	
	public synchronized native void setOptKernel(boolean b);
	
	public synchronized native void setOptProfiling(boolean b);
	
	public synchronized native void setOptCheck(boolean b);
	
	public synchronized native void setOptGenLustre(boolean b);
	
	public synchronized native void setOptGenDistrib(boolean b);
	
	public synchronized native void setOptXMI(boolean b);
	
	public synchronized native void setOptSynoptic(boolean b);
	
	public synchronized native void setOptTraceabilityMode(boolean b);
	
	public synchronized native void setOptHeader(boolean b);


	
/* Misc options : getting the status */	
    public synchronized native boolean getOptVerbose();
	public synchronized native boolean getOptStat();	
	public synchronized native boolean getOptWarn( );	
	public synchronized native boolean getOptDebug();
	public synchronized native boolean getOptTraceabilityMode();
	public synchronized native boolean getOptHeader();	 
}
