/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

import org.eclipse.pop.ssme.polychrony.traceability.TreesInterface;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class PkPlugin extends AbstractUIPlugin {
	
	/** The plug-in ID */
	public static final String	PLUGIN_ID			= "org.eclipse.pop.ssme.polychrony";
	
	/** The shared instance */
	private static PkPlugin		plugin;
	
	private static PKServices	POLYCHRONY_SERVICES	= null;
	
	public PkPlugin() {}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}
	
	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static PkPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * @see java.lang.Object#finalize()
	 * @generated NOT
	 */
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		
		// Finalize the POP.achine
		if (POLYCHRONY_SERVICES != null)
			POLYCHRONY_SERVICES.finalize();
	}
	
	/**
	 * @return the POP.ervices API
	 */
	public static PKServices getServices() {
		if (POLYCHRONY_SERVICES == null) 
			POLYCHRONY_SERVICES = PKServices.INSTANCE;
		return POLYCHRONY_SERVICES;
	}
	
	/**
	 * @return the Tree Printer Generator
	 */
	public static SignalTreePrinter getPrinter() {
		return getServices().getPrinter();
	}
	
	/**
	 * @return the POP.arser
	 * @generated NOT
	 * */
	public static SignalParser getParser() {
		return getServices().getParser();
	}
	
	/**
	 * @return the Trees builder
	 * @generated NOT
	 */
	public static SignalTreeBuilting getTreeBuilder() {
		return getServices().getTreeBuilder();
	}
	
	/**
	 * @return the Trees builder
	 * @generated NOT
	 */
	public static SignalTreeExploring getTreeExplorer() {
		return getServices().getTreeExplorer();
	}
	/**
	 * @return the PKTrees API
	 * @generated NOT
	 */
	public static PKTrees getTreeAPI() {
		return getServices().getTreeAPI();
	}
	
	public static SignalTreeComment getCommentAPI() {
		return getServices().getCommentAPI();
	}
	
	public static TreesInterface getTraceabilityAPI() {
		return getServices().getTraceabilityAPI();
	}
}
