/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

/**
 * Class for containing the return of n_getPragmaValues method declared in SignalTreeExploring.
 */
public class PragmaValues {
	/**
	 * Name of the pragma (kind).
	 */
	public String	name;
	
	/**
	 * Node containing the list of all identifiers on which the pragma is applied
	 */
	public long		objList;
	
	/**
	 * Node containing the value of the pragma if any
	 */
	public long		enonce;
	
	/**
	 * @param name
	 * @param objList
	 * @param enonce
	 */
	public PragmaValues(String name, long objList, long enonce) {
		this.name = name;
		this.objList = objList;
		this.enonce = enonce;
	}
}
