/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

/**
 * This class contains methods to parse signal textual form to create an abstract syntax tree.
 */
public class SignalParser {
	/**
	 * Creates and initializes the temporary file used by the compiler
	 */
	public synchronized native void init();
	
	public SignalParser() {
		init();
	}
	
	/**
	 * @param filename
	 *        the name of the parameter file to parse (absolute path)
	 * @return a node representing the abstract tree of the parameter file or PKTrees.ERROR_NODE if there is an error.
	 */
	public synchronized native long parseParamfile(String filename);
	
	/**
	 * @param filename
	 *        the name of the SIG file to parse (absolute path)
	 * @return a node representing the abstract tree of the Signal program contained in the file or PKTrees.ERROR_NODE
	 *         if there is an error.
	 */
	public synchronized native long parseSrcfile(String filename);
	
	
	/**
	 * It returns the abstract tree corresponding to the parsing of a text. This text is assumed to be an element of a
	 * syntactic group characterized by its phylum (aPhylum).
	 * 
	 * @param phylum
	 *        syntactic group of the Signal grammar
	 * @param expression
	 *        non-null Signal expression
	 * @return a node representing the abstract tree of the expression or PKTrees.ERROR_NODE if there is an error.
	 * 
	 * @see org.eclipse.pop.ssme.polychrony.Phyla
	 */
	public synchronized native long parseString(String expression);

	public synchronized native long parseIntegerConstant(String atomString);

	public synchronized native long parseDoubleReal(String atomString);

	public synchronized native long parseReal(String atomString);

	public synchronized native long parseChar(String string) ;

	public synchronized native long parseIdent(String atomString);

	public synchronized native long parseOperator(String string);
}
