/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony;

public class SignalTreePrinter {
	public SignalTreePrinter() {
		init();
	}

	public synchronized native void init();

	/**
	 * Print the Signal Program corresponding to the given tree in a file <code> OutputDirectory/model_name.SIG </code>.
	 * Here the tree must represent a model declaration or a module.
	 * 
	 * @param tree
	 *        the tree representing the model
	 * @return true if there is no errors in the code generation, false otherwise.
	 * 
	 * @see org.eclipse.ssme.polychrony.SignalTreePrinter#setOutputDirectory(String)
	 */
	public synchronized native boolean printTree(long tree);

	/**
	 * Print the Signal Program corresponding to the given tree in a specific file. The file will be stored in the
	 * Output directory set through
	 * 
	 * @param node
	 *        the tree
	 * @param fileName
	 *        the name of the file in which the tree is generated
	 * @return true if there is no errors in the code generation, false otherwise.
	 * 
	 * @see org.eclipse.ssme.polychrony.SignalTreePrinter#setOutputDirectory(String)
	 */
	public synchronized native boolean printTreeFile(long node, String fileName);

	/**
	 * Set the Output directory in which the generated file will be stored.
	 * 
	 * @param directory
	 *        the absolute path to the directory
	 * @return true if the directory is available, false otherwise
	 */
	public synchronized native boolean setOutputDirectory(String directory);
}
