/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony.traceability;

import org.eclipse.emf.ecore.EObject;

/**
 * Class used in the Traceability API to represent a SSME Node, with the EMF node, a boolean indicating if there is an
 * error and the error message, if there is any.
 */
public class SSMENode {
	/** The EMF Node */
	private EObject	node;
	
	/** Boolean set to true if there is an error */
	private boolean		error;
	
	/** The error message, if there is any */
	private String		errorMessage;
	
	/**
	 * Constructor
	 */
	public SSMENode() {
		setNode(null);
		setError(false);
		setErrorMessage("");
	}
	
	/**
	 * the EMF node getter
	 * 
	 * @return the EMF node
	 */
	public EObject getNode() {
		return node;
	}
	
	/**
	 * the EMF node setter
	 * 
	 * @param node
	 *        the EMF node to set
	 */
	public void setNode(EObject node) {
		this.node = node;
	}
	
	/**
	 * Error boolean getter
	 * 
	 * @return true if there is an error, false otherwise.
	 */
	public boolean isError() {
		return error;
	}
	
	/**
	 * Error boolean setter
	 * 
	 * @param error
	 *        the value to set
	 */
	public void setError(boolean error) {
		this.error = error;
	}
	
	/**
	 * Error message getter
	 * 
	 * @return the error message, or "" if there isn't any
	 */
	public String getErrorMessage() {
		return errorMessage;
	}
	
	/**
	 * Error message setter
	 * 
	 * @param errorMessage
	 *        the error message to set
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	
	/**
	 * This method prints the informations of a SME node.
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("Node : ");
		buffer.append(getNode().toString());
		buffer.append("\n");
		buffer.append(" Has Error : ");
		buffer.append(isError());
		buffer.append("\n");
		buffer.append(" Error Message : ");
		buffer.append(getErrorMessage());
		buffer.append("\n\n");
		
		return buffer.toString();
	}
}
