/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.polychrony.utils;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.pop.ssme.polychrony.PkPlugin;

public class PolychronyMarkerHelper extends EditUIMarkerHelper {
	public final static PolychronyMarkerHelper	INSTANCE	= new PolychronyMarkerHelper();
	
	public final static String					ID_MARKER	= EValidator.MARKER;
																							
	@Override
	protected String getMarkerID() {
		return ID_MARKER;
	}
	
	public void createMarkers(IFile file, Diagnostic diagnostic) {
		try {
			createMarkers(file, diagnostic, null);
		}
		catch (CoreException ce) {
			PkPlugin.getDefault().getLog().log(
				new Status(IStatus.ERROR, PkPlugin.PLUGIN_ID, 0,
					"An exception has been thrown during the creation of a marker problem on " + file, ce));
		}
	}
	
	public void createMarkers(Resource resource, Diagnostic diagnostic) {
		try {
			createMarkers(getFile(resource), diagnostic, null);
		}
		catch (CoreException ce) {
			PkPlugin.getDefault().getLog()
					.log(
						new Status(IStatus.ERROR, PkPlugin.PLUGIN_ID, 0,
							"An exception has been thrown during the creation of a marker problem on "
									+ getFile(resource), ce));
		}
	}
	
	@Override
	protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
		String message = diagnostic.getMessage();
		if (parentDiagnostic != null) {
			String parentMessage = parentDiagnostic.getMessage();
			if (parentMessage != null) {
				message = message != null ? parentMessage + ". " + message : parentMessage;
			}
		}
		return message;
	}
	
	@Override
	protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic)
			throws CoreException {
		List<?> data = diagnostic.getData();
		StringBuilder relatedURIs = new StringBuilder();
		boolean first = true;
		for (Object object : data) {
			if (object instanceof EObject) {
				EObject eObject = (EObject) object;
				if (first) {
					first = false;
					marker.setAttribute(EValidator.URI_ATTRIBUTE, ResourceHelper.getURI(eObject).toString());
				}
				else {
					if (relatedURIs.length() != 0) {
						relatedURIs.append(' ');
					}
					relatedURIs.append(URI.encodeFragment(ResourceHelper.getURI(eObject).toString(), false));
				}
			}
		}
		
		if (relatedURIs.length() > 0) {
			marker.setAttribute(EValidator.RELATED_URIS_ATTRIBUTE, relatedURIs.toString());
		}
		
		super.adjustMarker(marker, diagnostic, parentDiagnostic);
	}
}
