/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.texteditor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/**
 * This class defines the Signal language Scanner for the Signal textual editor
 */
public class SignalEditorScanner extends RuleBasedScanner {
	/** Colors for text elements */
	private static final Color		COLOR_KEYWORD;
	private static final Color		COLOR_COMMENT;
	private static final Color		COLOR_CONSTANT;
	private static final Color		COLOR_OTHER;
	
	static {
		Display d = PlatformUI.getWorkbench().getDisplay();
		COLOR_KEYWORD = new Color(d, 127, 0, 85);
		COLOR_COMMENT = new Color(d, 0, 128, 0);
		COLOR_CONSTANT = new Color(d, 0, 0, 255);
		COLOR_OTHER = new Color(d, 0, 0, 0);
	}
	
	/** List of Signal language keywords */
	private static final String[]	KEYWORDS	= new String[] { "action", "after", "and", "array", "assert",
			"boolean", "bundle", "case", "cell", "char", "complex", "constant", "count", "dcomplex", "default",
			"defaultvalue", "deterministic", "dreal", "else", "end", "enum", "event", "external", "false", "from",
			"function", "if", "in", "init", "integer", "iterate", "label", "long", "module", "modulo", "next", "node",
			"not", "of", "operator", "or", "pragmas", "private", "process", "real", "ref", "safe", "shared", "short",
			"spec", "statevar", "step", "string", "struct", "then", "to", "tr", "true", "type", "unsafe", "use", "var",
			"when", "where", "window", "with", "xor" };
	
	/**
	 * Constructor of Signal editor Scanner
	 */
	public SignalEditorScanner() {
		Token keyword = new Token(new TextAttribute(COLOR_KEYWORD, null, SWT.BOLD));
		Token comment = new Token(new TextAttribute(COLOR_COMMENT, null, SWT.ITALIC));
		Token constant = new Token(new TextAttribute(COLOR_CONSTANT, null, SWT.BOLD));
		Token other = new Token(new TextAttribute(COLOR_OTHER));
		
		WordRule basicRule = new WordRule(new IWordDetector() {
			public boolean isWordPart(char c) {
				return Character.isJavaIdentifierPart(c);
			}
			public boolean isWordStart(char c) {
				return Character.isJavaIdentifierStart(c);
			}
		}, other);
		
		for (String k : KEYWORDS)
			basicRule.addWord(k, keyword);
		
		IRule numberRule = new NumberRule(constant);
		IRule charRule = new SingleLineRule("'", "'", constant, '\\', true);
		IRule stringRule = new MultiLineRule("\"", "\"", constant, '\\', true);
		
		IRule commentRule = new MultiLineRule("%", "%", comment, (char) 0, true);
		
		setRules(new IRule[] { basicRule, commentRule, numberRule, charRule, stringRule });
	}
}
