/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Case Interval</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.CaseInterval#getLowerBound <em>Lower Bound</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.CaseInterval#getUpperBound <em>Upper Bound</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.CaseInterval#getIntervalsKind <em>Intervals Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getCaseInterval()
 * @model annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
 * @generated
 */
public interface CaseInterval extends CaseExprEnumeration {
	/**
	 * Returns the value of the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lower Bound</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lower Bound</em>' containment reference.
	 * @see #setLowerBound(ExprSignal)
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseInterval_LowerBound()
	 * @model containment="true" required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
	 * @generated
	 */
	ExprSignal getLowerBound();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.CaseInterval#getLowerBound <em>Lower Bound</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lower Bound</em>' containment reference.
	 * @see #getLowerBound()
	 * @generated
	 */
	void setLowerBound(ExprSignal value);

	/**
	 * Returns the value of the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Upper Bound</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Upper Bound</em>' containment reference.
	 * @see #setUpperBound(ExprSignal)
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseInterval_UpperBound()
	 * @model containment="true" required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
	 * @generated
	 */
	ExprSignal getUpperBound();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.CaseInterval#getUpperBound <em>Upper Bound</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Upper Bound</em>' containment reference.
	 * @see #getUpperBound()
	 * @generated
	 */
	void setUpperBound(ExprSignal value);

	/**
	 * Returns the value of the '<em><b>Intervals Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.pop.ssme.IntervalsKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Intervals Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Intervals Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.IntervalsKind
	 * @see #setIntervalsKind(IntervalsKind)
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseInterval_IntervalsKind()
	 * @model required="true"
	 * @generated
	 */
	IntervalsKind getIntervalsKind();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.CaseInterval#getIntervalsKind <em>Intervals Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Intervals Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.IntervalsKind
	 * @see #getIntervalsKind()
	 * @generated
	 */
	void setIntervalsKind(IntervalsKind value);

} // CaseInterval
