/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Case Process</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.CaseProcess#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.CaseProcess#getListCaseBranch <em>List Case Branch</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.CaseProcess#getElseCase <em>Else Case</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getCaseProcess()
 * @model annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
 * @generated
 */
public interface CaseProcess extends ExprProcess {
	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' containment reference.
	 * @see #setIdentifier(Identifier)
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseProcess_Identifier()
	 * @model containment="true" required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
	 * @generated
	 */
	Identifier getIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.CaseProcess#getIdentifier <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' containment reference.
	 * @see #getIdentifier()
	 * @generated
	 */
	void setIdentifier(Identifier value);

	/**
	 * Returns the value of the '<em><b>List Case Branch</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.CaseBranch}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Case Branch</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Case Branch</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseProcess_ListCaseBranch()
	 * @model containment="true" required="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
	 * @generated
	 */
	EList<CaseBranch> getListCaseBranch();

	/**
	 * Returns the value of the '<em><b>Else Case</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Else Case</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Else Case</em>' containment reference.
	 * @see #setElseCase(ExprProcess)
	 * @see org.eclipse.pop.ssme.SsmePackage#getCaseProcess_ElseCase()
	 * @model containment="true"
	 *        annotation="http://www.topcased.org/uuid uuid='_2LOfQO5WEduz9o2pAin6-g'"
	 * @generated
	 */
	ExprProcess getElseCase();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.CaseProcess#getElseCase <em>Else Case</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Else Case</em>' containment reference.
	 * @see #getElseCase()
	 * @generated
	 */
	void setElseCase(ExprProcess value);

} // CaseProcess
