/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Conditioned Dependence</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsFrom <em>Signals From</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsTo <em>Signals To</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ConditionedDependence#getConditionExpr <em>Condition Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getConditionedDependence()
 * @model
 * @generated
 */
public interface ConditionedDependence extends Dependences {
	/**
	 * Returns the value of the '<em><b>Signals From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Signals From</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Signals From</em>' containment reference.
	 * @see #setSignalsFrom(Signals)
	 * @see org.eclipse.pop.ssme.SsmePackage#getConditionedDependence_SignalsFrom()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Signals getSignalsFrom();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsFrom <em>Signals From</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Signals From</em>' containment reference.
	 * @see #getSignalsFrom()
	 * @generated
	 */
	void setSignalsFrom(Signals value);

	/**
	 * Returns the value of the '<em><b>Signals To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Signals To</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Signals To</em>' containment reference.
	 * @see #setSignalsTo(Signals)
	 * @see org.eclipse.pop.ssme.SsmePackage#getConditionedDependence_SignalsTo()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Signals getSignalsTo();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsTo <em>Signals To</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Signals To</em>' containment reference.
	 * @see #getSignalsTo()
	 * @generated
	 */
	void setSignalsTo(Signals value);

	/**
	 * Returns the value of the '<em><b>Condition Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Condition Expr</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Condition Expr</em>' containment reference.
	 * @see #setConditionExpr(ExprSignal)
	 * @see org.eclipse.pop.ssme.SsmePackage#getConditionedDependence_ConditionExpr()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ExprSignal getConditionExpr();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ConditionedDependence#getConditionExpr <em>Condition Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Condition Expr</em>' containment reference.
	 * @see #getConditionExpr()
	 * @generated
	 */
	void setConditionExpr(ExprSignal value);

} // ConditionedDependence
