/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Module Description</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.ModuleDescription#getListPragma <em>List Pragma</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ModuleDescription#getListDeclaration <em>List Declaration</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getModuleDescription()
 * @model
 * @generated
 */
public interface ModuleDescription extends SignalElement {
	/**
	 * Returns the value of the '<em><b>List Pragma</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Pragma}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Pragma</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Pragma</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getModuleDescription_ListPragma()
	 * @model containment="true"
	 * @generated
	 */
	EList<Pragma> getListPragma();

	/**
	 * Returns the value of the '<em><b>List Declaration</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Declaration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Declaration</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Declaration</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getModuleDescription_ListDeclaration()
	 * @model containment="true"
	 * @generated
	 */
	EList<Declaration> getListDeclaration();

} // ModuleDescription
