/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Operator Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.SsmePackage#getOperatorKind()
 * @model
 * @generated
 */
public enum OperatorKind implements Enumerator {
	/**
	 * The '<em><b>Null Clock</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NULL_CLOCK
	 * @generated
	 * @ordered
	 */
	NULL_CLOCK_LITERAL(0, "nullClock", "nullClock"),

	/**
	 * The '<em><b>Next</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NEXT
	 * @generated
	 * @ordered
	 */
	NEXT_LITERAL(1, "next", "next"),

	/**
	 * The '<em><b>Array Restructuration</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ARRAY_RESTRUCTURATION
	 * @generated
	 * @ordered
	 */
	ARRAY_RESTRUCTURATION_LITERAL(2, "arrayRestructuration", "arrayRestructuration"),

	/**
	 * The '<em><b>Default</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEFAULT
	 * @generated
	 * @ordered
	 */
	DEFAULT_LITERAL(3, "default", "default"),

	/**
	 * The '<em><b>When</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WHEN
	 * @generated
	 * @ordered
	 */
	WHEN_LITERAL(4, "when", "when"),

	/**
	 * The '<em><b>After</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER
	 * @generated
	 * @ordered
	 */
	AFTER_LITERAL(5, "after", "after"),

	/**
	 * The '<em><b>From</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FROM
	 * @generated
	 * @ordered
	 */
	FROM_LITERAL(6, "from", "from"),

	/**
	 * The '<em><b>Count</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COUNT
	 * @generated
	 * @ordered
	 */
	COUNT_LITERAL(7, "count", "count"),

	/**
	 * The '<em><b>Clock Union</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLOCK_UNION
	 * @generated
	 * @ordered
	 */
	CLOCK_UNION_LITERAL(8, "clockUnion", "clockUnion"),

	/**
	 * The '<em><b>Clock Difference</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLOCK_DIFFERENCE
	 * @generated
	 * @ordered
	 */
	CLOCK_DIFFERENCE_LITERAL(9, "clockDifference", "clockDifference"),

	/**
	 * The '<em><b>Clock Product</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLOCK_PRODUCT
	 * @generated
	 * @ordered
	 */
	CLOCK_PRODUCT_LITERAL(10, "clockProduct", "clockProduct"),

	/**
	 * The '<em><b>If</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IF
	 * @generated
	 * @ordered
	 */
	IF_LITERAL(11, "if", "if"),

	/**
	 * The '<em><b>Expr Index</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPR_INDEX
	 * @generated
	 * @ordered
	 */
	EXPR_INDEX_LITERAL(12, "exprIndex", "exprIndex"),

	/**
	 * The '<em><b>Xor</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #XOR
	 * @generated
	 * @ordered
	 */
	XOR_LITERAL(13, "xor", "xor"),

	/**
	 * The '<em><b>Or</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OR
	 * @generated
	 * @ordered
	 */
	OR_LITERAL(14, "or", "or"),

	/**
	 * The '<em><b>And</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AND
	 * @generated
	 * @ordered
	 */
	AND_LITERAL(15, "and", "and"),

	/**
	 * The '<em><b>Not</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT
	 * @generated
	 * @ordered
	 */
	NOT_LITERAL(16, "not", "not"),

	/**
	 * The '<em><b>Equal Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EQUAL_EQUAL
	 * @generated
	 * @ordered
	 */
	EQUAL_EQUAL_LITERAL(17, "equalEqual", "equalEqual"),

	/**
	 * The '<em><b>Less Less Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LESS_LESS_EQUAL
	 * @generated
	 * @ordered
	 */
	LESS_LESS_EQUAL_LITERAL(18, "LessLessEqual", "LessLessEqual"),

	/**
	 * The '<em><b>Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EQUAL
	 * @generated
	 * @ordered
	 */
	EQUAL_LITERAL(19, "equal", "equal"),

	/**
	 * The '<em><b>Not Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_EQUAL
	 * @generated
	 * @ordered
	 */
	NOT_EQUAL_LITERAL(20, "notEqual", "notEqual"),

	/**
	 * The '<em><b>Greater</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GREATER
	 * @generated
	 * @ordered
	 */
	GREATER_LITERAL(21, "greater", "greater"),

	/**
	 * The '<em><b>Greater Or Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GREATER_OR_EQUAL
	 * @generated
	 * @ordered
	 */
	GREATER_OR_EQUAL_LITERAL(22, "greaterOrEqual", "greaterOrEqual"),

	/**
	 * The '<em><b>Less</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LESS
	 * @generated
	 * @ordered
	 */
	LESS_LITERAL(23, "less", "less"),

	/**
	 * The '<em><b>Less Or Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LESS_OR_EQUAL
	 * @generated
	 * @ordered
	 */
	LESS_OR_EQUAL_LITERAL(24, "lessOrEqual", "lessOrEqual"),

	/**
	 * The '<em><b>Add</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ADD
	 * @generated
	 * @ordered
	 */
	ADD_LITERAL(25, "add", "add"),

	/**
	 * The '<em><b>Minus</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MINUS
	 * @generated
	 * @ordered
	 */
	MINUS_LITERAL(26, "minus", "minus"),

	/**
	 * The '<em><b>Concatenation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONCATENATION
	 * @generated
	 * @ordered
	 */
	CONCATENATION_LITERAL(27, "concatenation", "concatenation"),

	/**
	 * The '<em><b>Product</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRODUCT
	 * @generated
	 * @ordered
	 */
	PRODUCT_LITERAL(28, "product", "product"),

	/**
	 * The '<em><b>Array Product</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ARRAY_PRODUCT
	 * @generated
	 * @ordered
	 */
	ARRAY_PRODUCT_LITERAL(29, "arrayProduct", "arrayProduct"),

	/**
	 * The '<em><b>Div</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DIV
	 * @generated
	 * @ordered
	 */
	DIV_LITERAL(30, "div", "div"),

	/**
	 * The '<em><b>Modulo</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MODULO
	 * @generated
	 * @ordered
	 */
	MODULO_LITERAL(31, "modulo", "modulo"),

	/**
	 * The '<em><b>Repetition</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REPETITION
	 * @generated
	 * @ordered
	 */
	REPETITION_LITERAL(32, "repetition", "repetition"),

	/**
	 * The '<em><b>Power</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POWER
	 * @generated
	 * @ordered
	 */
	POWER_LITERAL(33, "power", "power"),

	/**
	 * The '<em><b>Complex Constructor</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPLEX_CONSTRUCTOR
	 * @generated
	 * @ordered
	 */
	COMPLEX_CONSTRUCTOR_LITERAL(34, "complexConstructor", "complexConstructor"),

	/**
	 * The '<em><b>Cell</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CELL
	 * @generated
	 * @ordered
	 */
	CELL_LITERAL(35, "cell", "cell"),

	/**
	 * The '<em><b>Var</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VAR
	 * @generated
	 * @ordered
	 */
	VAR_LITERAL(36, "var", "var"),

	/**
	 * The '<em><b>Delay</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DELAY
	 * @generated
	 * @ordered
	 */
	DELAY_LITERAL(37, "delay", "delay"),

	/**
	 * The '<em><b>Window</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WINDOW
	 * @generated
	 * @ordered
	 */
	WINDOW_LITERAL(38, "window", "window"),

	/**
	 * The '<em><b>Tr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TR
	 * @generated
	 * @ordered
	 */
	TR_LITERAL(39, "tr", "tr"),

	/**
	 * The '<em><b>Recuperation</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RECUPERATION
	 * @generated
	 * @ordered
	 */
	RECUPERATION_LITERAL(40, "recuperation", "recuperation"),

	/**
	 * The '<em><b>Clock</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLOCK
	 * @generated
	 * @ordered
	 */
	CLOCK_LITERAL(41, "clock", "clock"),

	/**
	 * The '<em><b>Event</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EVENT
	 * @generated
	 * @ordered
	 */
	EVENT_LITERAL(42, "event", "event"),

	/**
	 * The '<em><b>Boolean</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOOLEAN
	 * @generated
	 * @ordered
	 */
	BOOLEAN_LITERAL(43, "boolean", "boolean"),

	/**
	 * The '<em><b>Short</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SHORT
	 * @generated
	 * @ordered
	 */
	SHORT_LITERAL(44, "short", "short"),

	/**
	 * The '<em><b>Integer</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INTEGER
	 * @generated
	 * @ordered
	 */
	INTEGER_LITERAL(45, "integer", "integer"),

	/**
	 * The '<em><b>Long</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LONG
	 * @generated
	 * @ordered
	 */
	LONG_LITERAL(46, "long", "long"),

	/**
	 * The '<em><b>Real</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REAL
	 * @generated
	 * @ordered
	 */
	REAL_LITERAL(47, "real", "real"),

	/**
	 * The '<em><b>Dreal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DREAL
	 * @generated
	 * @ordered
	 */
	DREAL_LITERAL(48, "dreal", "dreal"),

	/**
	 * The '<em><b>Complex</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPLEX
	 * @generated
	 * @ordered
	 */
	COMPLEX_LITERAL(49, "complex", "complex"),

	/**
	 * The '<em><b>Dcomplex</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DCOMPLEX
	 * @generated
	 * @ordered
	 */
	DCOMPLEX_LITERAL(50, "dcomplex", "dcomplex"),

	/**
	 * The '<em><b>Char</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CHAR
	 * @generated
	 * @ordered
	 */
	CHAR_LITERAL(51, "char", "char"),

	/**
	 * The '<em><b>String</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STRING
	 * @generated
	 * @ordered
	 */
	STRING_LITERAL(52, "string", "string"),

	/**
	 * The '<em><b>False</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FALSE
	 * @generated
	 * @ordered
	 */
	FALSE_LITERAL(53, "false", "false"),

	/**
	 * The '<em><b>True</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRUE
	 * @generated
	 * @ordered
	 */
	TRUE_LITERAL(54, "true", "true");

	/**
	 * The '<em><b>Null Clock</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Null Clock</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NULL_CLOCK_LITERAL
	 * @model name="nullClock"
	 * @generated
	 * @ordered
	 */
	public static final int NULL_CLOCK = 0;

	/**
	 * The '<em><b>Next</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Next</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NEXT_LITERAL
	 * @model name="next"
	 * @generated
	 * @ordered
	 */
	public static final int NEXT = 1;

	/**
	 * The '<em><b>Array Restructuration</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Array Restructuration</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ARRAY_RESTRUCTURATION_LITERAL
	 * @model name="arrayRestructuration"
	 * @generated
	 * @ordered
	 */
	public static final int ARRAY_RESTRUCTURATION = 2;

	/**
	 * The '<em><b>Default</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Default</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEFAULT_LITERAL
	 * @model name="default"
	 * @generated
	 * @ordered
	 */
	public static final int DEFAULT = 3;

	/**
	 * The '<em><b>When</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>When</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WHEN_LITERAL
	 * @model name="when"
	 * @generated
	 * @ordered
	 */
	public static final int WHEN = 4;

	/**
	 * The '<em><b>After</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>After</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AFTER_LITERAL
	 * @model name="after"
	 * @generated
	 * @ordered
	 */
	public static final int AFTER = 5;

	/**
	 * The '<em><b>From</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>From</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FROM_LITERAL
	 * @model name="from"
	 * @generated
	 * @ordered
	 */
	public static final int FROM = 6;

	/**
	 * The '<em><b>Count</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Count</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COUNT_LITERAL
	 * @model name="count"
	 * @generated
	 * @ordered
	 */
	public static final int COUNT = 7;

	/**
	 * The '<em><b>Clock Union</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Clock Union</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLOCK_UNION_LITERAL
	 * @model name="clockUnion"
	 * @generated
	 * @ordered
	 */
	public static final int CLOCK_UNION = 8;

	/**
	 * The '<em><b>Clock Difference</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Clock Difference</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLOCK_DIFFERENCE_LITERAL
	 * @model name="clockDifference"
	 * @generated
	 * @ordered
	 */
	public static final int CLOCK_DIFFERENCE = 9;

	/**
	 * The '<em><b>Clock Product</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Clock Product</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLOCK_PRODUCT_LITERAL
	 * @model name="clockProduct"
	 * @generated
	 * @ordered
	 */
	public static final int CLOCK_PRODUCT = 10;

	/**
	 * The '<em><b>If</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>If</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #IF_LITERAL
	 * @model name="if"
	 * @generated
	 * @ordered
	 */
	public static final int IF = 11;

	/**
	 * The '<em><b>Expr Index</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Expr Index</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPR_INDEX_LITERAL
	 * @model name="exprIndex"
	 * @generated
	 * @ordered
	 */
	public static final int EXPR_INDEX = 12;

	/**
	 * The '<em><b>Xor</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Xor</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #XOR_LITERAL
	 * @model name="xor"
	 * @generated
	 * @ordered
	 */
	public static final int XOR = 13;

	/**
	 * The '<em><b>Or</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Or</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OR_LITERAL
	 * @model name="or"
	 * @generated
	 * @ordered
	 */
	public static final int OR = 14;

	/**
	 * The '<em><b>And</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>And</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AND_LITERAL
	 * @model name="and"
	 * @generated
	 * @ordered
	 */
	public static final int AND = 15;

	/**
	 * The '<em><b>Not</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Not</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOT_LITERAL
	 * @model name="not"
	 * @generated
	 * @ordered
	 */
	public static final int NOT = 16;

	/**
	 * The '<em><b>Equal Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Equal Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EQUAL_EQUAL_LITERAL
	 * @model name="equalEqual"
	 * @generated
	 * @ordered
	 */
	public static final int EQUAL_EQUAL = 17;

	/**
	 * The '<em><b>Less Less Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Less Less Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LESS_LESS_EQUAL_LITERAL
	 * @model name="LessLessEqual"
	 * @generated
	 * @ordered
	 */
	public static final int LESS_LESS_EQUAL = 18;

	/**
	 * The '<em><b>Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EQUAL_LITERAL
	 * @model name="equal"
	 * @generated
	 * @ordered
	 */
	public static final int EQUAL = 19;

	/**
	 * The '<em><b>Not Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Not Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOT_EQUAL_LITERAL
	 * @model name="notEqual"
	 * @generated
	 * @ordered
	 */
	public static final int NOT_EQUAL = 20;

	/**
	 * The '<em><b>Greater</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Greater</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GREATER_LITERAL
	 * @model name="greater"
	 * @generated
	 * @ordered
	 */
	public static final int GREATER = 21;

	/**
	 * The '<em><b>Greater Or Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Greater Or Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GREATER_OR_EQUAL_LITERAL
	 * @model name="greaterOrEqual"
	 * @generated
	 * @ordered
	 */
	public static final int GREATER_OR_EQUAL = 22;

	/**
	 * The '<em><b>Less</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Less</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LESS_LITERAL
	 * @model name="less"
	 * @generated
	 * @ordered
	 */
	public static final int LESS = 23;

	/**
	 * The '<em><b>Less Or Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Less Or Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LESS_OR_EQUAL_LITERAL
	 * @model name="lessOrEqual"
	 * @generated
	 * @ordered
	 */
	public static final int LESS_OR_EQUAL = 24;

	/**
	 * The '<em><b>Add</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Add</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ADD_LITERAL
	 * @model name="add"
	 * @generated
	 * @ordered
	 */
	public static final int ADD = 25;

	/**
	 * The '<em><b>Minus</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Minus</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MINUS_LITERAL
	 * @model name="minus"
	 * @generated
	 * @ordered
	 */
	public static final int MINUS = 26;

	/**
	 * The '<em><b>Concatenation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Concatenation</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONCATENATION_LITERAL
	 * @model name="concatenation"
	 * @generated
	 * @ordered
	 */
	public static final int CONCATENATION = 27;

	/**
	 * The '<em><b>Product</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Product</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PRODUCT_LITERAL
	 * @model name="product"
	 * @generated
	 * @ordered
	 */
	public static final int PRODUCT = 28;

	/**
	 * The '<em><b>Array Product</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Array Product</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ARRAY_PRODUCT_LITERAL
	 * @model name="arrayProduct"
	 * @generated
	 * @ordered
	 */
	public static final int ARRAY_PRODUCT = 29;

	/**
	 * The '<em><b>Div</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Div</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DIV_LITERAL
	 * @model name="div"
	 * @generated
	 * @ordered
	 */
	public static final int DIV = 30;

	/**
	 * The '<em><b>Modulo</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Modulo</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MODULO_LITERAL
	 * @model name="modulo"
	 * @generated
	 * @ordered
	 */
	public static final int MODULO = 31;

	/**
	 * The '<em><b>Repetition</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Repetition</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REPETITION_LITERAL
	 * @model name="repetition"
	 * @generated
	 * @ordered
	 */
	public static final int REPETITION = 32;

	/**
	 * The '<em><b>Power</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Power</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POWER_LITERAL
	 * @model name="power"
	 * @generated
	 * @ordered
	 */
	public static final int POWER = 33;

	/**
	 * The '<em><b>Complex Constructor</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Complex Constructor</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPLEX_CONSTRUCTOR_LITERAL
	 * @model name="complexConstructor"
	 * @generated
	 * @ordered
	 */
	public static final int COMPLEX_CONSTRUCTOR = 34;

	/**
	 * The '<em><b>Cell</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Cell</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CELL_LITERAL
	 * @model name="cell"
	 * @generated
	 * @ordered
	 */
	public static final int CELL = 35;

	/**
	 * The '<em><b>Var</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Var</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VAR_LITERAL
	 * @model name="var"
	 * @generated
	 * @ordered
	 */
	public static final int VAR = 36;

	/**
	 * The '<em><b>Delay</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Delay</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DELAY_LITERAL
	 * @model name="delay"
	 * @generated
	 * @ordered
	 */
	public static final int DELAY = 37;

	/**
	 * The '<em><b>Window</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Window</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WINDOW_LITERAL
	 * @model name="window"
	 * @generated
	 * @ordered
	 */
	public static final int WINDOW = 38;

	/**
	 * The '<em><b>Tr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Tr</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TR_LITERAL
	 * @model name="tr"
	 * @generated
	 * @ordered
	 */
	public static final int TR = 39;

	/**
	 * The '<em><b>Recuperation</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Recuperation</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RECUPERATION_LITERAL
	 * @model name="recuperation"
	 * @generated
	 * @ordered
	 */
	public static final int RECUPERATION = 40;

	/**
	 * The '<em><b>Clock</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Clock</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLOCK_LITERAL
	 * @model name="clock"
	 * @generated
	 * @ordered
	 */
	public static final int CLOCK = 41;

	/**
	 * The '<em><b>Event</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Event</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EVENT_LITERAL
	 * @model name="event"
	 * @generated
	 * @ordered
	 */
	public static final int EVENT = 42;

	/**
	 * The '<em><b>Boolean</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Boolean</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BOOLEAN_LITERAL
	 * @model name="boolean"
	 * @generated
	 * @ordered
	 */
	public static final int BOOLEAN = 43;

	/**
	 * The '<em><b>Short</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Short</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SHORT_LITERAL
	 * @model name="short"
	 * @generated
	 * @ordered
	 */
	public static final int SHORT = 44;

	/**
	 * The '<em><b>Integer</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Integer</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INTEGER_LITERAL
	 * @model name="integer"
	 * @generated
	 * @ordered
	 */
	public static final int INTEGER = 45;

	/**
	 * The '<em><b>Long</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Long</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LONG_LITERAL
	 * @model name="long"
	 * @generated
	 * @ordered
	 */
	public static final int LONG = 46;

	/**
	 * The '<em><b>Real</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Real</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REAL_LITERAL
	 * @model name="real"
	 * @generated
	 * @ordered
	 */
	public static final int REAL = 47;

	/**
	 * The '<em><b>Dreal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Dreal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DREAL_LITERAL
	 * @model name="dreal"
	 * @generated
	 * @ordered
	 */
	public static final int DREAL = 48;

	/**
	 * The '<em><b>Complex</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Complex</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPLEX_LITERAL
	 * @model name="complex"
	 * @generated
	 * @ordered
	 */
	public static final int COMPLEX = 49;

	/**
	 * The '<em><b>Dcomplex</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Dcomplex</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DCOMPLEX_LITERAL
	 * @model name="dcomplex"
	 * @generated
	 * @ordered
	 */
	public static final int DCOMPLEX = 50;

	/**
	 * The '<em><b>Char</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Char</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CHAR_LITERAL
	 * @model name="char"
	 * @generated
	 * @ordered
	 */
	public static final int CHAR = 51;

	/**
	 * The '<em><b>String</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>String</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STRING_LITERAL
	 * @model name="string"
	 * @generated
	 * @ordered
	 */
	public static final int STRING = 52;

	/**
	 * The '<em><b>False</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>False</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FALSE_LITERAL
	 * @model name="false"
	 * @generated
	 * @ordered
	 */
	public static final int FALSE = 53;

	/**
	 * The '<em><b>True</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>True</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TRUE_LITERAL
	 * @model name="true"
	 * @generated
	 * @ordered
	 */
	public static final int TRUE = 54;

	/**
	 * An array of all the '<em><b>Operator Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final OperatorKind[] VALUES_ARRAY =
		new OperatorKind[] {
			NULL_CLOCK_LITERAL,
			NEXT_LITERAL,
			ARRAY_RESTRUCTURATION_LITERAL,
			DEFAULT_LITERAL,
			WHEN_LITERAL,
			AFTER_LITERAL,
			FROM_LITERAL,
			COUNT_LITERAL,
			CLOCK_UNION_LITERAL,
			CLOCK_DIFFERENCE_LITERAL,
			CLOCK_PRODUCT_LITERAL,
			IF_LITERAL,
			EXPR_INDEX_LITERAL,
			XOR_LITERAL,
			OR_LITERAL,
			AND_LITERAL,
			NOT_LITERAL,
			EQUAL_EQUAL_LITERAL,
			LESS_LESS_EQUAL_LITERAL,
			EQUAL_LITERAL,
			NOT_EQUAL_LITERAL,
			GREATER_LITERAL,
			GREATER_OR_EQUAL_LITERAL,
			LESS_LITERAL,
			LESS_OR_EQUAL_LITERAL,
			ADD_LITERAL,
			MINUS_LITERAL,
			CONCATENATION_LITERAL,
			PRODUCT_LITERAL,
			ARRAY_PRODUCT_LITERAL,
			DIV_LITERAL,
			MODULO_LITERAL,
			REPETITION_LITERAL,
			POWER_LITERAL,
			COMPLEX_CONSTRUCTOR_LITERAL,
			CELL_LITERAL,
			VAR_LITERAL,
			DELAY_LITERAL,
			WINDOW_LITERAL,
			TR_LITERAL,
			RECUPERATION_LITERAL,
			CLOCK_LITERAL,
			EVENT_LITERAL,
			BOOLEAN_LITERAL,
			SHORT_LITERAL,
			INTEGER_LITERAL,
			LONG_LITERAL,
			REAL_LITERAL,
			DREAL_LITERAL,
			COMPLEX_LITERAL,
			DCOMPLEX_LITERAL,
			CHAR_LITERAL,
			STRING_LITERAL,
			FALSE_LITERAL,
			TRUE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Operator Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<OperatorKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Operator Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static OperatorKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			OperatorKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Operator Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static OperatorKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			OperatorKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Operator Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static OperatorKind get(int value) {
		switch (value) {
			case NULL_CLOCK: return NULL_CLOCK_LITERAL;
			case NEXT: return NEXT_LITERAL;
			case ARRAY_RESTRUCTURATION: return ARRAY_RESTRUCTURATION_LITERAL;
			case DEFAULT: return DEFAULT_LITERAL;
			case WHEN: return WHEN_LITERAL;
			case AFTER: return AFTER_LITERAL;
			case FROM: return FROM_LITERAL;
			case COUNT: return COUNT_LITERAL;
			case CLOCK_UNION: return CLOCK_UNION_LITERAL;
			case CLOCK_DIFFERENCE: return CLOCK_DIFFERENCE_LITERAL;
			case CLOCK_PRODUCT: return CLOCK_PRODUCT_LITERAL;
			case IF: return IF_LITERAL;
			case EXPR_INDEX: return EXPR_INDEX_LITERAL;
			case XOR: return XOR_LITERAL;
			case OR: return OR_LITERAL;
			case AND: return AND_LITERAL;
			case NOT: return NOT_LITERAL;
			case EQUAL_EQUAL: return EQUAL_EQUAL_LITERAL;
			case LESS_LESS_EQUAL: return LESS_LESS_EQUAL_LITERAL;
			case EQUAL: return EQUAL_LITERAL;
			case NOT_EQUAL: return NOT_EQUAL_LITERAL;
			case GREATER: return GREATER_LITERAL;
			case GREATER_OR_EQUAL: return GREATER_OR_EQUAL_LITERAL;
			case LESS: return LESS_LITERAL;
			case LESS_OR_EQUAL: return LESS_OR_EQUAL_LITERAL;
			case ADD: return ADD_LITERAL;
			case MINUS: return MINUS_LITERAL;
			case CONCATENATION: return CONCATENATION_LITERAL;
			case PRODUCT: return PRODUCT_LITERAL;
			case ARRAY_PRODUCT: return ARRAY_PRODUCT_LITERAL;
			case DIV: return DIV_LITERAL;
			case MODULO: return MODULO_LITERAL;
			case REPETITION: return REPETITION_LITERAL;
			case POWER: return POWER_LITERAL;
			case COMPLEX_CONSTRUCTOR: return COMPLEX_CONSTRUCTOR_LITERAL;
			case CELL: return CELL_LITERAL;
			case VAR: return VAR_LITERAL;
			case DELAY: return DELAY_LITERAL;
			case WINDOW: return WINDOW_LITERAL;
			case TR: return TR_LITERAL;
			case RECUPERATION: return RECUPERATION_LITERAL;
			case CLOCK: return CLOCK_LITERAL;
			case EVENT: return EVENT_LITERAL;
			case BOOLEAN: return BOOLEAN_LITERAL;
			case SHORT: return SHORT_LITERAL;
			case INTEGER: return INTEGER_LITERAL;
			case LONG: return LONG_LITERAL;
			case REAL: return REAL_LITERAL;
			case DREAL: return DREAL_LITERAL;
			case COMPLEX: return COMPLEX_LITERAL;
			case DCOMPLEX: return DCOMPLEX_LITERAL;
			case CHAR: return CHAR_LITERAL;
			case STRING: return STRING_LITERAL;
			case FALSE: return FALSE_LITERAL;
			case TRUE: return TRUE_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private OperatorKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //OperatorKind
