/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operator Model</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.OperatorModel#getOperatorIdentifier <em>Operator Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.OperatorModel#getInterfaceDefinition <em>Interface Definition</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.OperatorModel#getDescription <em>Description</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getOperatorModel()
 * @model
 * @generated
 */
public interface OperatorModel extends SignalElement, ProcessDeclaration {
	/**
	 * Returns the value of the '<em><b>Operator Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operator Identifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operator Identifier</em>' containment reference.
	 * @see #setOperatorIdentifier(OperatorIdentifier)
	 * @see org.eclipse.pop.ssme.SsmePackage#getOperatorModel_OperatorIdentifier()
	 * @model containment="true" required="true"
	 * @generated
	 */
	OperatorIdentifier getOperatorIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.OperatorModel#getOperatorIdentifier <em>Operator Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operator Identifier</em>' containment reference.
	 * @see #getOperatorIdentifier()
	 * @generated
	 */
	void setOperatorIdentifier(OperatorIdentifier value);

	/**
	 * Returns the value of the '<em><b>Interface Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface Definition</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interface Definition</em>' containment reference.
	 * @see #setInterfaceDefinition(InterfaceDefinition)
	 * @see org.eclipse.pop.ssme.SsmePackage#getOperatorModel_InterfaceDefinition()
	 * @model containment="true" required="true"
	 * @generated
	 */
	InterfaceDefinition getInterfaceDefinition();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.OperatorModel#getInterfaceDefinition <em>Interface Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface Definition</em>' containment reference.
	 * @see #getInterfaceDefinition()
	 * @generated
	 */
	void setInterfaceDefinition(InterfaceDefinition value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' containment reference.
	 * @see #setDescription(Description)
	 * @see org.eclipse.pop.ssme.SsmePackage#getOperatorModel_Description()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Description getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.OperatorModel#getDescription <em>Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' containment reference.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(Description value);

} // OperatorModel
