/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Pragma</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.Pragma#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.Pragma#getListPragmaObject <em>List Pragma Object</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.Pragma#getPragmaStatement <em>Pragma Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getPragma()
 * @model
 * @generated
 */
public interface Pragma extends SignalElement {
	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' containment reference.
	 * @see #setIdentifier(Identifier)
	 * @see org.eclipse.pop.ssme.SsmePackage#getPragma_Identifier()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Identifier getIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.Pragma#getIdentifier <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' containment reference.
	 * @see #getIdentifier()
	 * @generated
	 */
	void setIdentifier(Identifier value);

	/**
	 * Returns the value of the '<em><b>List Pragma Object</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.Identifier}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Pragma Object</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Pragma Object</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getPragma_ListPragmaObject()
	 * @model containment="true"
	 * @generated
	 */
	EList<Identifier> getListPragmaObject();

	/**
	 * Returns the value of the '<em><b>Pragma Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pragma Statement</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pragma Statement</em>' containment reference.
	 * @see #setPragmaStatement(StringValue)
	 * @see org.eclipse.pop.ssme.SsmePackage#getPragma_PragmaStatement()
	 * @model containment="true"
	 * @generated
	 */
	StringValue getPragmaStatement();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.Pragma#getPragmaStatement <em>Pragma Statement</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pragma Statement</em>' containment reference.
	 * @see #getPragmaStatement()
	 * @generated
	 */
	void setPragmaStatement(StringValue value);

} // Pragma
