/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Process Model Interface</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.ProcessModelInterface#getListFormalParameter <em>List Formal Parameter</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ProcessModelInterface#getIoProfile <em>Io Profile</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.ProcessModelInterface#getExternalGraph <em>External Graph</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getProcessModelInterface()
 * @model
 * @generated
 */
public interface ProcessModelInterface extends InterfaceDefinition {
	/**
	 * Returns the value of the '<em><b>List Formal Parameter</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Formal Parameter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Formal Parameter</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessModelInterface_ListFormalParameter()
	 * @model containment="true"
	 * @generated
	 */
	EList<TypesOrSignalsDeclaration> getListFormalParameter();

	/**
	 * Returns the value of the '<em><b>Io Profile</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Io Profile</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Io Profile</em>' containment reference.
	 * @see #setIoProfile(IOProfile)
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessModelInterface_IoProfile()
	 * @model containment="true" required="true"
	 * @generated
	 */
	IOProfile getIoProfile();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ProcessModelInterface#getIoProfile <em>Io Profile</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Io Profile</em>' containment reference.
	 * @see #getIoProfile()
	 * @generated
	 */
	void setIoProfile(IOProfile value);

	/**
	 * Returns the value of the '<em><b>External Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>External Graph</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>External Graph</em>' containment reference.
	 * @see #setExternalGraph(ExternalGraph)
	 * @see org.eclipse.pop.ssme.SsmePackage#getProcessModelInterface_ExternalGraph()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ExternalGraph getExternalGraph();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.ProcessModelInterface#getExternalGraph <em>External Graph</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>External Graph</em>' containment reference.
	 * @see #getExternalGraph()
	 * @generated
	 */
	void setExternalGraph(ExternalGraph value);

} // ProcessModelInterface
