/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.SsmePackage
 * @generated
 */
public interface SsmeFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SsmeFactory eINSTANCE = org.eclipse.pop.ssme.impl.SsmeFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>After</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>After</em>'.
	 * @generated
	 */
	After createAfter();

	/**
	 * Returns a new object of class '<em>And</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>And</em>'.
	 * @generated
	 */
	And createAnd();

	/**
	 * Returns a new object of class '<em>Array Elem</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Elem</em>'.
	 * @generated
	 */
	ArrayElem createArrayElem();

	/**
	 * Returns a new object of class '<em>Array Elements Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Elements Enumeration</em>'.
	 * @generated
	 */
	ArrayElementsEnumeration createArrayElementsEnumeration();

	/**
	 * Returns a new object of class '<em>Array Index</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Index</em>'.
	 * @generated
	 */
	ArrayIndex createArrayIndex();

	/**
	 * Returns a new object of class '<em>Array Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Process</em>'.
	 * @generated
	 */
	ArrayProcess createArrayProcess();

	/**
	 * Returns a new object of class '<em>Array Product</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Product</em>'.
	 * @generated
	 */
	ArrayProduct createArrayProduct();

	/**
	 * Returns a new object of class '<em>Array Restructuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Restructuration</em>'.
	 * @generated
	 */
	ArrayRestructuration createArrayRestructuration();

	/**
	 * Returns a new object of class '<em>Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Type</em>'.
	 * @generated
	 */
	ArrayType createArrayType();

	/**
	 * Returns a new object of class '<em>Assert Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Assert Process</em>'.
	 * @generated
	 */
	AssertProcess createAssertProcess();

	/**
	 * Returns a new object of class '<em>Assert Signal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Assert Signal</em>'.
	 * @generated
	 */
	AssertSignal createAssertSignal();

	/**
	 * Returns a new object of class '<em>Bounds</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bounds</em>'.
	 * @generated
	 */
	Bounds createBounds();

	/**
	 * Returns a new object of class '<em>Cartesian Product</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cartesian Product</em>'.
	 * @generated
	 */
	CartesianProduct createCartesianProduct();

	/**
	 * Returns a new object of class '<em>Case Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Case Enumeration</em>'.
	 * @generated
	 */
	CaseEnumeration createCaseEnumeration();

	/**
	 * Returns a new object of class '<em>Case Interval</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Case Interval</em>'.
	 * @generated
	 */
	CaseInterval createCaseInterval();

	/**
	 * Returns a new object of class '<em>Case Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Case Process</em>'.
	 * @generated
	 */
	CaseProcess createCaseProcess();

	/**
	 * Returns a new object of class '<em>Case Branch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Case Branch</em>'.
	 * @generated
	 */
	CaseBranch createCaseBranch();

	/**
	 * Returns a new object of class '<em>Cell</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cell</em>'.
	 * @generated
	 */
	Cell createCell();

	/**
	 * Returns a new object of class '<em>Clock</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock</em>'.
	 * @generated
	 */
	Clock createClock();

	/**
	 * Returns a new object of class '<em>Clock Difference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Difference</em>'.
	 * @generated
	 */
	ClockDifference createClockDifference();

	/**
	 * Returns a new object of class '<em>Clock Equality</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Equality</em>'.
	 * @generated
	 */
	ClockEquality createClockEquality();

	/**
	 * Returns a new object of class '<em>Clock Exclusive Relation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Exclusive Relation</em>'.
	 * @generated
	 */
	ClockExclusiveRelation createClockExclusiveRelation();

	/**
	 * Returns a new object of class '<em>Clock Inf Relation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Inf Relation</em>'.
	 * @generated
	 */
	ClockInfRelation createClockInfRelation();

	/**
	 * Returns a new object of class '<em>Clock Product</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Product</em>'.
	 * @generated
	 */
	ClockProduct createClockProduct();

	/**
	 * Returns a new object of class '<em>Clock Sup Relation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Sup Relation</em>'.
	 * @generated
	 */
	ClockSupRelation createClockSupRelation();

	/**
	 * Returns a new object of class '<em>Clock Union</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Union</em>'.
	 * @generated
	 */
	ClockUnion createClockUnion();

	/**
	 * Returns a new object of class '<em>Comment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Comment</em>'.
	 * @generated
	 */
	Comment createComment();

	/**
	 * Returns a new object of class '<em>Complex Constructor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Complex Constructor</em>'.
	 * @generated
	 */
	ComplexConstructor createComplexConstructor();

	/**
	 * Returns a new object of class '<em>Composition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composition</em>'.
	 * @generated
	 */
	Composition createComposition();

	/**
	 * Returns a new object of class '<em>Concatenation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Concatenation</em>'.
	 * @generated
	 */
	Concatenation createConcatenation();

	/**
	 * Returns a new object of class '<em>Conditioned Dependence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conditioned Dependence</em>'.
	 * @generated
	 */
	ConditionedDependence createConditionedDependence();

	/**
	 * Returns a new object of class '<em>Constant Character</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Character</em>'.
	 * @generated
	 */
	ConstantCharacter createConstantCharacter();

	/**
	 * Returns a new object of class '<em>Constant Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Description</em>'.
	 * @generated
	 */
	ConstantDescription createConstantDescription();

	/**
	 * Returns a new object of class '<em>Constant Double Real</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Double Real</em>'.
	 * @generated
	 */
	ConstantDoubleReal createConstantDoubleReal();

	/**
	 * Returns a new object of class '<em>Constant Enum</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Enum</em>'.
	 * @generated
	 */
	ConstantEnum createConstantEnum();

	/**
	 * Returns a new object of class '<em>Constant Integer</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Integer</em>'.
	 * @generated
	 */
	ConstantInteger createConstantInteger();

	/**
	 * Returns a new object of class '<em>Constant Logical</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Logical</em>'.
	 * @generated
	 */
	ConstantLogical createConstantLogical();

	/**
	 * Returns a new object of class '<em>Constant Real</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Real</em>'.
	 * @generated
	 */
	ConstantReal createConstantReal();

	/**
	 * Returns a new object of class '<em>Constants Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constants Declaration</em>'.
	 * @generated
	 */
	ConstantsDeclaration createConstantsDeclaration();

	/**
	 * Returns a new object of class '<em>Constant String</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant String</em>'.
	 * @generated
	 */
	ConstantString createConstantString();

	/**
	 * Returns a new object of class '<em>Conversion</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion</em>'.
	 * @generated
	 */
	Conversion createConversion();

	/**
	 * Returns a new object of class '<em>Count</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count</em>'.
	 * @generated
	 */
	Count createCount();

	/**
	 * Returns a new object of class '<em>Default</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Default</em>'.
	 * @generated
	 */
	Default createDefault();

	/**
	 * Returns a new object of class '<em>Delay</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Delay</em>'.
	 * @generated
	 */
	Delay createDelay();

	/**
	 * Returns a new object of class '<em>Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Description</em>'.
	 * @generated
	 */
	Description createDescription();

	/**
	 * Returns a new object of class '<em>Div</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Div</em>'.
	 * @generated
	 */
	Div createDiv();

	/**
	 * Returns a new object of class '<em>Elem Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Elem Definition</em>'.
	 * @generated
	 */
	ElemDefinition createElemDefinition();

	/**
	 * Returns a new object of class '<em>Elem Definition Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Elem Definition Enumeration</em>'.
	 * @generated
	 */
	ElemDefinitionEnumeration createElemDefinitionEnumeration();

	/**
	 * Returns a new object of class '<em>Enumeration Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enumeration Type</em>'.
	 * @generated
	 */
	EnumerationType createEnumerationType();

	/**
	 * Returns a new object of class '<em>Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Equal</em>'.
	 * @generated
	 */
	Equal createEqual();

	/**
	 * Returns a new object of class '<em>Equal Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Equal Equal</em>'.
	 * @generated
	 */
	EqualEqual createEqualEqual();

	/**
	 * Returns a new object of class '<em>External Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>External Attribute</em>'.
	 * @generated
	 */
	ExternalAttribute createExternalAttribute();

	/**
	 * Returns a new object of class '<em>External Graph</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>External Graph</em>'.
	 * @generated
	 */
	ExternalGraph createExternalGraph();

	/**
	 * Returns a new object of class '<em>External References</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>External References</em>'.
	 * @generated
	 */
	ExternalReferences createExternalReferences();

	/**
	 * Returns a new object of class '<em>Field Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Field Access</em>'.
	 * @generated
	 */
	FieldAccess createFieldAccess();

	/**
	 * Returns a new object of class '<em>Formal Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Formal Process</em>'.
	 * @generated
	 */
	FormalProcess createFormalProcess();

	/**
	 * Returns a new object of class '<em>From</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>From</em>'.
	 * @generated
	 */
	From createFrom();

	/**
	 * Returns a new object of class '<em>Graph Specification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Graph Specification</em>'.
	 * @generated
	 */
	GraphSpecification createGraphSpecification();

	/**
	 * Returns a new object of class '<em>Greater</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Greater</em>'.
	 * @generated
	 */
	Greater createGreater();

	/**
	 * Returns a new object of class '<em>Greater Or Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Greater Or Equal</em>'.
	 * @generated
	 */
	GreaterOrEqual createGreaterOrEqual();

	/**
	 * Returns a new object of class '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Identifier</em>'.
	 * @generated
	 */
	Identifier createIdentifier();

	/**
	 * Returns a new object of class '<em>Identity Equation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Identity Equation</em>'.
	 * @generated
	 */
	IdentityEquation createIdentityEquation();

	/**
	 * Returns a new object of class '<em>If Then Else</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>If Then Else</em>'.
	 * @generated
	 */
	IfThenElse createIfThenElse();

	/**
	 * Returns a new object of class '<em>Index</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Index</em>'.
	 * @generated
	 */
	Index createIndex();

	/**
	 * Returns a new object of class '<em>IO Profile</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IO Profile</em>'.
	 * @generated
	 */
	IOProfile createIOProfile();

	/**
	 * Returns a new object of class '<em>Iteration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Iteration</em>'.
	 * @generated
	 */
	Iteration createIteration();

	/**
	 * Returns a new object of class '<em>Iteration Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Iteration Process</em>'.
	 * @generated
	 */
	IterationProcess createIterationProcess();

	/**
	 * Returns a new object of class '<em>Labelled Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Labelled Process</em>'.
	 * @generated
	 */
	LabelledProcess createLabelledProcess();

	/**
	 * Returns a new object of class '<em>Labels</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Labels</em>'.
	 * @generated
	 */
	Labels createLabels();

	/**
	 * Returns a new object of class '<em>Less</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Less</em>'.
	 * @generated
	 */
	Less createLess();

	/**
	 * Returns a new object of class '<em>Less Less Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Less Less Equal</em>'.
	 * @generated
	 */
	LessLessEqual createLessLessEqual();

	/**
	 * Returns a new object of class '<em>Less Or Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Less Or Equal</em>'.
	 * @generated
	 */
	LessOrEqual createLessOrEqual();

	/**
	 * Returns a new object of class '<em>List Expr Signal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>List Expr Signal</em>'.
	 * @generated
	 */
	ListExprSignal createListExprSignal();

	/**
	 * Returns a new object of class '<em>List Flows</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>List Flows</em>'.
	 * @generated
	 */
	ListFlows createListFlows();

	/**
	 * Returns a new object of class '<em>List Module</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>List Module</em>'.
	 * @generated
	 */
	ListModule createListModule();

	/**
	 * Returns a new object of class '<em>Masking</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Masking</em>'.
	 * @generated
	 */
	Masking createMasking();

	/**
	 * Returns a new object of class '<em>Minus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Minus</em>'.
	 * @generated
	 */
	Minus createMinus();

	/**
	 * Returns a new object of class '<em>Module</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Module</em>'.
	 * @generated
	 */
	Module createModule();

	/**
	 * Returns a new object of class '<em>Module Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Module Description</em>'.
	 * @generated
	 */
	ModuleDescription createModuleDescription();

	/**
	 * Returns a new object of class '<em>Modules Import</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Modules Import</em>'.
	 * @generated
	 */
	ModulesImport createModulesImport();

	/**
	 * Returns a new object of class '<em>Modulo</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Modulo</em>'.
	 * @generated
	 */
	Modulo createModulo();

	/**
	 * Returns a new object of class '<em>Not</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Not</em>'.
	 * @generated
	 */
	Not createNot();

	/**
	 * Returns a new object of class '<em>Not Equal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Not Equal</em>'.
	 * @generated
	 */
	NotEqual createNotEqual();

	/**
	 * Returns a new object of class '<em>Null Clock</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Null Clock</em>'.
	 * @generated
	 */
	NullClock createNullClock();

	/**
	 * Returns a new object of class '<em>Null Proc</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Null Proc</em>'.
	 * @generated
	 */
	NullProc createNullProc();

	/**
	 * Returns a new object of class '<em>Operator</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operator</em>'.
	 * @generated
	 */
	Operator createOperator();

	/**
	 * Returns a new object of class '<em>Operator Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operator Model</em>'.
	 * @generated
	 */
	OperatorModel createOperatorModel();

	/**
	 * Returns a new object of class '<em>Or</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Or</em>'.
	 * @generated
	 */
	Or createOr();

	/**
	 * Returns a new object of class '<em>Partial Iteration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Partial Iteration</em>'.
	 * @generated
	 */
	PartialIteration createPartialIteration();

	/**
	 * Returns a new object of class '<em>Plus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Plus</em>'.
	 * @generated
	 */
	Plus createPlus();

	/**
	 * Returns a new object of class '<em>Power</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Power</em>'.
	 * @generated
	 */
	Power createPower();

	/**
	 * Returns a new object of class '<em>Pragma</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pragma</em>'.
	 * @generated
	 */
	Pragma createPragma();

	/**
	 * Returns a new object of class '<em>Predefined Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Predefined Type</em>'.
	 * @generated
	 */
	PredefinedType createPredefinedType();

	/**
	 * Returns a new object of class '<em>Previous Iteration Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Previous Iteration Ref</em>'.
	 * @generated
	 */
	PreviousIterationRef createPreviousIterationRef();

	/**
	 * Returns a new object of class '<em>Process Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Attribute</em>'.
	 * @generated
	 */
	ProcessAttribute createProcessAttribute();

	/**
	 * Returns a new object of class '<em>Process Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Call</em>'.
	 * @generated
	 */
	ProcessCall createProcessCall();

	/**
	 * Returns a new object of class '<em>Process Expansion</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Expansion</em>'.
	 * @generated
	 */
	ProcessExpansion createProcessExpansion();

	/**
	 * Returns a new object of class '<em>Process Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Model</em>'.
	 * @generated
	 */
	ProcessModel createProcessModel();

	/**
	 * Returns a new object of class '<em>Process Model Interface</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Model Interface</em>'.
	 * @generated
	 */
	ProcessModelInterface createProcessModelInterface();

	/**
	 * Returns a new object of class '<em>Process Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Type</em>'.
	 * @generated
	 */
	ProcessType createProcessType();

	/**
	 * Returns a new object of class '<em>Product</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Product</em>'.
	 * @generated
	 */
	Product createProduct();

	/**
	 * Returns a new object of class '<em>Recover</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Recover</em>'.
	 * @generated
	 */
	Recover createRecover();

	/**
	 * Returns a new object of class '<em>Repetition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Repetition</em>'.
	 * @generated
	 */
	Repetition createRepetition();

	/**
	 * Returns a new object of class '<em>Restriction Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Restriction Process</em>'.
	 * @generated
	 */
	RestrictionProcess createRestrictionProcess();

	/**
	 * Returns a new object of class '<em>Sequential Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sequential Definition</em>'.
	 * @generated
	 */
	SequentialDefinition createSequentialDefinition();

	/**
	 * Returns a new object of class '<em>Shared Variables Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Shared Variables Declaration</em>'.
	 * @generated
	 */
	SharedVariablesDeclaration createSharedVariablesDeclaration();

	/**
	 * Returns a new object of class '<em>Signal Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signal Element</em>'.
	 * @generated
	 */
	SignalElement createSignalElement();

	/**
	 * Returns a new object of class '<em>Signal Naming</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signal Naming</em>'.
	 * @generated
	 */
	SignalNaming createSignalNaming();

	/**
	 * Returns a new object of class '<em>Signals</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signals</em>'.
	 * @generated
	 */
	Signals createSignals();

	/**
	 * Returns a new object of class '<em>Signals Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signals Declaration</em>'.
	 * @generated
	 */
	SignalsDeclaration createSignalsDeclaration();

	/**
	 * Returns a new object of class '<em>Signals Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signals Definition</em>'.
	 * @generated
	 */
	SignalsDefinition createSignalsDefinition();

	/**
	 * Returns a new object of class '<em>Signals Partial Default Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signals Partial Default Definition</em>'.
	 * @generated
	 */
	SignalsPartialDefaultDefinition createSignalsPartialDefaultDefinition();

	/**
	 * Returns a new object of class '<em>Signals Partial Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Signals Partial Definition</em>'.
	 * @generated
	 */
	SignalsPartialDefinition createSignalsPartialDefinition();

	/**
	 * Returns a new object of class '<em>State Variables Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>State Variables Declaration</em>'.
	 * @generated
	 */
	StateVariablesDeclaration createStateVariablesDeclaration();

	/**
	 * Returns a new object of class '<em>State Variable Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>State Variable Value</em>'.
	 * @generated
	 */
	StateVariableValue createStateVariableValue();

	/**
	 * Returns a new object of class '<em>String Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Value</em>'.
	 * @generated
	 */
	StringValue createStringValue();

	/**
	 * Returns a new object of class '<em>Transposition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transposition</em>'.
	 * @generated
	 */
	Transposition createTransposition();

	/**
	 * Returns a new object of class '<em>Tuple Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tuple Type</em>'.
	 * @generated
	 */
	TupleType createTupleType();

	/**
	 * Returns a new object of class '<em>Type Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type Description</em>'.
	 * @generated
	 */
	TypeDescription createTypeDescription();

	/**
	 * Returns a new object of class '<em>Type Morphism</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type Morphism</em>'.
	 * @generated
	 */
	TypeMorphism createTypeMorphism();

	/**
	 * Returns a new object of class '<em>Types Declaration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Types Declaration</em>'.
	 * @generated
	 */
	TypesDeclaration createTypesDeclaration();

	/**
	 * Returns a new object of class '<em>Unary Minus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unary Minus</em>'.
	 * @generated
	 */
	UnaryMinus createUnaryMinus();

	/**
	 * Returns a new object of class '<em>Unary Plus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unary Plus</em>'.
	 * @generated
	 */
	UnaryPlus createUnaryPlus();

	/**
	 * Returns a new object of class '<em>Unary When</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unary When</em>'.
	 * @generated
	 */
	UnaryWhen createUnaryWhen();

	/**
	 * Returns a new object of class '<em>Unconditioned Dependences</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unconditioned Dependences</em>'.
	 * @generated
	 */
	UnconditionedDependences createUnconditionedDependences();

	/**
	 * Returns a new object of class '<em>Var</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Var</em>'.
	 * @generated
	 */
	Var createVar();

	/**
	 * Returns a new object of class '<em>When</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>When</em>'.
	 * @generated
	 */
	When createWhen();

	/**
	 * Returns a new object of class '<em>Window</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Window</em>'.
	 * @generated
	 */
	Window createWindow();

	/**
	 * Returns a new object of class '<em>Xor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xor</em>'.
	 * @generated
	 */
	Xor createXor();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	SsmePackage getSsmePackage();

} //SsmeFactory
