/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.pop.ssme.SsmeFactory
 * @model kind="package"
 * @generated
 */
public interface SsmePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "ssme";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.irisa.fr/espresso/ssme.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "ssme";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SsmePackage eINSTANCE = org.eclipse.pop.ssme.impl.SsmePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalElementImpl <em>Signal Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalElementImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalElement()
	 * @generated
	 */
	int SIGNAL_ELEMENT = 129;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_ELEMENT__COMMENT_PRE = 0;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_ELEMENT__COMMENT_POST = 1;

	/**
	 * The number of structural features of the '<em>Signal Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_ELEMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ExprSignal <em>Expr Signal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ExprSignal
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExprSignal()
	 * @generated
	 */
	int EXPR_SIGNAL = 61;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_SIGNAL__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_SIGNAL__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Expr Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_SIGNAL_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.BinaryOperators <em>Binary Operators</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.BinaryOperators
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getBinaryOperators()
	 * @generated
	 */
	int BINARY_OPERATORS = 11;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATORS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATORS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATORS__EXPR_SIGNAL1 = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATORS__EXPR_SIGNAL2 = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Binary Operators</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATORS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.AfterImpl <em>After</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.AfterImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getAfter()
	 * @generated
	 */
	int AFTER = 0;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFTER__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFTER__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFTER__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFTER__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>After</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFTER_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.AndImpl <em>And</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.AndImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getAnd()
	 * @generated
	 */
	int AND = 1;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>And</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayElemImpl <em>Array Elem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayElemImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayElem()
	 * @generated
	 */
	int ARRAY_ELEM = 2;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEM__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEM__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEM__EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEM__LIST_EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Array Elem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEM_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.IterativeEnumeration <em>Iterative Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.IterativeEnumeration
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIterativeEnumeration()
	 * @generated
	 */
	int ITERATIVE_ENUMERATION = 80;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATIVE_ENUMERATION__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATIVE_ENUMERATION__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Iterative Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATIVE_ENUMERATION_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayElementsEnumerationImpl <em>Array Elements Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayElementsEnumerationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayElementsEnumeration()
	 * @generated
	 */
	int ARRAY_ELEMENTS_ENUMERATION = 3;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEMENTS_ENUMERATION__COMMENT_PRE = ITERATIVE_ENUMERATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEMENTS_ENUMERATION__COMMENT_POST = ITERATIVE_ENUMERATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Partial Array Definition</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION = ITERATIVE_ENUMERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Array Elements Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ELEMENTS_ENUMERATION_FEATURE_COUNT = ITERATIVE_ENUMERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayIndexImpl <em>Array Index</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayIndexImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayIndex()
	 * @generated
	 */
	int ARRAY_INDEX = 4;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_INDEX__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_INDEX__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_INDEX__IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_INDEX__UPPER_BOUND = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Array Index</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_INDEX_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ExprProcess <em>Expr Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ExprProcess
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExprProcess()
	 * @generated
	 */
	int EXPR_PROCESS = 60;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PROCESS__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PROCESS__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Expr Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PROCESS_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.IterationOfProcesses <em>Iteration Of Processes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.IterationOfProcesses
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIterationOfProcesses()
	 * @generated
	 */
	int ITERATION_OF_PROCESSES = 78;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_OF_PROCESSES__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_OF_PROCESSES__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Iteration Of Processes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_OF_PROCESSES_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayProcessImpl <em>Array Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayProcess()
	 * @generated
	 */
	int ARRAY_PROCESS = 5;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS__COMMENT_PRE = ITERATION_OF_PROCESSES__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS__COMMENT_POST = ITERATION_OF_PROCESSES__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Array Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS__ARRAY_INDEX = ITERATION_OF_PROCESSES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS__EXPR_PROCESS = ITERATION_OF_PROCESSES_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Iteration Init</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS__ITERATION_INIT = ITERATION_OF_PROCESSES_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Array Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PROCESS_FEATURE_COUNT = ITERATION_OF_PROCESSES_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayProductImpl <em>Array Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayProductImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayProduct()
	 * @generated
	 */
	int ARRAY_PRODUCT = 6;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PRODUCT__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PRODUCT__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PRODUCT__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PRODUCT__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Array Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_PRODUCT_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayRestructurationImpl <em>Array Restructuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayRestructurationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayRestructuration()
	 * @generated
	 */
	int ARRAY_RESTRUCTURATION = 7;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_RESTRUCTURATION__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_RESTRUCTURATION__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_RESTRUCTURATION__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_RESTRUCTURATION__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Array Restructuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_RESTRUCTURATION_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.TypeDescriptionValue <em>Type Description Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.TypeDescriptionValue
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypeDescriptionValue()
	 * @generated
	 */
	int TYPE_DESCRIPTION_VALUE = 145;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION_VALUE__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION_VALUE__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Type Description Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION_VALUE_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.Type <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.Type
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getType()
	 * @generated
	 */
	int TYPE = 142;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__COMMENT_PRE = TYPE_DESCRIPTION_VALUE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE__COMMENT_POST = TYPE_DESCRIPTION_VALUE__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_FEATURE_COUNT = TYPE_DESCRIPTION_VALUE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.DescribedType <em>Described Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.DescribedType
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDescribedType()
	 * @generated
	 */
	int DESCRIBED_TYPE = 51;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIBED_TYPE__COMMENT_PRE = TYPE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIBED_TYPE__COMMENT_POST = TYPE__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Described Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIBED_TYPE_FEATURE_COUNT = TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ArrayTypeImpl <em>Array Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ArrayTypeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getArrayType()
	 * @generated
	 */
	int ARRAY_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__COMMENT_PRE = DESCRIBED_TYPE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__COMMENT_POST = DESCRIBED_TYPE__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__EXPR_DIMENSION = DESCRIBED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__TYPE = DESCRIBED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Array Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE_FEATURE_COUNT = DESCRIBED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.AssertProcessImpl <em>Assert Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.AssertProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getAssertProcess()
	 * @generated
	 */
	int ASSERT_PROCESS = 9;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_PROCESS__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_PROCESS__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Process Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_PROCESS__PROCESS_EXPRESSION = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Assert Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_PROCESS_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ProcessCallOrAssert <em>Process Call Or Assert</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ProcessCallOrAssert
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessCallOrAssert()
	 * @generated
	 */
	int PROCESS_CALL_OR_ASSERT = 114;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL_OR_ASSERT__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL_OR_ASSERT__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Process Call Or Assert</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL_OR_ASSERT_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.AssertSignalImpl <em>Assert Signal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.AssertSignalImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getAssertSignal()
	 * @generated
	 */
	int ASSERT_SIGNAL = 10;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_SIGNAL__COMMENT_PRE = PROCESS_CALL_OR_ASSERT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_SIGNAL__COMMENT_POST = PROCESS_CALL_OR_ASSERT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_SIGNAL__EXPR_SIGNAL = PROCESS_CALL_OR_ASSERT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Assert Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSERT_SIGNAL_FEATURE_COUNT = PROCESS_CALL_OR_ASSERT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.BoundsImpl <em>Bounds</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.BoundsImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getBounds()
	 * @generated
	 */
	int BOUNDS = 12;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS__LOWER_BOUND = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS__UPPER_BOUND = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS__STEP = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Bounds</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDS_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CartesianProductImpl <em>Cartesian Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CartesianProductImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCartesianProduct()
	 * @generated
	 */
	int CARTESIAN_PRODUCT = 13;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_PRODUCT__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_PRODUCT__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_PRODUCT__LIST_EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Cartesian Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_PRODUCT_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.CaseExprEnumeration <em>Case Expr Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.CaseExprEnumeration
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCaseExprEnumeration()
	 * @generated
	 */
	int CASE_EXPR_ENUMERATION = 15;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPR_ENUMERATION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPR_ENUMERATION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Case Expr Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_EXPR_ENUMERATION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CaseEnumerationImpl <em>Case Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CaseEnumerationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCaseEnumeration()
	 * @generated
	 */
	int CASE_ENUMERATION = 14;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_ENUMERATION__COMMENT_PRE = CASE_EXPR_ENUMERATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_ENUMERATION__COMMENT_POST = CASE_EXPR_ENUMERATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_ENUMERATION__LIST_EXPR_SIGNAL = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Case Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_ENUMERATION_FEATURE_COUNT = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CaseIntervalImpl <em>Case Interval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CaseIntervalImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCaseInterval()
	 * @generated
	 */
	int CASE_INTERVAL = 16;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL__COMMENT_PRE = CASE_EXPR_ENUMERATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL__COMMENT_POST = CASE_EXPR_ENUMERATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL__LOWER_BOUND = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL__UPPER_BOUND = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Intervals Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL__INTERVALS_KIND = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Case Interval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_INTERVAL_FEATURE_COUNT = CASE_EXPR_ENUMERATION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CaseProcessImpl <em>Case Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CaseProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCaseProcess()
	 * @generated
	 */
	int CASE_PROCESS = 17;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS__IDENTIFIER = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Case Branch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS__LIST_CASE_BRANCH = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Else Case</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS__ELSE_CASE = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Case Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_PROCESS_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CaseBranchImpl <em>Case Branch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CaseBranchImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCaseBranch()
	 * @generated
	 */
	int CASE_BRANCH = 18;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_BRANCH__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_BRANCH__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Enumeration Values</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_BRANCH__ENUMERATION_VALUES = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_BRANCH__EXPR_PROCESS = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Case Branch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CASE_BRANCH_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.TernaryOperators <em>Ternary Operators</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.TernaryOperators
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTernaryOperators()
	 * @generated
	 */
	int TERNARY_OPERATORS = 139;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS__EXPR_SIGNAL1 = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS__EXPR_SIGNAL2 = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS__EXPR_SIGNAL3 = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ternary Operators</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERNARY_OPERATORS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CellImpl <em>Cell</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CellImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCell()
	 * @generated
	 */
	int CELL = 19;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL__COMMENT_PRE = TERNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL__COMMENT_POST = TERNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL__EXPR_SIGNAL1 = TERNARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL__EXPR_SIGNAL2 = TERNARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL__EXPR_SIGNAL3 = TERNARY_OPERATORS__EXPR_SIGNAL3;

	/**
	 * The number of structural features of the '<em>Cell</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CELL_FEATURE_COUNT = TERNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.UnaryOperators <em>Unary Operators</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.UnaryOperators
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getUnaryOperators()
	 * @generated
	 */
	int UNARY_OPERATORS = 151;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_OPERATORS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_OPERATORS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_OPERATORS__EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Unary Operators</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_OPERATORS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockImpl <em>Clock</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClock()
	 * @generated
	 */
	int CLOCK = 20;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockDifferenceImpl <em>Clock Difference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockDifferenceImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockDifference()
	 * @generated
	 */
	int CLOCK_DIFFERENCE = 21;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_DIFFERENCE__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_DIFFERENCE__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_DIFFERENCE__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_DIFFERENCE__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Clock Difference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_DIFFERENCE_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockEqualityImpl <em>Clock Equality</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockEqualityImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockEquality()
	 * @generated
	 */
	int CLOCK_EQUALITY = 22;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EQUALITY__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EQUALITY__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EQUALITY__EXPR_SIGNAL = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clock Equality</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EQUALITY_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockExclusiveRelationImpl <em>Clock Exclusive Relation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockExclusiveRelationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockExclusiveRelation()
	 * @generated
	 */
	int CLOCK_EXCLUSIVE_RELATION = 23;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EXCLUSIVE_RELATION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EXCLUSIVE_RELATION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EXCLUSIVE_RELATION__EXPR_SIGNAL = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clock Exclusive Relation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_EXCLUSIVE_RELATION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockInfRelationImpl <em>Clock Inf Relation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockInfRelationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockInfRelation()
	 * @generated
	 */
	int CLOCK_INF_RELATION = 24;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_INF_RELATION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_INF_RELATION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_INF_RELATION__EXPR_SIGNAL = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clock Inf Relation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_INF_RELATION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockProductImpl <em>Clock Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockProductImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockProduct()
	 * @generated
	 */
	int CLOCK_PRODUCT = 25;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_PRODUCT__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_PRODUCT__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_PRODUCT__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_PRODUCT__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Clock Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_PRODUCT_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockSupRelationImpl <em>Clock Sup Relation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockSupRelationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockSupRelation()
	 * @generated
	 */
	int CLOCK_SUP_RELATION = 26;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SUP_RELATION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SUP_RELATION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SUP_RELATION__EXPR_SIGNAL = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Clock Sup Relation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_SUP_RELATION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ClockUnionImpl <em>Clock Union</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ClockUnionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getClockUnion()
	 * @generated
	 */
	int CLOCK_UNION = 27;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_UNION__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_UNION__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_UNION__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_UNION__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Clock Union</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOCK_UNION_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CommentImpl <em>Comment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CommentImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getComment()
	 * @generated
	 */
	int COMMENT = 28;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT__ATOM_STRING = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Comment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMMENT_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ComplexConstructorImpl <em>Complex Constructor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ComplexConstructorImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getComplexConstructor()
	 * @generated
	 */
	int COMPLEX_CONSTRUCTOR = 29;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_CONSTRUCTOR__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_CONSTRUCTOR__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_CONSTRUCTOR__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_CONSTRUCTOR__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Complex Constructor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPLEX_CONSTRUCTOR_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CompositionImpl <em>Composition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CompositionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getComposition()
	 * @generated
	 */
	int COMPOSITION = 30;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Expr Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITION__LIST_EXPR_PROCESS = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Composition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConcatenationImpl <em>Concatenation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConcatenationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConcatenation()
	 * @generated
	 */
	int CONCATENATION = 31;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATION__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATION__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATION__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATION__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Concatenation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATION_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.Dependences <em>Dependences</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.Dependences
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDependences()
	 * @generated
	 */
	int DEPENDENCES = 50;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCES__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCES__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Dependences</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCES_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConditionedDependenceImpl <em>Conditioned Dependence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConditionedDependenceImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConditionedDependence()
	 * @generated
	 */
	int CONDITIONED_DEPENDENCE = 32;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE__COMMENT_PRE = DEPENDENCES__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE__COMMENT_POST = DEPENDENCES__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Signals From</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE__SIGNALS_FROM = DEPENDENCES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Signals To</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE__SIGNALS_TO = DEPENDENCES_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Condition Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE__CONDITION_EXPR = DEPENDENCES_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Conditioned Dependence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITIONED_DEPENDENCE_FEATURE_COUNT = DEPENDENCES_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.Constant <em>Constant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.Constant
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstant()
	 * @generated
	 */
	int CONSTANT = 33;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Constant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantCharacterImpl <em>Constant Character</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantCharacterImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantCharacter()
	 * @generated
	 */
	int CONSTANT_CHARACTER = 34;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_CHARACTER__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_CHARACTER__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_CHARACTER__ATOM_STRING = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant Character</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_CHARACTER_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ConstantDefinition <em>Constant Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ConstantDefinition
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantDefinition()
	 * @generated
	 */
	int CONSTANT_DEFINITION = 35;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DEFINITION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DEFINITION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Constant Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DEFINITION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantDescriptionImpl <em>Constant Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantDescriptionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantDescription()
	 * @generated
	 */
	int CONSTANT_DESCRIPTION = 36;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION__COMMENT_PRE = CONSTANT_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION__COMMENT_POST = CONSTANT_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION__IDENTIFIER = CONSTANT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constant Description Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE = CONSTANT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Constant Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION_FEATURE_COUNT = CONSTANT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ConstantDescriptionValue <em>Constant Description Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ConstantDescriptionValue
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantDescriptionValue()
	 * @generated
	 */
	int CONSTANT_DESCRIPTION_VALUE = 37;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION_VALUE__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION_VALUE__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Constant Description Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DESCRIPTION_VALUE_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantDoubleRealImpl <em>Constant Double Real</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantDoubleRealImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantDoubleReal()
	 * @generated
	 */
	int CONSTANT_DOUBLE_REAL = 38;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DOUBLE_REAL__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DOUBLE_REAL__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DOUBLE_REAL__ATOM_STRING = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant Double Real</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_DOUBLE_REAL_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantEnumImpl <em>Constant Enum</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantEnumImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantEnum()
	 * @generated
	 */
	int CONSTANT_ENUM = 39;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_ENUM__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_ENUM__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Type Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_ENUM__TYPE_IDENTIFIER = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constant Enum Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_ENUM__CONSTANT_ENUM_VALUE = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Constant Enum</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_ENUM_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantIntegerImpl <em>Constant Integer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantIntegerImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantInteger()
	 * @generated
	 */
	int CONSTANT_INTEGER = 40;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_INTEGER__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_INTEGER__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_INTEGER__ATOM_STRING = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant Integer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_INTEGER_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantLogicalImpl <em>Constant Logical</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantLogicalImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantLogical()
	 * @generated
	 */
	int CONSTANT_LOGICAL = 41;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_LOGICAL__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_LOGICAL__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Constant Logical Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant Logical</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_LOGICAL_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantRealImpl <em>Constant Real</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantRealImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantReal()
	 * @generated
	 */
	int CONSTANT_REAL = 42;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_REAL__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_REAL__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_REAL__ATOM_STRING = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant Real</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_REAL_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.Declaration <em>Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.Declaration
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDeclaration()
	 * @generated
	 */
	int DECLARATION = 47;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECLARATION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantsDeclarationImpl <em>Constants Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantsDeclarationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantsDeclaration()
	 * @generated
	 */
	int CONSTANTS_DECLARATION = 43;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION__VISIBILITY = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION__TYPE = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>List Constant Definition</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION = DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Constants Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANTS_DECLARATION_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConstantStringImpl <em>Constant String</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConstantStringImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantString()
	 * @generated
	 */
	int CONSTANT_STRING = 44;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_STRING__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_STRING__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_STRING__ATOM_STRING = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Constant String</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_STRING_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ConversionImpl <em>Conversion</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ConversionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConversion()
	 * @generated
	 */
	int CONVERSION = 45;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION__PREDEFINED_TYPE = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION__EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Conversion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.CountImpl <em>Count</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.CountImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getCount()
	 * @generated
	 */
	int COUNT = 46;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Count</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.DefaultImpl <em>Default</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.DefaultImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDefault()
	 * @generated
	 */
	int DEFAULT = 48;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Default</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.DelayImpl <em>Delay</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.DelayImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDelay()
	 * @generated
	 */
	int DELAY = 49;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY__COMMENT_PRE = TERNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY__COMMENT_POST = TERNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY__EXPR_SIGNAL1 = TERNARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY__EXPR_SIGNAL2 = TERNARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY__EXPR_SIGNAL3 = TERNARY_OPERATORS__EXPR_SIGNAL3;

	/**
	 * The number of structural features of the '<em>Delay</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DELAY_FEATURE_COUNT = TERNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.DescriptionImpl <em>Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.DescriptionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDescription()
	 * @generated
	 */
	int DESCRIPTION = 52;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Pragma</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__LIST_PRAGMA = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION__BODY = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESCRIPTION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.DivImpl <em>Div</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.DivImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getDiv()
	 * @generated
	 */
	int DIV = 53;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIV__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIV__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIV__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIV__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Div</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIV_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.PartialArrayDefinition <em>Partial Array Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.PartialArrayDefinition
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPartialArrayDefinition()
	 * @generated
	 */
	int PARTIAL_ARRAY_DEFINITION = 104;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ARRAY_DEFINITION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ARRAY_DEFINITION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Partial Array Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ElemDefinitionImpl <em>Elem Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ElemDefinitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getElemDefinition()
	 * @generated
	 */
	int ELEM_DEFINITION = 54;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION__COMMENT_PRE = PARTIAL_ARRAY_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION__COMMENT_POST = PARTIAL_ARRAY_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION__EXPR_DIMENSION = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION__EXPR_SIGNAL = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Elem Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION_FEATURE_COUNT = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ElemDefinitionEnumerationImpl <em>Elem Definition Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ElemDefinitionEnumerationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getElemDefinitionEnumeration()
	 * @generated
	 */
	int ELEM_DEFINITION_ENUMERATION = 55;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION_ENUMERATION__COMMENT_PRE = ITERATIVE_ENUMERATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION_ENUMERATION__COMMENT_POST = ITERATIVE_ENUMERATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL = ITERATIVE_ENUMERATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Elem Definition Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEM_DEFINITION_ENUMERATION_FEATURE_COUNT = ITERATIVE_ENUMERATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.EnumerationTypeImpl <em>Enumeration Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.EnumerationTypeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getEnumerationType()
	 * @generated
	 */
	int ENUMERATION_TYPE = 56;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_TYPE__COMMENT_PRE = DESCRIBED_TYPE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_TYPE__COMMENT_POST = DESCRIBED_TYPE__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Identifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_TYPE__LIST_IDENTIFIER = DESCRIBED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enumeration Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_TYPE_FEATURE_COUNT = DESCRIBED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.EqualImpl <em>Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.EqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getEqual()
	 * @generated
	 */
	int EQUAL = 57;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.EqualEqualImpl <em>Equal Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.EqualEqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getEqualEqual()
	 * @generated
	 */
	int EQUAL_EQUAL = 58;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Equal Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUAL_EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ExprParam <em>Expr Param</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ExprParam
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExprParam()
	 * @generated
	 */
	int EXPR_PARAM = 59;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PARAM__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PARAM__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Expr Param</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXPR_PARAM_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ProcessBody <em>Process Body</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ProcessBody
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessBody()
	 * @generated
	 */
	int PROCESS_BODY = 112;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_BODY__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_BODY__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Process Body</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_BODY_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ExternalAttributeImpl <em>External Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ExternalAttributeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExternalAttribute()
	 * @generated
	 */
	int EXTERNAL_ATTRIBUTE = 62;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ATTRIBUTE__COMMENT_PRE = PROCESS_BODY__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ATTRIBUTE__COMMENT_POST = PROCESS_BODY__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ATTRIBUTE__STRING = PROCESS_BODY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>External Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_ATTRIBUTE_FEATURE_COUNT = PROCESS_BODY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ExternalGraphImpl <em>External Graph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ExternalGraphImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExternalGraph()
	 * @generated
	 */
	int EXTERNAL_GRAPH = 63;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_GRAPH__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_GRAPH__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Process Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_GRAPH__PROCESS_ATTRIBUTES = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Graph Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_GRAPH__GRAPH_SPECIFICATION = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>External Graph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_GRAPH_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ExternalReferencesImpl <em>External References</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ExternalReferencesImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getExternalReferences()
	 * @generated
	 */
	int EXTERNAL_REFERENCES = 64;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_REFERENCES__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_REFERENCES__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Identifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_REFERENCES__LIST_IDENTIFIER = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>External References</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_REFERENCES_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.FieldAccessImpl <em>Field Access</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.FieldAccessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getFieldAccess()
	 * @generated
	 */
	int FIELD_ACCESS = 65;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIELD_ACCESS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIELD_ACCESS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIELD_ACCESS__EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIELD_ACCESS__IDENTIFIER = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Field Access</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FIELD_ACCESS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration <em>Types Or Signals Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.TypesOrSignalsDeclaration
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypesOrSignalsDeclaration()
	 * @generated
	 */
	int TYPES_OR_SIGNALS_DECLARATION = 148;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_OR_SIGNALS_DECLARATION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_OR_SIGNALS_DECLARATION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Types Or Signals Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.FormalProcessImpl <em>Formal Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.FormalProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getFormalProcess()
	 * @generated
	 */
	int FORMAL_PROCESS = 66;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS__COMMENT_PRE = TYPES_OR_SIGNALS_DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS__COMMENT_POST = TYPES_OR_SIGNALS_DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Model Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS__MODEL_KIND = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS__MODEL_TYPE = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Model Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS__MODEL_NAME = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Formal Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMAL_PROCESS_FEATURE_COUNT = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.FromImpl <em>From</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.FromImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getFrom()
	 * @generated
	 */
	int FROM = 67;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>From</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FROM_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.GraphSpecificationImpl <em>Graph Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.GraphSpecificationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getGraphSpecification()
	 * @generated
	 */
	int GRAPH_SPECIFICATION = 68;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_SPECIFICATION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_SPECIFICATION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_SPECIFICATION__EXPR_PROCESS = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Graph Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAPH_SPECIFICATION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.GreaterImpl <em>Greater</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.GreaterImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getGreater()
	 * @generated
	 */
	int GREATER = 69;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Greater</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.GreaterOrEqualImpl <em>Greater Or Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.GreaterOrEqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getGreaterOrEqual()
	 * @generated
	 */
	int GREATER_OR_EQUAL = 70;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_OR_EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_OR_EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_OR_EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_OR_EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Greater Or Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GREATER_OR_EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IdentifierImpl <em>Identifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IdentifierImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIdentifier()
	 * @generated
	 */
	int IDENTIFIER = 71;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Atom String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER__ATOM_STRING = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Identifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIER_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IdentityEquationImpl <em>Identity Equation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IdentityEquationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIdentityEquation()
	 * @generated
	 */
	int IDENTITY_EQUATION = 72;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTITY_EQUATION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTITY_EQUATION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTITY_EQUATION__EXPR_SIGNAL_LEFT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTITY_EQUATION__EXPR_SIGNAL_RIGHT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Identity Equation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTITY_EQUATION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IfThenElseImpl <em>If Then Else</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IfThenElseImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIfThenElse()
	 * @generated
	 */
	int IF_THEN_ELSE = 73;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE__COMMENT_PRE = TERNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE__COMMENT_POST = TERNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE__EXPR_SIGNAL1 = TERNARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE__EXPR_SIGNAL2 = TERNARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE__EXPR_SIGNAL3 = TERNARY_OPERATORS__EXPR_SIGNAL3;

	/**
	 * The number of structural features of the '<em>If Then Else</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IF_THEN_ELSE_FEATURE_COUNT = TERNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IndexImpl <em>Index</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IndexImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIndex()
	 * @generated
	 */
	int INDEX = 74;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX__COMMENT_PRE = TERNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX__COMMENT_POST = TERNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX__EXPR_SIGNAL1 = TERNARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX__EXPR_SIGNAL2 = TERNARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX__EXPR_SIGNAL3 = TERNARY_OPERATORS__EXPR_SIGNAL3;

	/**
	 * The number of structural features of the '<em>Index</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDEX_FEATURE_COUNT = TERNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.InterfaceDefinition <em>Interface Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.InterfaceDefinition
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getInterfaceDefinition()
	 * @generated
	 */
	int INTERFACE_DEFINITION = 75;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_DEFINITION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_DEFINITION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Interface Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_DEFINITION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IOProfileImpl <em>IO Profile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IOProfileImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIOProfile()
	 * @generated
	 */
	int IO_PROFILE = 76;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_PROFILE__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_PROFILE__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Inputs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_PROFILE__INPUTS = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Outputs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_PROFILE__OUTPUTS = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>IO Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_PROFILE_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IterationImpl <em>Iteration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IterationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIteration()
	 * @generated
	 */
	int ITERATION = 77;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION__COMMENT_PRE = PARTIAL_ARRAY_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION__COMMENT_POST = PARTIAL_ARRAY_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Partial Iteration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION__PARTIAL_ITERATION = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elem Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION__ELEM_DEFINITION = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Iteration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_FEATURE_COUNT = PARTIAL_ARRAY_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.IterationProcessImpl <em>Iteration Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.IterationProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIterationProcess()
	 * @generated
	 */
	int ITERATION_PROCESS = 79;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS__COMMENT_PRE = ITERATION_OF_PROCESSES__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS__COMMENT_POST = ITERATION_OF_PROCESSES__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Iteration Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS__ITERATION_INDEX = ITERATION_OF_PROCESSES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS__EXPR_PROCESS = ITERATION_OF_PROCESSES_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Iteration Init</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS__ITERATION_INIT = ITERATION_OF_PROCESSES_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Iteration Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATION_PROCESS_FEATURE_COUNT = ITERATION_OF_PROCESSES_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.LabelledProcessImpl <em>Labelled Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.LabelledProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getLabelledProcess()
	 * @generated
	 */
	int LABELLED_PROCESS = 81;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELLED_PROCESS__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELLED_PROCESS__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELLED_PROCESS__LABEL = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELLED_PROCESS__EXPR_PROCESS = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Labelled Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELLED_PROCESS_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.LabelsImpl <em>Labels</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.LabelsImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getLabels()
	 * @generated
	 */
	int LABELS = 82;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELS__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELS__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Identifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELS__LIST_IDENTIFIER = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Labels</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABELS_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.LessImpl <em>Less</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.LessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getLess()
	 * @generated
	 */
	int LESS = 83;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Less</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.LessLessEqualImpl <em>Less Less Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.LessLessEqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getLessLessEqual()
	 * @generated
	 */
	int LESS_LESS_EQUAL = 84;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_LESS_EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_LESS_EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_LESS_EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_LESS_EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Less Less Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_LESS_EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.LessOrEqualImpl <em>Less Or Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.LessOrEqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getLessOrEqual()
	 * @generated
	 */
	int LESS_OR_EQUAL = 85;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_OR_EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_OR_EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_OR_EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_OR_EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Less Or Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LESS_OR_EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ListExprSignalImpl <em>List Expr Signal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ListExprSignalImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getListExprSignal()
	 * @generated
	 */
	int LIST_EXPR_SIGNAL = 86;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_EXPR_SIGNAL__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_EXPR_SIGNAL__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_EXPR_SIGNAL__EXPR_SIGNAL = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Expr Signal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_EXPR_SIGNAL_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ListFlowsImpl <em>List Flows</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ListFlowsImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getListFlows()
	 * @generated
	 */
	int LIST_FLOWS = 87;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_FLOWS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_FLOWS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_FLOWS__EXPR_SIGNAL = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Flows</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_FLOWS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.RootModel <em>Root Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.RootModel
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getRootModel()
	 * @generated
	 */
	int ROOT_MODEL = 126;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_MODEL__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_MODEL__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Root Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_MODEL_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ListModuleImpl <em>List Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ListModuleImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getListModule()
	 * @generated
	 */
	int LIST_MODULE = 88;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_MODULE__COMMENT_PRE = ROOT_MODEL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_MODULE__COMMENT_POST = ROOT_MODEL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Module</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_MODULE__LIST_MODULE = ROOT_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIST_MODULE_FEATURE_COUNT = ROOT_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.MaskingImpl <em>Masking</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.MaskingImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getMasking()
	 * @generated
	 */
	int MASKING = 89;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASKING__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASKING__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASKING__EXPR_PROCESS = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Identifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASKING__LIST_IDENTIFIER = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Masking</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASKING_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.MinusImpl <em>Minus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.MinusImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getMinus()
	 * @generated
	 */
	int MINUS = 90;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MINUS__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MINUS__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MINUS__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MINUS__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Minus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MINUS_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ModuleImpl <em>Module</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ModuleImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getModule()
	 * @generated
	 */
	int MODULE = 91;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE__IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Module Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE__MODULE_DESCRIPTION = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Module</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ModuleDescriptionImpl <em>Module Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ModuleDescriptionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getModuleDescription()
	 * @generated
	 */
	int MODULE_DESCRIPTION = 92;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_DESCRIPTION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_DESCRIPTION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Pragma</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_DESCRIPTION__LIST_PRAGMA = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Declaration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_DESCRIPTION__LIST_DECLARATION = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Module Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULE_DESCRIPTION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ModulesImportImpl <em>Modules Import</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ModulesImportImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getModulesImport()
	 * @generated
	 */
	int MODULES_IMPORT = 93;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULES_IMPORT__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULES_IMPORT__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Module</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULES_IMPORT__LIST_MODULE = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Modules Import</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULES_IMPORT_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ModuloImpl <em>Modulo</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ModuloImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getModulo()
	 * @generated
	 */
	int MODULO = 94;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULO__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULO__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULO__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULO__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Modulo</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MODULO_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.NotImpl <em>Not</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.NotImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getNot()
	 * @generated
	 */
	int NOT = 95;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Not</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.NotEqualImpl <em>Not Equal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.NotEqualImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getNotEqual()
	 * @generated
	 */
	int NOT_EQUAL = 96;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EQUAL__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EQUAL__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EQUAL__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EQUAL__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Not Equal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_EQUAL_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.NullaryOperators <em>Nullary Operators</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.NullaryOperators
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getNullaryOperators()
	 * @generated
	 */
	int NULLARY_OPERATORS = 97;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULLARY_OPERATORS__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULLARY_OPERATORS__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Nullary Operators</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULLARY_OPERATORS_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.NullClockImpl <em>Null Clock</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.NullClockImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getNullClock()
	 * @generated
	 */
	int NULL_CLOCK = 98;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_CLOCK__COMMENT_PRE = NULLARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_CLOCK__COMMENT_POST = NULLARY_OPERATORS__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Null Clock</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_CLOCK_FEATURE_COUNT = NULLARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.NullProcImpl <em>Null Proc</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.NullProcImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getNullProc()
	 * @generated
	 */
	int NULL_PROC = 99;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_PROC__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_PROC__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Null Proc</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_PROC_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.OperatorIdentifier <em>Operator Identifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.OperatorIdentifier
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getOperatorIdentifier()
	 * @generated
	 */
	int OPERATOR_IDENTIFIER = 101;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_IDENTIFIER__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_IDENTIFIER__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Operator Identifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_IDENTIFIER_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.OperatorImpl <em>Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.OperatorImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getOperator()
	 * @generated
	 */
	int OPERATOR = 100;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR__COMMENT_PRE = OPERATOR_IDENTIFIER__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR__COMMENT_POST = OPERATOR_IDENTIFIER__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Operator Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR__OPERATOR_KIND = OPERATOR_IDENTIFIER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_FEATURE_COUNT = OPERATOR_IDENTIFIER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.OperatorModelImpl <em>Operator Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.OperatorModelImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getOperatorModel()
	 * @generated
	 */
	int OPERATOR_MODEL = 102;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Operator Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL__OPERATOR_IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interface Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL__INTERFACE_DEFINITION = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL__DESCRIPTION = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Operator Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATOR_MODEL_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.OrImpl <em>Or</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.OrImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getOr()
	 * @generated
	 */
	int OR = 103;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Or</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PartialIterationImpl <em>Partial Iteration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PartialIterationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPartialIteration()
	 * @generated
	 */
	int PARTIAL_ITERATION = 105;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ITERATION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ITERATION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Index</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ITERATION__INDEX = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ITERATION__BOUNDS = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Partial Iteration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTIAL_ITERATION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PlusImpl <em>Plus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PlusImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPlus()
	 * @generated
	 */
	int PLUS = 106;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUS__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUS__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUS__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUS__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Plus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLUS_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PowerImpl <em>Power</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PowerImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPower()
	 * @generated
	 */
	int POWER = 107;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Power</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POWER_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PragmaImpl <em>Pragma</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PragmaImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPragma()
	 * @generated
	 */
	int PRAGMA = 108;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA__IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Pragma Object</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA__LIST_PRAGMA_OBJECT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Pragma Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA__PRAGMA_STATEMENT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Pragma</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRAGMA_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PredefinedTypeImpl <em>Predefined Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PredefinedTypeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPredefinedType()
	 * @generated
	 */
	int PREDEFINED_TYPE = 109;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_TYPE__COMMENT_PRE = DESCRIBED_TYPE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_TYPE__COMMENT_POST = DESCRIBED_TYPE__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_TYPE__TYPE = DESCRIBED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Predefined Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREDEFINED_TYPE_FEATURE_COUNT = DESCRIBED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.PreviousIterationRefImpl <em>Previous Iteration Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.PreviousIterationRefImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getPreviousIterationRef()
	 * @generated
	 */
	int PREVIOUS_ITERATION_REF = 110;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREVIOUS_ITERATION_REF__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREVIOUS_ITERATION_REF__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREVIOUS_ITERATION_REF__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Previous Iteration Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREVIOUS_ITERATION_REF_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessAttributeImpl <em>Process Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessAttributeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessAttribute()
	 * @generated
	 */
	int PROCESS_ATTRIBUTE = 111;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ATTRIBUTE__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ATTRIBUTE__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Process Attribute Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Process Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_ATTRIBUTE_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessCallImpl <em>Process Call</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessCallImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessCall()
	 * @generated
	 */
	int PROCESS_CALL = 113;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL__COMMENT_PRE = PROCESS_CALL_OR_ASSERT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL__COMMENT_POST = PROCESS_CALL_OR_ASSERT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Reference Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL__REFERENCE_PROCESS = PROCESS_CALL_OR_ASSERT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL__LIST_EXPR_SIGNAL = PROCESS_CALL_OR_ASSERT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Call</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_CALL_FEATURE_COUNT = PROCESS_CALL_OR_ASSERT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ProcessDeclaration <em>Process Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ProcessDeclaration
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessDeclaration()
	 * @generated
	 */
	int PROCESS_DECLARATION = 115;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_DECLARATION__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_DECLARATION__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Process Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_DECLARATION_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ProcessInstance <em>Process Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ProcessInstance
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessInstance()
	 * @generated
	 */
	int PROCESS_INSTANCE = 117;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_INSTANCE__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_INSTANCE__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Process Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_INSTANCE_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessExpansionImpl <em>Process Expansion</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessExpansionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessExpansion()
	 * @generated
	 */
	int PROCESS_EXPANSION = 116;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EXPANSION__COMMENT_PRE = PROCESS_INSTANCE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EXPANSION__COMMENT_POST = PROCESS_INSTANCE__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EXPANSION__IDENTIFIER = PROCESS_INSTANCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Expr Param</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EXPANSION__LIST_EXPR_PARAM = PROCESS_INSTANCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Process Expansion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_EXPANSION_FEATURE_COUNT = PROCESS_INSTANCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessModelImpl <em>Process Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessModelImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessModel()
	 * @generated
	 */
	int PROCESS_MODEL = 118;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interface Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__INTERFACE_DEFINITION = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__DESCRIPTION = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Model Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__MODEL_KIND = SIGNAL_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Visibility Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL__VISIBILITY_KIND = SIGNAL_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Process Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessModelInterfaceImpl <em>Process Model Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessModelInterfaceImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessModelInterface()
	 * @generated
	 */
	int PROCESS_MODEL_INTERFACE = 119;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE__COMMENT_PRE = INTERFACE_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE__COMMENT_POST = INTERFACE_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Formal Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER = INTERFACE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Io Profile</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE__IO_PROFILE = INTERFACE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>External Graph</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH = INTERFACE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Process Model Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_MODEL_INTERFACE_FEATURE_COUNT = INTERFACE_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.TypeDefinition <em>Type Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.TypeDefinition
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypeDefinition()
	 * @generated
	 */
	int TYPE_DEFINITION = 143;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Type Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DEFINITION_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProcessTypeImpl <em>Process Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProcessTypeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessType()
	 * @generated
	 */
	int PROCESS_TYPE = 120;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__COMMENT_PRE = TYPE_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__COMMENT_POST = TYPE_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Model Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__MODEL_KIND = TYPE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__IDENTIFIER = TYPE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Interface Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__INTERFACE_DEFINITION = TYPE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>List Pragma</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE__LIST_PRAGMA = TYPE_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Process Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_TYPE_FEATURE_COUNT = TYPE_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.ProductImpl <em>Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.ProductImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProduct()
	 * @generated
	 */
	int PRODUCT = 121;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCT_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.RecoverImpl <em>Recover</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.RecoverImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getRecover()
	 * @generated
	 */
	int RECOVER = 122;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECOVER__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECOVER__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECOVER__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECOVER__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Recover</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECOVER_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ReferenceProcess <em>Reference Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ReferenceProcess
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getReferenceProcess()
	 * @generated
	 */
	int REFERENCE_PROCESS = 123;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_PROCESS__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_PROCESS__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The number of structural features of the '<em>Reference Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_PROCESS_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.RepetitionImpl <em>Repetition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.RepetitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getRepetition()
	 * @generated
	 */
	int REPETITION = 124;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Repetition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPETITION_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.RestrictionProcessImpl <em>Restriction Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.RestrictionProcessImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getRestrictionProcess()
	 * @generated
	 */
	int RESTRICTION_PROCESS = 125;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESTRICTION_PROCESS__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESTRICTION_PROCESS__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESTRICTION_PROCESS__EXPR_PROCESS = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Declarations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESTRICTION_PROCESS__LIST_DECLARATIONS = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Restriction Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESTRICTION_PROCESS_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SequentialDefinitionImpl <em>Sequential Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SequentialDefinitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSequentialDefinition()
	 * @generated
	 */
	int SEQUENTIAL_DEFINITION = 127;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_DEFINITION__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_DEFINITION__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_DEFINITION__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_DEFINITION__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Sequential Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENTIAL_DEFINITION_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SharedVariablesDeclarationImpl <em>Shared Variables Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SharedVariablesDeclarationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSharedVariablesDeclaration()
	 * @generated
	 */
	int SHARED_VARIABLES_DECLARATION = 128;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_VARIABLES_DECLARATION__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_VARIABLES_DECLARATION__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_VARIABLES_DECLARATION__TYPE = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_VARIABLES_DECLARATION__LIST_SIGNAL = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Shared Variables Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_VARIABLES_DECLARATION_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalNamingImpl <em>Signal Naming</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalNamingImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalNaming()
	 * @generated
	 */
	int SIGNAL_NAMING = 130;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_NAMING__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_NAMING__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_NAMING__IDENTIFIER = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Init Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_NAMING__INIT_VALUE = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Signal Naming</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNAL_NAMING_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalsImpl <em>Signals</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalsImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignals()
	 * @generated
	 */
	int SIGNALS = 131;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS__COMMENT_PRE = SIGNAL_ELEMENT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS__COMMENT_POST = SIGNAL_ELEMENT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS__LIST_EXPR_SIGNAL = SIGNAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Signals</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_FEATURE_COUNT = SIGNAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalsDeclarationImpl <em>Signals Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalsDeclarationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalsDeclaration()
	 * @generated
	 */
	int SIGNALS_DECLARATION = 132;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DECLARATION__COMMENT_PRE = TYPES_OR_SIGNALS_DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DECLARATION__COMMENT_POST = TYPES_OR_SIGNALS_DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DECLARATION__TYPE = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DECLARATION__LIST_SIGNAL = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Signals Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DECLARATION_FEATURE_COUNT = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalsDefinitionImpl <em>Signals Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalsDefinitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalsDefinition()
	 * @generated
	 */
	int SIGNALS_DEFINITION = 133;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DEFINITION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DEFINITION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DEFINITION__EXPR_SIGNAL_LEFT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DEFINITION__EXPR_SIGNAL_RIGHT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Signals Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_DEFINITION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalsPartialDefaultDefinitionImpl <em>Signals Partial Default Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalsPartialDefaultDefinitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalsPartialDefaultDefinition()
	 * @generated
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION = 134;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION__EXPR_SIGNAL_LEFT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION__EXPR_SIGNAL_RIGHT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Signals Partial Default Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFAULT_DEFINITION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.SignalsPartialDefinitionImpl <em>Signals Partial Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.SignalsPartialDefinitionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalsPartialDefinition()
	 * @generated
	 */
	int SIGNALS_PARTIAL_DEFINITION = 135;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFINITION__COMMENT_PRE = EXPR_PROCESS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFINITION__COMMENT_POST = EXPR_PROCESS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT = EXPR_PROCESS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr Signal Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT = EXPR_PROCESS_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Signals Partial Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNALS_PARTIAL_DEFINITION_FEATURE_COUNT = EXPR_PROCESS_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.StateVariablesDeclarationImpl <em>State Variables Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.StateVariablesDeclarationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getStateVariablesDeclaration()
	 * @generated
	 */
	int STATE_VARIABLES_DECLARATION = 136;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLES_DECLARATION__COMMENT_PRE = DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLES_DECLARATION__COMMENT_POST = DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLES_DECLARATION__TYPE = DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Signal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLES_DECLARATION__LIST_SIGNAL = DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>State Variables Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLES_DECLARATION_FEATURE_COUNT = DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.StateVariableValueImpl <em>State Variable Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.StateVariableValueImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getStateVariableValue()
	 * @generated
	 */
	int STATE_VARIABLE_VALUE = 137;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLE_VALUE__COMMENT_PRE = EXPR_SIGNAL__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLE_VALUE__COMMENT_POST = EXPR_SIGNAL__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLE_VALUE__IDENTIFIER = EXPR_SIGNAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>State Variable Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VARIABLE_VALUE_FEATURE_COUNT = EXPR_SIGNAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.StringValueImpl <em>String Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.StringValueImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getStringValue()
	 * @generated
	 */
	int STRING_VALUE = 138;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE__COMMENT_PRE = CONSTANT__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE__COMMENT_POST = CONSTANT__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Constant String</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE__LIST_CONSTANT_STRING = CONSTANT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_VALUE_FEATURE_COUNT = CONSTANT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.TranspositionImpl <em>Transposition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.TranspositionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTransposition()
	 * @generated
	 */
	int TRANSPOSITION = 140;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSPOSITION__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSPOSITION__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSPOSITION__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Transposition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSPOSITION_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.TupleTypeImpl <em>Tuple Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.TupleTypeImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTupleType()
	 * @generated
	 */
	int TUPLE_TYPE = 141;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE__COMMENT_PRE = DESCRIBED_TYPE__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE__COMMENT_POST = DESCRIBED_TYPE__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>List Signals Declaration</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE__LIST_SIGNALS_DECLARATION = DESCRIBED_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Graph Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE__GRAPH_SPECIFICATION = DESCRIBED_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE__TYPE_KIND = DESCRIBED_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Tuple Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TUPLE_TYPE_FEATURE_COUNT = DESCRIBED_TYPE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.TypeDescriptionImpl <em>Type Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.TypeDescriptionImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypeDescription()
	 * @generated
	 */
	int TYPE_DESCRIPTION = 144;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION__COMMENT_PRE = TYPE_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION__COMMENT_POST = TYPE_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION__IDENTIFIER = TYPE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Description Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION__TYPE_DESCRIPTION_VALUE = TYPE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Init Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION__INIT_VALUE = TYPE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Type Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DESCRIPTION_FEATURE_COUNT = TYPE_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.TypeMorphismImpl <em>Type Morphism</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.TypeMorphismImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypeMorphism()
	 * @generated
	 */
	int TYPE_MORPHISM = 146;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_MORPHISM__COMMENT_PRE = TYPE_DEFINITION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_MORPHISM__COMMENT_POST = TYPE_DEFINITION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Described Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_MORPHISM__DESCRIBED_TYPE = TYPE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Description Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE = TYPE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Type Morphism</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_MORPHISM_FEATURE_COUNT = TYPE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.TypesDeclarationImpl <em>Types Declaration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.TypesDeclarationImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypesDeclaration()
	 * @generated
	 */
	int TYPES_DECLARATION = 147;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_DECLARATION__COMMENT_PRE = TYPES_OR_SIGNALS_DECLARATION__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_DECLARATION__COMMENT_POST = TYPES_OR_SIGNALS_DECLARATION__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_DECLARATION__VISIBILITY = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type Definition</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_DECLARATION__TYPE_DEFINITION = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Types Declaration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPES_DECLARATION_FEATURE_COUNT = TYPES_OR_SIGNALS_DECLARATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.UnaryMinusImpl <em>Unary Minus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.UnaryMinusImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getUnaryMinus()
	 * @generated
	 */
	int UNARY_MINUS = 149;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_MINUS__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_MINUS__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_MINUS__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Unary Minus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_MINUS_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.UnaryPlusImpl <em>Unary Plus</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.UnaryPlusImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getUnaryPlus()
	 * @generated
	 */
	int UNARY_PLUS = 150;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_PLUS__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_PLUS__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_PLUS__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Unary Plus</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_PLUS_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.UnaryWhenImpl <em>Unary When</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.UnaryWhenImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getUnaryWhen()
	 * @generated
	 */
	int UNARY_WHEN = 152;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_WHEN__COMMENT_PRE = UNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_WHEN__COMMENT_POST = UNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_WHEN__EXPR_SIGNAL = UNARY_OPERATORS__EXPR_SIGNAL;

	/**
	 * The number of structural features of the '<em>Unary When</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNARY_WHEN_FEATURE_COUNT = UNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.UnconditionedDependencesImpl <em>Unconditioned Dependences</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.UnconditionedDependencesImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getUnconditionedDependences()
	 * @generated
	 */
	int UNCONDITIONED_DEPENDENCES = 153;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNCONDITIONED_DEPENDENCES__COMMENT_PRE = DEPENDENCES__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNCONDITIONED_DEPENDENCES__COMMENT_POST = DEPENDENCES__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Signals</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNCONDITIONED_DEPENDENCES__SIGNALS = DEPENDENCES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dependence Elements List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST = DEPENDENCES_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Unconditioned Dependences</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNCONDITIONED_DEPENDENCES_FEATURE_COUNT = DEPENDENCES_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.VarImpl <em>Var</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.VarImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getVar()
	 * @generated
	 */
	int VAR = 154;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VAR__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VAR__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VAR__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VAR__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Var</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VAR_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.WhenImpl <em>When</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.WhenImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getWhen()
	 * @generated
	 */
	int WHEN = 155;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>When</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WHEN_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.WindowImpl <em>Window</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.WindowImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getWindow()
	 * @generated
	 */
	int WINDOW = 156;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW__COMMENT_PRE = TERNARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW__COMMENT_POST = TERNARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW__EXPR_SIGNAL1 = TERNARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW__EXPR_SIGNAL2 = TERNARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The feature id for the '<em><b>Expr Signal3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW__EXPR_SIGNAL3 = TERNARY_OPERATORS__EXPR_SIGNAL3;

	/**
	 * The number of structural features of the '<em>Window</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WINDOW_FEATURE_COUNT = TERNARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.impl.XorImpl <em>Xor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.impl.XorImpl
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getXor()
	 * @generated
	 */
	int XOR = 157;

	/**
	 * The feature id for the '<em><b>Comment Pre</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XOR__COMMENT_PRE = BINARY_OPERATORS__COMMENT_PRE;

	/**
	 * The feature id for the '<em><b>Comment Post</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XOR__COMMENT_POST = BINARY_OPERATORS__COMMENT_POST;

	/**
	 * The feature id for the '<em><b>Expr Signal1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XOR__EXPR_SIGNAL1 = BINARY_OPERATORS__EXPR_SIGNAL1;

	/**
	 * The feature id for the '<em><b>Expr Signal2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XOR__EXPR_SIGNAL2 = BINARY_OPERATORS__EXPR_SIGNAL2;

	/**
	 * The number of structural features of the '<em>Xor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int XOR_FEATURE_COUNT = BINARY_OPERATORS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ConstantLogicalKind <em>Constant Logical Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ConstantLogicalKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getConstantLogicalKind()
	 * @generated
	 */
	int CONSTANT_LOGICAL_KIND = 158;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.IntervalsKind <em>Intervals Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.IntervalsKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getIntervalsKind()
	 * @generated
	 */
	int INTERVALS_KIND = 159;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ModelKind <em>Model Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ModelKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getModelKind()
	 * @generated
	 */
	int MODEL_KIND = 160;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.OperatorKind <em>Operator Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.OperatorKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getOperatorKind()
	 * @generated
	 */
	int OPERATOR_KIND = 161;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.ProcessAttributeKind <em>Process Attribute Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.ProcessAttributeKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getProcessAttributeKind()
	 * @generated
	 */
	int PROCESS_ATTRIBUTE_KIND = 162;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.SignalIntrinsicType <em>Signal Intrinsic Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.SignalIntrinsicType
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getSignalIntrinsicType()
	 * @generated
	 */
	int SIGNAL_INTRINSIC_TYPE = 163;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.TypeKind <em>Type Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.TypeKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getTypeKind()
	 * @generated
	 */
	int TYPE_KIND = 164;

	/**
	 * The meta object id for the '{@link org.eclipse.pop.ssme.VisibilityKind <em>Visibility Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.pop.ssme.VisibilityKind
	 * @see org.eclipse.pop.ssme.impl.SsmePackageImpl#getVisibilityKind()
	 * @generated
	 */
	int VISIBILITY_KIND = 165;

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.After <em>After</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>After</em>'.
	 * @see org.eclipse.pop.ssme.After
	 * @generated
	 */
	EClass getAfter();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.And <em>And</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>And</em>'.
	 * @see org.eclipse.pop.ssme.And
	 * @generated
	 */
	EClass getAnd();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayElem <em>Array Elem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Elem</em>'.
	 * @see org.eclipse.pop.ssme.ArrayElem
	 * @generated
	 */
	EClass getArrayElem();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayElem#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ArrayElem#getExprSignal()
	 * @see #getArrayElem()
	 * @generated
	 */
	EReference getArrayElem_ExprSignal();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayElem#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ArrayElem#getListExprSignal()
	 * @see #getArrayElem()
	 * @generated
	 */
	EReference getArrayElem_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayElementsEnumeration <em>Array Elements Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Elements Enumeration</em>'.
	 * @see org.eclipse.pop.ssme.ArrayElementsEnumeration
	 * @generated
	 */
	EClass getArrayElementsEnumeration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ArrayElementsEnumeration#getListPartialArrayDefinition <em>List Partial Array Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Partial Array Definition</em>'.
	 * @see org.eclipse.pop.ssme.ArrayElementsEnumeration#getListPartialArrayDefinition()
	 * @see #getArrayElementsEnumeration()
	 * @generated
	 */
	EReference getArrayElementsEnumeration_ListPartialArrayDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayIndex <em>Array Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Index</em>'.
	 * @see org.eclipse.pop.ssme.ArrayIndex
	 * @generated
	 */
	EClass getArrayIndex();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayIndex#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ArrayIndex#getIdentifier()
	 * @see #getArrayIndex()
	 * @generated
	 */
	EReference getArrayIndex_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayIndex#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upper Bound</em>'.
	 * @see org.eclipse.pop.ssme.ArrayIndex#getUpperBound()
	 * @see #getArrayIndex()
	 * @generated
	 */
	EReference getArrayIndex_UpperBound();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayProcess <em>Array Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Process</em>'.
	 * @see org.eclipse.pop.ssme.ArrayProcess
	 * @generated
	 */
	EClass getArrayProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayProcess#getArrayIndex <em>Array Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Array Index</em>'.
	 * @see org.eclipse.pop.ssme.ArrayProcess#getArrayIndex()
	 * @see #getArrayProcess()
	 * @generated
	 */
	EReference getArrayProcess_ArrayIndex();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayProcess#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.ArrayProcess#getExprProcess()
	 * @see #getArrayProcess()
	 * @generated
	 */
	EReference getArrayProcess_ExprProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayProcess#getIterationInit <em>Iteration Init</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Iteration Init</em>'.
	 * @see org.eclipse.pop.ssme.ArrayProcess#getIterationInit()
	 * @see #getArrayProcess()
	 * @generated
	 */
	EReference getArrayProcess_IterationInit();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayProduct <em>Array Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Product</em>'.
	 * @see org.eclipse.pop.ssme.ArrayProduct
	 * @generated
	 */
	EClass getArrayProduct();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayRestructuration <em>Array Restructuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Restructuration</em>'.
	 * @see org.eclipse.pop.ssme.ArrayRestructuration
	 * @generated
	 */
	EClass getArrayRestructuration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ArrayType <em>Array Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Array Type</em>'.
	 * @see org.eclipse.pop.ssme.ArrayType
	 * @generated
	 */
	EClass getArrayType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayType#getExprDimension <em>Expr Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Dimension</em>'.
	 * @see org.eclipse.pop.ssme.ArrayType#getExprDimension()
	 * @see #getArrayType()
	 * @generated
	 */
	EReference getArrayType_ExprDimension();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ArrayType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.ArrayType#getType()
	 * @see #getArrayType()
	 * @generated
	 */
	EReference getArrayType_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.AssertProcess <em>Assert Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assert Process</em>'.
	 * @see org.eclipse.pop.ssme.AssertProcess
	 * @generated
	 */
	EClass getAssertProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.AssertProcess#getProcessExpression <em>Process Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Process Expression</em>'.
	 * @see org.eclipse.pop.ssme.AssertProcess#getProcessExpression()
	 * @see #getAssertProcess()
	 * @generated
	 */
	EReference getAssertProcess_ProcessExpression();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.AssertSignal <em>Assert Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assert Signal</em>'.
	 * @see org.eclipse.pop.ssme.AssertSignal
	 * @generated
	 */
	EClass getAssertSignal();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.AssertSignal#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.AssertSignal#getExprSignal()
	 * @see #getAssertSignal()
	 * @generated
	 */
	EReference getAssertSignal_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.BinaryOperators <em>Binary Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Operators</em>'.
	 * @see org.eclipse.pop.ssme.BinaryOperators
	 * @generated
	 */
	EClass getBinaryOperators();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.BinaryOperators#getExprSignal1 <em>Expr Signal1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal1</em>'.
	 * @see org.eclipse.pop.ssme.BinaryOperators#getExprSignal1()
	 * @see #getBinaryOperators()
	 * @generated
	 */
	EReference getBinaryOperators_ExprSignal1();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.BinaryOperators#getExprSignal2 <em>Expr Signal2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal2</em>'.
	 * @see org.eclipse.pop.ssme.BinaryOperators#getExprSignal2()
	 * @see #getBinaryOperators()
	 * @generated
	 */
	EReference getBinaryOperators_ExprSignal2();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Bounds <em>Bounds</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bounds</em>'.
	 * @see org.eclipse.pop.ssme.Bounds
	 * @generated
	 */
	EClass getBounds();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Bounds#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lower Bound</em>'.
	 * @see org.eclipse.pop.ssme.Bounds#getLowerBound()
	 * @see #getBounds()
	 * @generated
	 */
	EReference getBounds_LowerBound();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Bounds#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upper Bound</em>'.
	 * @see org.eclipse.pop.ssme.Bounds#getUpperBound()
	 * @see #getBounds()
	 * @generated
	 */
	EReference getBounds_UpperBound();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Bounds#getStep <em>Step</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Step</em>'.
	 * @see org.eclipse.pop.ssme.Bounds#getStep()
	 * @see #getBounds()
	 * @generated
	 */
	EReference getBounds_Step();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CartesianProduct <em>Cartesian Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cartesian Product</em>'.
	 * @see org.eclipse.pop.ssme.CartesianProduct
	 * @generated
	 */
	EClass getCartesianProduct();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CartesianProduct#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.CartesianProduct#getListExprSignal()
	 * @see #getCartesianProduct()
	 * @generated
	 */
	EReference getCartesianProduct_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CaseEnumeration <em>Case Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Enumeration</em>'.
	 * @see org.eclipse.pop.ssme.CaseEnumeration
	 * @generated
	 */
	EClass getCaseEnumeration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseEnumeration#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.CaseEnumeration#getListExprSignal()
	 * @see #getCaseEnumeration()
	 * @generated
	 */
	EReference getCaseEnumeration_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CaseExprEnumeration <em>Case Expr Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Expr Enumeration</em>'.
	 * @see org.eclipse.pop.ssme.CaseExprEnumeration
	 * @generated
	 */
	EClass getCaseExprEnumeration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CaseInterval <em>Case Interval</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Interval</em>'.
	 * @see org.eclipse.pop.ssme.CaseInterval
	 * @generated
	 */
	EClass getCaseInterval();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseInterval#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lower Bound</em>'.
	 * @see org.eclipse.pop.ssme.CaseInterval#getLowerBound()
	 * @see #getCaseInterval()
	 * @generated
	 */
	EReference getCaseInterval_LowerBound();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseInterval#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Upper Bound</em>'.
	 * @see org.eclipse.pop.ssme.CaseInterval#getUpperBound()
	 * @see #getCaseInterval()
	 * @generated
	 */
	EReference getCaseInterval_UpperBound();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.CaseInterval#getIntervalsKind <em>Intervals Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Intervals Kind</em>'.
	 * @see org.eclipse.pop.ssme.CaseInterval#getIntervalsKind()
	 * @see #getCaseInterval()
	 * @generated
	 */
	EAttribute getCaseInterval_IntervalsKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CaseProcess <em>Case Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Process</em>'.
	 * @see org.eclipse.pop.ssme.CaseProcess
	 * @generated
	 */
	EClass getCaseProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseProcess#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.CaseProcess#getIdentifier()
	 * @see #getCaseProcess()
	 * @generated
	 */
	EReference getCaseProcess_Identifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.CaseProcess#getListCaseBranch <em>List Case Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Case Branch</em>'.
	 * @see org.eclipse.pop.ssme.CaseProcess#getListCaseBranch()
	 * @see #getCaseProcess()
	 * @generated
	 */
	EReference getCaseProcess_ListCaseBranch();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseProcess#getElseCase <em>Else Case</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Else Case</em>'.
	 * @see org.eclipse.pop.ssme.CaseProcess#getElseCase()
	 * @see #getCaseProcess()
	 * @generated
	 */
	EReference getCaseProcess_ElseCase();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.CaseBranch <em>Case Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Case Branch</em>'.
	 * @see org.eclipse.pop.ssme.CaseBranch
	 * @generated
	 */
	EClass getCaseBranch();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseBranch#getEnumerationValues <em>Enumeration Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Enumeration Values</em>'.
	 * @see org.eclipse.pop.ssme.CaseBranch#getEnumerationValues()
	 * @see #getCaseBranch()
	 * @generated
	 */
	EReference getCaseBranch_EnumerationValues();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.CaseBranch#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.CaseBranch#getExprProcess()
	 * @see #getCaseBranch()
	 * @generated
	 */
	EReference getCaseBranch_ExprProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Cell <em>Cell</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cell</em>'.
	 * @see org.eclipse.pop.ssme.Cell
	 * @generated
	 */
	EClass getCell();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Clock <em>Clock</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock</em>'.
	 * @see org.eclipse.pop.ssme.Clock
	 * @generated
	 */
	EClass getClock();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockDifference <em>Clock Difference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Difference</em>'.
	 * @see org.eclipse.pop.ssme.ClockDifference
	 * @generated
	 */
	EClass getClockDifference();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockEquality <em>Clock Equality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Equality</em>'.
	 * @see org.eclipse.pop.ssme.ClockEquality
	 * @generated
	 */
	EClass getClockEquality();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ClockEquality#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ClockEquality#getExprSignal()
	 * @see #getClockEquality()
	 * @generated
	 */
	EReference getClockEquality_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockExclusiveRelation <em>Clock Exclusive Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Exclusive Relation</em>'.
	 * @see org.eclipse.pop.ssme.ClockExclusiveRelation
	 * @generated
	 */
	EClass getClockExclusiveRelation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ClockExclusiveRelation#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ClockExclusiveRelation#getExprSignal()
	 * @see #getClockExclusiveRelation()
	 * @generated
	 */
	EReference getClockExclusiveRelation_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockInfRelation <em>Clock Inf Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Inf Relation</em>'.
	 * @see org.eclipse.pop.ssme.ClockInfRelation
	 * @generated
	 */
	EClass getClockInfRelation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ClockInfRelation#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ClockInfRelation#getExprSignal()
	 * @see #getClockInfRelation()
	 * @generated
	 */
	EReference getClockInfRelation_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockProduct <em>Clock Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Product</em>'.
	 * @see org.eclipse.pop.ssme.ClockProduct
	 * @generated
	 */
	EClass getClockProduct();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockSupRelation <em>Clock Sup Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Sup Relation</em>'.
	 * @see org.eclipse.pop.ssme.ClockSupRelation
	 * @generated
	 */
	EClass getClockSupRelation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ClockSupRelation#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ClockSupRelation#getExprSignal()
	 * @see #getClockSupRelation()
	 * @generated
	 */
	EReference getClockSupRelation_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ClockUnion <em>Clock Union</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clock Union</em>'.
	 * @see org.eclipse.pop.ssme.ClockUnion
	 * @generated
	 */
	EClass getClockUnion();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Comment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Comment</em>'.
	 * @see org.eclipse.pop.ssme.Comment
	 * @generated
	 */
	EClass getComment();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.Comment#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.Comment#getAtomString()
	 * @see #getComment()
	 * @generated
	 */
	EAttribute getComment_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ComplexConstructor <em>Complex Constructor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Complex Constructor</em>'.
	 * @see org.eclipse.pop.ssme.ComplexConstructor
	 * @generated
	 */
	EClass getComplexConstructor();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Composition <em>Composition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composition</em>'.
	 * @see org.eclipse.pop.ssme.Composition
	 * @generated
	 */
	EClass getComposition();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Composition#getListExprProcess <em>List Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.Composition#getListExprProcess()
	 * @see #getComposition()
	 * @generated
	 */
	EReference getComposition_ListExprProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Concatenation <em>Concatenation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Concatenation</em>'.
	 * @see org.eclipse.pop.ssme.Concatenation
	 * @generated
	 */
	EClass getConcatenation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConditionedDependence <em>Conditioned Dependence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Conditioned Dependence</em>'.
	 * @see org.eclipse.pop.ssme.ConditionedDependence
	 * @generated
	 */
	EClass getConditionedDependence();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsFrom <em>Signals From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Signals From</em>'.
	 * @see org.eclipse.pop.ssme.ConditionedDependence#getSignalsFrom()
	 * @see #getConditionedDependence()
	 * @generated
	 */
	EReference getConditionedDependence_SignalsFrom();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConditionedDependence#getSignalsTo <em>Signals To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Signals To</em>'.
	 * @see org.eclipse.pop.ssme.ConditionedDependence#getSignalsTo()
	 * @see #getConditionedDependence()
	 * @generated
	 */
	EReference getConditionedDependence_SignalsTo();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConditionedDependence#getConditionExpr <em>Condition Expr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Condition Expr</em>'.
	 * @see org.eclipse.pop.ssme.ConditionedDependence#getConditionExpr()
	 * @see #getConditionedDependence()
	 * @generated
	 */
	EReference getConditionedDependence_ConditionExpr();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Constant <em>Constant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant</em>'.
	 * @see org.eclipse.pop.ssme.Constant
	 * @generated
	 */
	EClass getConstant();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantCharacter <em>Constant Character</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Character</em>'.
	 * @see org.eclipse.pop.ssme.ConstantCharacter
	 * @generated
	 */
	EClass getConstantCharacter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantCharacter#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantCharacter#getAtomString()
	 * @see #getConstantCharacter()
	 * @generated
	 */
	EAttribute getConstantCharacter_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantDefinition <em>Constant Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Definition</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDefinition
	 * @generated
	 */
	EClass getConstantDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantDescription <em>Constant Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Description</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDescription
	 * @generated
	 */
	EClass getConstantDescription();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConstantDescription#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDescription#getIdentifier()
	 * @see #getConstantDescription()
	 * @generated
	 */
	EReference getConstantDescription_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConstantDescription#getConstantDescriptionValue <em>Constant Description Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Constant Description Value</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDescription#getConstantDescriptionValue()
	 * @see #getConstantDescription()
	 * @generated
	 */
	EReference getConstantDescription_ConstantDescriptionValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantDescriptionValue <em>Constant Description Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Description Value</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDescriptionValue
	 * @generated
	 */
	EClass getConstantDescriptionValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantDoubleReal <em>Constant Double Real</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Double Real</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDoubleReal
	 * @generated
	 */
	EClass getConstantDoubleReal();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantDoubleReal#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantDoubleReal#getAtomString()
	 * @see #getConstantDoubleReal()
	 * @generated
	 */
	EAttribute getConstantDoubleReal_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantEnum <em>Constant Enum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Enum</em>'.
	 * @see org.eclipse.pop.ssme.ConstantEnum
	 * @generated
	 */
	EClass getConstantEnum();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConstantEnum#getTypeIdentifier <em>Type Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ConstantEnum#getTypeIdentifier()
	 * @see #getConstantEnum()
	 * @generated
	 */
	EReference getConstantEnum_TypeIdentifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConstantEnum#getConstantEnumValue <em>Constant Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Constant Enum Value</em>'.
	 * @see org.eclipse.pop.ssme.ConstantEnum#getConstantEnumValue()
	 * @see #getConstantEnum()
	 * @generated
	 */
	EReference getConstantEnum_ConstantEnumValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantInteger <em>Constant Integer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Integer</em>'.
	 * @see org.eclipse.pop.ssme.ConstantInteger
	 * @generated
	 */
	EClass getConstantInteger();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantInteger#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantInteger#getAtomString()
	 * @see #getConstantInteger()
	 * @generated
	 */
	EAttribute getConstantInteger_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantLogical <em>Constant Logical</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Logical</em>'.
	 * @see org.eclipse.pop.ssme.ConstantLogical
	 * @generated
	 */
	EClass getConstantLogical();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantLogical#getConstantLogicalKind <em>Constant Logical Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Constant Logical Kind</em>'.
	 * @see org.eclipse.pop.ssme.ConstantLogical#getConstantLogicalKind()
	 * @see #getConstantLogical()
	 * @generated
	 */
	EAttribute getConstantLogical_ConstantLogicalKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantReal <em>Constant Real</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Real</em>'.
	 * @see org.eclipse.pop.ssme.ConstantReal
	 * @generated
	 */
	EClass getConstantReal();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantReal#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantReal#getAtomString()
	 * @see #getConstantReal()
	 * @generated
	 */
	EAttribute getConstantReal_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantsDeclaration <em>Constants Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constants Declaration</em>'.
	 * @see org.eclipse.pop.ssme.ConstantsDeclaration
	 * @generated
	 */
	EClass getConstantsDeclaration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantsDeclaration#getVisibility <em>Visibility</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visibility</em>'.
	 * @see org.eclipse.pop.ssme.ConstantsDeclaration#getVisibility()
	 * @see #getConstantsDeclaration()
	 * @generated
	 */
	EAttribute getConstantsDeclaration_Visibility();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ConstantsDeclaration#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.ConstantsDeclaration#getType()
	 * @see #getConstantsDeclaration()
	 * @generated
	 */
	EReference getConstantsDeclaration_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ConstantsDeclaration#getListConstantDefinition <em>List Constant Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Constant Definition</em>'.
	 * @see org.eclipse.pop.ssme.ConstantsDeclaration#getListConstantDefinition()
	 * @see #getConstantsDeclaration()
	 * @generated
	 */
	EReference getConstantsDeclaration_ListConstantDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ConstantString <em>Constant String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantString
	 * @generated
	 */
	EClass getConstantString();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ConstantString#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.ConstantString#getAtomString()
	 * @see #getConstantString()
	 * @generated
	 */
	EAttribute getConstantString_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Conversion <em>Conversion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Conversion</em>'.
	 * @see org.eclipse.pop.ssme.Conversion
	 * @generated
	 */
	EClass getConversion();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Conversion#getPredefinedType <em>Predefined Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Predefined Type</em>'.
	 * @see org.eclipse.pop.ssme.Conversion#getPredefinedType()
	 * @see #getConversion()
	 * @generated
	 */
	EReference getConversion_PredefinedType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Conversion#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.Conversion#getExprSignal()
	 * @see #getConversion()
	 * @generated
	 */
	EReference getConversion_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Count <em>Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Count</em>'.
	 * @see org.eclipse.pop.ssme.Count
	 * @generated
	 */
	EClass getCount();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Declaration <em>Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Declaration</em>'.
	 * @see org.eclipse.pop.ssme.Declaration
	 * @generated
	 */
	EClass getDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Default <em>Default</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Default</em>'.
	 * @see org.eclipse.pop.ssme.Default
	 * @generated
	 */
	EClass getDefault();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Delay <em>Delay</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Delay</em>'.
	 * @see org.eclipse.pop.ssme.Delay
	 * @generated
	 */
	EClass getDelay();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Dependences <em>Dependences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dependences</em>'.
	 * @see org.eclipse.pop.ssme.Dependences
	 * @generated
	 */
	EClass getDependences();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.DescribedType <em>Described Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Described Type</em>'.
	 * @see org.eclipse.pop.ssme.DescribedType
	 * @generated
	 */
	EClass getDescribedType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Description <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Description</em>'.
	 * @see org.eclipse.pop.ssme.Description
	 * @generated
	 */
	EClass getDescription();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Description#getListPragma <em>List Pragma</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Pragma</em>'.
	 * @see org.eclipse.pop.ssme.Description#getListPragma()
	 * @see #getDescription()
	 * @generated
	 */
	EReference getDescription_ListPragma();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Description#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see org.eclipse.pop.ssme.Description#getBody()
	 * @see #getDescription()
	 * @generated
	 */
	EReference getDescription_Body();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Div <em>Div</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Div</em>'.
	 * @see org.eclipse.pop.ssme.Div
	 * @generated
	 */
	EClass getDiv();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ElemDefinition <em>Elem Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Elem Definition</em>'.
	 * @see org.eclipse.pop.ssme.ElemDefinition
	 * @generated
	 */
	EClass getElemDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ElemDefinition#getExprDimension <em>Expr Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Dimension</em>'.
	 * @see org.eclipse.pop.ssme.ElemDefinition#getExprDimension()
	 * @see #getElemDefinition()
	 * @generated
	 */
	EReference getElemDefinition_ExprDimension();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ElemDefinition#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ElemDefinition#getExprSignal()
	 * @see #getElemDefinition()
	 * @generated
	 */
	EReference getElemDefinition_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ElemDefinitionEnumeration <em>Elem Definition Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Elem Definition Enumeration</em>'.
	 * @see org.eclipse.pop.ssme.ElemDefinitionEnumeration
	 * @generated
	 */
	EClass getElemDefinitionEnumeration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ElemDefinitionEnumeration#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ElemDefinitionEnumeration#getListExprSignal()
	 * @see #getElemDefinitionEnumeration()
	 * @generated
	 */
	EReference getElemDefinitionEnumeration_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.EnumerationType <em>Enumeration Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Enumeration Type</em>'.
	 * @see org.eclipse.pop.ssme.EnumerationType
	 * @generated
	 */
	EClass getEnumerationType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.EnumerationType#getListIdentifier <em>List Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Identifier</em>'.
	 * @see org.eclipse.pop.ssme.EnumerationType#getListIdentifier()
	 * @see #getEnumerationType()
	 * @generated
	 */
	EReference getEnumerationType_ListIdentifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Equal <em>Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equal</em>'.
	 * @see org.eclipse.pop.ssme.Equal
	 * @generated
	 */
	EClass getEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.EqualEqual <em>Equal Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equal Equal</em>'.
	 * @see org.eclipse.pop.ssme.EqualEqual
	 * @generated
	 */
	EClass getEqualEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExprParam <em>Expr Param</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expr Param</em>'.
	 * @see org.eclipse.pop.ssme.ExprParam
	 * @generated
	 */
	EClass getExprParam();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.ExprProcess
	 * @generated
	 */
	EClass getExprProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ExprSignal
	 * @generated
	 */
	EClass getExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExternalAttribute <em>External Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Attribute</em>'.
	 * @see org.eclipse.pop.ssme.ExternalAttribute
	 * @generated
	 */
	EClass getExternalAttribute();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ExternalAttribute#getString <em>String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>String</em>'.
	 * @see org.eclipse.pop.ssme.ExternalAttribute#getString()
	 * @see #getExternalAttribute()
	 * @generated
	 */
	EReference getExternalAttribute_String();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExternalGraph <em>External Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External Graph</em>'.
	 * @see org.eclipse.pop.ssme.ExternalGraph
	 * @generated
	 */
	EClass getExternalGraph();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ExternalGraph#getProcessAttributes <em>Process Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Process Attributes</em>'.
	 * @see org.eclipse.pop.ssme.ExternalGraph#getProcessAttributes()
	 * @see #getExternalGraph()
	 * @generated
	 */
	EReference getExternalGraph_ProcessAttributes();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ExternalGraph#getGraphSpecification <em>Graph Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Graph Specification</em>'.
	 * @see org.eclipse.pop.ssme.ExternalGraph#getGraphSpecification()
	 * @see #getExternalGraph()
	 * @generated
	 */
	EReference getExternalGraph_GraphSpecification();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ExternalReferences <em>External References</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>External References</em>'.
	 * @see org.eclipse.pop.ssme.ExternalReferences
	 * @generated
	 */
	EClass getExternalReferences();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ExternalReferences#getListIdentifier <em>List Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ExternalReferences#getListIdentifier()
	 * @see #getExternalReferences()
	 * @generated
	 */
	EReference getExternalReferences_ListIdentifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.FieldAccess <em>Field Access</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Field Access</em>'.
	 * @see org.eclipse.pop.ssme.FieldAccess
	 * @generated
	 */
	EClass getFieldAccess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.FieldAccess#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.FieldAccess#getExprSignal()
	 * @see #getFieldAccess()
	 * @generated
	 */
	EReference getFieldAccess_ExprSignal();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.FieldAccess#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.FieldAccess#getIdentifier()
	 * @see #getFieldAccess()
	 * @generated
	 */
	EReference getFieldAccess_Identifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.FormalProcess <em>Formal Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Formal Process</em>'.
	 * @see org.eclipse.pop.ssme.FormalProcess
	 * @generated
	 */
	EClass getFormalProcess();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.FormalProcess#getModelKind <em>Model Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model Kind</em>'.
	 * @see org.eclipse.pop.ssme.FormalProcess#getModelKind()
	 * @see #getFormalProcess()
	 * @generated
	 */
	EAttribute getFormalProcess_ModelKind();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.FormalProcess#getModelType <em>Model Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Model Type</em>'.
	 * @see org.eclipse.pop.ssme.FormalProcess#getModelType()
	 * @see #getFormalProcess()
	 * @generated
	 */
	EReference getFormalProcess_ModelType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.FormalProcess#getModelName <em>Model Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Model Name</em>'.
	 * @see org.eclipse.pop.ssme.FormalProcess#getModelName()
	 * @see #getFormalProcess()
	 * @generated
	 */
	EReference getFormalProcess_ModelName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.From <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>From</em>'.
	 * @see org.eclipse.pop.ssme.From
	 * @generated
	 */
	EClass getFrom();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.GraphSpecification <em>Graph Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Graph Specification</em>'.
	 * @see org.eclipse.pop.ssme.GraphSpecification
	 * @generated
	 */
	EClass getGraphSpecification();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.GraphSpecification#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.GraphSpecification#getExprProcess()
	 * @see #getGraphSpecification()
	 * @generated
	 */
	EReference getGraphSpecification_ExprProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Greater <em>Greater</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Greater</em>'.
	 * @see org.eclipse.pop.ssme.Greater
	 * @generated
	 */
	EClass getGreater();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.GreaterOrEqual <em>Greater Or Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Greater Or Equal</em>'.
	 * @see org.eclipse.pop.ssme.GreaterOrEqual
	 * @generated
	 */
	EClass getGreaterOrEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Identifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.Identifier
	 * @generated
	 */
	EClass getIdentifier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.Identifier#getAtomString <em>Atom String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Atom String</em>'.
	 * @see org.eclipse.pop.ssme.Identifier#getAtomString()
	 * @see #getIdentifier()
	 * @generated
	 */
	EAttribute getIdentifier_AtomString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IdentityEquation <em>Identity Equation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Identity Equation</em>'.
	 * @see org.eclipse.pop.ssme.IdentityEquation
	 * @generated
	 */
	EClass getIdentityEquation();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.IdentityEquation#getExprSignalLeft <em>Expr Signal Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Left</em>'.
	 * @see org.eclipse.pop.ssme.IdentityEquation#getExprSignalLeft()
	 * @see #getIdentityEquation()
	 * @generated
	 */
	EReference getIdentityEquation_ExprSignalLeft();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.IdentityEquation#getExprSignalRight <em>Expr Signal Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Right</em>'.
	 * @see org.eclipse.pop.ssme.IdentityEquation#getExprSignalRight()
	 * @see #getIdentityEquation()
	 * @generated
	 */
	EReference getIdentityEquation_ExprSignalRight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IfThenElse <em>If Then Else</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>If Then Else</em>'.
	 * @see org.eclipse.pop.ssme.IfThenElse
	 * @generated
	 */
	EClass getIfThenElse();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Index <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Index</em>'.
	 * @see org.eclipse.pop.ssme.Index
	 * @generated
	 */
	EClass getIndex();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.InterfaceDefinition <em>Interface Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interface Definition</em>'.
	 * @see org.eclipse.pop.ssme.InterfaceDefinition
	 * @generated
	 */
	EClass getInterfaceDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IOProfile <em>IO Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IO Profile</em>'.
	 * @see org.eclipse.pop.ssme.IOProfile
	 * @generated
	 */
	EClass getIOProfile();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.IOProfile#getInputs <em>Inputs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inputs</em>'.
	 * @see org.eclipse.pop.ssme.IOProfile#getInputs()
	 * @see #getIOProfile()
	 * @generated
	 */
	EReference getIOProfile_Inputs();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.IOProfile#getOutputs <em>Outputs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Outputs</em>'.
	 * @see org.eclipse.pop.ssme.IOProfile#getOutputs()
	 * @see #getIOProfile()
	 * @generated
	 */
	EReference getIOProfile_Outputs();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Iteration <em>Iteration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iteration</em>'.
	 * @see org.eclipse.pop.ssme.Iteration
	 * @generated
	 */
	EClass getIteration();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Iteration#getPartialIteration <em>Partial Iteration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Partial Iteration</em>'.
	 * @see org.eclipse.pop.ssme.Iteration#getPartialIteration()
	 * @see #getIteration()
	 * @generated
	 */
	EReference getIteration_PartialIteration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Iteration#getElemDefinition <em>Elem Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Elem Definition</em>'.
	 * @see org.eclipse.pop.ssme.Iteration#getElemDefinition()
	 * @see #getIteration()
	 * @generated
	 */
	EReference getIteration_ElemDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IterationOfProcesses <em>Iteration Of Processes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iteration Of Processes</em>'.
	 * @see org.eclipse.pop.ssme.IterationOfProcesses
	 * @generated
	 */
	EClass getIterationOfProcesses();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IterationProcess <em>Iteration Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iteration Process</em>'.
	 * @see org.eclipse.pop.ssme.IterationProcess
	 * @generated
	 */
	EClass getIterationProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.IterationProcess#getIterationIndex <em>Iteration Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Iteration Index</em>'.
	 * @see org.eclipse.pop.ssme.IterationProcess#getIterationIndex()
	 * @see #getIterationProcess()
	 * @generated
	 */
	EReference getIterationProcess_IterationIndex();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.IterationProcess#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.IterationProcess#getExprProcess()
	 * @see #getIterationProcess()
	 * @generated
	 */
	EReference getIterationProcess_ExprProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.IterationProcess#getIterationInit <em>Iteration Init</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Iteration Init</em>'.
	 * @see org.eclipse.pop.ssme.IterationProcess#getIterationInit()
	 * @see #getIterationProcess()
	 * @generated
	 */
	EReference getIterationProcess_IterationInit();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.IterativeEnumeration <em>Iterative Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iterative Enumeration</em>'.
	 * @see org.eclipse.pop.ssme.IterativeEnumeration
	 * @generated
	 */
	EClass getIterativeEnumeration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.LabelledProcess <em>Labelled Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Labelled Process</em>'.
	 * @see org.eclipse.pop.ssme.LabelledProcess
	 * @generated
	 */
	EClass getLabelledProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.LabelledProcess#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Label</em>'.
	 * @see org.eclipse.pop.ssme.LabelledProcess#getLabel()
	 * @see #getLabelledProcess()
	 * @generated
	 */
	EReference getLabelledProcess_Label();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.LabelledProcess#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.LabelledProcess#getExprProcess()
	 * @see #getLabelledProcess()
	 * @generated
	 */
	EReference getLabelledProcess_ExprProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Labels <em>Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Labels</em>'.
	 * @see org.eclipse.pop.ssme.Labels
	 * @generated
	 */
	EClass getLabels();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Labels#getListIdentifier <em>List Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Identifier</em>'.
	 * @see org.eclipse.pop.ssme.Labels#getListIdentifier()
	 * @see #getLabels()
	 * @generated
	 */
	EReference getLabels_ListIdentifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Less <em>Less</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Less</em>'.
	 * @see org.eclipse.pop.ssme.Less
	 * @generated
	 */
	EClass getLess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.LessLessEqual <em>Less Less Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Less Less Equal</em>'.
	 * @see org.eclipse.pop.ssme.LessLessEqual
	 * @generated
	 */
	EClass getLessLessEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.LessOrEqual <em>Less Or Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Less Or Equal</em>'.
	 * @see org.eclipse.pop.ssme.LessOrEqual
	 * @generated
	 */
	EClass getLessOrEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ListExprSignal
	 * @generated
	 */
	EClass getListExprSignal();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ListExprSignal#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ListExprSignal#getExprSignal()
	 * @see #getListExprSignal()
	 * @generated
	 */
	EReference getListExprSignal_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ListFlows <em>List Flows</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Flows</em>'.
	 * @see org.eclipse.pop.ssme.ListFlows
	 * @generated
	 */
	EClass getListFlows();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ListFlows#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ListFlows#getExprSignal()
	 * @see #getListFlows()
	 * @generated
	 */
	EReference getListFlows_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ListModule <em>List Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>List Module</em>'.
	 * @see org.eclipse.pop.ssme.ListModule
	 * @generated
	 */
	EClass getListModule();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ListModule#getListModule <em>List Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Module</em>'.
	 * @see org.eclipse.pop.ssme.ListModule#getListModule()
	 * @see #getListModule()
	 * @generated
	 */
	EReference getListModule_ListModule();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Masking <em>Masking</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Masking</em>'.
	 * @see org.eclipse.pop.ssme.Masking
	 * @generated
	 */
	EClass getMasking();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Masking#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.Masking#getExprProcess()
	 * @see #getMasking()
	 * @generated
	 */
	EReference getMasking_ExprProcess();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Masking#getListIdentifier <em>List Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Identifier</em>'.
	 * @see org.eclipse.pop.ssme.Masking#getListIdentifier()
	 * @see #getMasking()
	 * @generated
	 */
	EReference getMasking_ListIdentifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Minus <em>Minus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Minus</em>'.
	 * @see org.eclipse.pop.ssme.Minus
	 * @generated
	 */
	EClass getMinus();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Module <em>Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Module</em>'.
	 * @see org.eclipse.pop.ssme.Module
	 * @generated
	 */
	EClass getModule();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Module#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.Module#getIdentifier()
	 * @see #getModule()
	 * @generated
	 */
	EReference getModule_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Module#getModuleDescription <em>Module Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Module Description</em>'.
	 * @see org.eclipse.pop.ssme.Module#getModuleDescription()
	 * @see #getModule()
	 * @generated
	 */
	EReference getModule_ModuleDescription();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ModuleDescription <em>Module Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Module Description</em>'.
	 * @see org.eclipse.pop.ssme.ModuleDescription
	 * @generated
	 */
	EClass getModuleDescription();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ModuleDescription#getListPragma <em>List Pragma</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Pragma</em>'.
	 * @see org.eclipse.pop.ssme.ModuleDescription#getListPragma()
	 * @see #getModuleDescription()
	 * @generated
	 */
	EReference getModuleDescription_ListPragma();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ModuleDescription#getListDeclaration <em>List Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Declaration</em>'.
	 * @see org.eclipse.pop.ssme.ModuleDescription#getListDeclaration()
	 * @see #getModuleDescription()
	 * @generated
	 */
	EReference getModuleDescription_ListDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ModulesImport <em>Modules Import</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Modules Import</em>'.
	 * @see org.eclipse.pop.ssme.ModulesImport
	 * @generated
	 */
	EClass getModulesImport();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ModulesImport#getListModule <em>List Module</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Module</em>'.
	 * @see org.eclipse.pop.ssme.ModulesImport#getListModule()
	 * @see #getModulesImport()
	 * @generated
	 */
	EReference getModulesImport_ListModule();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Modulo <em>Modulo</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Modulo</em>'.
	 * @see org.eclipse.pop.ssme.Modulo
	 * @generated
	 */
	EClass getModulo();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Not <em>Not</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Not</em>'.
	 * @see org.eclipse.pop.ssme.Not
	 * @generated
	 */
	EClass getNot();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.NotEqual <em>Not Equal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Not Equal</em>'.
	 * @see org.eclipse.pop.ssme.NotEqual
	 * @generated
	 */
	EClass getNotEqual();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.NullaryOperators <em>Nullary Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Nullary Operators</em>'.
	 * @see org.eclipse.pop.ssme.NullaryOperators
	 * @generated
	 */
	EClass getNullaryOperators();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.NullClock <em>Null Clock</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Clock</em>'.
	 * @see org.eclipse.pop.ssme.NullClock
	 * @generated
	 */
	EClass getNullClock();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.NullProc <em>Null Proc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Proc</em>'.
	 * @see org.eclipse.pop.ssme.NullProc
	 * @generated
	 */
	EClass getNullProc();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Operator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operator</em>'.
	 * @see org.eclipse.pop.ssme.Operator
	 * @generated
	 */
	EClass getOperator();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.Operator#getOperatorKind <em>Operator Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator Kind</em>'.
	 * @see org.eclipse.pop.ssme.Operator#getOperatorKind()
	 * @see #getOperator()
	 * @generated
	 */
	EAttribute getOperator_OperatorKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.OperatorIdentifier <em>Operator Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operator Identifier</em>'.
	 * @see org.eclipse.pop.ssme.OperatorIdentifier
	 * @generated
	 */
	EClass getOperatorIdentifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.OperatorModel <em>Operator Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operator Model</em>'.
	 * @see org.eclipse.pop.ssme.OperatorModel
	 * @generated
	 */
	EClass getOperatorModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.OperatorModel#getOperatorIdentifier <em>Operator Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Operator Identifier</em>'.
	 * @see org.eclipse.pop.ssme.OperatorModel#getOperatorIdentifier()
	 * @see #getOperatorModel()
	 * @generated
	 */
	EReference getOperatorModel_OperatorIdentifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.OperatorModel#getInterfaceDefinition <em>Interface Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Interface Definition</em>'.
	 * @see org.eclipse.pop.ssme.OperatorModel#getInterfaceDefinition()
	 * @see #getOperatorModel()
	 * @generated
	 */
	EReference getOperatorModel_InterfaceDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.OperatorModel#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Description</em>'.
	 * @see org.eclipse.pop.ssme.OperatorModel#getDescription()
	 * @see #getOperatorModel()
	 * @generated
	 */
	EReference getOperatorModel_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Or <em>Or</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Or</em>'.
	 * @see org.eclipse.pop.ssme.Or
	 * @generated
	 */
	EClass getOr();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.PartialArrayDefinition <em>Partial Array Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Partial Array Definition</em>'.
	 * @see org.eclipse.pop.ssme.PartialArrayDefinition
	 * @generated
	 */
	EClass getPartialArrayDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.PartialIteration <em>Partial Iteration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Partial Iteration</em>'.
	 * @see org.eclipse.pop.ssme.PartialIteration
	 * @generated
	 */
	EClass getPartialIteration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.PartialIteration#getIndex <em>Index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Index</em>'.
	 * @see org.eclipse.pop.ssme.PartialIteration#getIndex()
	 * @see #getPartialIteration()
	 * @generated
	 */
	EReference getPartialIteration_Index();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.PartialIteration#getBounds <em>Bounds</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Bounds</em>'.
	 * @see org.eclipse.pop.ssme.PartialIteration#getBounds()
	 * @see #getPartialIteration()
	 * @generated
	 */
	EReference getPartialIteration_Bounds();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Plus <em>Plus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Plus</em>'.
	 * @see org.eclipse.pop.ssme.Plus
	 * @generated
	 */
	EClass getPlus();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Power <em>Power</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Power</em>'.
	 * @see org.eclipse.pop.ssme.Power
	 * @generated
	 */
	EClass getPower();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Pragma <em>Pragma</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pragma</em>'.
	 * @see org.eclipse.pop.ssme.Pragma
	 * @generated
	 */
	EClass getPragma();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Pragma#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.Pragma#getIdentifier()
	 * @see #getPragma()
	 * @generated
	 */
	EReference getPragma_Identifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.Pragma#getListPragmaObject <em>List Pragma Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Pragma Object</em>'.
	 * @see org.eclipse.pop.ssme.Pragma#getListPragmaObject()
	 * @see #getPragma()
	 * @generated
	 */
	EReference getPragma_ListPragmaObject();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Pragma#getPragmaStatement <em>Pragma Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pragma Statement</em>'.
	 * @see org.eclipse.pop.ssme.Pragma#getPragmaStatement()
	 * @see #getPragma()
	 * @generated
	 */
	EReference getPragma_PragmaStatement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.PredefinedType <em>Predefined Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Predefined Type</em>'.
	 * @see org.eclipse.pop.ssme.PredefinedType
	 * @generated
	 */
	EClass getPredefinedType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.PredefinedType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.PredefinedType#getType()
	 * @see #getPredefinedType()
	 * @generated
	 */
	EAttribute getPredefinedType_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.PreviousIterationRef <em>Previous Iteration Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Previous Iteration Ref</em>'.
	 * @see org.eclipse.pop.ssme.PreviousIterationRef
	 * @generated
	 */
	EClass getPreviousIterationRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessAttribute <em>Process Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Attribute</em>'.
	 * @see org.eclipse.pop.ssme.ProcessAttribute
	 * @generated
	 */
	EClass getProcessAttribute();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ProcessAttribute#getProcessAttributeKind <em>Process Attribute Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Process Attribute Kind</em>'.
	 * @see org.eclipse.pop.ssme.ProcessAttribute#getProcessAttributeKind()
	 * @see #getProcessAttribute()
	 * @generated
	 */
	EAttribute getProcessAttribute_ProcessAttributeKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessBody <em>Process Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Body</em>'.
	 * @see org.eclipse.pop.ssme.ProcessBody
	 * @generated
	 */
	EClass getProcessBody();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessCall <em>Process Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Call</em>'.
	 * @see org.eclipse.pop.ssme.ProcessCall
	 * @generated
	 */
	EClass getProcessCall();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessCall#getReferenceProcess <em>Reference Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Reference Process</em>'.
	 * @see org.eclipse.pop.ssme.ProcessCall#getReferenceProcess()
	 * @see #getProcessCall()
	 * @generated
	 */
	EReference getProcessCall_ReferenceProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessCall#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.ProcessCall#getListExprSignal()
	 * @see #getProcessCall()
	 * @generated
	 */
	EReference getProcessCall_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessCallOrAssert <em>Process Call Or Assert</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Call Or Assert</em>'.
	 * @see org.eclipse.pop.ssme.ProcessCallOrAssert
	 * @generated
	 */
	EClass getProcessCallOrAssert();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessDeclaration <em>Process Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Declaration</em>'.
	 * @see org.eclipse.pop.ssme.ProcessDeclaration
	 * @generated
	 */
	EClass getProcessDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessExpansion <em>Process Expansion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Expansion</em>'.
	 * @see org.eclipse.pop.ssme.ProcessExpansion
	 * @generated
	 */
	EClass getProcessExpansion();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessExpansion#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ProcessExpansion#getIdentifier()
	 * @see #getProcessExpansion()
	 * @generated
	 */
	EReference getProcessExpansion_Identifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ProcessExpansion#getListExprParam <em>List Expr Param</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Expr Param</em>'.
	 * @see org.eclipse.pop.ssme.ProcessExpansion#getListExprParam()
	 * @see #getProcessExpansion()
	 * @generated
	 */
	EReference getProcessExpansion_ListExprParam();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessInstance <em>Process Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Instance</em>'.
	 * @see org.eclipse.pop.ssme.ProcessInstance
	 * @generated
	 */
	EClass getProcessInstance();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessModel <em>Process Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Model</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel
	 * @generated
	 */
	EClass getProcessModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessModel#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel#getIdentifier()
	 * @see #getProcessModel()
	 * @generated
	 */
	EReference getProcessModel_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessModel#getInterfaceDefinition <em>Interface Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Interface Definition</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel#getInterfaceDefinition()
	 * @see #getProcessModel()
	 * @generated
	 */
	EReference getProcessModel_InterfaceDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessModel#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Description</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel#getDescription()
	 * @see #getProcessModel()
	 * @generated
	 */
	EReference getProcessModel_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ProcessModel#getModelKind <em>Model Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model Kind</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel#getModelKind()
	 * @see #getProcessModel()
	 * @generated
	 */
	EAttribute getProcessModel_ModelKind();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ProcessModel#getVisibilityKind <em>Visibility Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visibility Kind</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModel#getVisibilityKind()
	 * @see #getProcessModel()
	 * @generated
	 */
	EAttribute getProcessModel_VisibilityKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessModelInterface <em>Process Model Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Model Interface</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModelInterface
	 * @generated
	 */
	EClass getProcessModelInterface();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ProcessModelInterface#getListFormalParameter <em>List Formal Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Formal Parameter</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModelInterface#getListFormalParameter()
	 * @see #getProcessModelInterface()
	 * @generated
	 */
	EReference getProcessModelInterface_ListFormalParameter();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessModelInterface#getIoProfile <em>Io Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Io Profile</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModelInterface#getIoProfile()
	 * @see #getProcessModelInterface()
	 * @generated
	 */
	EReference getProcessModelInterface_IoProfile();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessModelInterface#getExternalGraph <em>External Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>External Graph</em>'.
	 * @see org.eclipse.pop.ssme.ProcessModelInterface#getExternalGraph()
	 * @see #getProcessModelInterface()
	 * @generated
	 */
	EReference getProcessModelInterface_ExternalGraph();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ProcessType <em>Process Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Type</em>'.
	 * @see org.eclipse.pop.ssme.ProcessType
	 * @generated
	 */
	EClass getProcessType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.ProcessType#getModelKind <em>Model Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model Kind</em>'.
	 * @see org.eclipse.pop.ssme.ProcessType#getModelKind()
	 * @see #getProcessType()
	 * @generated
	 */
	EAttribute getProcessType_ModelKind();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessType#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.ProcessType#getIdentifier()
	 * @see #getProcessType()
	 * @generated
	 */
	EReference getProcessType_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.ProcessType#getInterfaceDefinition <em>Interface Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Interface Definition</em>'.
	 * @see org.eclipse.pop.ssme.ProcessType#getInterfaceDefinition()
	 * @see #getProcessType()
	 * @generated
	 */
	EReference getProcessType_InterfaceDefinition();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.ProcessType#getListPragma <em>List Pragma</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Pragma</em>'.
	 * @see org.eclipse.pop.ssme.ProcessType#getListPragma()
	 * @see #getProcessType()
	 * @generated
	 */
	EReference getProcessType_ListPragma();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Product <em>Product</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Product</em>'.
	 * @see org.eclipse.pop.ssme.Product
	 * @generated
	 */
	EClass getProduct();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Recover <em>Recover</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Recover</em>'.
	 * @see org.eclipse.pop.ssme.Recover
	 * @generated
	 */
	EClass getRecover();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.ReferenceProcess <em>Reference Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference Process</em>'.
	 * @see org.eclipse.pop.ssme.ReferenceProcess
	 * @generated
	 */
	EClass getReferenceProcess();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Repetition <em>Repetition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Repetition</em>'.
	 * @see org.eclipse.pop.ssme.Repetition
	 * @generated
	 */
	EClass getRepetition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.RestrictionProcess <em>Restriction Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Restriction Process</em>'.
	 * @see org.eclipse.pop.ssme.RestrictionProcess
	 * @generated
	 */
	EClass getRestrictionProcess();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.RestrictionProcess#getExprProcess <em>Expr Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Process</em>'.
	 * @see org.eclipse.pop.ssme.RestrictionProcess#getExprProcess()
	 * @see #getRestrictionProcess()
	 * @generated
	 */
	EReference getRestrictionProcess_ExprProcess();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.RestrictionProcess#getListDeclarations <em>List Declarations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Declarations</em>'.
	 * @see org.eclipse.pop.ssme.RestrictionProcess#getListDeclarations()
	 * @see #getRestrictionProcess()
	 * @generated
	 */
	EReference getRestrictionProcess_ListDeclarations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.RootModel <em>Root Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root Model</em>'.
	 * @see org.eclipse.pop.ssme.RootModel
	 * @generated
	 */
	EClass getRootModel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SequentialDefinition <em>Sequential Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sequential Definition</em>'.
	 * @see org.eclipse.pop.ssme.SequentialDefinition
	 * @generated
	 */
	EClass getSequentialDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SharedVariablesDeclaration <em>Shared Variables Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shared Variables Declaration</em>'.
	 * @see org.eclipse.pop.ssme.SharedVariablesDeclaration
	 * @generated
	 */
	EClass getSharedVariablesDeclaration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SharedVariablesDeclaration#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.SharedVariablesDeclaration#getType()
	 * @see #getSharedVariablesDeclaration()
	 * @generated
	 */
	EReference getSharedVariablesDeclaration_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.SharedVariablesDeclaration#getListSignal <em>List Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Signal</em>'.
	 * @see org.eclipse.pop.ssme.SharedVariablesDeclaration#getListSignal()
	 * @see #getSharedVariablesDeclaration()
	 * @generated
	 */
	EReference getSharedVariablesDeclaration_ListSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalElement <em>Signal Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signal Element</em>'.
	 * @see org.eclipse.pop.ssme.SignalElement
	 * @generated
	 */
	EClass getSignalElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.SignalElement#getCommentPre <em>Comment Pre</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Comment Pre</em>'.
	 * @see org.eclipse.pop.ssme.SignalElement#getCommentPre()
	 * @see #getSignalElement()
	 * @generated
	 */
	EReference getSignalElement_CommentPre();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.SignalElement#getCommentPost <em>Comment Post</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Comment Post</em>'.
	 * @see org.eclipse.pop.ssme.SignalElement#getCommentPost()
	 * @see #getSignalElement()
	 * @generated
	 */
	EReference getSignalElement_CommentPost();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalNaming <em>Signal Naming</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signal Naming</em>'.
	 * @see org.eclipse.pop.ssme.SignalNaming
	 * @generated
	 */
	EClass getSignalNaming();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalNaming#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.SignalNaming#getIdentifier()
	 * @see #getSignalNaming()
	 * @generated
	 */
	EReference getSignalNaming_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalNaming#getInitValue <em>Init Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Init Value</em>'.
	 * @see org.eclipse.pop.ssme.SignalNaming#getInitValue()
	 * @see #getSignalNaming()
	 * @generated
	 */
	EReference getSignalNaming_InitValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Signals <em>Signals</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signals</em>'.
	 * @see org.eclipse.pop.ssme.Signals
	 * @generated
	 */
	EClass getSignals();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.Signals#getListExprSignal <em>List Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>List Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.Signals#getListExprSignal()
	 * @see #getSignals()
	 * @generated
	 */
	EReference getSignals_ListExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalsDeclaration <em>Signals Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signals Declaration</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDeclaration
	 * @generated
	 */
	EClass getSignalsDeclaration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsDeclaration#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDeclaration#getType()
	 * @see #getSignalsDeclaration()
	 * @generated
	 */
	EReference getSignalsDeclaration_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.SignalsDeclaration#getListSignal <em>List Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Signal</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDeclaration#getListSignal()
	 * @see #getSignalsDeclaration()
	 * @generated
	 */
	EReference getSignalsDeclaration_ListSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalsDefinition <em>Signals Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signals Definition</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDefinition
	 * @generated
	 */
	EClass getSignalsDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsDefinition#getExprSignalLeft <em>Expr Signal Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Left</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDefinition#getExprSignalLeft()
	 * @see #getSignalsDefinition()
	 * @generated
	 */
	EReference getSignalsDefinition_ExprSignalLeft();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsDefinition#getExprSignalRight <em>Expr Signal Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Right</em>'.
	 * @see org.eclipse.pop.ssme.SignalsDefinition#getExprSignalRight()
	 * @see #getSignalsDefinition()
	 * @generated
	 */
	EReference getSignalsDefinition_ExprSignalRight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalsPartialDefaultDefinition <em>Signals Partial Default Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signals Partial Default Definition</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefaultDefinition
	 * @generated
	 */
	EClass getSignalsPartialDefaultDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsPartialDefaultDefinition#getExprSignalLeft <em>Expr Signal Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Left</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefaultDefinition#getExprSignalLeft()
	 * @see #getSignalsPartialDefaultDefinition()
	 * @generated
	 */
	EReference getSignalsPartialDefaultDefinition_ExprSignalLeft();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsPartialDefaultDefinition#getExprSignalRight <em>Expr Signal Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Right</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefaultDefinition#getExprSignalRight()
	 * @see #getSignalsPartialDefaultDefinition()
	 * @generated
	 */
	EReference getSignalsPartialDefaultDefinition_ExprSignalRight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.SignalsPartialDefinition <em>Signals Partial Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signals Partial Definition</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefinition
	 * @generated
	 */
	EClass getSignalsPartialDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsPartialDefinition#getExprSignalLeft <em>Expr Signal Left</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Left</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefinition#getExprSignalLeft()
	 * @see #getSignalsPartialDefinition()
	 * @generated
	 */
	EReference getSignalsPartialDefinition_ExprSignalLeft();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.SignalsPartialDefinition#getExprSignalRight <em>Expr Signal Right</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal Right</em>'.
	 * @see org.eclipse.pop.ssme.SignalsPartialDefinition#getExprSignalRight()
	 * @see #getSignalsPartialDefinition()
	 * @generated
	 */
	EReference getSignalsPartialDefinition_ExprSignalRight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.StateVariablesDeclaration <em>State Variables Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State Variables Declaration</em>'.
	 * @see org.eclipse.pop.ssme.StateVariablesDeclaration
	 * @generated
	 */
	EClass getStateVariablesDeclaration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.StateVariablesDeclaration#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.StateVariablesDeclaration#getType()
	 * @see #getStateVariablesDeclaration()
	 * @generated
	 */
	EReference getStateVariablesDeclaration_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.StateVariablesDeclaration#getListSignal <em>List Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Signal</em>'.
	 * @see org.eclipse.pop.ssme.StateVariablesDeclaration#getListSignal()
	 * @see #getStateVariablesDeclaration()
	 * @generated
	 */
	EReference getStateVariablesDeclaration_ListSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.StateVariableValue <em>State Variable Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State Variable Value</em>'.
	 * @see org.eclipse.pop.ssme.StateVariableValue
	 * @generated
	 */
	EClass getStateVariableValue();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.StateVariableValue#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.StateVariableValue#getIdentifier()
	 * @see #getStateVariableValue()
	 * @generated
	 */
	EReference getStateVariableValue_Identifier();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.StringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Value</em>'.
	 * @see org.eclipse.pop.ssme.StringValue
	 * @generated
	 */
	EClass getStringValue();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.StringValue#getListConstantString <em>List Constant String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Constant String</em>'.
	 * @see org.eclipse.pop.ssme.StringValue#getListConstantString()
	 * @see #getStringValue()
	 * @generated
	 */
	EReference getStringValue_ListConstantString();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TernaryOperators <em>Ternary Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ternary Operators</em>'.
	 * @see org.eclipse.pop.ssme.TernaryOperators
	 * @generated
	 */
	EClass getTernaryOperators();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TernaryOperators#getExprSignal1 <em>Expr Signal1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal1</em>'.
	 * @see org.eclipse.pop.ssme.TernaryOperators#getExprSignal1()
	 * @see #getTernaryOperators()
	 * @generated
	 */
	EReference getTernaryOperators_ExprSignal1();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TernaryOperators#getExprSignal2 <em>Expr Signal2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal2</em>'.
	 * @see org.eclipse.pop.ssme.TernaryOperators#getExprSignal2()
	 * @see #getTernaryOperators()
	 * @generated
	 */
	EReference getTernaryOperators_ExprSignal2();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TernaryOperators#getExprSignal3 <em>Expr Signal3</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal3</em>'.
	 * @see org.eclipse.pop.ssme.TernaryOperators#getExprSignal3()
	 * @see #getTernaryOperators()
	 * @generated
	 */
	EReference getTernaryOperators_ExprSignal3();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Transposition <em>Transposition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transposition</em>'.
	 * @see org.eclipse.pop.ssme.Transposition
	 * @generated
	 */
	EClass getTransposition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TupleType <em>Tuple Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tuple Type</em>'.
	 * @see org.eclipse.pop.ssme.TupleType
	 * @generated
	 */
	EClass getTupleType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.TupleType#getListSignalsDeclaration <em>List Signals Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>List Signals Declaration</em>'.
	 * @see org.eclipse.pop.ssme.TupleType#getListSignalsDeclaration()
	 * @see #getTupleType()
	 * @generated
	 */
	EReference getTupleType_ListSignalsDeclaration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TupleType#getGraphSpecification <em>Graph Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Graph Specification</em>'.
	 * @see org.eclipse.pop.ssme.TupleType#getGraphSpecification()
	 * @see #getTupleType()
	 * @generated
	 */
	EReference getTupleType_GraphSpecification();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.TupleType#getTypeKind <em>Type Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type Kind</em>'.
	 * @see org.eclipse.pop.ssme.TupleType#getTypeKind()
	 * @see #getTupleType()
	 * @generated
	 */
	EAttribute getTupleType_TypeKind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see org.eclipse.pop.ssme.Type
	 * @generated
	 */
	EClass getType();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypeDefinition <em>Type Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Definition</em>'.
	 * @see org.eclipse.pop.ssme.TypeDefinition
	 * @generated
	 */
	EClass getTypeDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypeDescription <em>Type Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Description</em>'.
	 * @see org.eclipse.pop.ssme.TypeDescription
	 * @generated
	 */
	EClass getTypeDescription();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TypeDescription#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Identifier</em>'.
	 * @see org.eclipse.pop.ssme.TypeDescription#getIdentifier()
	 * @see #getTypeDescription()
	 * @generated
	 */
	EReference getTypeDescription_Identifier();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TypeDescription#getTypeDescriptionValue <em>Type Description Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Description Value</em>'.
	 * @see org.eclipse.pop.ssme.TypeDescription#getTypeDescriptionValue()
	 * @see #getTypeDescription()
	 * @generated
	 */
	EReference getTypeDescription_TypeDescriptionValue();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TypeDescription#getInitValue <em>Init Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Init Value</em>'.
	 * @see org.eclipse.pop.ssme.TypeDescription#getInitValue()
	 * @see #getTypeDescription()
	 * @generated
	 */
	EReference getTypeDescription_InitValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypeDescriptionValue <em>Type Description Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Description Value</em>'.
	 * @see org.eclipse.pop.ssme.TypeDescriptionValue
	 * @generated
	 */
	EClass getTypeDescriptionValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypeMorphism <em>Type Morphism</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Morphism</em>'.
	 * @see org.eclipse.pop.ssme.TypeMorphism
	 * @generated
	 */
	EClass getTypeMorphism();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TypeMorphism#getDescribedType <em>Described Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Described Type</em>'.
	 * @see org.eclipse.pop.ssme.TypeMorphism#getDescribedType()
	 * @see #getTypeMorphism()
	 * @generated
	 */
	EReference getTypeMorphism_DescribedType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.TypeMorphism#getTypeDescriptionValue <em>Type Description Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Description Value</em>'.
	 * @see org.eclipse.pop.ssme.TypeMorphism#getTypeDescriptionValue()
	 * @see #getTypeMorphism()
	 * @generated
	 */
	EReference getTypeMorphism_TypeDescriptionValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypesDeclaration <em>Types Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Types Declaration</em>'.
	 * @see org.eclipse.pop.ssme.TypesDeclaration
	 * @generated
	 */
	EClass getTypesDeclaration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.pop.ssme.TypesDeclaration#getVisibility <em>Visibility</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visibility</em>'.
	 * @see org.eclipse.pop.ssme.TypesDeclaration#getVisibility()
	 * @see #getTypesDeclaration()
	 * @generated
	 */
	EAttribute getTypesDeclaration_Visibility();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.TypesDeclaration#getTypeDefinition <em>Type Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Type Definition</em>'.
	 * @see org.eclipse.pop.ssme.TypesDeclaration#getTypeDefinition()
	 * @see #getTypesDeclaration()
	 * @generated
	 */
	EReference getTypesDeclaration_TypeDefinition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration <em>Types Or Signals Declaration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Types Or Signals Declaration</em>'.
	 * @see org.eclipse.pop.ssme.TypesOrSignalsDeclaration
	 * @generated
	 */
	EClass getTypesOrSignalsDeclaration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.UnaryMinus <em>Unary Minus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Minus</em>'.
	 * @see org.eclipse.pop.ssme.UnaryMinus
	 * @generated
	 */
	EClass getUnaryMinus();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.UnaryPlus <em>Unary Plus</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Plus</em>'.
	 * @see org.eclipse.pop.ssme.UnaryPlus
	 * @generated
	 */
	EClass getUnaryPlus();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.UnaryOperators <em>Unary Operators</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary Operators</em>'.
	 * @see org.eclipse.pop.ssme.UnaryOperators
	 * @generated
	 */
	EClass getUnaryOperators();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.UnaryOperators#getExprSignal <em>Expr Signal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr Signal</em>'.
	 * @see org.eclipse.pop.ssme.UnaryOperators#getExprSignal()
	 * @see #getUnaryOperators()
	 * @generated
	 */
	EReference getUnaryOperators_ExprSignal();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.UnaryWhen <em>Unary When</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unary When</em>'.
	 * @see org.eclipse.pop.ssme.UnaryWhen
	 * @generated
	 */
	EClass getUnaryWhen();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.UnconditionedDependences <em>Unconditioned Dependences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unconditioned Dependences</em>'.
	 * @see org.eclipse.pop.ssme.UnconditionedDependences
	 * @generated
	 */
	EClass getUnconditionedDependences();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.pop.ssme.UnconditionedDependences#getSignals <em>Signals</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Signals</em>'.
	 * @see org.eclipse.pop.ssme.UnconditionedDependences#getSignals()
	 * @see #getUnconditionedDependences()
	 * @generated
	 */
	EReference getUnconditionedDependences_Signals();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.pop.ssme.UnconditionedDependences#getDependenceElementsList <em>Dependence Elements List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Dependence Elements List</em>'.
	 * @see org.eclipse.pop.ssme.UnconditionedDependences#getDependenceElementsList()
	 * @see #getUnconditionedDependences()
	 * @generated
	 */
	EReference getUnconditionedDependences_DependenceElementsList();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Var <em>Var</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Var</em>'.
	 * @see org.eclipse.pop.ssme.Var
	 * @generated
	 */
	EClass getVar();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.When <em>When</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>When</em>'.
	 * @see org.eclipse.pop.ssme.When
	 * @generated
	 */
	EClass getWhen();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Window <em>Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Window</em>'.
	 * @see org.eclipse.pop.ssme.Window
	 * @generated
	 */
	EClass getWindow();

	/**
	 * Returns the meta object for class '{@link org.eclipse.pop.ssme.Xor <em>Xor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Xor</em>'.
	 * @see org.eclipse.pop.ssme.Xor
	 * @generated
	 */
	EClass getXor();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.ConstantLogicalKind <em>Constant Logical Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Constant Logical Kind</em>'.
	 * @see org.eclipse.pop.ssme.ConstantLogicalKind
	 * @generated
	 */
	EEnum getConstantLogicalKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.IntervalsKind <em>Intervals Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Intervals Kind</em>'.
	 * @see org.eclipse.pop.ssme.IntervalsKind
	 * @generated
	 */
	EEnum getIntervalsKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.ModelKind <em>Model Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Model Kind</em>'.
	 * @see org.eclipse.pop.ssme.ModelKind
	 * @generated
	 */
	EEnum getModelKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.OperatorKind <em>Operator Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Operator Kind</em>'.
	 * @see org.eclipse.pop.ssme.OperatorKind
	 * @generated
	 */
	EEnum getOperatorKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.ProcessAttributeKind <em>Process Attribute Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Process Attribute Kind</em>'.
	 * @see org.eclipse.pop.ssme.ProcessAttributeKind
	 * @generated
	 */
	EEnum getProcessAttributeKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.SignalIntrinsicType <em>Signal Intrinsic Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Signal Intrinsic Type</em>'.
	 * @see org.eclipse.pop.ssme.SignalIntrinsicType
	 * @generated
	 */
	EEnum getSignalIntrinsicType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.TypeKind <em>Type Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Type Kind</em>'.
	 * @see org.eclipse.pop.ssme.TypeKind
	 * @generated
	 */
	EEnum getTypeKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.pop.ssme.VisibilityKind <em>Visibility Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Visibility Kind</em>'.
	 * @see org.eclipse.pop.ssme.VisibilityKind
	 * @generated
	 */
	EEnum getVisibilityKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SsmeFactory getSsmeFactory();

} //SsmePackage
