/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Tuple Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.TupleType#getListSignalsDeclaration <em>List Signals Declaration</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.TupleType#getGraphSpecification <em>Graph Specification</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.TupleType#getTypeKind <em>Type Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getTupleType()
 * @model
 * @generated
 */
public interface TupleType extends DescribedType {
	/**
	 * Returns the value of the '<em><b>List Signals Declaration</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.pop.ssme.TypesOrSignalsDeclaration}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>List Signals Declaration</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>List Signals Declaration</em>' containment reference list.
	 * @see org.eclipse.pop.ssme.SsmePackage#getTupleType_ListSignalsDeclaration()
	 * @model containment="true"
	 * @generated
	 */
	EList<TypesOrSignalsDeclaration> getListSignalsDeclaration();

	/**
	 * Returns the value of the '<em><b>Graph Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Graph Specification</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Graph Specification</em>' containment reference.
	 * @see #setGraphSpecification(GraphSpecification)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTupleType_GraphSpecification()
	 * @model containment="true"
	 * @generated
	 */
	GraphSpecification getGraphSpecification();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TupleType#getGraphSpecification <em>Graph Specification</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Graph Specification</em>' containment reference.
	 * @see #getGraphSpecification()
	 * @generated
	 */
	void setGraphSpecification(GraphSpecification value);

	/**
	 * Returns the value of the '<em><b>Type Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.pop.ssme.TypeKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.TypeKind
	 * @see #setTypeKind(TypeKind)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTupleType_TypeKind()
	 * @model required="true"
	 * @generated
	 */
	TypeKind getTypeKind();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TupleType#getTypeKind <em>Type Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type Kind</em>' attribute.
	 * @see org.eclipse.pop.ssme.TypeKind
	 * @see #getTypeKind()
	 * @generated
	 */
	void setTypeKind(TypeKind value);

} // TupleType
