/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Description</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.TypeDescription#getIdentifier <em>Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.TypeDescription#getTypeDescriptionValue <em>Type Description Value</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.TypeDescription#getInitValue <em>Init Value</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.pop.ssme.SsmePackage#getTypeDescription()
 * @model
 * @generated
 */
public interface TypeDescription extends TypeDefinition {
	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' containment reference.
	 * @see #setIdentifier(Identifier)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTypeDescription_Identifier()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Identifier getIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TypeDescription#getIdentifier <em>Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' containment reference.
	 * @see #getIdentifier()
	 * @generated
	 */
	void setIdentifier(Identifier value);

	/**
	 * Returns the value of the '<em><b>Type Description Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type Description Value</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type Description Value</em>' containment reference.
	 * @see #setTypeDescriptionValue(TypeDescriptionValue)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTypeDescription_TypeDescriptionValue()
	 * @model containment="true" required="true"
	 * @generated
	 */
	TypeDescriptionValue getTypeDescriptionValue();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TypeDescription#getTypeDescriptionValue <em>Type Description Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type Description Value</em>' containment reference.
	 * @see #getTypeDescriptionValue()
	 * @generated
	 */
	void setTypeDescriptionValue(TypeDescriptionValue value);

	/**
	 * Returns the value of the '<em><b>Init Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Init Value</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Init Value</em>' containment reference.
	 * @see #setInitValue(ExprSignal)
	 * @see org.eclipse.pop.ssme.SsmePackage#getTypeDescription_InitValue()
	 * @model containment="true"
	 * @generated
	 */
	ExprSignal getInitValue();

	/**
	 * Sets the value of the '{@link org.eclipse.pop.ssme.TypeDescription#getInitValue <em>Init Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Init Value</em>' containment reference.
	 * @see #getInitValue()
	 * @generated
	 */
	void setInitValue(ExprSignal value);

} // TypeDescription
