/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.AssertProcess;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Assert Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.AssertProcessImpl#getProcessExpression <em>Process Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AssertProcessImpl extends SignalElementImpl implements AssertProcess {
	/**
	 * The cached value of the '{@link #getProcessExpression() <em>Process Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessExpression()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess processExpression;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssertProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getAssertProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getProcessExpression() {
		return processExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProcessExpression(ExprProcess newProcessExpression, NotificationChain msgs) {
		ExprProcess oldProcessExpression = processExpression;
		processExpression = newProcessExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION, oldProcessExpression, newProcessExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessExpression(ExprProcess newProcessExpression) {
		if (newProcessExpression != processExpression) {
			NotificationChain msgs = null;
			if (processExpression != null)
				msgs = ((InternalEObject)processExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION, null, msgs);
			if (newProcessExpression != null)
				msgs = ((InternalEObject)newProcessExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION, null, msgs);
			msgs = basicSetProcessExpression(newProcessExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION, newProcessExpression, newProcessExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION:
				return basicSetProcessExpression(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION:
				return getProcessExpression();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION:
				setProcessExpression((ExprProcess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION:
				setProcessExpression((ExprProcess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ASSERT_PROCESS__PROCESS_EXPRESSION:
				return processExpression != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		long compositionNode = API.getNilTree();
		if (getProcessExpression() != null) {
			compositionNode = getProcessExpression().makeAST();
		}
		if (compositionNode != PKTrees.ERROR_NODE) {
			result = API.makeUnary(SignalOperators.oppassert, compositionNode);
		}
		setASTAttribute(this, result);
		return result;
	}
	
} //AssertProcessImpl
