/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.CaseBranch;
import org.eclipse.pop.ssme.CaseExprEnumeration;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Case Branch</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseBranchImpl#getEnumerationValues <em>Enumeration Values</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseBranchImpl#getExprProcess <em>Expr Process</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CaseBranchImpl extends SignalElementImpl implements CaseBranch {
	/**
	 * The cached value of the '{@link #getEnumerationValues() <em>Enumeration Values</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnumerationValues()
	 * @generated
	 * @ordered
	 */
	protected CaseExprEnumeration enumerationValues;

	/**
	 * The cached value of the '{@link #getExprProcess() <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprProcess()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess exprProcess;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseBranchImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getCaseBranch();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseExprEnumeration getEnumerationValues() {
		return enumerationValues;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEnumerationValues(CaseExprEnumeration newEnumerationValues, NotificationChain msgs) {
		CaseExprEnumeration oldEnumerationValues = enumerationValues;
		enumerationValues = newEnumerationValues;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_BRANCH__ENUMERATION_VALUES, oldEnumerationValues, newEnumerationValues);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnumerationValues(CaseExprEnumeration newEnumerationValues) {
		if (newEnumerationValues != enumerationValues) {
			NotificationChain msgs = null;
			if (enumerationValues != null)
				msgs = ((InternalEObject)enumerationValues).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_BRANCH__ENUMERATION_VALUES, null, msgs);
			if (newEnumerationValues != null)
				msgs = ((InternalEObject)newEnumerationValues).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_BRANCH__ENUMERATION_VALUES, null, msgs);
			msgs = basicSetEnumerationValues(newEnumerationValues, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_BRANCH__ENUMERATION_VALUES, newEnumerationValues, newEnumerationValues));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getExprProcess() {
		return exprProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprProcess(ExprProcess newExprProcess, NotificationChain msgs) {
		ExprProcess oldExprProcess = exprProcess;
		exprProcess = newExprProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_BRANCH__EXPR_PROCESS, oldExprProcess, newExprProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprProcess(ExprProcess newExprProcess) {
		if (newExprProcess != exprProcess) {
			NotificationChain msgs = null;
			if (exprProcess != null)
				msgs = ((InternalEObject)exprProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_BRANCH__EXPR_PROCESS, null, msgs);
			if (newExprProcess != null)
				msgs = ((InternalEObject)newExprProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_BRANCH__EXPR_PROCESS, null, msgs);
			msgs = basicSetExprProcess(newExprProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_BRANCH__EXPR_PROCESS, newExprProcess, newExprProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CASE_BRANCH__ENUMERATION_VALUES:
				return basicSetEnumerationValues(null, msgs);
			case SsmePackage.CASE_BRANCH__EXPR_PROCESS:
				return basicSetExprProcess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CASE_BRANCH__ENUMERATION_VALUES:
				return getEnumerationValues();
			case SsmePackage.CASE_BRANCH__EXPR_PROCESS:
				return getExprProcess();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CASE_BRANCH__ENUMERATION_VALUES:
				setEnumerationValues((CaseExprEnumeration)newValue);
				return;
			case SsmePackage.CASE_BRANCH__EXPR_PROCESS:
				setExprProcess((ExprProcess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_BRANCH__ENUMERATION_VALUES:
				setEnumerationValues((CaseExprEnumeration)null);
				return;
			case SsmePackage.CASE_BRANCH__EXPR_PROCESS:
				setExprProcess((ExprProcess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_BRANCH__ENUMERATION_VALUES:
				return enumerationValues != null;
			case SsmePackage.CASE_BRANCH__EXPR_PROCESS:
				return exprProcess != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long caseExprNode = API.getNilTree();
		if (getEnumerationValues() != null) {
			caseExprNode = getEnumerationValues().makeAST();
		}
		
		long termProcessNode = API.getNilTree();
		if (getExprProcess() != null) {
			termProcessNode = getExprProcess().makeAST();
		}
		
		if (caseExprNode != PKTrees.ERROR_NODE && termProcessNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opcas, caseExprNode, termProcessNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //CaseBranchImpl
