/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.CaseInterval;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.IntervalsKind;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Case Interval</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseIntervalImpl#getLowerBound <em>Lower Bound</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseIntervalImpl#getUpperBound <em>Upper Bound</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.CaseIntervalImpl#getIntervalsKind <em>Intervals Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CaseIntervalImpl extends SignalElementImpl implements CaseInterval {
	/**
	 * The cached value of the '{@link #getLowerBound() <em>Lower Bound</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLowerBound()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal lowerBound;

	/**
	 * The cached value of the '{@link #getUpperBound() <em>Upper Bound</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUpperBound()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal upperBound;

	/**
	 * The default value of the '{@link #getIntervalsKind() <em>Intervals Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntervalsKind()
	 * @generated
	 * @ordered
	 */
	protected static final IntervalsKind INTERVALS_KIND_EDEFAULT = IntervalsKind.LEFT_CLOSED_RIGHT_CLOSED_LITERAL;

	/**
	 * The cached value of the '{@link #getIntervalsKind() <em>Intervals Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIntervalsKind()
	 * @generated
	 * @ordered
	 */
	protected IntervalsKind intervalsKind = INTERVALS_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseIntervalImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getCaseInterval();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getLowerBound() {
		return lowerBound;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLowerBound(ExprSignal newLowerBound, NotificationChain msgs) {
		ExprSignal oldLowerBound = lowerBound;
		lowerBound = newLowerBound;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_INTERVAL__LOWER_BOUND, oldLowerBound, newLowerBound);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLowerBound(ExprSignal newLowerBound) {
		if (newLowerBound != lowerBound) {
			NotificationChain msgs = null;
			if (lowerBound != null)
				msgs = ((InternalEObject)lowerBound).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_INTERVAL__LOWER_BOUND, null, msgs);
			if (newLowerBound != null)
				msgs = ((InternalEObject)newLowerBound).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_INTERVAL__LOWER_BOUND, null, msgs);
			msgs = basicSetLowerBound(newLowerBound, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_INTERVAL__LOWER_BOUND, newLowerBound, newLowerBound));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getUpperBound() {
		return upperBound;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUpperBound(ExprSignal newUpperBound, NotificationChain msgs) {
		ExprSignal oldUpperBound = upperBound;
		upperBound = newUpperBound;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_INTERVAL__UPPER_BOUND, oldUpperBound, newUpperBound);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUpperBound(ExprSignal newUpperBound) {
		if (newUpperBound != upperBound) {
			NotificationChain msgs = null;
			if (upperBound != null)
				msgs = ((InternalEObject)upperBound).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_INTERVAL__UPPER_BOUND, null, msgs);
			if (newUpperBound != null)
				msgs = ((InternalEObject)newUpperBound).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CASE_INTERVAL__UPPER_BOUND, null, msgs);
			msgs = basicSetUpperBound(newUpperBound, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_INTERVAL__UPPER_BOUND, newUpperBound, newUpperBound));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalsKind getIntervalsKind() {
		return intervalsKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIntervalsKind(IntervalsKind newIntervalsKind) {
		IntervalsKind oldIntervalsKind = intervalsKind;
		intervalsKind = newIntervalsKind == null ? INTERVALS_KIND_EDEFAULT : newIntervalsKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CASE_INTERVAL__INTERVALS_KIND, oldIntervalsKind, intervalsKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CASE_INTERVAL__LOWER_BOUND:
				return basicSetLowerBound(null, msgs);
			case SsmePackage.CASE_INTERVAL__UPPER_BOUND:
				return basicSetUpperBound(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CASE_INTERVAL__LOWER_BOUND:
				return getLowerBound();
			case SsmePackage.CASE_INTERVAL__UPPER_BOUND:
				return getUpperBound();
			case SsmePackage.CASE_INTERVAL__INTERVALS_KIND:
				return getIntervalsKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CASE_INTERVAL__LOWER_BOUND:
				setLowerBound((ExprSignal)newValue);
				return;
			case SsmePackage.CASE_INTERVAL__UPPER_BOUND:
				setUpperBound((ExprSignal)newValue);
				return;
			case SsmePackage.CASE_INTERVAL__INTERVALS_KIND:
				setIntervalsKind((IntervalsKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_INTERVAL__LOWER_BOUND:
				setLowerBound((ExprSignal)null);
				return;
			case SsmePackage.CASE_INTERVAL__UPPER_BOUND:
				setUpperBound((ExprSignal)null);
				return;
			case SsmePackage.CASE_INTERVAL__INTERVALS_KIND:
				setIntervalsKind(INTERVALS_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CASE_INTERVAL__LOWER_BOUND:
				return lowerBound != null;
			case SsmePackage.CASE_INTERVAL__UPPER_BOUND:
				return upperBound != null;
			case SsmePackage.CASE_INTERVAL__INTERVALS_KIND:
				return intervalsKind != INTERVALS_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (intervalsKind: ");
		result.append(intervalsKind);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long lowerBoundNode = API.getNilTree();
		if (getLowerBound() != null) {
			lowerBoundNode = getLowerBound().makeAST();
		}
		
		long upperBoundNode = API.getNilTree();
		if (getUpperBound() != null) {
			upperBoundNode = getUpperBound().makeAST();
		}
		
		if (lowerBoundNode != PKTrees.ERROR_NODE && upperBoundNode != PKTrees.ERROR_NODE) {
			if (getIntervalsKind().equals(IntervalsKind.LEFT_CLOSED_RIGHT_CLOSED_LITERAL)) {
				result = API.makeBinary(SignalOperators.opintvff, lowerBoundNode, upperBoundNode);
			}
			else if (getIntervalsKind().equals(IntervalsKind.LEFT_CLOSED_RIGHT_OPENED_LITERAL)) {
				result = API.makeBinary(SignalOperators.opintvfo, lowerBoundNode, upperBoundNode);
			}
			else if (getIntervalsKind().equals(IntervalsKind.LEFT_OPENED_RIGHT_CLOSED_LITERAL)) {
				result = API.makeBinary(SignalOperators.opintvof, lowerBoundNode, upperBoundNode);
			}
			else if (getIntervalsKind().equals(IntervalsKind.LEFT_OPENED_RIGHT_OPENED_LITERAL)) {
				result = API.makeBinary(SignalOperators.opintvoo, lowerBoundNode, upperBoundNode);
			}
		}
		setASTAttribute(this, result);
		return result;
	}
	
} //CaseIntervalImpl
