/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ConstantEnum;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Constant Enum</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantEnumImpl#getTypeIdentifier <em>Type Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ConstantEnumImpl#getConstantEnumValue <em>Constant Enum Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConstantEnumImpl extends SignalElementImpl implements ConstantEnum {
	/**
	 * The cached value of the '{@link #getTypeIdentifier() <em>Type Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeIdentifier()
	 * @generated
	 * @ordered
	 */
	protected Identifier typeIdentifier;

	/**
	 * The cached value of the '{@link #getConstantEnumValue() <em>Constant Enum Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstantEnumValue()
	 * @generated
	 * @ordered
	 */
	protected Identifier constantEnumValue;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantEnumImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getConstantEnum();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getTypeIdentifier() {
		return typeIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTypeIdentifier(Identifier newTypeIdentifier, NotificationChain msgs) {
		Identifier oldTypeIdentifier = typeIdentifier;
		typeIdentifier = newTypeIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER, oldTypeIdentifier, newTypeIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTypeIdentifier(Identifier newTypeIdentifier) {
		if (newTypeIdentifier != typeIdentifier) {
			NotificationChain msgs = null;
			if (typeIdentifier != null)
				msgs = ((InternalEObject)typeIdentifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER, null, msgs);
			if (newTypeIdentifier != null)
				msgs = ((InternalEObject)newTypeIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER, null, msgs);
			msgs = basicSetTypeIdentifier(newTypeIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER, newTypeIdentifier, newTypeIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getConstantEnumValue() {
		return constantEnumValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConstantEnumValue(Identifier newConstantEnumValue, NotificationChain msgs) {
		Identifier oldConstantEnumValue = constantEnumValue;
		constantEnumValue = newConstantEnumValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE, oldConstantEnumValue, newConstantEnumValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConstantEnumValue(Identifier newConstantEnumValue) {
		if (newConstantEnumValue != constantEnumValue) {
			NotificationChain msgs = null;
			if (constantEnumValue != null)
				msgs = ((InternalEObject)constantEnumValue).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE, null, msgs);
			if (newConstantEnumValue != null)
				msgs = ((InternalEObject)newConstantEnumValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE, null, msgs);
			msgs = basicSetConstantEnumValue(newConstantEnumValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE, newConstantEnumValue, newConstantEnumValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER:
				return basicSetTypeIdentifier(null, msgs);
			case SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE:
				return basicSetConstantEnumValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER:
				return getTypeIdentifier();
			case SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE:
				return getConstantEnumValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER:
				setTypeIdentifier((Identifier)newValue);
				return;
			case SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE:
				setConstantEnumValue((Identifier)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER:
				setTypeIdentifier((Identifier)null);
				return;
			case SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE:
				setConstantEnumValue((Identifier)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.CONSTANT_ENUM__TYPE_IDENTIFIER:
				return typeIdentifier != null;
			case SsmePackage.CONSTANT_ENUM__CONSTANT_ENUM_VALUE:
				return constantEnumValue != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long id1Node = API.getNilTree();
		if (getTypeIdentifier() != null) {
			id1Node = getTypeIdentifier().makeAST();
		}
		
		long id2Node = API.getNilTree();
		if (getConstantEnumValue() != null) {
			id2Node = getConstantEnumValue().makeAST();
		}
		
		if (id1Node != PKTrees.ERROR_NODE && id2Node != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opvenum, id1Node, id2Node);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ConstantEnumImpl
