/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExternalGraph;
import org.eclipse.pop.ssme.GraphSpecification;
import org.eclipse.pop.ssme.ProcessAttribute;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>External Graph</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ExternalGraphImpl#getProcessAttributes <em>Process Attributes</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ExternalGraphImpl#getGraphSpecification <em>Graph Specification</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ExternalGraphImpl extends SignalElementImpl implements ExternalGraph {
	/**
	 * The cached value of the '{@link #getProcessAttributes() <em>Process Attributes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessAttributes()
	 * @generated
	 * @ordered
	 */
	protected EList<ProcessAttribute> processAttributes;

	/**
	 * The cached value of the '{@link #getGraphSpecification() <em>Graph Specification</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphSpecification()
	 * @generated
	 * @ordered
	 */
	protected GraphSpecification graphSpecification;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalGraphImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getExternalGraph();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ProcessAttribute> getProcessAttributes() {
		if (processAttributes == null) {
			processAttributes = new EObjectContainmentEList<ProcessAttribute>(ProcessAttribute.class, this, SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES);
		}
		return processAttributes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphSpecification getGraphSpecification() {
		return graphSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGraphSpecification(GraphSpecification newGraphSpecification, NotificationChain msgs) {
		GraphSpecification oldGraphSpecification = graphSpecification;
		graphSpecification = newGraphSpecification;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION, oldGraphSpecification, newGraphSpecification);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGraphSpecification(GraphSpecification newGraphSpecification) {
		if (newGraphSpecification != graphSpecification) {
			NotificationChain msgs = null;
			if (graphSpecification != null)
				msgs = ((InternalEObject)graphSpecification).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION, null, msgs);
			if (newGraphSpecification != null)
				msgs = ((InternalEObject)newGraphSpecification).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION, null, msgs);
			msgs = basicSetGraphSpecification(newGraphSpecification, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION, newGraphSpecification, newGraphSpecification));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		
		boolean attributsNullOrEmpty = true;
		if (getProcessAttributes() != null && !getProcessAttributes().isEmpty())
		{
			attributsNullOrEmpty = false;
		}
		
		if (attributsNullOrEmpty == false && getGraphSpecification() != null) {
			long nodeAttribut = API.makeEmptyList(SignalOperators.oplattr);
			for (ProcessAttribute attr : getProcessAttributes()) {
				nodeAttribut = API.post(nodeAttribut, attr.makeAST());
			}
			long nodeSpec = getGraphSpecification().makeAST();
			result = API.makeBinary(SignalOperators.opspec, nodeAttribut, nodeSpec);
		}
		else if (attributsNullOrEmpty == true && getGraphSpecification() != null) {
			long nodeSpec = getGraphSpecification().makeAST();
			result = API.makeBinary(SignalOperators.opspec, API.getNilTree(), nodeSpec);
		}
		else if (attributsNullOrEmpty == false && getGraphSpecification() == null) {
			long nodeAttribut = API.makeEmptyList(SignalOperators.oplattr);
			for (ProcessAttribute attr : getProcessAttributes()) {
				nodeAttribut = API.post(nodeAttribut, attr.makeAST());
			}
			result = API.makeBinary(SignalOperators.opspec, nodeAttribut, API.getNilTree());
		}
		else if (attributsNullOrEmpty == true && getGraphSpecification() == null) {
			result = API.makeBinary(SignalOperators.opspec, API.getNilTree(), API.getNilTree());
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES:
				return ((InternalEList<?>)getProcessAttributes()).basicRemove(otherEnd, msgs);
			case SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION:
				return basicSetGraphSpecification(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES:
				return getProcessAttributes();
			case SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION:
				return getGraphSpecification();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES:
				getProcessAttributes().clear();
				getProcessAttributes().addAll((Collection<? extends ProcessAttribute>)newValue);
				return;
			case SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION:
				setGraphSpecification((GraphSpecification)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES:
				getProcessAttributes().clear();
				return;
			case SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION:
				setGraphSpecification((GraphSpecification)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.EXTERNAL_GRAPH__PROCESS_ATTRIBUTES:
				return processAttributes != null && !processAttributes.isEmpty();
			case SsmePackage.EXTERNAL_GRAPH__GRAPH_SPECIFICATION:
				return graphSpecification != null;
		}
		return super.eIsSet(featureID);
	}

} //ExternalGraphImpl
