/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.IOProfile;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.TypesOrSignalsDeclaration;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>IO Profile</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.IOProfileImpl#getInputs <em>Inputs</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.IOProfileImpl#getOutputs <em>Outputs</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IOProfileImpl extends SignalElementImpl implements IOProfile {
	/**
	 * The cached value of the '{@link #getInputs() <em>Inputs</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputs()
	 * @generated
	 * @ordered
	 */
	protected EList<TypesOrSignalsDeclaration> inputs;

	/**
	 * The cached value of the '{@link #getOutputs() <em>Outputs</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputs()
	 * @generated
	 * @ordered
	 */
	protected EList<TypesOrSignalsDeclaration> outputs;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IOProfileImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getIOProfile();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypesOrSignalsDeclaration> getInputs() {
		if (inputs == null) {
			inputs = new EObjectContainmentEList<TypesOrSignalsDeclaration>(TypesOrSignalsDeclaration.class, this, SsmePackage.IO_PROFILE__INPUTS);
		}
		return inputs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypesOrSignalsDeclaration> getOutputs() {
		if (outputs == null) {
			outputs = new EObjectContainmentEList<TypesOrSignalsDeclaration>(TypesOrSignalsDeclaration.class, this, SsmePackage.IO_PROFILE__OUTPUTS);
		}
		return outputs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.IO_PROFILE__INPUTS:
				return ((InternalEList<?>)getInputs()).basicRemove(otherEnd, msgs);
			case SsmePackage.IO_PROFILE__OUTPUTS:
				return ((InternalEList<?>)getOutputs()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.IO_PROFILE__INPUTS:
				return getInputs();
			case SsmePackage.IO_PROFILE__OUTPUTS:
				return getOutputs();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.IO_PROFILE__INPUTS:
				getInputs().clear();
				getInputs().addAll((Collection<? extends TypesOrSignalsDeclaration>)newValue);
				return;
			case SsmePackage.IO_PROFILE__OUTPUTS:
				getOutputs().clear();
				getOutputs().addAll((Collection<? extends TypesOrSignalsDeclaration>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.IO_PROFILE__INPUTS:
				getInputs().clear();
				return;
			case SsmePackage.IO_PROFILE__OUTPUTS:
				getOutputs().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.IO_PROFILE__INPUTS:
				return inputs != null && !inputs.isEmpty();
			case SsmePackage.IO_PROFILE__OUTPUTS:
				return outputs != null && !outputs.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long listeEntrees = API.getNilTree();
		if (getInputs() != null && !getInputs().isEmpty()) {
			listeEntrees = API.makeEmptyList(SignalOperators.opldecs);
			for (TypesOrSignalsDeclaration ds : getInputs()) {
				long node = ds.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					listeEntrees = API.post(listeEntrees, node);
				}
			}
		}
		
		long listeSorties = API.getNilTree();
		if (getOutputs() != null && !getOutputs().isEmpty()) {
			listeSorties = API.makeEmptyList(SignalOperators.opldecs);
			for (TypesOrSignalsDeclaration ds : getOutputs()) {
				long node = ds.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					listeSorties = API.post(listeSorties, node);
				}
			}
		}
		
		if (listeEntrees != PKTrees.ERROR_NODE && listeSorties != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opentsor, listeEntrees, listeSorties);
		}
		setASTAttribute(this, result);
		return result;
	}

} //IOProfileImpl
