/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.Iteration;
import org.eclipse.pop.ssme.PartialIteration;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Iteration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.IterationImpl#getPartialIteration <em>Partial Iteration</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.IterationImpl#getElemDefinition <em>Elem Definition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IterationImpl extends SignalElementImpl implements Iteration {
	/**
	 * The cached value of the '{@link #getPartialIteration() <em>Partial Iteration</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPartialIteration()
	 * @generated
	 * @ordered
	 */
	protected EList<PartialIteration> partialIteration;

	/**
	 * The cached value of the '{@link #getElemDefinition() <em>Elem Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElemDefinition()
	 * @generated
	 * @ordered
	 */
	protected ExprSignal elemDefinition;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IterationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getIteration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<PartialIteration> getPartialIteration() {
		if (partialIteration == null) {
			partialIteration = new EObjectContainmentEList<PartialIteration>(PartialIteration.class, this, SsmePackage.ITERATION__PARTIAL_ITERATION);
		}
		return partialIteration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprSignal getElemDefinition() {
		return elemDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetElemDefinition(ExprSignal newElemDefinition, NotificationChain msgs) {
		ExprSignal oldElemDefinition = elemDefinition;
		elemDefinition = newElemDefinition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.ITERATION__ELEM_DEFINITION, oldElemDefinition, newElemDefinition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElemDefinition(ExprSignal newElemDefinition) {
		if (newElemDefinition != elemDefinition) {
			NotificationChain msgs = null;
			if (elemDefinition != null)
				msgs = ((InternalEObject)elemDefinition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ITERATION__ELEM_DEFINITION, null, msgs);
			if (newElemDefinition != null)
				msgs = ((InternalEObject)newElemDefinition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.ITERATION__ELEM_DEFINITION, null, msgs);
			msgs = basicSetElemDefinition(newElemDefinition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.ITERATION__ELEM_DEFINITION, newElemDefinition, newElemDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.ITERATION__PARTIAL_ITERATION:
				return ((InternalEList<?>)getPartialIteration()).basicRemove(otherEnd, msgs);
			case SsmePackage.ITERATION__ELEM_DEFINITION:
				return basicSetElemDefinition(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.ITERATION__PARTIAL_ITERATION:
				return getPartialIteration();
			case SsmePackage.ITERATION__ELEM_DEFINITION:
				return getElemDefinition();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.ITERATION__PARTIAL_ITERATION:
				getPartialIteration().clear();
				getPartialIteration().addAll((Collection<? extends PartialIteration>)newValue);
				return;
			case SsmePackage.ITERATION__ELEM_DEFINITION:
				setElemDefinition((ExprSignal)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.ITERATION__PARTIAL_ITERATION:
				getPartialIteration().clear();
				return;
			case SsmePackage.ITERATION__ELEM_DEFINITION:
				setElemDefinition((ExprSignal)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.ITERATION__PARTIAL_ITERATION:
				return partialIteration != null && !partialIteration.isEmpty();
			case SsmePackage.ITERATION__ELEM_DEFINITION:
				return elemDefinition != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long listParcoursNode = API.getNilTree();
		if (getPartialIteration() != null && !getPartialIteration().isEmpty()) {
			listParcoursNode = API.makeEmptyList(SignalOperators.oplparc);
			for (PartialIteration partIter : getPartialIteration()) {
				long parcoursNode = partIter.makeAST();
				if (parcoursNode != PKTrees.ERROR_NODE) {
					listParcoursNode = API.post(listParcoursNode, parcoursNode);
				}
			}
		}
		
		long defElementMultipleNode = API.getNilTree();
		if (getElemDefinition() != null) {
			defElementMultipleNode = getElemDefinition().makeAST();
		}
		
		if (listParcoursNode != PKTrees.ERROR_NODE && defElementMultipleNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opensvec, listParcoursNode, defElementMultipleNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //IterationImpl
