/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.LabelledProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Labelled Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.LabelledProcessImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.LabelledProcessImpl#getExprProcess <em>Expr Process</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class LabelledProcessImpl extends SignalElementImpl implements LabelledProcess {
	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected Identifier label;

	/**
	 * The cached value of the '{@link #getExprProcess() <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprProcess()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess exprProcess;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LabelledProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getLabelledProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier getLabel() {
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLabel(Identifier newLabel, NotificationChain msgs) {
		Identifier oldLabel = label;
		label = newLabel;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.LABELLED_PROCESS__LABEL, oldLabel, newLabel);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(Identifier newLabel) {
		if (newLabel != label) {
			NotificationChain msgs = null;
			if (label != null)
				msgs = ((InternalEObject)label).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.LABELLED_PROCESS__LABEL, null, msgs);
			if (newLabel != null)
				msgs = ((InternalEObject)newLabel).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.LABELLED_PROCESS__LABEL, null, msgs);
			msgs = basicSetLabel(newLabel, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.LABELLED_PROCESS__LABEL, newLabel, newLabel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getExprProcess() {
		return exprProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprProcess(ExprProcess newExprProcess, NotificationChain msgs) {
		ExprProcess oldExprProcess = exprProcess;
		exprProcess = newExprProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.LABELLED_PROCESS__EXPR_PROCESS, oldExprProcess, newExprProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprProcess(ExprProcess newExprProcess) {
		if (newExprProcess != exprProcess) {
			NotificationChain msgs = null;
			if (exprProcess != null)
				msgs = ((InternalEObject)exprProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.LABELLED_PROCESS__EXPR_PROCESS, null, msgs);
			if (newExprProcess != null)
				msgs = ((InternalEObject)newExprProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.LABELLED_PROCESS__EXPR_PROCESS, null, msgs);
			msgs = basicSetExprProcess(newExprProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.LABELLED_PROCESS__EXPR_PROCESS, newExprProcess, newExprProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long etiqNode = API.getNilTree();
		long procNode = API.getNilTree();
		if (getLabel() != null) {
			etiqNode = getLabel().makeAST();
		}
		if (getExprProcess() != null) {
			procNode = getExprProcess().makeAST();
		}
		if (etiqNode != PKTrees.ERROR_NODE && procNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.oppetiq, etiqNode, procNode);
		}
		setASTAttribute(this, result);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.LABELLED_PROCESS__LABEL:
				return basicSetLabel(null, msgs);
			case SsmePackage.LABELLED_PROCESS__EXPR_PROCESS:
				return basicSetExprProcess(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.LABELLED_PROCESS__LABEL:
				return getLabel();
			case SsmePackage.LABELLED_PROCESS__EXPR_PROCESS:
				return getExprProcess();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.LABELLED_PROCESS__LABEL:
				setLabel((Identifier)newValue);
				return;
			case SsmePackage.LABELLED_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.LABELLED_PROCESS__LABEL:
				setLabel((Identifier)null);
				return;
			case SsmePackage.LABELLED_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.LABELLED_PROCESS__LABEL:
				return label != null;
			case SsmePackage.LABELLED_PROCESS__EXPR_PROCESS:
				return exprProcess != null;
		}
		return super.eIsSet(featureID);
	}

} //LabelledProcessImpl
