/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.ListExprSignal;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>List Expr Signal</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ListExprSignalImpl#getExprSignal <em>Expr Signal</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ListExprSignalImpl extends SignalElementImpl implements ListExprSignal {
	/**
	 * The cached value of the '{@link #getExprSignal() <em>Expr Signal</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprSignal()
	 * @generated
	 * @ordered
	 */
	protected EList<ExprSignal> exprSignal;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListExprSignalImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getListExprSignal();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ExprSignal> getExprSignal() {
		if (exprSignal == null) {
			exprSignal = new EObjectContainmentEList<ExprSignal>(ExprSignal.class, this, SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL);
		}
		return exprSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL:
				return ((InternalEList<?>)getExprSignal()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL:
				return getExprSignal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL:
				getExprSignal().clear();
				getExprSignal().addAll((Collection<? extends ExprSignal>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL:
				getExprSignal().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.LIST_EXPR_SIGNAL__EXPR_SIGNAL:
				return exprSignal != null && !exprSignal.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long listESig = API.getNilTree();
		if (getExprSignal() != null && !getExprSignal().isEmpty()) 
		{
			listESig = API.makeEmptyList(SignalOperators.oplesign);
			for (ExprSignal esig : getExprSignal())
			{
				long esigAst = esig.makeAST();
				if (esigAst != PKTrees.ERROR_NODE)  listESig = API.post(listESig, esigAst);
			}
		}
		if (listESig != PKTrees.ERROR_NODE) result = listESig;
		setASTAttribute(this, result);
		return result;
	}

} //ListExprSignalImpl
