/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.Masking;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Masking</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.MaskingImpl#getExprProcess <em>Expr Process</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.MaskingImpl#getListIdentifier <em>List Identifier</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MaskingImpl extends SignalElementImpl implements Masking {
	/**
	 * The cached value of the '{@link #getExprProcess() <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprProcess()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess exprProcess;

	/**
	 * The cached value of the '{@link #getListIdentifier() <em>List Identifier</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListIdentifier()
	 * @generated
	 * @ordered
	 */
	protected EList<Identifier> listIdentifier;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MaskingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getMasking();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getExprProcess() {
		return exprProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprProcess(ExprProcess newExprProcess, NotificationChain msgs) {
		ExprProcess oldExprProcess = exprProcess;
		exprProcess = newExprProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.MASKING__EXPR_PROCESS, oldExprProcess, newExprProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprProcess(ExprProcess newExprProcess) {
		if (newExprProcess != exprProcess) {
			NotificationChain msgs = null;
			if (exprProcess != null)
				msgs = ((InternalEObject)exprProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MASKING__EXPR_PROCESS, null, msgs);
			if (newExprProcess != null)
				msgs = ((InternalEObject)newExprProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.MASKING__EXPR_PROCESS, null, msgs);
			msgs = basicSetExprProcess(newExprProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.MASKING__EXPR_PROCESS, newExprProcess, newExprProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Identifier> getListIdentifier() {
		if (listIdentifier == null) {
			listIdentifier = new EObjectContainmentEList<Identifier>(Identifier.class, this, SsmePackage.MASKING__LIST_IDENTIFIER);
		}
		return listIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.MASKING__EXPR_PROCESS:
				return basicSetExprProcess(null, msgs);
			case SsmePackage.MASKING__LIST_IDENTIFIER:
				return ((InternalEList<?>)getListIdentifier()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.MASKING__EXPR_PROCESS:
				return getExprProcess();
			case SsmePackage.MASKING__LIST_IDENTIFIER:
				return getListIdentifier();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.MASKING__EXPR_PROCESS:
				setExprProcess((ExprProcess)newValue);
				return;
			case SsmePackage.MASKING__LIST_IDENTIFIER:
				getListIdentifier().clear();
				getListIdentifier().addAll((Collection<? extends Identifier>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.MASKING__EXPR_PROCESS:
				setExprProcess((ExprProcess)null);
				return;
			case SsmePackage.MASKING__LIST_IDENTIFIER:
				getListIdentifier().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.MASKING__EXPR_PROCESS:
				return exprProcess != null;
			case SsmePackage.MASKING__LIST_IDENTIFIER:
				return listIdentifier != null && !listIdentifier.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long termProcNode= API.getNilTree();
		if (getExprProcess() != null) {
			termProcNode = getExprProcess().makeAST();
		}
		long identNode = API.getNilTree();
		if (getListIdentifier() != null && !(getListIdentifier().isEmpty())) {
			identNode = API.makeEmptyList(SignalOperators.oplident);
			for (Identifier ident : getListIdentifier()) {
				long node = ident.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					identNode = API.post(identNode, node);
				}
			}
		}
		if (termProcNode != PKTrees.ERROR_NODE && identNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opobli, termProcNode, identNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //MaskingImpl
