/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.Description;
import org.eclipse.pop.ssme.InterfaceDefinition;
import org.eclipse.pop.ssme.OperatorIdentifier;
import org.eclipse.pop.ssme.OperatorModel;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Operator Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.OperatorModelImpl#getOperatorIdentifier <em>Operator Identifier</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.OperatorModelImpl#getInterfaceDefinition <em>Interface Definition</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.OperatorModelImpl#getDescription <em>Description</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OperatorModelImpl extends SignalElementImpl implements OperatorModel {
	/**
	 * The cached value of the '{@link #getOperatorIdentifier() <em>Operator Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperatorIdentifier()
	 * @generated
	 * @ordered
	 */
	protected OperatorIdentifier operatorIdentifier;

	/**
	 * The cached value of the '{@link #getInterfaceDefinition() <em>Interface Definition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceDefinition()
	 * @generated
	 * @ordered
	 */
	protected InterfaceDefinition interfaceDefinition;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected Description description;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getOperatorModel();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorIdentifier getOperatorIdentifier() {
		return operatorIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperatorIdentifier(OperatorIdentifier newOperatorIdentifier, NotificationChain msgs) {
		OperatorIdentifier oldOperatorIdentifier = operatorIdentifier;
		operatorIdentifier = newOperatorIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER, oldOperatorIdentifier, newOperatorIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperatorIdentifier(OperatorIdentifier newOperatorIdentifier) {
		if (newOperatorIdentifier != operatorIdentifier) {
			NotificationChain msgs = null;
			if (operatorIdentifier != null)
				msgs = ((InternalEObject)operatorIdentifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER, null, msgs);
			if (newOperatorIdentifier != null)
				msgs = ((InternalEObject)newOperatorIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER, null, msgs);
			msgs = basicSetOperatorIdentifier(newOperatorIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER, newOperatorIdentifier, newOperatorIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InterfaceDefinition getInterfaceDefinition() {
		return interfaceDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInterfaceDefinition(InterfaceDefinition newInterfaceDefinition, NotificationChain msgs) {
		InterfaceDefinition oldInterfaceDefinition = interfaceDefinition;
		interfaceDefinition = newInterfaceDefinition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION, oldInterfaceDefinition, newInterfaceDefinition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceDefinition(InterfaceDefinition newInterfaceDefinition) {
		if (newInterfaceDefinition != interfaceDefinition) {
			NotificationChain msgs = null;
			if (interfaceDefinition != null)
				msgs = ((InternalEObject)interfaceDefinition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION, null, msgs);
			if (newInterfaceDefinition != null)
				msgs = ((InternalEObject)newInterfaceDefinition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION, null, msgs);
			msgs = basicSetInterfaceDefinition(newInterfaceDefinition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION, newInterfaceDefinition, newInterfaceDefinition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Description getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDescription(Description newDescription, NotificationChain msgs) {
		Description oldDescription = description;
		description = newDescription;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__DESCRIPTION, oldDescription, newDescription);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(Description newDescription) {
		if (newDescription != description) {
			NotificationChain msgs = null;
			if (description != null)
				msgs = ((InternalEObject)description).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__DESCRIPTION, null, msgs);
			if (newDescription != null)
				msgs = ((InternalEObject)newDescription).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.OPERATOR_MODEL__DESCRIPTION, null, msgs);
			msgs = basicSetDescription(newDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.OPERATOR_MODEL__DESCRIPTION, newDescription, newDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER:
				return basicSetOperatorIdentifier(null, msgs);
			case SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION:
				return basicSetInterfaceDefinition(null, msgs);
			case SsmePackage.OPERATOR_MODEL__DESCRIPTION:
				return basicSetDescription(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER:
				return getOperatorIdentifier();
			case SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION:
				return getInterfaceDefinition();
			case SsmePackage.OPERATOR_MODEL__DESCRIPTION:
				return getDescription();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER:
				setOperatorIdentifier((OperatorIdentifier)newValue);
				return;
			case SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)newValue);
				return;
			case SsmePackage.OPERATOR_MODEL__DESCRIPTION:
				setDescription((Description)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER:
				setOperatorIdentifier((OperatorIdentifier)null);
				return;
			case SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION:
				setInterfaceDefinition((InterfaceDefinition)null);
				return;
			case SsmePackage.OPERATOR_MODEL__DESCRIPTION:
				setDescription((Description)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.OPERATOR_MODEL__OPERATOR_IDENTIFIER:
				return operatorIdentifier != null;
			case SsmePackage.OPERATOR_MODEL__INTERFACE_DEFINITION:
				return interfaceDefinition != null;
			case SsmePackage.OPERATOR_MODEL__DESCRIPTION:
				return description != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long operatorNode = API.getNilTree();
		long interfaceNode = API.getNilTree();
		long descriptionNode = API.getNilTree();
		
		if (getOperatorIdentifier() != null) {
			operatorNode = getOperatorIdentifier().makeAST();
		}
		if (getInterfaceDefinition() != null) {
			interfaceNode = getInterfaceDefinition().makeAST();
		}
		if (getDescription() != null) {
			descriptionNode = getDescription().makeAST();
		}
		
		if (operatorNode != PKTrees.ERROR_NODE
				&& interfaceNode != PKTrees.ERROR_NODE
				&& descriptionNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.opoper, operatorNode, interfaceNode, descriptionNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //OperatorModelImpl
