/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.ProcessAttribute;
import org.eclipse.pop.ssme.ProcessAttributeKind;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessAttributeImpl#getProcessAttributeKind <em>Process Attribute Kind</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProcessAttributeImpl extends SignalElementImpl implements ProcessAttribute {
	/**
	 * The default value of the '{@link #getProcessAttributeKind() <em>Process Attribute Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessAttributeKind()
	 * @generated
	 * @ordered
	 */
	protected static final ProcessAttributeKind PROCESS_ATTRIBUTE_KIND_EDEFAULT = ProcessAttributeKind.SAFE_LITERAL;

	/**
	 * The cached value of the '{@link #getProcessAttributeKind() <em>Process Attribute Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessAttributeKind()
	 * @generated
	 * @ordered
	 */
	protected ProcessAttributeKind processAttributeKind = PROCESS_ATTRIBUTE_KIND_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessAttribute();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessAttributeKind getProcessAttributeKind() {
		return processAttributeKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessAttributeKind(ProcessAttributeKind newProcessAttributeKind) {
		ProcessAttributeKind oldProcessAttributeKind = processAttributeKind;
		processAttributeKind = newProcessAttributeKind == null ? PROCESS_ATTRIBUTE_KIND_EDEFAULT : newProcessAttributeKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND, oldProcessAttributeKind, processAttributeKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND:
				return getProcessAttributeKind();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND:
				setProcessAttributeKind((ProcessAttributeKind)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND:
				setProcessAttributeKind(PROCESS_ATTRIBUTE_KIND_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND:
				return processAttributeKind != PROCESS_ATTRIBUTE_KIND_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (processAttributeKind: ");
		result.append(processAttributeKind);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = API.getNilTree();
		if (getProcessAttributeKind().equals(ProcessAttributeKind.DETERMINISTIC_LITERAL)) {
			result = API.makeNullary(SignalOperators.opdeterm);
		}
		else if (getProcessAttributeKind().equals(ProcessAttributeKind.UNSAFE_LITERAL)) {
			result = API.makeNullary(SignalOperators.opunsafe);
		}
		else if (getProcessAttributeKind().equals(ProcessAttributeKind.SAFE_LITERAL)) {
			result = API.makeNullary(SignalOperators.opsafe);
		}
		setASTAttribute(this, result);
		return result;
	}
	
} //ProcessAttributeImpl
