/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.ExternalGraph;
import org.eclipse.pop.ssme.IOProfile;
import org.eclipse.pop.ssme.ProcessModelInterface;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.TypesOrSignalsDeclaration;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Process Model Interface</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelInterfaceImpl#getListFormalParameter <em>List Formal Parameter</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelInterfaceImpl#getIoProfile <em>Io Profile</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.ProcessModelInterfaceImpl#getExternalGraph <em>External Graph</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProcessModelInterfaceImpl extends SignalElementImpl implements ProcessModelInterface {
	/**
	 * The cached value of the '{@link #getListFormalParameter() <em>List Formal Parameter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListFormalParameter()
	 * @generated
	 * @ordered
	 */
	protected EList<TypesOrSignalsDeclaration> listFormalParameter;

	/**
	 * The cached value of the '{@link #getIoProfile() <em>Io Profile</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIoProfile()
	 * @generated
	 * @ordered
	 */
	protected IOProfile ioProfile;

	/**
	 * The cached value of the '{@link #getExternalGraph() <em>External Graph</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExternalGraph()
	 * @generated
	 * @ordered
	 */
	protected ExternalGraph externalGraph;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessModelInterfaceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getProcessModelInterface();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypesOrSignalsDeclaration> getListFormalParameter() {
		if (listFormalParameter == null) {
			listFormalParameter = new EObjectContainmentEList<TypesOrSignalsDeclaration>(TypesOrSignalsDeclaration.class, this, SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER);
		}
		return listFormalParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IOProfile getIoProfile() {
		return ioProfile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIoProfile(IOProfile newIoProfile, NotificationChain msgs) {
		IOProfile oldIoProfile = ioProfile;
		ioProfile = newIoProfile;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE, oldIoProfile, newIoProfile);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIoProfile(IOProfile newIoProfile) {
		if (newIoProfile != ioProfile) {
			NotificationChain msgs = null;
			if (ioProfile != null)
				msgs = ((InternalEObject)ioProfile).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE, null, msgs);
			if (newIoProfile != null)
				msgs = ((InternalEObject)newIoProfile).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE, null, msgs);
			msgs = basicSetIoProfile(newIoProfile, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE, newIoProfile, newIoProfile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalGraph getExternalGraph() {
		return externalGraph;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExternalGraph(ExternalGraph newExternalGraph, NotificationChain msgs) {
		ExternalGraph oldExternalGraph = externalGraph;
		externalGraph = newExternalGraph;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH, oldExternalGraph, newExternalGraph);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExternalGraph(ExternalGraph newExternalGraph) {
		if (newExternalGraph != externalGraph) {
			NotificationChain msgs = null;
			if (externalGraph != null)
				msgs = ((InternalEObject)externalGraph).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH, null, msgs);
			if (newExternalGraph != null)
				msgs = ((InternalEObject)newExternalGraph).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH, null, msgs);
			msgs = basicSetExternalGraph(newExternalGraph, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH, newExternalGraph, newExternalGraph));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER:
				return ((InternalEList<?>)getListFormalParameter()).basicRemove(otherEnd, msgs);
			case SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE:
				return basicSetIoProfile(null, msgs);
			case SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH:
				return basicSetExternalGraph(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER:
				return getListFormalParameter();
			case SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE:
				return getIoProfile();
			case SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH:
				return getExternalGraph();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER:
				getListFormalParameter().clear();
				getListFormalParameter().addAll((Collection<? extends TypesOrSignalsDeclaration>)newValue);
				return;
			case SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE:
				setIoProfile((IOProfile)newValue);
				return;
			case SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH:
				setExternalGraph((ExternalGraph)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER:
				getListFormalParameter().clear();
				return;
			case SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE:
				setIoProfile((IOProfile)null);
				return;
			case SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH:
				setExternalGraph((ExternalGraph)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER:
				return listFormalParameter != null && !listFormalParameter.isEmpty();
			case SsmePackage.PROCESS_MODEL_INTERFACE__IO_PROFILE:
				return ioProfile != null;
			case SsmePackage.PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH:
				return externalGraph != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long paramNode = API.getNilTree();
		if (getListFormalParameter() != null && !getListFormalParameter().isEmpty()) {
			paramNode = API.makeEmptyList(SignalOperators.opldecs);
			for (TypesOrSignalsDeclaration sp : getListFormalParameter()) {
				long node = sp.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					paramNode = API.post(paramNode, sp.makeAST());
				}
			}
		}
		
		long esNode = API.getNilTree();
		if (getIoProfile() != null) {
			esNode = getIoProfile().makeAST();
		}
		
		long grapheNode = API.getNilTree();
		if (getExternalGraph() != null) {
			grapheNode = getExternalGraph().makeAST();
		}
		
		if (paramNode != PKTrees.ERROR_NODE && esNode != PKTrees.ERROR_NODE && grapheNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.opinte, paramNode, esNode, grapheNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //ProcessModelInterfaceImpl
