/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Declaration;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.RestrictionProcess;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Restriction Process</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.RestrictionProcessImpl#getExprProcess <em>Expr Process</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.RestrictionProcessImpl#getListDeclarations <em>List Declarations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RestrictionProcessImpl extends SignalElementImpl implements RestrictionProcess {
	/**
	 * The cached value of the '{@link #getExprProcess() <em>Expr Process</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExprProcess()
	 * @generated
	 * @ordered
	 */
	protected ExprProcess exprProcess;

	/**
	 * The cached value of the '{@link #getListDeclarations() <em>List Declarations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListDeclarations()
	 * @generated
	 * @ordered
	 */
	protected EList<Declaration> listDeclarations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RestrictionProcessImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getRestrictionProcess();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExprProcess getExprProcess() {
		return exprProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExprProcess(ExprProcess newExprProcess, NotificationChain msgs) {
		ExprProcess oldExprProcess = exprProcess;
		exprProcess = newExprProcess;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS, oldExprProcess, newExprProcess);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExprProcess(ExprProcess newExprProcess) {
		if (newExprProcess != exprProcess) {
			NotificationChain msgs = null;
			if (exprProcess != null)
				msgs = ((InternalEObject)exprProcess).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS, null, msgs);
			if (newExprProcess != null)
				msgs = ((InternalEObject)newExprProcess).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS, null, msgs);
			msgs = basicSetExprProcess(newExprProcess, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS, newExprProcess, newExprProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Declaration> getListDeclarations() {
		if (listDeclarations == null) {
			listDeclarations = new EObjectContainmentEList<Declaration>(Declaration.class, this, SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS);
		}
		return listDeclarations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
				return basicSetExprProcess(null, msgs);
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				return ((InternalEList<?>)getListDeclarations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
				return getExprProcess();
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				return getListDeclarations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)newValue);
				return;
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				getListDeclarations().clear();
				getListDeclarations().addAll((Collection<? extends Declaration>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
				setExprProcess((ExprProcess)null);
				return;
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				getListDeclarations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.RESTRICTION_PROCESS__EXPR_PROCESS:
				return exprProcess != null;
			case SsmePackage.RESTRICTION_PROCESS__LIST_DECLARATIONS:
				return listDeclarations != null && !listDeclarations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long primaireProcNode = API.getNilTree();
		if (getExprProcess() != null) {
			primaireProcNode = getExprProcess().makeAST();
		}
		
		long declNode = API.getNilTree();
		if (getListDeclarations() != null && !getListDeclarations().isEmpty()) {
			declNode = API.makeEmptyList(SignalOperators.opldecl);
			for (Declaration decl : getListDeclarations()) {
				long node = decl.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					declNode = API.post(declNode, node);
				}
			}
		}
		
		if (primaireProcNode != PKTrees.ERROR_NODE && declNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.oppconf, primaireProcNode, declNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //RestrictionProcessImpl
