/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.SharedVariablesDeclaration;
import org.eclipse.pop.ssme.SignalNaming;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.Type;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shared Variables Declaration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.SharedVariablesDeclarationImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.SharedVariablesDeclarationImpl#getListSignal <em>List Signal</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SharedVariablesDeclarationImpl extends SignalElementImpl implements SharedVariablesDeclaration {
	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected Type type;

	/**
	 * The cached value of the '{@link #getListSignal() <em>List Signal</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getListSignal()
	 * @generated
	 * @ordered
	 */
	protected EList<SignalNaming> listSignal;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SharedVariablesDeclarationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getSharedVariablesDeclaration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Type getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetType(Type newType, NotificationChain msgs) {
		Type oldType = type;
		type = newType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE, oldType, newType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(Type newType) {
		if (newType != type) {
			NotificationChain msgs = null;
			if (type != null)
				msgs = ((InternalEObject)type).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE, null, msgs);
			if (newType != null)
				msgs = ((InternalEObject)newType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE, null, msgs);
			msgs = basicSetType(newType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE, newType, newType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SignalNaming> getListSignal() {
		if (listSignal == null) {
			listSignal = new EObjectContainmentEList<SignalNaming>(SignalNaming.class, this, SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL);
		}
		return listSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE:
				return basicSetType(null, msgs);
			case SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL:
				return ((InternalEList<?>)getListSignal()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE:
				return getType();
			case SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL:
				return getListSignal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE:
				setType((Type)newValue);
				return;
			case SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL:
				getListSignal().clear();
				getListSignal().addAll((Collection<? extends SignalNaming>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE:
				setType((Type)null);
				return;
			case SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL:
				getListSignal().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.SHARED_VARIABLES_DECLARATION__TYPE:
				return type != null;
			case SsmePackage.SHARED_VARIABLES_DECLARATION__LIST_SIGNAL:
				return listSignal != null && !listSignal.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long typeNode = API.getNilTree();
		if (getType() != null) {
			typeNode = getType().makeAST();
		}
		else {
			typeNode = API.makeNullary(SignalOperators.opimplicit);
		}
		
		long signalsNode = API.getNilTree();
		if (getListSignal() != null && !getListSignal().isEmpty()) {
			signalsNode = API.makeEmptyList(SignalOperators.oplsign);
			for (SignalNaming sig : getListSignal()) {
				long node = sig.makeAST();
				if (node != PKTrees.ERROR_NODE) {
					signalsNode = API.post(signalsNode, node);
				}
			}
		}
		
		if (typeNode != PKTrees.ERROR_NODE && signalsNode != PKTrees.ERROR_NODE) {
			result = API.makeBinary(SignalOperators.opdecpar, typeNode, signalsNode);
		}
		setASTAttribute(this, result);
		return result;
	}

} //SharedVariablesDeclarationImpl
