/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;


import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.pop.ssme.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SsmeFactoryImpl extends EFactoryImpl implements SsmeFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SsmeFactory init() {
		try {
			SsmeFactory theSsmeFactory = (SsmeFactory)EPackage.Registry.INSTANCE.getEFactory(SsmePackage.eNS_URI);
			if (theSsmeFactory != null) {
				return theSsmeFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new SsmeFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmeFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case SsmePackage.AFTER: return createAfter();
			case SsmePackage.AND: return createAnd();
			case SsmePackage.ARRAY_ELEM: return createArrayElem();
			case SsmePackage.ARRAY_ELEMENTS_ENUMERATION: return createArrayElementsEnumeration();
			case SsmePackage.ARRAY_INDEX: return createArrayIndex();
			case SsmePackage.ARRAY_PROCESS: return createArrayProcess();
			case SsmePackage.ARRAY_PRODUCT: return createArrayProduct();
			case SsmePackage.ARRAY_RESTRUCTURATION: return createArrayRestructuration();
			case SsmePackage.ARRAY_TYPE: return createArrayType();
			case SsmePackage.ASSERT_PROCESS: return createAssertProcess();
			case SsmePackage.ASSERT_SIGNAL: return createAssertSignal();
			case SsmePackage.BOUNDS: return createBounds();
			case SsmePackage.CARTESIAN_PRODUCT: return createCartesianProduct();
			case SsmePackage.CASE_ENUMERATION: return createCaseEnumeration();
			case SsmePackage.CASE_INTERVAL: return createCaseInterval();
			case SsmePackage.CASE_PROCESS: return createCaseProcess();
			case SsmePackage.CASE_BRANCH: return createCaseBranch();
			case SsmePackage.CELL: return createCell();
			case SsmePackage.CLOCK: return createClock();
			case SsmePackage.CLOCK_DIFFERENCE: return createClockDifference();
			case SsmePackage.CLOCK_EQUALITY: return createClockEquality();
			case SsmePackage.CLOCK_EXCLUSIVE_RELATION: return createClockExclusiveRelation();
			case SsmePackage.CLOCK_INF_RELATION: return createClockInfRelation();
			case SsmePackage.CLOCK_PRODUCT: return createClockProduct();
			case SsmePackage.CLOCK_SUP_RELATION: return createClockSupRelation();
			case SsmePackage.CLOCK_UNION: return createClockUnion();
			case SsmePackage.COMMENT: return createComment();
			case SsmePackage.COMPLEX_CONSTRUCTOR: return createComplexConstructor();
			case SsmePackage.COMPOSITION: return createComposition();
			case SsmePackage.CONCATENATION: return createConcatenation();
			case SsmePackage.CONDITIONED_DEPENDENCE: return createConditionedDependence();
			case SsmePackage.CONSTANT_CHARACTER: return createConstantCharacter();
			case SsmePackage.CONSTANT_DESCRIPTION: return createConstantDescription();
			case SsmePackage.CONSTANT_DOUBLE_REAL: return createConstantDoubleReal();
			case SsmePackage.CONSTANT_ENUM: return createConstantEnum();
			case SsmePackage.CONSTANT_INTEGER: return createConstantInteger();
			case SsmePackage.CONSTANT_LOGICAL: return createConstantLogical();
			case SsmePackage.CONSTANT_REAL: return createConstantReal();
			case SsmePackage.CONSTANTS_DECLARATION: return createConstantsDeclaration();
			case SsmePackage.CONSTANT_STRING: return createConstantString();
			case SsmePackage.CONVERSION: return createConversion();
			case SsmePackage.COUNT: return createCount();
			case SsmePackage.DEFAULT: return createDefault();
			case SsmePackage.DELAY: return createDelay();
			case SsmePackage.DESCRIPTION: return createDescription();
			case SsmePackage.DIV: return createDiv();
			case SsmePackage.ELEM_DEFINITION: return createElemDefinition();
			case SsmePackage.ELEM_DEFINITION_ENUMERATION: return createElemDefinitionEnumeration();
			case SsmePackage.ENUMERATION_TYPE: return createEnumerationType();
			case SsmePackage.EQUAL: return createEqual();
			case SsmePackage.EQUAL_EQUAL: return createEqualEqual();
			case SsmePackage.EXTERNAL_ATTRIBUTE: return createExternalAttribute();
			case SsmePackage.EXTERNAL_GRAPH: return createExternalGraph();
			case SsmePackage.EXTERNAL_REFERENCES: return createExternalReferences();
			case SsmePackage.FIELD_ACCESS: return createFieldAccess();
			case SsmePackage.FORMAL_PROCESS: return createFormalProcess();
			case SsmePackage.FROM: return createFrom();
			case SsmePackage.GRAPH_SPECIFICATION: return createGraphSpecification();
			case SsmePackage.GREATER: return createGreater();
			case SsmePackage.GREATER_OR_EQUAL: return createGreaterOrEqual();
			case SsmePackage.IDENTIFIER: return createIdentifier();
			case SsmePackage.IDENTITY_EQUATION: return createIdentityEquation();
			case SsmePackage.IF_THEN_ELSE: return createIfThenElse();
			case SsmePackage.INDEX: return createIndex();
			case SsmePackage.IO_PROFILE: return createIOProfile();
			case SsmePackage.ITERATION: return createIteration();
			case SsmePackage.ITERATION_PROCESS: return createIterationProcess();
			case SsmePackage.LABELLED_PROCESS: return createLabelledProcess();
			case SsmePackage.LABELS: return createLabels();
			case SsmePackage.LESS: return createLess();
			case SsmePackage.LESS_LESS_EQUAL: return createLessLessEqual();
			case SsmePackage.LESS_OR_EQUAL: return createLessOrEqual();
			case SsmePackage.LIST_EXPR_SIGNAL: return createListExprSignal();
			case SsmePackage.LIST_FLOWS: return createListFlows();
			case SsmePackage.LIST_MODULE: return createListModule();
			case SsmePackage.MASKING: return createMasking();
			case SsmePackage.MINUS: return createMinus();
			case SsmePackage.MODULE: return createModule();
			case SsmePackage.MODULE_DESCRIPTION: return createModuleDescription();
			case SsmePackage.MODULES_IMPORT: return createModulesImport();
			case SsmePackage.MODULO: return createModulo();
			case SsmePackage.NOT: return createNot();
			case SsmePackage.NOT_EQUAL: return createNotEqual();
			case SsmePackage.NULL_CLOCK: return createNullClock();
			case SsmePackage.NULL_PROC: return createNullProc();
			case SsmePackage.OPERATOR: return createOperator();
			case SsmePackage.OPERATOR_MODEL: return createOperatorModel();
			case SsmePackage.OR: return createOr();
			case SsmePackage.PARTIAL_ITERATION: return createPartialIteration();
			case SsmePackage.PLUS: return createPlus();
			case SsmePackage.POWER: return createPower();
			case SsmePackage.PRAGMA: return createPragma();
			case SsmePackage.PREDEFINED_TYPE: return createPredefinedType();
			case SsmePackage.PREVIOUS_ITERATION_REF: return createPreviousIterationRef();
			case SsmePackage.PROCESS_ATTRIBUTE: return createProcessAttribute();
			case SsmePackage.PROCESS_CALL: return createProcessCall();
			case SsmePackage.PROCESS_EXPANSION: return createProcessExpansion();
			case SsmePackage.PROCESS_MODEL: return createProcessModel();
			case SsmePackage.PROCESS_MODEL_INTERFACE: return createProcessModelInterface();
			case SsmePackage.PROCESS_TYPE: return createProcessType();
			case SsmePackage.PRODUCT: return createProduct();
			case SsmePackage.RECOVER: return createRecover();
			case SsmePackage.REPETITION: return createRepetition();
			case SsmePackage.RESTRICTION_PROCESS: return createRestrictionProcess();
			case SsmePackage.SEQUENTIAL_DEFINITION: return createSequentialDefinition();
			case SsmePackage.SHARED_VARIABLES_DECLARATION: return createSharedVariablesDeclaration();
			case SsmePackage.SIGNAL_ELEMENT: return createSignalElement();
			case SsmePackage.SIGNAL_NAMING: return createSignalNaming();
			case SsmePackage.SIGNALS: return createSignals();
			case SsmePackage.SIGNALS_DECLARATION: return createSignalsDeclaration();
			case SsmePackage.SIGNALS_DEFINITION: return createSignalsDefinition();
			case SsmePackage.SIGNALS_PARTIAL_DEFAULT_DEFINITION: return createSignalsPartialDefaultDefinition();
			case SsmePackage.SIGNALS_PARTIAL_DEFINITION: return createSignalsPartialDefinition();
			case SsmePackage.STATE_VARIABLES_DECLARATION: return createStateVariablesDeclaration();
			case SsmePackage.STATE_VARIABLE_VALUE: return createStateVariableValue();
			case SsmePackage.STRING_VALUE: return createStringValue();
			case SsmePackage.TRANSPOSITION: return createTransposition();
			case SsmePackage.TUPLE_TYPE: return createTupleType();
			case SsmePackage.TYPE_DESCRIPTION: return createTypeDescription();
			case SsmePackage.TYPE_MORPHISM: return createTypeMorphism();
			case SsmePackage.TYPES_DECLARATION: return createTypesDeclaration();
			case SsmePackage.UNARY_MINUS: return createUnaryMinus();
			case SsmePackage.UNARY_PLUS: return createUnaryPlus();
			case SsmePackage.UNARY_WHEN: return createUnaryWhen();
			case SsmePackage.UNCONDITIONED_DEPENDENCES: return createUnconditionedDependences();
			case SsmePackage.VAR: return createVar();
			case SsmePackage.WHEN: return createWhen();
			case SsmePackage.WINDOW: return createWindow();
			case SsmePackage.XOR: return createXor();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case SsmePackage.CONSTANT_LOGICAL_KIND:
				return createConstantLogicalKindFromString(eDataType, initialValue);
			case SsmePackage.INTERVALS_KIND:
				return createIntervalsKindFromString(eDataType, initialValue);
			case SsmePackage.MODEL_KIND:
				return createModelKindFromString(eDataType, initialValue);
			case SsmePackage.OPERATOR_KIND:
				return createOperatorKindFromString(eDataType, initialValue);
			case SsmePackage.PROCESS_ATTRIBUTE_KIND:
				return createProcessAttributeKindFromString(eDataType, initialValue);
			case SsmePackage.SIGNAL_INTRINSIC_TYPE:
				return createSignalIntrinsicTypeFromString(eDataType, initialValue);
			case SsmePackage.TYPE_KIND:
				return createTypeKindFromString(eDataType, initialValue);
			case SsmePackage.VISIBILITY_KIND:
				return createVisibilityKindFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case SsmePackage.CONSTANT_LOGICAL_KIND:
				return convertConstantLogicalKindToString(eDataType, instanceValue);
			case SsmePackage.INTERVALS_KIND:
				return convertIntervalsKindToString(eDataType, instanceValue);
			case SsmePackage.MODEL_KIND:
				return convertModelKindToString(eDataType, instanceValue);
			case SsmePackage.OPERATOR_KIND:
				return convertOperatorKindToString(eDataType, instanceValue);
			case SsmePackage.PROCESS_ATTRIBUTE_KIND:
				return convertProcessAttributeKindToString(eDataType, instanceValue);
			case SsmePackage.SIGNAL_INTRINSIC_TYPE:
				return convertSignalIntrinsicTypeToString(eDataType, instanceValue);
			case SsmePackage.TYPE_KIND:
				return convertTypeKindToString(eDataType, instanceValue);
			case SsmePackage.VISIBILITY_KIND:
				return convertVisibilityKindToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public After createAfter() {
		AfterImpl after = new AfterImpl();
		return after;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public And createAnd() {
		AndImpl and = new AndImpl();
		return and;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayElem createArrayElem() {
		ArrayElemImpl arrayElem = new ArrayElemImpl();
		return arrayElem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayElementsEnumeration createArrayElementsEnumeration() {
		ArrayElementsEnumerationImpl arrayElementsEnumeration = new ArrayElementsEnumerationImpl();
		return arrayElementsEnumeration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayIndex createArrayIndex() {
		ArrayIndexImpl arrayIndex = new ArrayIndexImpl();
		return arrayIndex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayProcess createArrayProcess() {
		ArrayProcessImpl arrayProcess = new ArrayProcessImpl();
		return arrayProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayProduct createArrayProduct() {
		ArrayProductImpl arrayProduct = new ArrayProductImpl();
		return arrayProduct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayRestructuration createArrayRestructuration() {
		ArrayRestructurationImpl arrayRestructuration = new ArrayRestructurationImpl();
		return arrayRestructuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArrayType createArrayType() {
		ArrayTypeImpl arrayType = new ArrayTypeImpl();
		return arrayType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssertProcess createAssertProcess() {
		AssertProcessImpl assertProcess = new AssertProcessImpl();
		return assertProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssertSignal createAssertSignal() {
		AssertSignalImpl assertSignal = new AssertSignalImpl();
		return assertSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Bounds createBounds() {
		BoundsImpl bounds = new BoundsImpl();
		return bounds;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CartesianProduct createCartesianProduct() {
		CartesianProductImpl cartesianProduct = new CartesianProductImpl();
		return cartesianProduct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseEnumeration createCaseEnumeration() {
		CaseEnumerationImpl caseEnumeration = new CaseEnumerationImpl();
		return caseEnumeration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseInterval createCaseInterval() {
		CaseIntervalImpl caseInterval = new CaseIntervalImpl();
		return caseInterval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseProcess createCaseProcess() {
		CaseProcessImpl caseProcess = new CaseProcessImpl();
		return caseProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CaseBranch createCaseBranch() {
		CaseBranchImpl caseBranch = new CaseBranchImpl();
		return caseBranch;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Cell createCell() {
		CellImpl cell = new CellImpl();
		return cell;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Clock createClock() {
		ClockImpl clock = new ClockImpl();
		return clock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockDifference createClockDifference() {
		ClockDifferenceImpl clockDifference = new ClockDifferenceImpl();
		return clockDifference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockEquality createClockEquality() {
		ClockEqualityImpl clockEquality = new ClockEqualityImpl();
		return clockEquality;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockExclusiveRelation createClockExclusiveRelation() {
		ClockExclusiveRelationImpl clockExclusiveRelation = new ClockExclusiveRelationImpl();
		return clockExclusiveRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockInfRelation createClockInfRelation() {
		ClockInfRelationImpl clockInfRelation = new ClockInfRelationImpl();
		return clockInfRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockProduct createClockProduct() {
		ClockProductImpl clockProduct = new ClockProductImpl();
		return clockProduct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockSupRelation createClockSupRelation() {
		ClockSupRelationImpl clockSupRelation = new ClockSupRelationImpl();
		return clockSupRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClockUnion createClockUnion() {
		ClockUnionImpl clockUnion = new ClockUnionImpl();
		return clockUnion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Comment createComment() {
		CommentImpl comment = new CommentImpl();
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComplexConstructor createComplexConstructor() {
		ComplexConstructorImpl complexConstructor = new ComplexConstructorImpl();
		return complexConstructor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Composition createComposition() {
		CompositionImpl composition = new CompositionImpl();
		return composition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Concatenation createConcatenation() {
		ConcatenationImpl concatenation = new ConcatenationImpl();
		return concatenation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConditionedDependence createConditionedDependence() {
		ConditionedDependenceImpl conditionedDependence = new ConditionedDependenceImpl();
		return conditionedDependence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantCharacter createConstantCharacter() {
		ConstantCharacterImpl constantCharacter = new ConstantCharacterImpl();
		return constantCharacter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantDescription createConstantDescription() {
		ConstantDescriptionImpl constantDescription = new ConstantDescriptionImpl();
		return constantDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantDoubleReal createConstantDoubleReal() {
		ConstantDoubleRealImpl constantDoubleReal = new ConstantDoubleRealImpl();
		return constantDoubleReal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantEnum createConstantEnum() {
		ConstantEnumImpl constantEnum = new ConstantEnumImpl();
		return constantEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantInteger createConstantInteger() {
		ConstantIntegerImpl constantInteger = new ConstantIntegerImpl();
		return constantInteger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantLogical createConstantLogical() {
		ConstantLogicalImpl constantLogical = new ConstantLogicalImpl();
		return constantLogical;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantReal createConstantReal() {
		ConstantRealImpl constantReal = new ConstantRealImpl();
		return constantReal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantsDeclaration createConstantsDeclaration() {
		ConstantsDeclarationImpl constantsDeclaration = new ConstantsDeclarationImpl();
		return constantsDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantString createConstantString() {
		ConstantStringImpl constantString = new ConstantStringImpl();
		return constantString;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Conversion createConversion() {
		ConversionImpl conversion = new ConversionImpl();
		return conversion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Count createCount() {
		CountImpl count = new CountImpl();
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Default createDefault() {
		DefaultImpl default_ = new DefaultImpl();
		return default_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Delay createDelay() {
		DelayImpl delay = new DelayImpl();
		return delay;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Description createDescription() {
		DescriptionImpl description = new DescriptionImpl();
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Div createDiv() {
		DivImpl div = new DivImpl();
		return div;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ElemDefinition createElemDefinition() {
		ElemDefinitionImpl elemDefinition = new ElemDefinitionImpl();
		return elemDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ElemDefinitionEnumeration createElemDefinitionEnumeration() {
		ElemDefinitionEnumerationImpl elemDefinitionEnumeration = new ElemDefinitionEnumerationImpl();
		return elemDefinitionEnumeration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationType createEnumerationType() {
		EnumerationTypeImpl enumerationType = new EnumerationTypeImpl();
		return enumerationType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Equal createEqual() {
		EqualImpl equal = new EqualImpl();
		return equal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EqualEqual createEqualEqual() {
		EqualEqualImpl equalEqual = new EqualEqualImpl();
		return equalEqual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalAttribute createExternalAttribute() {
		ExternalAttributeImpl externalAttribute = new ExternalAttributeImpl();
		return externalAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalGraph createExternalGraph() {
		ExternalGraphImpl externalGraph = new ExternalGraphImpl();
		return externalGraph;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExternalReferences createExternalReferences() {
		ExternalReferencesImpl externalReferences = new ExternalReferencesImpl();
		return externalReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FieldAccess createFieldAccess() {
		FieldAccessImpl fieldAccess = new FieldAccessImpl();
		return fieldAccess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FormalProcess createFormalProcess() {
		FormalProcessImpl formalProcess = new FormalProcessImpl();
		return formalProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public From createFrom() {
		FromImpl from = new FromImpl();
		return from;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GraphSpecification createGraphSpecification() {
		GraphSpecificationImpl graphSpecification = new GraphSpecificationImpl();
		return graphSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Greater createGreater() {
		GreaterImpl greater = new GreaterImpl();
		return greater;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GreaterOrEqual createGreaterOrEqual() {
		GreaterOrEqualImpl greaterOrEqual = new GreaterOrEqualImpl();
		return greaterOrEqual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Identifier createIdentifier() {
		IdentifierImpl identifier = new IdentifierImpl();
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdentityEquation createIdentityEquation() {
		IdentityEquationImpl identityEquation = new IdentityEquationImpl();
		return identityEquation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IfThenElse createIfThenElse() {
		IfThenElseImpl ifThenElse = new IfThenElseImpl();
		return ifThenElse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Index createIndex() {
		IndexImpl index = new IndexImpl();
		return index;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IOProfile createIOProfile() {
		IOProfileImpl ioProfile = new IOProfileImpl();
		return ioProfile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Iteration createIteration() {
		IterationImpl iteration = new IterationImpl();
		return iteration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IterationProcess createIterationProcess() {
		IterationProcessImpl iterationProcess = new IterationProcessImpl();
		return iterationProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LabelledProcess createLabelledProcess() {
		LabelledProcessImpl labelledProcess = new LabelledProcessImpl();
		return labelledProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Labels createLabels() {
		LabelsImpl labels = new LabelsImpl();
		return labels;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Less createLess() {
		LessImpl less = new LessImpl();
		return less;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LessLessEqual createLessLessEqual() {
		LessLessEqualImpl lessLessEqual = new LessLessEqualImpl();
		return lessLessEqual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LessOrEqual createLessOrEqual() {
		LessOrEqualImpl lessOrEqual = new LessOrEqualImpl();
		return lessOrEqual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListExprSignal createListExprSignal() {
		ListExprSignalImpl listExprSignal = new ListExprSignalImpl();
		return listExprSignal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListFlows createListFlows() {
		ListFlowsImpl listFlows = new ListFlowsImpl();
		return listFlows;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ListModule createListModule() {
		ListModuleImpl listModule = new ListModuleImpl();
		return listModule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Masking createMasking() {
		MaskingImpl masking = new MaskingImpl();
		return masking;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Minus createMinus() {
		MinusImpl minus = new MinusImpl();
		return minus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Module createModule() {
		ModuleImpl module = new ModuleImpl();
		return module;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModuleDescription createModuleDescription() {
		ModuleDescriptionImpl moduleDescription = new ModuleDescriptionImpl();
		return moduleDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModulesImport createModulesImport() {
		ModulesImportImpl modulesImport = new ModulesImportImpl();
		return modulesImport;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Modulo createModulo() {
		ModuloImpl modulo = new ModuloImpl();
		return modulo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Not createNot() {
		NotImpl not = new NotImpl();
		return not;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotEqual createNotEqual() {
		NotEqualImpl notEqual = new NotEqualImpl();
		return notEqual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NullClock createNullClock() {
		NullClockImpl nullClock = new NullClockImpl();
		return nullClock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NullProc createNullProc() {
		NullProcImpl nullProc = new NullProcImpl();
		return nullProc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operator createOperator() {
		OperatorImpl operator = new OperatorImpl();
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorModel createOperatorModel() {
		OperatorModelImpl operatorModel = new OperatorModelImpl();
		return operatorModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Or createOr() {
		OrImpl or = new OrImpl();
		return or;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PartialIteration createPartialIteration() {
		PartialIterationImpl partialIteration = new PartialIterationImpl();
		return partialIteration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Plus createPlus() {
		PlusImpl plus = new PlusImpl();
		return plus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Power createPower() {
		PowerImpl power = new PowerImpl();
		return power;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Pragma createPragma() {
		PragmaImpl pragma = new PragmaImpl();
		return pragma;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PredefinedType createPredefinedType() {
		PredefinedTypeImpl predefinedType = new PredefinedTypeImpl();
		return predefinedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PreviousIterationRef createPreviousIterationRef() {
		PreviousIterationRefImpl previousIterationRef = new PreviousIterationRefImpl();
		return previousIterationRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessAttribute createProcessAttribute() {
		ProcessAttributeImpl processAttribute = new ProcessAttributeImpl();
		return processAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessCall createProcessCall() {
		ProcessCallImpl processCall = new ProcessCallImpl();
		return processCall;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessExpansion createProcessExpansion() {
		ProcessExpansionImpl processExpansion = new ProcessExpansionImpl();
		return processExpansion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessModel createProcessModel() {
		ProcessModelImpl processModel = new ProcessModelImpl();
		return processModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessModelInterface createProcessModelInterface() {
		ProcessModelInterfaceImpl processModelInterface = new ProcessModelInterfaceImpl();
		return processModelInterface;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessType createProcessType() {
		ProcessTypeImpl processType = new ProcessTypeImpl();
		return processType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Product createProduct() {
		ProductImpl product = new ProductImpl();
		return product;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Recover createRecover() {
		RecoverImpl recover = new RecoverImpl();
		return recover;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Repetition createRepetition() {
		RepetitionImpl repetition = new RepetitionImpl();
		return repetition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RestrictionProcess createRestrictionProcess() {
		RestrictionProcessImpl restrictionProcess = new RestrictionProcessImpl();
		return restrictionProcess;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequentialDefinition createSequentialDefinition() {
		SequentialDefinitionImpl sequentialDefinition = new SequentialDefinitionImpl();
		return sequentialDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SharedVariablesDeclaration createSharedVariablesDeclaration() {
		SharedVariablesDeclarationImpl sharedVariablesDeclaration = new SharedVariablesDeclarationImpl();
		return sharedVariablesDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalElement createSignalElement() {
		SignalElementImpl signalElement = new SignalElementImpl();
		return signalElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalNaming createSignalNaming() {
		SignalNamingImpl signalNaming = new SignalNamingImpl();
		return signalNaming;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signals createSignals() {
		SignalsImpl signals = new SignalsImpl();
		return signals;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsDeclaration createSignalsDeclaration() {
		SignalsDeclarationImpl signalsDeclaration = new SignalsDeclarationImpl();
		return signalsDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsDefinition createSignalsDefinition() {
		SignalsDefinitionImpl signalsDefinition = new SignalsDefinitionImpl();
		return signalsDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsPartialDefaultDefinition createSignalsPartialDefaultDefinition() {
		SignalsPartialDefaultDefinitionImpl signalsPartialDefaultDefinition = new SignalsPartialDefaultDefinitionImpl();
		return signalsPartialDefaultDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalsPartialDefinition createSignalsPartialDefinition() {
		SignalsPartialDefinitionImpl signalsPartialDefinition = new SignalsPartialDefinitionImpl();
		return signalsPartialDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StateVariablesDeclaration createStateVariablesDeclaration() {
		StateVariablesDeclarationImpl stateVariablesDeclaration = new StateVariablesDeclarationImpl();
		return stateVariablesDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StateVariableValue createStateVariableValue() {
		StateVariableValueImpl stateVariableValue = new StateVariableValueImpl();
		return stateVariableValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringValue createStringValue() {
		StringValueImpl stringValue = new StringValueImpl();
		return stringValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Transposition createTransposition() {
		TranspositionImpl transposition = new TranspositionImpl();
		return transposition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TupleType createTupleType() {
		TupleTypeImpl tupleType = new TupleTypeImpl();
		return tupleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeDescription createTypeDescription() {
		TypeDescriptionImpl typeDescription = new TypeDescriptionImpl();
		return typeDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMorphism createTypeMorphism() {
		TypeMorphismImpl typeMorphism = new TypeMorphismImpl();
		return typeMorphism;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypesDeclaration createTypesDeclaration() {
		TypesDeclarationImpl typesDeclaration = new TypesDeclarationImpl();
		return typesDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryMinus createUnaryMinus() {
		UnaryMinusImpl unaryMinus = new UnaryMinusImpl();
		return unaryMinus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryPlus createUnaryPlus() {
		UnaryPlusImpl unaryPlus = new UnaryPlusImpl();
		return unaryPlus;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnaryWhen createUnaryWhen() {
		UnaryWhenImpl unaryWhen = new UnaryWhenImpl();
		return unaryWhen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnconditionedDependences createUnconditionedDependences() {
		UnconditionedDependencesImpl unconditionedDependences = new UnconditionedDependencesImpl();
		return unconditionedDependences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Var createVar() {
		VarImpl var = new VarImpl();
		return var;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public When createWhen() {
		WhenImpl when = new WhenImpl();
		return when;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Window createWindow() {
		WindowImpl window = new WindowImpl();
		return window;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Xor createXor() {
		XorImpl xor = new XorImpl();
		return xor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantLogicalKind createConstantLogicalKindFromString(EDataType eDataType, String initialValue) {
		ConstantLogicalKind result = ConstantLogicalKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertConstantLogicalKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntervalsKind createIntervalsKindFromString(EDataType eDataType, String initialValue) {
		IntervalsKind result = IntervalsKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIntervalsKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelKind createModelKindFromString(EDataType eDataType, String initialValue) {
		ModelKind result = ModelKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertModelKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperatorKind createOperatorKindFromString(EDataType eDataType, String initialValue) {
		OperatorKind result = OperatorKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertOperatorKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessAttributeKind createProcessAttributeKindFromString(EDataType eDataType, String initialValue) {
		ProcessAttributeKind result = ProcessAttributeKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertProcessAttributeKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignalIntrinsicType createSignalIntrinsicTypeFromString(EDataType eDataType, String initialValue) {
		SignalIntrinsicType result = SignalIntrinsicType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSignalIntrinsicTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeKind createTypeKindFromString(EDataType eDataType, String initialValue) {
		TypeKind result = TypeKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTypeKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VisibilityKind createVisibilityKindFromString(EDataType eDataType, String initialValue) {
		VisibilityKind result = VisibilityKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVisibilityKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmePackage getSsmePackage() {
		return (SsmePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static SsmePackage getPackage() {
		return SsmePackage.eINSTANCE;
	}

} //SsmeFactoryImpl
