/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.pop.ssme.After;
import org.eclipse.pop.ssme.And;
import org.eclipse.pop.ssme.ArrayElem;
import org.eclipse.pop.ssme.ArrayElementsEnumeration;
import org.eclipse.pop.ssme.ArrayIndex;
import org.eclipse.pop.ssme.ArrayProcess;
import org.eclipse.pop.ssme.ArrayProduct;
import org.eclipse.pop.ssme.ArrayRestructuration;
import org.eclipse.pop.ssme.ArrayType;
import org.eclipse.pop.ssme.AssertProcess;
import org.eclipse.pop.ssme.AssertSignal;
import org.eclipse.pop.ssme.BinaryOperators;
import org.eclipse.pop.ssme.Bounds;
import org.eclipse.pop.ssme.CartesianProduct;
import org.eclipse.pop.ssme.CaseBranch;
import org.eclipse.pop.ssme.CaseEnumeration;
import org.eclipse.pop.ssme.CaseExprEnumeration;
import org.eclipse.pop.ssme.CaseInterval;
import org.eclipse.pop.ssme.CaseProcess;
import org.eclipse.pop.ssme.Cell;
import org.eclipse.pop.ssme.Clock;
import org.eclipse.pop.ssme.ClockDifference;
import org.eclipse.pop.ssme.ClockEquality;
import org.eclipse.pop.ssme.ClockExclusiveRelation;
import org.eclipse.pop.ssme.ClockInfRelation;
import org.eclipse.pop.ssme.ClockProduct;
import org.eclipse.pop.ssme.ClockSupRelation;
import org.eclipse.pop.ssme.ClockUnion;
import org.eclipse.pop.ssme.Comment;
import org.eclipse.pop.ssme.ComplexConstructor;
import org.eclipse.pop.ssme.Composition;
import org.eclipse.pop.ssme.Concatenation;
import org.eclipse.pop.ssme.ConditionedDependence;
import org.eclipse.pop.ssme.Constant;
import org.eclipse.pop.ssme.ConstantCharacter;
import org.eclipse.pop.ssme.ConstantDefinition;
import org.eclipse.pop.ssme.ConstantDescription;
import org.eclipse.pop.ssme.ConstantDescriptionValue;
import org.eclipse.pop.ssme.ConstantDoubleReal;
import org.eclipse.pop.ssme.ConstantEnum;
import org.eclipse.pop.ssme.ConstantInteger;
import org.eclipse.pop.ssme.ConstantLogical;
import org.eclipse.pop.ssme.ConstantLogicalKind;
import org.eclipse.pop.ssme.ConstantReal;
import org.eclipse.pop.ssme.ConstantString;
import org.eclipse.pop.ssme.ConstantsDeclaration;
import org.eclipse.pop.ssme.Conversion;
import org.eclipse.pop.ssme.Count;
import org.eclipse.pop.ssme.Declaration;
import org.eclipse.pop.ssme.Default;
import org.eclipse.pop.ssme.Delay;
import org.eclipse.pop.ssme.Dependences;
import org.eclipse.pop.ssme.DescribedType;
import org.eclipse.pop.ssme.Description;
import org.eclipse.pop.ssme.Div;
import org.eclipse.pop.ssme.ElemDefinition;
import org.eclipse.pop.ssme.ElemDefinitionEnumeration;
import org.eclipse.pop.ssme.EnumerationType;
import org.eclipse.pop.ssme.Equal;
import org.eclipse.pop.ssme.EqualEqual;
import org.eclipse.pop.ssme.ExprParam;
import org.eclipse.pop.ssme.ExprProcess;
import org.eclipse.pop.ssme.ExprSignal;
import org.eclipse.pop.ssme.ExternalAttribute;
import org.eclipse.pop.ssme.ExternalGraph;
import org.eclipse.pop.ssme.ExternalReferences;
import org.eclipse.pop.ssme.FieldAccess;
import org.eclipse.pop.ssme.FormalProcess;
import org.eclipse.pop.ssme.From;
import org.eclipse.pop.ssme.GraphSpecification;
import org.eclipse.pop.ssme.Greater;
import org.eclipse.pop.ssme.GreaterOrEqual;
import org.eclipse.pop.ssme.IOProfile;
import org.eclipse.pop.ssme.Identifier;
import org.eclipse.pop.ssme.IdentityEquation;
import org.eclipse.pop.ssme.IfThenElse;
import org.eclipse.pop.ssme.Index;
import org.eclipse.pop.ssme.InterfaceDefinition;
import org.eclipse.pop.ssme.IntervalsKind;
import org.eclipse.pop.ssme.Iteration;
import org.eclipse.pop.ssme.IterationOfProcesses;
import org.eclipse.pop.ssme.IterationProcess;
import org.eclipse.pop.ssme.IterativeEnumeration;
import org.eclipse.pop.ssme.LabelledProcess;
import org.eclipse.pop.ssme.Labels;
import org.eclipse.pop.ssme.Less;
import org.eclipse.pop.ssme.LessLessEqual;
import org.eclipse.pop.ssme.LessOrEqual;
import org.eclipse.pop.ssme.ListExprSignal;
import org.eclipse.pop.ssme.ListFlows;
import org.eclipse.pop.ssme.ListModule;
import org.eclipse.pop.ssme.Masking;
import org.eclipse.pop.ssme.Minus;
import org.eclipse.pop.ssme.ModelKind;
import org.eclipse.pop.ssme.Module;
import org.eclipse.pop.ssme.ModuleDescription;
import org.eclipse.pop.ssme.ModulesImport;
import org.eclipse.pop.ssme.Modulo;
import org.eclipse.pop.ssme.Not;
import org.eclipse.pop.ssme.NotEqual;
import org.eclipse.pop.ssme.NullClock;
import org.eclipse.pop.ssme.NullProc;
import org.eclipse.pop.ssme.NullaryOperators;
import org.eclipse.pop.ssme.Operator;
import org.eclipse.pop.ssme.OperatorIdentifier;
import org.eclipse.pop.ssme.OperatorKind;
import org.eclipse.pop.ssme.OperatorModel;
import org.eclipse.pop.ssme.Or;
import org.eclipse.pop.ssme.PartialArrayDefinition;
import org.eclipse.pop.ssme.PartialIteration;
import org.eclipse.pop.ssme.Plus;
import org.eclipse.pop.ssme.Power;
import org.eclipse.pop.ssme.Pragma;
import org.eclipse.pop.ssme.PredefinedType;
import org.eclipse.pop.ssme.PreviousIterationRef;
import org.eclipse.pop.ssme.ProcessAttribute;
import org.eclipse.pop.ssme.ProcessAttributeKind;
import org.eclipse.pop.ssme.ProcessBody;
import org.eclipse.pop.ssme.ProcessCall;
import org.eclipse.pop.ssme.ProcessCallOrAssert;
import org.eclipse.pop.ssme.ProcessDeclaration;
import org.eclipse.pop.ssme.ProcessExpansion;
import org.eclipse.pop.ssme.ProcessInstance;
import org.eclipse.pop.ssme.ProcessModel;
import org.eclipse.pop.ssme.ProcessModelInterface;
import org.eclipse.pop.ssme.ProcessType;
import org.eclipse.pop.ssme.Product;
import org.eclipse.pop.ssme.Recover;
import org.eclipse.pop.ssme.ReferenceProcess;
import org.eclipse.pop.ssme.Repetition;
import org.eclipse.pop.ssme.RestrictionProcess;
import org.eclipse.pop.ssme.RootModel;
import org.eclipse.pop.ssme.SequentialDefinition;
import org.eclipse.pop.ssme.SharedVariablesDeclaration;
import org.eclipse.pop.ssme.SignalElement;
import org.eclipse.pop.ssme.SignalIntrinsicType;
import org.eclipse.pop.ssme.SignalNaming;
import org.eclipse.pop.ssme.Signals;
import org.eclipse.pop.ssme.SignalsDeclaration;
import org.eclipse.pop.ssme.SignalsDefinition;
import org.eclipse.pop.ssme.SignalsPartialDefaultDefinition;
import org.eclipse.pop.ssme.SignalsPartialDefinition;
import org.eclipse.pop.ssme.SsmeFactory;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.StateVariableValue;
import org.eclipse.pop.ssme.StateVariablesDeclaration;
import org.eclipse.pop.ssme.StringValue;
import org.eclipse.pop.ssme.TernaryOperators;
import org.eclipse.pop.ssme.Transposition;
import org.eclipse.pop.ssme.TupleType;
import org.eclipse.pop.ssme.Type;
import org.eclipse.pop.ssme.TypeDefinition;
import org.eclipse.pop.ssme.TypeDescription;
import org.eclipse.pop.ssme.TypeDescriptionValue;
import org.eclipse.pop.ssme.TypeKind;
import org.eclipse.pop.ssme.TypeMorphism;
import org.eclipse.pop.ssme.TypesDeclaration;
import org.eclipse.pop.ssme.TypesOrSignalsDeclaration;
import org.eclipse.pop.ssme.UnaryMinus;
import org.eclipse.pop.ssme.UnaryOperators;
import org.eclipse.pop.ssme.UnaryPlus;
import org.eclipse.pop.ssme.UnaryWhen;
import org.eclipse.pop.ssme.UnconditionedDependences;
import org.eclipse.pop.ssme.Var;
import org.eclipse.pop.ssme.VisibilityKind;
import org.eclipse.pop.ssme.When;
import org.eclipse.pop.ssme.Window;
import org.eclipse.pop.ssme.Xor;
import org.eclipse.pop.ssme.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SsmePackageImpl extends EPackageImpl implements SsmePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass afterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass andEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayElemEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayElementsEnumerationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayIndexEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayProductEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayRestructurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass arrayTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass assertProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass assertSignalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass binaryOperatorsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass boundsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass cartesianProductEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass caseEnumerationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass caseExprEnumerationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass caseIntervalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass caseProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass caseBranchEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass cellEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockDifferenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockEqualityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockExclusiveRelationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockInfRelationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockProductEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockSupRelationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clockUnionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass commentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass complexConstructorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass compositionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass concatenationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass conditionedDependenceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantCharacterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantDescriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantDescriptionValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantDoubleRealEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantEnumEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantIntegerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantLogicalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantRealEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantsDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constantStringEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass conversionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass countEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass declarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass defaultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass delayEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dependencesEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass describedTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass descriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass divEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass elemDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass elemDefinitionEnumerationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass enumerationTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass equalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass equalEqualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass exprParamEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass exprProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass exprSignalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass externalAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass externalGraphEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass externalReferencesEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fieldAccessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass formalProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fromEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass graphSpecificationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass greaterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass greaterOrEqualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass identifierEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass identityEquationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ifThenElseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass indexEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass interfaceDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ioProfileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass iterationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass iterationOfProcessesEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass iterationProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass iterativeEnumerationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass labelledProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass labelsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lessLessEqualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lessOrEqualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass listExprSignalEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass listFlowsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass listModuleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass maskingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass minusEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass moduleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass moduleDescriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modulesImportEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass moduloEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass notEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass notEqualEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nullaryOperatorsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nullClockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nullProcEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass operatorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass operatorIdentifierEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass operatorModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass orEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass partialArrayDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass partialIterationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass plusEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass powerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pragmaEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass predefinedTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass previousIterationRefEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processAttributeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processBodyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processCallEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processCallOrAssertEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processExpansionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processInstanceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processModelInterfaceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass productEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass recoverEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass repetitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass restrictionProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rootModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sequentialDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sharedVariablesDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalNamingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalsDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalsDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalsPartialDefaultDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signalsPartialDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stateVariablesDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stateVariableValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ternaryOperatorsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass transpositionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tupleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeDescriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeDescriptionValueEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typeMorphismEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typesDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass typesOrSignalsDeclarationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryMinusEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryPlusEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryOperatorsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unaryWhenEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unconditionedDependencesEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass varEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass whenEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass windowEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass xorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum constantLogicalKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum intervalsKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum modelKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum operatorKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum processAttributeKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum signalIntrinsicTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum typeKindEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum visibilityKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.pop.ssme.SsmePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private SsmePackageImpl() {
		super(eNS_URI, SsmeFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link SsmePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static SsmePackage init() {
		if (isInited) return (SsmePackage)EPackage.Registry.INSTANCE.getEPackage(SsmePackage.eNS_URI);

		// Obtain or create and register package
		SsmePackageImpl theSsmePackage = (SsmePackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof SsmePackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new SsmePackageImpl());

		isInited = true;

		// Create package meta-data objects
		theSsmePackage.createPackageContents();

		// Initialize created meta-data
		theSsmePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theSsmePackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(SsmePackage.eNS_URI, theSsmePackage);
		return theSsmePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAfter() {
		return afterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAnd() {
		return andEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayElem() {
		return arrayElemEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayElem_ExprSignal() {
		return (EReference)arrayElemEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayElem_ListExprSignal() {
		return (EReference)arrayElemEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayElementsEnumeration() {
		return arrayElementsEnumerationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayElementsEnumeration_ListPartialArrayDefinition() {
		return (EReference)arrayElementsEnumerationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayIndex() {
		return arrayIndexEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayIndex_Identifier() {
		return (EReference)arrayIndexEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayIndex_UpperBound() {
		return (EReference)arrayIndexEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayProcess() {
		return arrayProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayProcess_ArrayIndex() {
		return (EReference)arrayProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayProcess_ExprProcess() {
		return (EReference)arrayProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayProcess_IterationInit() {
		return (EReference)arrayProcessEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayProduct() {
		return arrayProductEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayRestructuration() {
		return arrayRestructurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getArrayType() {
		return arrayTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayType_ExprDimension() {
		return (EReference)arrayTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getArrayType_Type() {
		return (EReference)arrayTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAssertProcess() {
		return assertProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssertProcess_ProcessExpression() {
		return (EReference)assertProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAssertSignal() {
		return assertSignalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAssertSignal_ExprSignal() {
		return (EReference)assertSignalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBinaryOperators() {
		return binaryOperatorsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBinaryOperators_ExprSignal1() {
		return (EReference)binaryOperatorsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBinaryOperators_ExprSignal2() {
		return (EReference)binaryOperatorsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBounds() {
		return boundsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBounds_LowerBound() {
		return (EReference)boundsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBounds_UpperBound() {
		return (EReference)boundsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBounds_Step() {
		return (EReference)boundsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCartesianProduct() {
		return cartesianProductEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCartesianProduct_ListExprSignal() {
		return (EReference)cartesianProductEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCaseEnumeration() {
		return caseEnumerationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseEnumeration_ListExprSignal() {
		return (EReference)caseEnumerationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCaseExprEnumeration() {
		return caseExprEnumerationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCaseInterval() {
		return caseIntervalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseInterval_LowerBound() {
		return (EReference)caseIntervalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseInterval_UpperBound() {
		return (EReference)caseIntervalEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCaseInterval_IntervalsKind() {
		return (EAttribute)caseIntervalEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCaseProcess() {
		return caseProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseProcess_Identifier() {
		return (EReference)caseProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseProcess_ListCaseBranch() {
		return (EReference)caseProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseProcess_ElseCase() {
		return (EReference)caseProcessEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCaseBranch() {
		return caseBranchEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseBranch_EnumerationValues() {
		return (EReference)caseBranchEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCaseBranch_ExprProcess() {
		return (EReference)caseBranchEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCell() {
		return cellEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClock() {
		return clockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockDifference() {
		return clockDifferenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockEquality() {
		return clockEqualityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getClockEquality_ExprSignal() {
		return (EReference)clockEqualityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockExclusiveRelation() {
		return clockExclusiveRelationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getClockExclusiveRelation_ExprSignal() {
		return (EReference)clockExclusiveRelationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockInfRelation() {
		return clockInfRelationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getClockInfRelation_ExprSignal() {
		return (EReference)clockInfRelationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockProduct() {
		return clockProductEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockSupRelation() {
		return clockSupRelationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getClockSupRelation_ExprSignal() {
		return (EReference)clockSupRelationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getClockUnion() {
		return clockUnionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComment() {
		return commentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComment_AtomString() {
		return (EAttribute)commentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComplexConstructor() {
		return complexConstructorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComposition() {
		return compositionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getComposition_ListExprProcess() {
		return (EReference)compositionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConcatenation() {
		return concatenationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConditionedDependence() {
		return conditionedDependenceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditionedDependence_SignalsFrom() {
		return (EReference)conditionedDependenceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditionedDependence_SignalsTo() {
		return (EReference)conditionedDependenceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConditionedDependence_ConditionExpr() {
		return (EReference)conditionedDependenceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstant() {
		return constantEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantCharacter() {
		return constantCharacterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantCharacter_AtomString() {
		return (EAttribute)constantCharacterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantDefinition() {
		return constantDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantDescription() {
		return constantDescriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantDescription_Identifier() {
		return (EReference)constantDescriptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantDescription_ConstantDescriptionValue() {
		return (EReference)constantDescriptionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantDescriptionValue() {
		return constantDescriptionValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantDoubleReal() {
		return constantDoubleRealEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantDoubleReal_AtomString() {
		return (EAttribute)constantDoubleRealEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantEnum() {
		return constantEnumEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantEnum_TypeIdentifier() {
		return (EReference)constantEnumEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantEnum_ConstantEnumValue() {
		return (EReference)constantEnumEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantInteger() {
		return constantIntegerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantInteger_AtomString() {
		return (EAttribute)constantIntegerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantLogical() {
		return constantLogicalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantLogical_ConstantLogicalKind() {
		return (EAttribute)constantLogicalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantReal() {
		return constantRealEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantReal_AtomString() {
		return (EAttribute)constantRealEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantsDeclaration() {
		return constantsDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantsDeclaration_Visibility() {
		return (EAttribute)constantsDeclarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantsDeclaration_Type() {
		return (EReference)constantsDeclarationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConstantsDeclaration_ListConstantDefinition() {
		return (EReference)constantsDeclarationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstantString() {
		return constantStringEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getConstantString_AtomString() {
		return (EAttribute)constantStringEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConversion() {
		return conversionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConversion_PredefinedType() {
		return (EReference)conversionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getConversion_ExprSignal() {
		return (EReference)conversionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCount() {
		return countEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDeclaration() {
		return declarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDefault() {
		return defaultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDelay() {
		return delayEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDependences() {
		return dependencesEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDescribedType() {
		return describedTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDescription() {
		return descriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDescription_ListPragma() {
		return (EReference)descriptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDescription_Body() {
		return (EReference)descriptionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDiv() {
		return divEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getElemDefinition() {
		return elemDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getElemDefinition_ExprDimension() {
		return (EReference)elemDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getElemDefinition_ExprSignal() {
		return (EReference)elemDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getElemDefinitionEnumeration() {
		return elemDefinitionEnumerationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getElemDefinitionEnumeration_ListExprSignal() {
		return (EReference)elemDefinitionEnumerationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEnumerationType() {
		return enumerationTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEnumerationType_ListIdentifier() {
		return (EReference)enumerationTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEqual() {
		return equalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEqualEqual() {
		return equalEqualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExprParam() {
		return exprParamEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExprProcess() {
		return exprProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExprSignal() {
		return exprSignalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExternalAttribute() {
		return externalAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExternalAttribute_String() {
		return (EReference)externalAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExternalGraph() {
		return externalGraphEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExternalGraph_ProcessAttributes() {
		return (EReference)externalGraphEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExternalGraph_GraphSpecification() {
		return (EReference)externalGraphEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExternalReferences() {
		return externalReferencesEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExternalReferences_ListIdentifier() {
		return (EReference)externalReferencesEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFieldAccess() {
		return fieldAccessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFieldAccess_ExprSignal() {
		return (EReference)fieldAccessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFieldAccess_Identifier() {
		return (EReference)fieldAccessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFormalProcess() {
		return formalProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFormalProcess_ModelKind() {
		return (EAttribute)formalProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFormalProcess_ModelType() {
		return (EReference)formalProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFormalProcess_ModelName() {
		return (EReference)formalProcessEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFrom() {
		return fromEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGraphSpecification() {
		return graphSpecificationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getGraphSpecification_ExprProcess() {
		return (EReference)graphSpecificationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGreater() {
		return greaterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGreaterOrEqual() {
		return greaterOrEqualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIdentifier() {
		return identifierEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIdentifier_AtomString() {
		return (EAttribute)identifierEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIdentityEquation() {
		return identityEquationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIdentityEquation_ExprSignalLeft() {
		return (EReference)identityEquationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIdentityEquation_ExprSignalRight() {
		return (EReference)identityEquationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIfThenElse() {
		return ifThenElseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIndex() {
		return indexEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInterfaceDefinition() {
		return interfaceDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIOProfile() {
		return ioProfileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIOProfile_Inputs() {
		return (EReference)ioProfileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIOProfile_Outputs() {
		return (EReference)ioProfileEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIteration() {
		return iterationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIteration_PartialIteration() {
		return (EReference)iterationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIteration_ElemDefinition() {
		return (EReference)iterationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIterationOfProcesses() {
		return iterationOfProcessesEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIterationProcess() {
		return iterationProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIterationProcess_IterationIndex() {
		return (EReference)iterationProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIterationProcess_ExprProcess() {
		return (EReference)iterationProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIterationProcess_IterationInit() {
		return (EReference)iterationProcessEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIterativeEnumeration() {
		return iterativeEnumerationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLabelledProcess() {
		return labelledProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLabelledProcess_Label() {
		return (EReference)labelledProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLabelledProcess_ExprProcess() {
		return (EReference)labelledProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLabels() {
		return labelsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLabels_ListIdentifier() {
		return (EReference)labelsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLess() {
		return lessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLessLessEqual() {
		return lessLessEqualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLessOrEqual() {
		return lessOrEqualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getListExprSignal() {
		return listExprSignalEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getListExprSignal_ExprSignal() {
		return (EReference)listExprSignalEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getListFlows() {
		return listFlowsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getListFlows_ExprSignal() {
		return (EReference)listFlowsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getListModule() {
		return listModuleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getListModule_ListModule() {
		return (EReference)listModuleEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMasking() {
		return maskingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMasking_ExprProcess() {
		return (EReference)maskingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMasking_ListIdentifier() {
		return (EReference)maskingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMinus() {
		return minusEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModule() {
		return moduleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModule_Identifier() {
		return (EReference)moduleEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModule_ModuleDescription() {
		return (EReference)moduleEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModuleDescription() {
		return moduleDescriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModuleDescription_ListPragma() {
		return (EReference)moduleDescriptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModuleDescription_ListDeclaration() {
		return (EReference)moduleDescriptionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModulesImport() {
		return modulesImportEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModulesImport_ListModule() {
		return (EReference)modulesImportEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModulo() {
		return moduloEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNot() {
		return notEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNotEqual() {
		return notEqualEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNullaryOperators() {
		return nullaryOperatorsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNullClock() {
		return nullClockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNullProc() {
		return nullProcEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOperator() {
		return operatorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOperator_OperatorKind() {
		return (EAttribute)operatorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOperatorIdentifier() {
		return operatorIdentifierEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOperatorModel() {
		return operatorModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOperatorModel_OperatorIdentifier() {
		return (EReference)operatorModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOperatorModel_InterfaceDefinition() {
		return (EReference)operatorModelEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOperatorModel_Description() {
		return (EReference)operatorModelEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOr() {
		return orEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPartialArrayDefinition() {
		return partialArrayDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPartialIteration() {
		return partialIterationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPartialIteration_Index() {
		return (EReference)partialIterationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPartialIteration_Bounds() {
		return (EReference)partialIterationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPlus() {
		return plusEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPower() {
		return powerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPragma() {
		return pragmaEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPragma_Identifier() {
		return (EReference)pragmaEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPragma_ListPragmaObject() {
		return (EReference)pragmaEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPragma_PragmaStatement() {
		return (EReference)pragmaEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPredefinedType() {
		return predefinedTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPredefinedType_Type() {
		return (EAttribute)predefinedTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPreviousIterationRef() {
		return previousIterationRefEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessAttribute() {
		return processAttributeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessAttribute_ProcessAttributeKind() {
		return (EAttribute)processAttributeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessBody() {
		return processBodyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessCall() {
		return processCallEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessCall_ReferenceProcess() {
		return (EReference)processCallEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessCall_ListExprSignal() {
		return (EReference)processCallEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessCallOrAssert() {
		return processCallOrAssertEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessDeclaration() {
		return processDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessExpansion() {
		return processExpansionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessExpansion_Identifier() {
		return (EReference)processExpansionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessExpansion_ListExprParam() {
		return (EReference)processExpansionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessInstance() {
		return processInstanceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessModel() {
		return processModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModel_Identifier() {
		return (EReference)processModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModel_InterfaceDefinition() {
		return (EReference)processModelEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModel_Description() {
		return (EReference)processModelEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessModel_ModelKind() {
		return (EAttribute)processModelEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessModel_VisibilityKind() {
		return (EAttribute)processModelEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessModelInterface() {
		return processModelInterfaceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModelInterface_ListFormalParameter() {
		return (EReference)processModelInterfaceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModelInterface_IoProfile() {
		return (EReference)processModelInterfaceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessModelInterface_ExternalGraph() {
		return (EReference)processModelInterfaceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessType() {
		return processTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessType_ModelKind() {
		return (EAttribute)processTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessType_Identifier() {
		return (EReference)processTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessType_InterfaceDefinition() {
		return (EReference)processTypeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessType_ListPragma() {
		return (EReference)processTypeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProduct() {
		return productEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRecover() {
		return recoverEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getReferenceProcess() {
		return referenceProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRepetition() {
		return repetitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRestrictionProcess() {
		return restrictionProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRestrictionProcess_ExprProcess() {
		return (EReference)restrictionProcessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRestrictionProcess_ListDeclarations() {
		return (EReference)restrictionProcessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRootModel() {
		return rootModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSequentialDefinition() {
		return sequentialDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSharedVariablesDeclaration() {
		return sharedVariablesDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSharedVariablesDeclaration_Type() {
		return (EReference)sharedVariablesDeclarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSharedVariablesDeclaration_ListSignal() {
		return (EReference)sharedVariablesDeclarationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalElement() {
		return signalElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalElement_CommentPre() {
		return (EReference)signalElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalElement_CommentPost() {
		return (EReference)signalElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalNaming() {
		return signalNamingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalNaming_Identifier() {
		return (EReference)signalNamingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalNaming_InitValue() {
		return (EReference)signalNamingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignals() {
		return signalsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignals_ListExprSignal() {
		return (EReference)signalsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalsDeclaration() {
		return signalsDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsDeclaration_Type() {
		return (EReference)signalsDeclarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsDeclaration_ListSignal() {
		return (EReference)signalsDeclarationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalsDefinition() {
		return signalsDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsDefinition_ExprSignalLeft() {
		return (EReference)signalsDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsDefinition_ExprSignalRight() {
		return (EReference)signalsDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalsPartialDefaultDefinition() {
		return signalsPartialDefaultDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsPartialDefaultDefinition_ExprSignalLeft() {
		return (EReference)signalsPartialDefaultDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsPartialDefaultDefinition_ExprSignalRight() {
		return (EReference)signalsPartialDefaultDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSignalsPartialDefinition() {
		return signalsPartialDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsPartialDefinition_ExprSignalLeft() {
		return (EReference)signalsPartialDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSignalsPartialDefinition_ExprSignalRight() {
		return (EReference)signalsPartialDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStateVariablesDeclaration() {
		return stateVariablesDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStateVariablesDeclaration_Type() {
		return (EReference)stateVariablesDeclarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStateVariablesDeclaration_ListSignal() {
		return (EReference)stateVariablesDeclarationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStateVariableValue() {
		return stateVariableValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStateVariableValue_Identifier() {
		return (EReference)stateVariableValueEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringValue() {
		return stringValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStringValue_ListConstantString() {
		return (EReference)stringValueEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTernaryOperators() {
		return ternaryOperatorsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTernaryOperators_ExprSignal1() {
		return (EReference)ternaryOperatorsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTernaryOperators_ExprSignal2() {
		return (EReference)ternaryOperatorsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTernaryOperators_ExprSignal3() {
		return (EReference)ternaryOperatorsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTransposition() {
		return transpositionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTupleType() {
		return tupleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTupleType_ListSignalsDeclaration() {
		return (EReference)tupleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTupleType_GraphSpecification() {
		return (EReference)tupleTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTupleType_TypeKind() {
		return (EAttribute)tupleTypeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getType() {
		return typeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeDefinition() {
		return typeDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeDescription() {
		return typeDescriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeDescription_Identifier() {
		return (EReference)typeDescriptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeDescription_TypeDescriptionValue() {
		return (EReference)typeDescriptionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeDescription_InitValue() {
		return (EReference)typeDescriptionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeDescriptionValue() {
		return typeDescriptionValueEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypeMorphism() {
		return typeMorphismEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeMorphism_DescribedType() {
		return (EReference)typeMorphismEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypeMorphism_TypeDescriptionValue() {
		return (EReference)typeMorphismEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypesDeclaration() {
		return typesDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTypesDeclaration_Visibility() {
		return (EAttribute)typesDeclarationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTypesDeclaration_TypeDefinition() {
		return (EReference)typesDeclarationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTypesOrSignalsDeclaration() {
		return typesOrSignalsDeclarationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnaryMinus() {
		return unaryMinusEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnaryPlus() {
		return unaryPlusEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnaryOperators() {
		return unaryOperatorsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnaryOperators_ExprSignal() {
		return (EReference)unaryOperatorsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnaryWhen() {
		return unaryWhenEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnconditionedDependences() {
		return unconditionedDependencesEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnconditionedDependences_Signals() {
		return (EReference)unconditionedDependencesEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnconditionedDependences_DependenceElementsList() {
		return (EReference)unconditionedDependencesEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVar() {
		return varEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getWhen() {
		return whenEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getWindow() {
		return windowEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getXor() {
		return xorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getConstantLogicalKind() {
		return constantLogicalKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getIntervalsKind() {
		return intervalsKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getModelKind() {
		return modelKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getOperatorKind() {
		return operatorKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getProcessAttributeKind() {
		return processAttributeKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getSignalIntrinsicType() {
		return signalIntrinsicTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getTypeKind() {
		return typeKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getVisibilityKind() {
		return visibilityKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SsmeFactory getSsmeFactory() {
		return (SsmeFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		afterEClass = createEClass(AFTER);

		andEClass = createEClass(AND);

		arrayElemEClass = createEClass(ARRAY_ELEM);
		createEReference(arrayElemEClass, ARRAY_ELEM__EXPR_SIGNAL);
		createEReference(arrayElemEClass, ARRAY_ELEM__LIST_EXPR_SIGNAL);

		arrayElementsEnumerationEClass = createEClass(ARRAY_ELEMENTS_ENUMERATION);
		createEReference(arrayElementsEnumerationEClass, ARRAY_ELEMENTS_ENUMERATION__LIST_PARTIAL_ARRAY_DEFINITION);

		arrayIndexEClass = createEClass(ARRAY_INDEX);
		createEReference(arrayIndexEClass, ARRAY_INDEX__IDENTIFIER);
		createEReference(arrayIndexEClass, ARRAY_INDEX__UPPER_BOUND);

		arrayProcessEClass = createEClass(ARRAY_PROCESS);
		createEReference(arrayProcessEClass, ARRAY_PROCESS__ARRAY_INDEX);
		createEReference(arrayProcessEClass, ARRAY_PROCESS__EXPR_PROCESS);
		createEReference(arrayProcessEClass, ARRAY_PROCESS__ITERATION_INIT);

		arrayProductEClass = createEClass(ARRAY_PRODUCT);

		arrayRestructurationEClass = createEClass(ARRAY_RESTRUCTURATION);

		arrayTypeEClass = createEClass(ARRAY_TYPE);
		createEReference(arrayTypeEClass, ARRAY_TYPE__EXPR_DIMENSION);
		createEReference(arrayTypeEClass, ARRAY_TYPE__TYPE);

		assertProcessEClass = createEClass(ASSERT_PROCESS);
		createEReference(assertProcessEClass, ASSERT_PROCESS__PROCESS_EXPRESSION);

		assertSignalEClass = createEClass(ASSERT_SIGNAL);
		createEReference(assertSignalEClass, ASSERT_SIGNAL__EXPR_SIGNAL);

		binaryOperatorsEClass = createEClass(BINARY_OPERATORS);
		createEReference(binaryOperatorsEClass, BINARY_OPERATORS__EXPR_SIGNAL1);
		createEReference(binaryOperatorsEClass, BINARY_OPERATORS__EXPR_SIGNAL2);

		boundsEClass = createEClass(BOUNDS);
		createEReference(boundsEClass, BOUNDS__LOWER_BOUND);
		createEReference(boundsEClass, BOUNDS__UPPER_BOUND);
		createEReference(boundsEClass, BOUNDS__STEP);

		cartesianProductEClass = createEClass(CARTESIAN_PRODUCT);
		createEReference(cartesianProductEClass, CARTESIAN_PRODUCT__LIST_EXPR_SIGNAL);

		caseEnumerationEClass = createEClass(CASE_ENUMERATION);
		createEReference(caseEnumerationEClass, CASE_ENUMERATION__LIST_EXPR_SIGNAL);

		caseExprEnumerationEClass = createEClass(CASE_EXPR_ENUMERATION);

		caseIntervalEClass = createEClass(CASE_INTERVAL);
		createEReference(caseIntervalEClass, CASE_INTERVAL__LOWER_BOUND);
		createEReference(caseIntervalEClass, CASE_INTERVAL__UPPER_BOUND);
		createEAttribute(caseIntervalEClass, CASE_INTERVAL__INTERVALS_KIND);

		caseProcessEClass = createEClass(CASE_PROCESS);
		createEReference(caseProcessEClass, CASE_PROCESS__IDENTIFIER);
		createEReference(caseProcessEClass, CASE_PROCESS__LIST_CASE_BRANCH);
		createEReference(caseProcessEClass, CASE_PROCESS__ELSE_CASE);

		caseBranchEClass = createEClass(CASE_BRANCH);
		createEReference(caseBranchEClass, CASE_BRANCH__ENUMERATION_VALUES);
		createEReference(caseBranchEClass, CASE_BRANCH__EXPR_PROCESS);

		cellEClass = createEClass(CELL);

		clockEClass = createEClass(CLOCK);

		clockDifferenceEClass = createEClass(CLOCK_DIFFERENCE);

		clockEqualityEClass = createEClass(CLOCK_EQUALITY);
		createEReference(clockEqualityEClass, CLOCK_EQUALITY__EXPR_SIGNAL);

		clockExclusiveRelationEClass = createEClass(CLOCK_EXCLUSIVE_RELATION);
		createEReference(clockExclusiveRelationEClass, CLOCK_EXCLUSIVE_RELATION__EXPR_SIGNAL);

		clockInfRelationEClass = createEClass(CLOCK_INF_RELATION);
		createEReference(clockInfRelationEClass, CLOCK_INF_RELATION__EXPR_SIGNAL);

		clockProductEClass = createEClass(CLOCK_PRODUCT);

		clockSupRelationEClass = createEClass(CLOCK_SUP_RELATION);
		createEReference(clockSupRelationEClass, CLOCK_SUP_RELATION__EXPR_SIGNAL);

		clockUnionEClass = createEClass(CLOCK_UNION);

		commentEClass = createEClass(COMMENT);
		createEAttribute(commentEClass, COMMENT__ATOM_STRING);

		complexConstructorEClass = createEClass(COMPLEX_CONSTRUCTOR);

		compositionEClass = createEClass(COMPOSITION);
		createEReference(compositionEClass, COMPOSITION__LIST_EXPR_PROCESS);

		concatenationEClass = createEClass(CONCATENATION);

		conditionedDependenceEClass = createEClass(CONDITIONED_DEPENDENCE);
		createEReference(conditionedDependenceEClass, CONDITIONED_DEPENDENCE__SIGNALS_FROM);
		createEReference(conditionedDependenceEClass, CONDITIONED_DEPENDENCE__SIGNALS_TO);
		createEReference(conditionedDependenceEClass, CONDITIONED_DEPENDENCE__CONDITION_EXPR);

		constantEClass = createEClass(CONSTANT);

		constantCharacterEClass = createEClass(CONSTANT_CHARACTER);
		createEAttribute(constantCharacterEClass, CONSTANT_CHARACTER__ATOM_STRING);

		constantDefinitionEClass = createEClass(CONSTANT_DEFINITION);

		constantDescriptionEClass = createEClass(CONSTANT_DESCRIPTION);
		createEReference(constantDescriptionEClass, CONSTANT_DESCRIPTION__IDENTIFIER);
		createEReference(constantDescriptionEClass, CONSTANT_DESCRIPTION__CONSTANT_DESCRIPTION_VALUE);

		constantDescriptionValueEClass = createEClass(CONSTANT_DESCRIPTION_VALUE);

		constantDoubleRealEClass = createEClass(CONSTANT_DOUBLE_REAL);
		createEAttribute(constantDoubleRealEClass, CONSTANT_DOUBLE_REAL__ATOM_STRING);

		constantEnumEClass = createEClass(CONSTANT_ENUM);
		createEReference(constantEnumEClass, CONSTANT_ENUM__TYPE_IDENTIFIER);
		createEReference(constantEnumEClass, CONSTANT_ENUM__CONSTANT_ENUM_VALUE);

		constantIntegerEClass = createEClass(CONSTANT_INTEGER);
		createEAttribute(constantIntegerEClass, CONSTANT_INTEGER__ATOM_STRING);

		constantLogicalEClass = createEClass(CONSTANT_LOGICAL);
		createEAttribute(constantLogicalEClass, CONSTANT_LOGICAL__CONSTANT_LOGICAL_KIND);

		constantRealEClass = createEClass(CONSTANT_REAL);
		createEAttribute(constantRealEClass, CONSTANT_REAL__ATOM_STRING);

		constantsDeclarationEClass = createEClass(CONSTANTS_DECLARATION);
		createEAttribute(constantsDeclarationEClass, CONSTANTS_DECLARATION__VISIBILITY);
		createEReference(constantsDeclarationEClass, CONSTANTS_DECLARATION__TYPE);
		createEReference(constantsDeclarationEClass, CONSTANTS_DECLARATION__LIST_CONSTANT_DEFINITION);

		constantStringEClass = createEClass(CONSTANT_STRING);
		createEAttribute(constantStringEClass, CONSTANT_STRING__ATOM_STRING);

		conversionEClass = createEClass(CONVERSION);
		createEReference(conversionEClass, CONVERSION__PREDEFINED_TYPE);
		createEReference(conversionEClass, CONVERSION__EXPR_SIGNAL);

		countEClass = createEClass(COUNT);

		declarationEClass = createEClass(DECLARATION);

		defaultEClass = createEClass(DEFAULT);

		delayEClass = createEClass(DELAY);

		dependencesEClass = createEClass(DEPENDENCES);

		describedTypeEClass = createEClass(DESCRIBED_TYPE);

		descriptionEClass = createEClass(DESCRIPTION);
		createEReference(descriptionEClass, DESCRIPTION__LIST_PRAGMA);
		createEReference(descriptionEClass, DESCRIPTION__BODY);

		divEClass = createEClass(DIV);

		elemDefinitionEClass = createEClass(ELEM_DEFINITION);
		createEReference(elemDefinitionEClass, ELEM_DEFINITION__EXPR_DIMENSION);
		createEReference(elemDefinitionEClass, ELEM_DEFINITION__EXPR_SIGNAL);

		elemDefinitionEnumerationEClass = createEClass(ELEM_DEFINITION_ENUMERATION);
		createEReference(elemDefinitionEnumerationEClass, ELEM_DEFINITION_ENUMERATION__LIST_EXPR_SIGNAL);

		enumerationTypeEClass = createEClass(ENUMERATION_TYPE);
		createEReference(enumerationTypeEClass, ENUMERATION_TYPE__LIST_IDENTIFIER);

		equalEClass = createEClass(EQUAL);

		equalEqualEClass = createEClass(EQUAL_EQUAL);

		exprParamEClass = createEClass(EXPR_PARAM);

		exprProcessEClass = createEClass(EXPR_PROCESS);

		exprSignalEClass = createEClass(EXPR_SIGNAL);

		externalAttributeEClass = createEClass(EXTERNAL_ATTRIBUTE);
		createEReference(externalAttributeEClass, EXTERNAL_ATTRIBUTE__STRING);

		externalGraphEClass = createEClass(EXTERNAL_GRAPH);
		createEReference(externalGraphEClass, EXTERNAL_GRAPH__PROCESS_ATTRIBUTES);
		createEReference(externalGraphEClass, EXTERNAL_GRAPH__GRAPH_SPECIFICATION);

		externalReferencesEClass = createEClass(EXTERNAL_REFERENCES);
		createEReference(externalReferencesEClass, EXTERNAL_REFERENCES__LIST_IDENTIFIER);

		fieldAccessEClass = createEClass(FIELD_ACCESS);
		createEReference(fieldAccessEClass, FIELD_ACCESS__EXPR_SIGNAL);
		createEReference(fieldAccessEClass, FIELD_ACCESS__IDENTIFIER);

		formalProcessEClass = createEClass(FORMAL_PROCESS);
		createEAttribute(formalProcessEClass, FORMAL_PROCESS__MODEL_KIND);
		createEReference(formalProcessEClass, FORMAL_PROCESS__MODEL_TYPE);
		createEReference(formalProcessEClass, FORMAL_PROCESS__MODEL_NAME);

		fromEClass = createEClass(FROM);

		graphSpecificationEClass = createEClass(GRAPH_SPECIFICATION);
		createEReference(graphSpecificationEClass, GRAPH_SPECIFICATION__EXPR_PROCESS);

		greaterEClass = createEClass(GREATER);

		greaterOrEqualEClass = createEClass(GREATER_OR_EQUAL);

		identifierEClass = createEClass(IDENTIFIER);
		createEAttribute(identifierEClass, IDENTIFIER__ATOM_STRING);

		identityEquationEClass = createEClass(IDENTITY_EQUATION);
		createEReference(identityEquationEClass, IDENTITY_EQUATION__EXPR_SIGNAL_LEFT);
		createEReference(identityEquationEClass, IDENTITY_EQUATION__EXPR_SIGNAL_RIGHT);

		ifThenElseEClass = createEClass(IF_THEN_ELSE);

		indexEClass = createEClass(INDEX);

		interfaceDefinitionEClass = createEClass(INTERFACE_DEFINITION);

		ioProfileEClass = createEClass(IO_PROFILE);
		createEReference(ioProfileEClass, IO_PROFILE__INPUTS);
		createEReference(ioProfileEClass, IO_PROFILE__OUTPUTS);

		iterationEClass = createEClass(ITERATION);
		createEReference(iterationEClass, ITERATION__PARTIAL_ITERATION);
		createEReference(iterationEClass, ITERATION__ELEM_DEFINITION);

		iterationOfProcessesEClass = createEClass(ITERATION_OF_PROCESSES);

		iterationProcessEClass = createEClass(ITERATION_PROCESS);
		createEReference(iterationProcessEClass, ITERATION_PROCESS__ITERATION_INDEX);
		createEReference(iterationProcessEClass, ITERATION_PROCESS__EXPR_PROCESS);
		createEReference(iterationProcessEClass, ITERATION_PROCESS__ITERATION_INIT);

		iterativeEnumerationEClass = createEClass(ITERATIVE_ENUMERATION);

		labelledProcessEClass = createEClass(LABELLED_PROCESS);
		createEReference(labelledProcessEClass, LABELLED_PROCESS__LABEL);
		createEReference(labelledProcessEClass, LABELLED_PROCESS__EXPR_PROCESS);

		labelsEClass = createEClass(LABELS);
		createEReference(labelsEClass, LABELS__LIST_IDENTIFIER);

		lessEClass = createEClass(LESS);

		lessLessEqualEClass = createEClass(LESS_LESS_EQUAL);

		lessOrEqualEClass = createEClass(LESS_OR_EQUAL);

		listExprSignalEClass = createEClass(LIST_EXPR_SIGNAL);
		createEReference(listExprSignalEClass, LIST_EXPR_SIGNAL__EXPR_SIGNAL);

		listFlowsEClass = createEClass(LIST_FLOWS);
		createEReference(listFlowsEClass, LIST_FLOWS__EXPR_SIGNAL);

		listModuleEClass = createEClass(LIST_MODULE);
		createEReference(listModuleEClass, LIST_MODULE__LIST_MODULE);

		maskingEClass = createEClass(MASKING);
		createEReference(maskingEClass, MASKING__EXPR_PROCESS);
		createEReference(maskingEClass, MASKING__LIST_IDENTIFIER);

		minusEClass = createEClass(MINUS);

		moduleEClass = createEClass(MODULE);
		createEReference(moduleEClass, MODULE__IDENTIFIER);
		createEReference(moduleEClass, MODULE__MODULE_DESCRIPTION);

		moduleDescriptionEClass = createEClass(MODULE_DESCRIPTION);
		createEReference(moduleDescriptionEClass, MODULE_DESCRIPTION__LIST_PRAGMA);
		createEReference(moduleDescriptionEClass, MODULE_DESCRIPTION__LIST_DECLARATION);

		modulesImportEClass = createEClass(MODULES_IMPORT);
		createEReference(modulesImportEClass, MODULES_IMPORT__LIST_MODULE);

		moduloEClass = createEClass(MODULO);

		notEClass = createEClass(NOT);

		notEqualEClass = createEClass(NOT_EQUAL);

		nullaryOperatorsEClass = createEClass(NULLARY_OPERATORS);

		nullClockEClass = createEClass(NULL_CLOCK);

		nullProcEClass = createEClass(NULL_PROC);

		operatorEClass = createEClass(OPERATOR);
		createEAttribute(operatorEClass, OPERATOR__OPERATOR_KIND);

		operatorIdentifierEClass = createEClass(OPERATOR_IDENTIFIER);

		operatorModelEClass = createEClass(OPERATOR_MODEL);
		createEReference(operatorModelEClass, OPERATOR_MODEL__OPERATOR_IDENTIFIER);
		createEReference(operatorModelEClass, OPERATOR_MODEL__INTERFACE_DEFINITION);
		createEReference(operatorModelEClass, OPERATOR_MODEL__DESCRIPTION);

		orEClass = createEClass(OR);

		partialArrayDefinitionEClass = createEClass(PARTIAL_ARRAY_DEFINITION);

		partialIterationEClass = createEClass(PARTIAL_ITERATION);
		createEReference(partialIterationEClass, PARTIAL_ITERATION__INDEX);
		createEReference(partialIterationEClass, PARTIAL_ITERATION__BOUNDS);

		plusEClass = createEClass(PLUS);

		powerEClass = createEClass(POWER);

		pragmaEClass = createEClass(PRAGMA);
		createEReference(pragmaEClass, PRAGMA__IDENTIFIER);
		createEReference(pragmaEClass, PRAGMA__LIST_PRAGMA_OBJECT);
		createEReference(pragmaEClass, PRAGMA__PRAGMA_STATEMENT);

		predefinedTypeEClass = createEClass(PREDEFINED_TYPE);
		createEAttribute(predefinedTypeEClass, PREDEFINED_TYPE__TYPE);

		previousIterationRefEClass = createEClass(PREVIOUS_ITERATION_REF);

		processAttributeEClass = createEClass(PROCESS_ATTRIBUTE);
		createEAttribute(processAttributeEClass, PROCESS_ATTRIBUTE__PROCESS_ATTRIBUTE_KIND);

		processBodyEClass = createEClass(PROCESS_BODY);

		processCallEClass = createEClass(PROCESS_CALL);
		createEReference(processCallEClass, PROCESS_CALL__REFERENCE_PROCESS);
		createEReference(processCallEClass, PROCESS_CALL__LIST_EXPR_SIGNAL);

		processCallOrAssertEClass = createEClass(PROCESS_CALL_OR_ASSERT);

		processDeclarationEClass = createEClass(PROCESS_DECLARATION);

		processExpansionEClass = createEClass(PROCESS_EXPANSION);
		createEReference(processExpansionEClass, PROCESS_EXPANSION__IDENTIFIER);
		createEReference(processExpansionEClass, PROCESS_EXPANSION__LIST_EXPR_PARAM);

		processInstanceEClass = createEClass(PROCESS_INSTANCE);

		processModelEClass = createEClass(PROCESS_MODEL);
		createEReference(processModelEClass, PROCESS_MODEL__IDENTIFIER);
		createEReference(processModelEClass, PROCESS_MODEL__INTERFACE_DEFINITION);
		createEReference(processModelEClass, PROCESS_MODEL__DESCRIPTION);
		createEAttribute(processModelEClass, PROCESS_MODEL__MODEL_KIND);
		createEAttribute(processModelEClass, PROCESS_MODEL__VISIBILITY_KIND);

		processModelInterfaceEClass = createEClass(PROCESS_MODEL_INTERFACE);
		createEReference(processModelInterfaceEClass, PROCESS_MODEL_INTERFACE__LIST_FORMAL_PARAMETER);
		createEReference(processModelInterfaceEClass, PROCESS_MODEL_INTERFACE__IO_PROFILE);
		createEReference(processModelInterfaceEClass, PROCESS_MODEL_INTERFACE__EXTERNAL_GRAPH);

		processTypeEClass = createEClass(PROCESS_TYPE);
		createEAttribute(processTypeEClass, PROCESS_TYPE__MODEL_KIND);
		createEReference(processTypeEClass, PROCESS_TYPE__IDENTIFIER);
		createEReference(processTypeEClass, PROCESS_TYPE__INTERFACE_DEFINITION);
		createEReference(processTypeEClass, PROCESS_TYPE__LIST_PRAGMA);

		productEClass = createEClass(PRODUCT);

		recoverEClass = createEClass(RECOVER);

		referenceProcessEClass = createEClass(REFERENCE_PROCESS);

		repetitionEClass = createEClass(REPETITION);

		restrictionProcessEClass = createEClass(RESTRICTION_PROCESS);
		createEReference(restrictionProcessEClass, RESTRICTION_PROCESS__EXPR_PROCESS);
		createEReference(restrictionProcessEClass, RESTRICTION_PROCESS__LIST_DECLARATIONS);

		rootModelEClass = createEClass(ROOT_MODEL);

		sequentialDefinitionEClass = createEClass(SEQUENTIAL_DEFINITION);

		sharedVariablesDeclarationEClass = createEClass(SHARED_VARIABLES_DECLARATION);
		createEReference(sharedVariablesDeclarationEClass, SHARED_VARIABLES_DECLARATION__TYPE);
		createEReference(sharedVariablesDeclarationEClass, SHARED_VARIABLES_DECLARATION__LIST_SIGNAL);

		signalElementEClass = createEClass(SIGNAL_ELEMENT);
		createEReference(signalElementEClass, SIGNAL_ELEMENT__COMMENT_PRE);
		createEReference(signalElementEClass, SIGNAL_ELEMENT__COMMENT_POST);

		signalNamingEClass = createEClass(SIGNAL_NAMING);
		createEReference(signalNamingEClass, SIGNAL_NAMING__IDENTIFIER);
		createEReference(signalNamingEClass, SIGNAL_NAMING__INIT_VALUE);

		signalsEClass = createEClass(SIGNALS);
		createEReference(signalsEClass, SIGNALS__LIST_EXPR_SIGNAL);

		signalsDeclarationEClass = createEClass(SIGNALS_DECLARATION);
		createEReference(signalsDeclarationEClass, SIGNALS_DECLARATION__TYPE);
		createEReference(signalsDeclarationEClass, SIGNALS_DECLARATION__LIST_SIGNAL);

		signalsDefinitionEClass = createEClass(SIGNALS_DEFINITION);
		createEReference(signalsDefinitionEClass, SIGNALS_DEFINITION__EXPR_SIGNAL_LEFT);
		createEReference(signalsDefinitionEClass, SIGNALS_DEFINITION__EXPR_SIGNAL_RIGHT);

		signalsPartialDefaultDefinitionEClass = createEClass(SIGNALS_PARTIAL_DEFAULT_DEFINITION);
		createEReference(signalsPartialDefaultDefinitionEClass, SIGNALS_PARTIAL_DEFAULT_DEFINITION__EXPR_SIGNAL_LEFT);
		createEReference(signalsPartialDefaultDefinitionEClass, SIGNALS_PARTIAL_DEFAULT_DEFINITION__EXPR_SIGNAL_RIGHT);

		signalsPartialDefinitionEClass = createEClass(SIGNALS_PARTIAL_DEFINITION);
		createEReference(signalsPartialDefinitionEClass, SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_LEFT);
		createEReference(signalsPartialDefinitionEClass, SIGNALS_PARTIAL_DEFINITION__EXPR_SIGNAL_RIGHT);

		stateVariablesDeclarationEClass = createEClass(STATE_VARIABLES_DECLARATION);
		createEReference(stateVariablesDeclarationEClass, STATE_VARIABLES_DECLARATION__TYPE);
		createEReference(stateVariablesDeclarationEClass, STATE_VARIABLES_DECLARATION__LIST_SIGNAL);

		stateVariableValueEClass = createEClass(STATE_VARIABLE_VALUE);
		createEReference(stateVariableValueEClass, STATE_VARIABLE_VALUE__IDENTIFIER);

		stringValueEClass = createEClass(STRING_VALUE);
		createEReference(stringValueEClass, STRING_VALUE__LIST_CONSTANT_STRING);

		ternaryOperatorsEClass = createEClass(TERNARY_OPERATORS);
		createEReference(ternaryOperatorsEClass, TERNARY_OPERATORS__EXPR_SIGNAL1);
		createEReference(ternaryOperatorsEClass, TERNARY_OPERATORS__EXPR_SIGNAL2);
		createEReference(ternaryOperatorsEClass, TERNARY_OPERATORS__EXPR_SIGNAL3);

		transpositionEClass = createEClass(TRANSPOSITION);

		tupleTypeEClass = createEClass(TUPLE_TYPE);
		createEReference(tupleTypeEClass, TUPLE_TYPE__LIST_SIGNALS_DECLARATION);
		createEReference(tupleTypeEClass, TUPLE_TYPE__GRAPH_SPECIFICATION);
		createEAttribute(tupleTypeEClass, TUPLE_TYPE__TYPE_KIND);

		typeEClass = createEClass(TYPE);

		typeDefinitionEClass = createEClass(TYPE_DEFINITION);

		typeDescriptionEClass = createEClass(TYPE_DESCRIPTION);
		createEReference(typeDescriptionEClass, TYPE_DESCRIPTION__IDENTIFIER);
		createEReference(typeDescriptionEClass, TYPE_DESCRIPTION__TYPE_DESCRIPTION_VALUE);
		createEReference(typeDescriptionEClass, TYPE_DESCRIPTION__INIT_VALUE);

		typeDescriptionValueEClass = createEClass(TYPE_DESCRIPTION_VALUE);

		typeMorphismEClass = createEClass(TYPE_MORPHISM);
		createEReference(typeMorphismEClass, TYPE_MORPHISM__DESCRIBED_TYPE);
		createEReference(typeMorphismEClass, TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE);

		typesDeclarationEClass = createEClass(TYPES_DECLARATION);
		createEAttribute(typesDeclarationEClass, TYPES_DECLARATION__VISIBILITY);
		createEReference(typesDeclarationEClass, TYPES_DECLARATION__TYPE_DEFINITION);

		typesOrSignalsDeclarationEClass = createEClass(TYPES_OR_SIGNALS_DECLARATION);

		unaryMinusEClass = createEClass(UNARY_MINUS);

		unaryPlusEClass = createEClass(UNARY_PLUS);

		unaryOperatorsEClass = createEClass(UNARY_OPERATORS);
		createEReference(unaryOperatorsEClass, UNARY_OPERATORS__EXPR_SIGNAL);

		unaryWhenEClass = createEClass(UNARY_WHEN);

		unconditionedDependencesEClass = createEClass(UNCONDITIONED_DEPENDENCES);
		createEReference(unconditionedDependencesEClass, UNCONDITIONED_DEPENDENCES__SIGNALS);
		createEReference(unconditionedDependencesEClass, UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST);

		varEClass = createEClass(VAR);

		whenEClass = createEClass(WHEN);

		windowEClass = createEClass(WINDOW);

		xorEClass = createEClass(XOR);

		// Create enums
		constantLogicalKindEEnum = createEEnum(CONSTANT_LOGICAL_KIND);
		intervalsKindEEnum = createEEnum(INTERVALS_KIND);
		modelKindEEnum = createEEnum(MODEL_KIND);
		operatorKindEEnum = createEEnum(OPERATOR_KIND);
		processAttributeKindEEnum = createEEnum(PROCESS_ATTRIBUTE_KIND);
		signalIntrinsicTypeEEnum = createEEnum(SIGNAL_INTRINSIC_TYPE);
		typeKindEEnum = createEEnum(TYPE_KIND);
		visibilityKindEEnum = createEEnum(VISIBILITY_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		afterEClass.getESuperTypes().add(this.getBinaryOperators());
		andEClass.getESuperTypes().add(this.getBinaryOperators());
		arrayElemEClass.getESuperTypes().add(this.getExprSignal());
		arrayElementsEnumerationEClass.getESuperTypes().add(this.getIterativeEnumeration());
		arrayIndexEClass.getESuperTypes().add(this.getSignalElement());
		arrayProcessEClass.getESuperTypes().add(this.getIterationOfProcesses());
		arrayProductEClass.getESuperTypes().add(this.getBinaryOperators());
		arrayRestructurationEClass.getESuperTypes().add(this.getBinaryOperators());
		arrayTypeEClass.getESuperTypes().add(this.getDescribedType());
		assertProcessEClass.getESuperTypes().add(this.getExprProcess());
		assertSignalEClass.getESuperTypes().add(this.getProcessCallOrAssert());
		binaryOperatorsEClass.getESuperTypes().add(this.getExprSignal());
		boundsEClass.getESuperTypes().add(this.getSignalElement());
		cartesianProductEClass.getESuperTypes().add(this.getExprSignal());
		caseEnumerationEClass.getESuperTypes().add(this.getCaseExprEnumeration());
		caseExprEnumerationEClass.getESuperTypes().add(this.getSignalElement());
		caseIntervalEClass.getESuperTypes().add(this.getCaseExprEnumeration());
		caseProcessEClass.getESuperTypes().add(this.getExprProcess());
		caseBranchEClass.getESuperTypes().add(this.getSignalElement());
		cellEClass.getESuperTypes().add(this.getTernaryOperators());
		clockEClass.getESuperTypes().add(this.getUnaryOperators());
		clockDifferenceEClass.getESuperTypes().add(this.getBinaryOperators());
		clockEqualityEClass.getESuperTypes().add(this.getExprProcess());
		clockExclusiveRelationEClass.getESuperTypes().add(this.getExprProcess());
		clockInfRelationEClass.getESuperTypes().add(this.getExprProcess());
		clockProductEClass.getESuperTypes().add(this.getBinaryOperators());
		clockSupRelationEClass.getESuperTypes().add(this.getExprProcess());
		clockUnionEClass.getESuperTypes().add(this.getBinaryOperators());
		commentEClass.getESuperTypes().add(this.getSignalElement());
		complexConstructorEClass.getESuperTypes().add(this.getBinaryOperators());
		compositionEClass.getESuperTypes().add(this.getExprProcess());
		concatenationEClass.getESuperTypes().add(this.getBinaryOperators());
		conditionedDependenceEClass.getESuperTypes().add(this.getDependences());
		constantEClass.getESuperTypes().add(this.getExprSignal());
		constantCharacterEClass.getESuperTypes().add(this.getConstant());
		constantDefinitionEClass.getESuperTypes().add(this.getSignalElement());
		constantDescriptionEClass.getESuperTypes().add(this.getConstantDefinition());
		constantDescriptionValueEClass.getESuperTypes().add(this.getSignalElement());
		constantDoubleRealEClass.getESuperTypes().add(this.getConstant());
		constantEnumEClass.getESuperTypes().add(this.getExprSignal());
		constantIntegerEClass.getESuperTypes().add(this.getConstant());
		constantLogicalEClass.getESuperTypes().add(this.getConstant());
		constantRealEClass.getESuperTypes().add(this.getConstant());
		constantsDeclarationEClass.getESuperTypes().add(this.getDeclaration());
		constantStringEClass.getESuperTypes().add(this.getSignalElement());
		conversionEClass.getESuperTypes().add(this.getExprSignal());
		countEClass.getESuperTypes().add(this.getBinaryOperators());
		declarationEClass.getESuperTypes().add(this.getSignalElement());
		defaultEClass.getESuperTypes().add(this.getBinaryOperators());
		delayEClass.getESuperTypes().add(this.getTernaryOperators());
		dependencesEClass.getESuperTypes().add(this.getExprProcess());
		describedTypeEClass.getESuperTypes().add(this.getType());
		describedTypeEClass.getESuperTypes().add(this.getExprParam());
		descriptionEClass.getESuperTypes().add(this.getSignalElement());
		divEClass.getESuperTypes().add(this.getBinaryOperators());
		elemDefinitionEClass.getESuperTypes().add(this.getPartialArrayDefinition());
		elemDefinitionEnumerationEClass.getESuperTypes().add(this.getIterativeEnumeration());
		enumerationTypeEClass.getESuperTypes().add(this.getDescribedType());
		equalEClass.getESuperTypes().add(this.getBinaryOperators());
		equalEqualEClass.getESuperTypes().add(this.getBinaryOperators());
		exprParamEClass.getESuperTypes().add(this.getSignalElement());
		exprProcessEClass.getESuperTypes().add(this.getSignalElement());
		exprProcessEClass.getESuperTypes().add(this.getProcessBody());
		exprSignalEClass.getESuperTypes().add(this.getSignalElement());
		exprSignalEClass.getESuperTypes().add(this.getConstantDescriptionValue());
		exprSignalEClass.getESuperTypes().add(this.getExprParam());
		externalAttributeEClass.getESuperTypes().add(this.getProcessBody());
		externalAttributeEClass.getESuperTypes().add(this.getTypeDescriptionValue());
		externalAttributeEClass.getESuperTypes().add(this.getConstantDescriptionValue());
		externalGraphEClass.getESuperTypes().add(this.getSignalElement());
		externalReferencesEClass.getESuperTypes().add(this.getDeclaration());
		fieldAccessEClass.getESuperTypes().add(this.getExprSignal());
		formalProcessEClass.getESuperTypes().add(this.getTypesOrSignalsDeclaration());
		fromEClass.getESuperTypes().add(this.getBinaryOperators());
		graphSpecificationEClass.getESuperTypes().add(this.getSignalElement());
		greaterEClass.getESuperTypes().add(this.getBinaryOperators());
		greaterOrEqualEClass.getESuperTypes().add(this.getBinaryOperators());
		identifierEClass.getESuperTypes().add(this.getSignalElement());
		identifierEClass.getESuperTypes().add(this.getInterfaceDefinition());
		identifierEClass.getESuperTypes().add(this.getOperatorIdentifier());
		identifierEClass.getESuperTypes().add(this.getReferenceProcess());
		identifierEClass.getESuperTypes().add(this.getNullaryOperators());
		identifierEClass.getESuperTypes().add(this.getTypeDefinition());
		identifierEClass.getESuperTypes().add(this.getConstantDefinition());
		identifierEClass.getESuperTypes().add(this.getType());
		identityEquationEClass.getESuperTypes().add(this.getExprProcess());
		ifThenElseEClass.getESuperTypes().add(this.getTernaryOperators());
		indexEClass.getESuperTypes().add(this.getTernaryOperators());
		interfaceDefinitionEClass.getESuperTypes().add(this.getSignalElement());
		ioProfileEClass.getESuperTypes().add(this.getSignalElement());
		iterationEClass.getESuperTypes().add(this.getPartialArrayDefinition());
		iterationOfProcessesEClass.getESuperTypes().add(this.getExprProcess());
		iterationProcessEClass.getESuperTypes().add(this.getIterationOfProcesses());
		iterativeEnumerationEClass.getESuperTypes().add(this.getExprSignal());
		labelledProcessEClass.getESuperTypes().add(this.getExprProcess());
		labelsEClass.getESuperTypes().add(this.getDeclaration());
		lessEClass.getESuperTypes().add(this.getBinaryOperators());
		lessLessEqualEClass.getESuperTypes().add(this.getBinaryOperators());
		lessOrEqualEClass.getESuperTypes().add(this.getBinaryOperators());
		listExprSignalEClass.getESuperTypes().add(this.getSignalElement());
		listFlowsEClass.getESuperTypes().add(this.getExprSignal());
		listModuleEClass.getESuperTypes().add(this.getRootModel());
		maskingEClass.getESuperTypes().add(this.getExprProcess());
		minusEClass.getESuperTypes().add(this.getBinaryOperators());
		moduleEClass.getESuperTypes().add(this.getSignalElement());
		moduleDescriptionEClass.getESuperTypes().add(this.getSignalElement());
		modulesImportEClass.getESuperTypes().add(this.getDeclaration());
		moduloEClass.getESuperTypes().add(this.getBinaryOperators());
		notEClass.getESuperTypes().add(this.getUnaryOperators());
		notEqualEClass.getESuperTypes().add(this.getBinaryOperators());
		nullaryOperatorsEClass.getESuperTypes().add(this.getExprSignal());
		nullClockEClass.getESuperTypes().add(this.getNullaryOperators());
		nullProcEClass.getESuperTypes().add(this.getExprProcess());
		operatorEClass.getESuperTypes().add(this.getOperatorIdentifier());
		operatorIdentifierEClass.getESuperTypes().add(this.getSignalElement());
		operatorModelEClass.getESuperTypes().add(this.getSignalElement());
		operatorModelEClass.getESuperTypes().add(this.getProcessDeclaration());
		orEClass.getESuperTypes().add(this.getBinaryOperators());
		partialArrayDefinitionEClass.getESuperTypes().add(this.getSignalElement());
		partialIterationEClass.getESuperTypes().add(this.getSignalElement());
		plusEClass.getESuperTypes().add(this.getBinaryOperators());
		powerEClass.getESuperTypes().add(this.getBinaryOperators());
		pragmaEClass.getESuperTypes().add(this.getSignalElement());
		predefinedTypeEClass.getESuperTypes().add(this.getDescribedType());
		previousIterationRefEClass.getESuperTypes().add(this.getUnaryOperators());
		processAttributeEClass.getESuperTypes().add(this.getSignalElement());
		processBodyEClass.getESuperTypes().add(this.getSignalElement());
		processCallEClass.getESuperTypes().add(this.getProcessCallOrAssert());
		processCallOrAssertEClass.getESuperTypes().add(this.getSignalElement());
		processCallOrAssertEClass.getESuperTypes().add(this.getProcessInstance());
		processDeclarationEClass.getESuperTypes().add(this.getDeclaration());
		processDeclarationEClass.getESuperTypes().add(this.getRootModel());
		processExpansionEClass.getESuperTypes().add(this.getProcessInstance());
		processExpansionEClass.getESuperTypes().add(this.getReferenceProcess());
		processInstanceEClass.getESuperTypes().add(this.getExprProcess());
		processInstanceEClass.getESuperTypes().add(this.getExprSignal());
		processModelEClass.getESuperTypes().add(this.getSignalElement());
		processModelEClass.getESuperTypes().add(this.getProcessDeclaration());
		processModelInterfaceEClass.getESuperTypes().add(this.getInterfaceDefinition());
		processTypeEClass.getESuperTypes().add(this.getTypeDefinition());
		productEClass.getESuperTypes().add(this.getBinaryOperators());
		recoverEClass.getESuperTypes().add(this.getBinaryOperators());
		referenceProcessEClass.getESuperTypes().add(this.getSignalElement());
		repetitionEClass.getESuperTypes().add(this.getBinaryOperators());
		restrictionProcessEClass.getESuperTypes().add(this.getExprProcess());
		rootModelEClass.getESuperTypes().add(this.getSignalElement());
		sequentialDefinitionEClass.getESuperTypes().add(this.getBinaryOperators());
		sharedVariablesDeclarationEClass.getESuperTypes().add(this.getDeclaration());
		signalNamingEClass.getESuperTypes().add(this.getSignalElement());
		signalsEClass.getESuperTypes().add(this.getSignalElement());
		signalsDeclarationEClass.getESuperTypes().add(this.getTypesOrSignalsDeclaration());
		signalsDefinitionEClass.getESuperTypes().add(this.getExprProcess());
		signalsPartialDefaultDefinitionEClass.getESuperTypes().add(this.getExprProcess());
		signalsPartialDefinitionEClass.getESuperTypes().add(this.getExprProcess());
		stateVariablesDeclarationEClass.getESuperTypes().add(this.getDeclaration());
		stateVariableValueEClass.getESuperTypes().add(this.getExprSignal());
		stringValueEClass.getESuperTypes().add(this.getConstant());
		ternaryOperatorsEClass.getESuperTypes().add(this.getExprSignal());
		transpositionEClass.getESuperTypes().add(this.getUnaryOperators());
		tupleTypeEClass.getESuperTypes().add(this.getDescribedType());
		typeEClass.getESuperTypes().add(this.getTypeDescriptionValue());
		typeDefinitionEClass.getESuperTypes().add(this.getSignalElement());
		typeDescriptionEClass.getESuperTypes().add(this.getTypeDefinition());
		typeDescriptionValueEClass.getESuperTypes().add(this.getSignalElement());
		typeMorphismEClass.getESuperTypes().add(this.getTypeDefinition());
		typesDeclarationEClass.getESuperTypes().add(this.getTypesOrSignalsDeclaration());
		typesOrSignalsDeclarationEClass.getESuperTypes().add(this.getSignalElement());
		typesOrSignalsDeclarationEClass.getESuperTypes().add(this.getDeclaration());
		unaryMinusEClass.getESuperTypes().add(this.getUnaryOperators());
		unaryPlusEClass.getESuperTypes().add(this.getUnaryOperators());
		unaryOperatorsEClass.getESuperTypes().add(this.getExprSignal());
		unaryWhenEClass.getESuperTypes().add(this.getUnaryOperators());
		unconditionedDependencesEClass.getESuperTypes().add(this.getDependences());
		varEClass.getESuperTypes().add(this.getBinaryOperators());
		whenEClass.getESuperTypes().add(this.getBinaryOperators());
		windowEClass.getESuperTypes().add(this.getTernaryOperators());
		xorEClass.getESuperTypes().add(this.getBinaryOperators());

		// Initialize classes and features; add operations and parameters
		initEClass(afterEClass, After.class, "After", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(andEClass, And.class, "And", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(arrayElemEClass, ArrayElem.class, "ArrayElem", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayElem_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, ArrayElem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getArrayElem_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 1, 1, ArrayElem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(arrayElementsEnumerationEClass, ArrayElementsEnumeration.class, "ArrayElementsEnumeration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayElementsEnumeration_ListPartialArrayDefinition(), this.getPartialArrayDefinition(), null, "listPartialArrayDefinition", null, 0, -1, ArrayElementsEnumeration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(arrayIndexEClass, ArrayIndex.class, "ArrayIndex", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayIndex_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, ArrayIndex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getArrayIndex_UpperBound(), this.getExprSignal(), null, "upperBound", null, 1, 1, ArrayIndex.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(arrayProcessEClass, ArrayProcess.class, "ArrayProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayProcess_ArrayIndex(), this.getArrayIndex(), null, "arrayIndex", null, 1, 1, ArrayProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getArrayProcess_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, ArrayProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getArrayProcess_IterationInit(), this.getExprProcess(), null, "iterationInit", null, 0, 1, ArrayProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(arrayProductEClass, ArrayProduct.class, "ArrayProduct", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(arrayRestructurationEClass, ArrayRestructuration.class, "ArrayRestructuration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(arrayTypeEClass, ArrayType.class, "ArrayType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getArrayType_ExprDimension(), this.getListExprSignal(), null, "exprDimension", null, 0, 1, ArrayType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getArrayType_Type(), this.getType(), null, "type", null, 1, 1, ArrayType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(assertProcessEClass, AssertProcess.class, "AssertProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAssertProcess_ProcessExpression(), this.getExprProcess(), null, "processExpression", null, 1, 1, AssertProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(assertSignalEClass, AssertSignal.class, "AssertSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAssertSignal_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, AssertSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(binaryOperatorsEClass, BinaryOperators.class, "BinaryOperators", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getBinaryOperators_ExprSignal1(), this.getExprSignal(), null, "exprSignal1", null, 1, 1, BinaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getBinaryOperators_ExprSignal2(), this.getExprSignal(), null, "exprSignal2", null, 1, 1, BinaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(boundsEClass, Bounds.class, "Bounds", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getBounds_LowerBound(), this.getExprSignal(), null, "lowerBound", null, 0, 1, Bounds.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getBounds_UpperBound(), this.getExprSignal(), null, "upperBound", null, 0, 1, Bounds.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getBounds_Step(), this.getExprSignal(), null, "step", null, 0, 1, Bounds.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(cartesianProductEClass, CartesianProduct.class, "CartesianProduct", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCartesianProduct_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 1, 1, CartesianProduct.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(caseEnumerationEClass, CaseEnumeration.class, "CaseEnumeration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCaseEnumeration_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 1, 1, CaseEnumeration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(caseExprEnumerationEClass, CaseExprEnumeration.class, "CaseExprEnumeration", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(caseIntervalEClass, CaseInterval.class, "CaseInterval", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCaseInterval_LowerBound(), this.getExprSignal(), null, "lowerBound", null, 1, 1, CaseInterval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCaseInterval_UpperBound(), this.getExprSignal(), null, "upperBound", null, 1, 1, CaseInterval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCaseInterval_IntervalsKind(), this.getIntervalsKind(), "intervalsKind", null, 1, 1, CaseInterval.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(caseProcessEClass, CaseProcess.class, "CaseProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCaseProcess_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, CaseProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCaseProcess_ListCaseBranch(), this.getCaseBranch(), null, "listCaseBranch", null, 1, -1, CaseProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCaseProcess_ElseCase(), this.getExprProcess(), null, "elseCase", null, 0, 1, CaseProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(caseBranchEClass, CaseBranch.class, "CaseBranch", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCaseBranch_EnumerationValues(), this.getCaseExprEnumeration(), null, "enumerationValues", null, 1, 1, CaseBranch.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCaseBranch_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, CaseBranch.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(cellEClass, Cell.class, "Cell", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(clockEClass, Clock.class, "Clock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(clockDifferenceEClass, ClockDifference.class, "ClockDifference", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(clockEqualityEClass, ClockEquality.class, "ClockEquality", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getClockEquality_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 2, -1, ClockEquality.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clockExclusiveRelationEClass, ClockExclusiveRelation.class, "ClockExclusiveRelation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getClockExclusiveRelation_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 2, -1, ClockExclusiveRelation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clockInfRelationEClass, ClockInfRelation.class, "ClockInfRelation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getClockInfRelation_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 2, -1, ClockInfRelation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clockProductEClass, ClockProduct.class, "ClockProduct", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(clockSupRelationEClass, ClockSupRelation.class, "ClockSupRelation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getClockSupRelation_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 2, -1, ClockSupRelation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clockUnionEClass, ClockUnion.class, "ClockUnion", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(commentEClass, Comment.class, "Comment", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getComment_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, Comment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(complexConstructorEClass, ComplexConstructor.class, "ComplexConstructor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(compositionEClass, Composition.class, "Composition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getComposition_ListExprProcess(), this.getExprProcess(), null, "listExprProcess", null, 1, -1, Composition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(concatenationEClass, Concatenation.class, "Concatenation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(conditionedDependenceEClass, ConditionedDependence.class, "ConditionedDependence", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConditionedDependence_SignalsFrom(), this.getSignals(), null, "signalsFrom", null, 1, 1, ConditionedDependence.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConditionedDependence_SignalsTo(), this.getSignals(), null, "signalsTo", null, 1, 1, ConditionedDependence.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConditionedDependence_ConditionExpr(), this.getExprSignal(), null, "conditionExpr", null, 1, 1, ConditionedDependence.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantEClass, Constant.class, "Constant", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(constantCharacterEClass, ConstantCharacter.class, "ConstantCharacter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantCharacter_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, ConstantCharacter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantDefinitionEClass, ConstantDefinition.class, "ConstantDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(constantDescriptionEClass, ConstantDescription.class, "ConstantDescription", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConstantDescription_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, ConstantDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConstantDescription_ConstantDescriptionValue(), this.getConstantDescriptionValue(), null, "constantDescriptionValue", null, 1, 1, ConstantDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantDescriptionValueEClass, ConstantDescriptionValue.class, "ConstantDescriptionValue", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(constantDoubleRealEClass, ConstantDoubleReal.class, "ConstantDoubleReal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantDoubleReal_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, ConstantDoubleReal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantEnumEClass, ConstantEnum.class, "ConstantEnum", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConstantEnum_TypeIdentifier(), this.getIdentifier(), null, "typeIdentifier", null, 0, 1, ConstantEnum.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConstantEnum_ConstantEnumValue(), this.getIdentifier(), null, "constantEnumValue", null, 1, 1, ConstantEnum.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantIntegerEClass, ConstantInteger.class, "ConstantInteger", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantInteger_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, ConstantInteger.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantLogicalEClass, ConstantLogical.class, "ConstantLogical", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantLogical_ConstantLogicalKind(), this.getConstantLogicalKind(), "constantLogicalKind", null, 1, 1, ConstantLogical.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantRealEClass, ConstantReal.class, "ConstantReal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantReal_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, ConstantReal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantsDeclarationEClass, ConstantsDeclaration.class, "ConstantsDeclaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantsDeclaration_Visibility(), this.getVisibilityKind(), "visibility", null, 1, 1, ConstantsDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConstantsDeclaration_Type(), this.getType(), null, "type", null, 1, 1, ConstantsDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConstantsDeclaration_ListConstantDefinition(), this.getConstantDefinition(), null, "listConstantDefinition", null, 1, -1, ConstantsDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constantStringEClass, ConstantString.class, "ConstantString", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getConstantString_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, ConstantString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(conversionEClass, Conversion.class, "Conversion", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getConversion_PredefinedType(), this.getPredefinedType(), null, "predefinedType", null, 1, 1, Conversion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getConversion_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, Conversion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(countEClass, Count.class, "Count", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(declarationEClass, Declaration.class, "Declaration", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(defaultEClass, Default.class, "Default", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(delayEClass, Delay.class, "Delay", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(dependencesEClass, Dependences.class, "Dependences", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(describedTypeEClass, DescribedType.class, "DescribedType", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(descriptionEClass, Description.class, "Description", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDescription_ListPragma(), this.getPragma(), null, "listPragma", null, 0, -1, Description.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDescription_Body(), this.getProcessBody(), null, "body", null, 0, 1, Description.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(divEClass, Div.class, "Div", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(elemDefinitionEClass, ElemDefinition.class, "ElemDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getElemDefinition_ExprDimension(), this.getListExprSignal(), null, "exprDimension", null, 0, 1, ElemDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getElemDefinition_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, ElemDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(elemDefinitionEnumerationEClass, ElemDefinitionEnumeration.class, "ElemDefinitionEnumeration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getElemDefinitionEnumeration_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 1, 1, ElemDefinitionEnumeration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(enumerationTypeEClass, EnumerationType.class, "EnumerationType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEnumerationType_ListIdentifier(), this.getIdentifier(), null, "listIdentifier", null, 0, -1, EnumerationType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(equalEClass, Equal.class, "Equal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(equalEqualEClass, EqualEqual.class, "EqualEqual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(exprParamEClass, ExprParam.class, "ExprParam", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(exprProcessEClass, ExprProcess.class, "ExprProcess", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(exprSignalEClass, ExprSignal.class, "ExprSignal", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(externalAttributeEClass, ExternalAttribute.class, "ExternalAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExternalAttribute_String(), this.getStringValue(), null, "string", null, 0, 1, ExternalAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(externalGraphEClass, ExternalGraph.class, "ExternalGraph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExternalGraph_ProcessAttributes(), this.getProcessAttribute(), null, "processAttributes", null, 0, -1, ExternalGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getExternalGraph_GraphSpecification(), this.getGraphSpecification(), null, "graphSpecification", null, 0, 1, ExternalGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(externalReferencesEClass, ExternalReferences.class, "ExternalReferences", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExternalReferences_ListIdentifier(), this.getIdentifier(), null, "listIdentifier", null, 1, -1, ExternalReferences.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(fieldAccessEClass, FieldAccess.class, "FieldAccess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFieldAccess_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, FieldAccess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFieldAccess_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, FieldAccess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(formalProcessEClass, FormalProcess.class, "FormalProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFormalProcess_ModelKind(), this.getModelKind(), "modelKind", null, 1, 1, FormalProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFormalProcess_ModelType(), this.getIdentifier(), null, "modelType", null, 1, 1, FormalProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFormalProcess_ModelName(), this.getIdentifier(), null, "modelName", null, 1, 1, FormalProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(fromEClass, From.class, "From", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(graphSpecificationEClass, GraphSpecification.class, "GraphSpecification", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGraphSpecification_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, GraphSpecification.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(greaterEClass, Greater.class, "Greater", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(greaterOrEqualEClass, GreaterOrEqual.class, "GreaterOrEqual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(identifierEClass, Identifier.class, "Identifier", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getIdentifier_AtomString(), ecorePackage.getEString(), "atomString", null, 1, 1, Identifier.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(identityEquationEClass, IdentityEquation.class, "IdentityEquation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIdentityEquation_ExprSignalLeft(), this.getExprSignal(), null, "exprSignalLeft", null, 1, 1, IdentityEquation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIdentityEquation_ExprSignalRight(), this.getExprSignal(), null, "exprSignalRight", null, 1, 1, IdentityEquation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ifThenElseEClass, IfThenElse.class, "IfThenElse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(indexEClass, Index.class, "Index", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(interfaceDefinitionEClass, InterfaceDefinition.class, "InterfaceDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ioProfileEClass, IOProfile.class, "IOProfile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIOProfile_Inputs(), this.getTypesOrSignalsDeclaration(), null, "inputs", null, 0, -1, IOProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIOProfile_Outputs(), this.getTypesOrSignalsDeclaration(), null, "outputs", null, 0, -1, IOProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(iterationEClass, Iteration.class, "Iteration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIteration_PartialIteration(), this.getPartialIteration(), null, "partialIteration", null, 1, -1, Iteration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIteration_ElemDefinition(), this.getExprSignal(), null, "elemDefinition", null, 1, 1, Iteration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(iterationOfProcessesEClass, IterationOfProcesses.class, "IterationOfProcesses", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(iterationProcessEClass, IterationProcess.class, "IterationProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIterationProcess_IterationIndex(), this.getExprSignal(), null, "iterationIndex", null, 1, 1, IterationProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIterationProcess_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, IterationProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIterationProcess_IterationInit(), this.getExprProcess(), null, "iterationInit", null, 0, 1, IterationProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(iterativeEnumerationEClass, IterativeEnumeration.class, "IterativeEnumeration", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(labelledProcessEClass, LabelledProcess.class, "LabelledProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLabelledProcess_Label(), this.getIdentifier(), null, "label", null, 1, 1, LabelledProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getLabelledProcess_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, LabelledProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(labelsEClass, Labels.class, "Labels", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLabels_ListIdentifier(), this.getIdentifier(), null, "listIdentifier", null, 1, -1, Labels.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(lessEClass, Less.class, "Less", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lessLessEqualEClass, LessLessEqual.class, "LessLessEqual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lessOrEqualEClass, LessOrEqual.class, "LessOrEqual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(listExprSignalEClass, ListExprSignal.class, "ListExprSignal", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getListExprSignal_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, -1, ListExprSignal.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(listFlowsEClass, ListFlows.class, "ListFlows", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getListFlows_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, -1, ListFlows.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(listModuleEClass, ListModule.class, "ListModule", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getListModule_ListModule(), this.getModule(), null, "listModule", null, 1, -1, ListModule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(maskingEClass, Masking.class, "Masking", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMasking_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, Masking.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMasking_ListIdentifier(), this.getIdentifier(), null, "listIdentifier", null, 1, -1, Masking.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(minusEClass, Minus.class, "Minus", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(moduleEClass, Module.class, "Module", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getModule_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, Module.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getModule_ModuleDescription(), this.getModuleDescription(), null, "moduleDescription", null, 1, 1, Module.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(moduleDescriptionEClass, ModuleDescription.class, "ModuleDescription", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getModuleDescription_ListPragma(), this.getPragma(), null, "listPragma", null, 0, -1, ModuleDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getModuleDescription_ListDeclaration(), this.getDeclaration(), null, "listDeclaration", null, 0, -1, ModuleDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(modulesImportEClass, ModulesImport.class, "ModulesImport", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getModulesImport_ListModule(), this.getIdentifier(), null, "listModule", null, 0, -1, ModulesImport.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(moduloEClass, Modulo.class, "Modulo", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(notEClass, Not.class, "Not", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(notEqualEClass, NotEqual.class, "NotEqual", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(nullaryOperatorsEClass, NullaryOperators.class, "NullaryOperators", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(nullClockEClass, NullClock.class, "NullClock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(nullProcEClass, NullProc.class, "NullProc", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(operatorEClass, Operator.class, "Operator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOperator_OperatorKind(), this.getOperatorKind(), "operatorKind", null, 1, 1, Operator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(operatorIdentifierEClass, OperatorIdentifier.class, "OperatorIdentifier", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(operatorModelEClass, OperatorModel.class, "OperatorModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getOperatorModel_OperatorIdentifier(), this.getOperatorIdentifier(), null, "operatorIdentifier", null, 1, 1, OperatorModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOperatorModel_InterfaceDefinition(), this.getInterfaceDefinition(), null, "interfaceDefinition", null, 1, 1, OperatorModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getOperatorModel_Description(), this.getDescription(), null, "description", null, 1, 1, OperatorModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(orEClass, Or.class, "Or", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(partialArrayDefinitionEClass, PartialArrayDefinition.class, "PartialArrayDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(partialIterationEClass, PartialIteration.class, "PartialIteration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPartialIteration_Index(), this.getIdentifier(), null, "index", null, 0, 1, PartialIteration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPartialIteration_Bounds(), this.getBounds(), null, "bounds", null, 1, 1, PartialIteration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(plusEClass, Plus.class, "Plus", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(powerEClass, Power.class, "Power", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(pragmaEClass, Pragma.class, "Pragma", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPragma_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, Pragma.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPragma_ListPragmaObject(), this.getIdentifier(), null, "listPragmaObject", null, 0, -1, Pragma.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPragma_PragmaStatement(), this.getStringValue(), null, "pragmaStatement", null, 0, 1, Pragma.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(predefinedTypeEClass, PredefinedType.class, "PredefinedType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPredefinedType_Type(), this.getSignalIntrinsicType(), "type", null, 1, 1, PredefinedType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(previousIterationRefEClass, PreviousIterationRef.class, "PreviousIterationRef", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(processAttributeEClass, ProcessAttribute.class, "ProcessAttribute", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProcessAttribute_ProcessAttributeKind(), this.getProcessAttributeKind(), "processAttributeKind", null, 1, 1, ProcessAttribute.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(processBodyEClass, ProcessBody.class, "ProcessBody", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(processCallEClass, ProcessCall.class, "ProcessCall", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessCall_ReferenceProcess(), this.getReferenceProcess(), null, "referenceProcess", null, 1, 1, ProcessCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessCall_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 0, 1, ProcessCall.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(processCallOrAssertEClass, ProcessCallOrAssert.class, "ProcessCallOrAssert", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(processDeclarationEClass, ProcessDeclaration.class, "ProcessDeclaration", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(processExpansionEClass, ProcessExpansion.class, "ProcessExpansion", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessExpansion_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, ProcessExpansion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessExpansion_ListExprParam(), this.getExprParam(), null, "listExprParam", null, 0, -1, ProcessExpansion.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(processInstanceEClass, ProcessInstance.class, "ProcessInstance", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(processModelEClass, ProcessModel.class, "ProcessModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessModel_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, ProcessModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessModel_InterfaceDefinition(), this.getInterfaceDefinition(), null, "interfaceDefinition", null, 1, 1, ProcessModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessModel_Description(), this.getDescription(), null, "description", null, 1, 1, ProcessModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessModel_ModelKind(), this.getModelKind(), "modelKind", null, 1, 1, ProcessModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProcessModel_VisibilityKind(), this.getVisibilityKind(), "visibilityKind", null, 1, 1, ProcessModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(processModelInterfaceEClass, ProcessModelInterface.class, "ProcessModelInterface", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessModelInterface_ListFormalParameter(), this.getTypesOrSignalsDeclaration(), null, "listFormalParameter", null, 0, -1, ProcessModelInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessModelInterface_IoProfile(), this.getIOProfile(), null, "ioProfile", null, 1, 1, ProcessModelInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessModelInterface_ExternalGraph(), this.getExternalGraph(), null, "externalGraph", null, 1, 1, ProcessModelInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(processTypeEClass, ProcessType.class, "ProcessType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProcessType_ModelKind(), this.getModelKind(), "modelKind", null, 1, 1, ProcessType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessType_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, ProcessType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessType_InterfaceDefinition(), this.getInterfaceDefinition(), null, "interfaceDefinition", null, 1, 1, ProcessType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProcessType_ListPragma(), this.getPragma(), null, "listPragma", null, 0, -1, ProcessType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(productEClass, Product.class, "Product", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(recoverEClass, Recover.class, "Recover", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(referenceProcessEClass, ReferenceProcess.class, "ReferenceProcess", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(repetitionEClass, Repetition.class, "Repetition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(restrictionProcessEClass, RestrictionProcess.class, "RestrictionProcess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRestrictionProcess_ExprProcess(), this.getExprProcess(), null, "exprProcess", null, 1, 1, RestrictionProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRestrictionProcess_ListDeclarations(), this.getDeclaration(), null, "listDeclarations", null, 0, -1, RestrictionProcess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rootModelEClass, RootModel.class, "RootModel", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sequentialDefinitionEClass, SequentialDefinition.class, "SequentialDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sharedVariablesDeclarationEClass, SharedVariablesDeclaration.class, "SharedVariablesDeclaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSharedVariablesDeclaration_Type(), this.getType(), null, "type", null, 1, 1, SharedVariablesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSharedVariablesDeclaration_ListSignal(), this.getSignalNaming(), null, "listSignal", null, 1, -1, SharedVariablesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalElementEClass, SignalElement.class, "SignalElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalElement_CommentPre(), this.getComment(), null, "commentPre", null, 0, -1, SignalElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalElement_CommentPost(), this.getComment(), null, "commentPost", null, 0, -1, SignalElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(signalElementEClass, null, "getParent", 1, 1, IS_UNIQUE, !IS_ORDERED);

		addEOperation(signalElementEClass, ecorePackage.getELong(), "makeAST", 1, 1, IS_UNIQUE, IS_ORDERED);

		EOperation op = addEOperation(signalElementEClass, null, "setASTAttribute", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEObject(), "sigElem", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getELong(), "tree", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(signalNamingEClass, SignalNaming.class, "SignalNaming", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalNaming_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, SignalNaming.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalNaming_InitValue(), this.getExprSignal(), null, "initValue", null, 0, 1, SignalNaming.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalsEClass, Signals.class, "Signals", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignals_ListExprSignal(), this.getListExprSignal(), null, "listExprSignal", null, 1, 1, Signals.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalsDeclarationEClass, SignalsDeclaration.class, "SignalsDeclaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalsDeclaration_Type(), this.getType(), null, "type", null, 0, 1, SignalsDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalsDeclaration_ListSignal(), this.getSignalNaming(), null, "listSignal", null, 1, -1, SignalsDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalsDefinitionEClass, SignalsDefinition.class, "SignalsDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalsDefinition_ExprSignalLeft(), this.getExprSignal(), null, "exprSignalLeft", null, 1, 1, SignalsDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalsDefinition_ExprSignalRight(), this.getExprSignal(), null, "exprSignalRight", null, 1, 1, SignalsDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalsPartialDefaultDefinitionEClass, SignalsPartialDefaultDefinition.class, "SignalsPartialDefaultDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalsPartialDefaultDefinition_ExprSignalLeft(), this.getExprSignal(), null, "exprSignalLeft", null, 1, 1, SignalsPartialDefaultDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalsPartialDefaultDefinition_ExprSignalRight(), this.getExprSignal(), null, "exprSignalRight", null, 1, 1, SignalsPartialDefaultDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signalsPartialDefinitionEClass, SignalsPartialDefinition.class, "SignalsPartialDefinition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getSignalsPartialDefinition_ExprSignalLeft(), this.getExprSignal(), null, "exprSignalLeft", null, 1, 1, SignalsPartialDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSignalsPartialDefinition_ExprSignalRight(), this.getExprSignal(), null, "exprSignalRight", null, 1, 1, SignalsPartialDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stateVariablesDeclarationEClass, StateVariablesDeclaration.class, "StateVariablesDeclaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getStateVariablesDeclaration_Type(), this.getType(), null, "type", null, 1, 1, StateVariablesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getStateVariablesDeclaration_ListSignal(), this.getSignalNaming(), null, "listSignal", null, 1, -1, StateVariablesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stateVariableValueEClass, StateVariableValue.class, "StateVariableValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getStateVariableValue_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, StateVariableValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stringValueEClass, StringValue.class, "StringValue", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getStringValue_ListConstantString(), this.getConstantString(), null, "listConstantString", null, 1, -1, StringValue.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ternaryOperatorsEClass, TernaryOperators.class, "TernaryOperators", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTernaryOperators_ExprSignal1(), this.getExprSignal(), null, "exprSignal1", null, 1, 1, TernaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTernaryOperators_ExprSignal2(), this.getExprSignal(), null, "exprSignal2", null, 1, 1, TernaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTernaryOperators_ExprSignal3(), this.getExprSignal(), null, "exprSignal3", null, 1, 1, TernaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(transpositionEClass, Transposition.class, "Transposition", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(tupleTypeEClass, TupleType.class, "TupleType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTupleType_ListSignalsDeclaration(), this.getTypesOrSignalsDeclaration(), null, "listSignalsDeclaration", null, 0, -1, TupleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTupleType_GraphSpecification(), this.getGraphSpecification(), null, "graphSpecification", null, 0, 1, TupleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTupleType_TypeKind(), this.getTypeKind(), "typeKind", null, 1, 1, TupleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(typeEClass, Type.class, "Type", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(typeDefinitionEClass, TypeDefinition.class, "TypeDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(typeDescriptionEClass, TypeDescription.class, "TypeDescription", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTypeDescription_Identifier(), this.getIdentifier(), null, "identifier", null, 1, 1, TypeDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTypeDescription_TypeDescriptionValue(), this.getTypeDescriptionValue(), null, "typeDescriptionValue", null, 1, 1, TypeDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTypeDescription_InitValue(), this.getExprSignal(), null, "initValue", null, 0, 1, TypeDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(typeDescriptionValueEClass, TypeDescriptionValue.class, "TypeDescriptionValue", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(typeMorphismEClass, TypeMorphism.class, "TypeMorphism", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTypeMorphism_DescribedType(), this.getDescribedType(), null, "describedType", null, 1, 1, TypeMorphism.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTypeMorphism_TypeDescriptionValue(), this.getTypeDescriptionValue(), null, "typeDescriptionValue", null, 1, 1, TypeMorphism.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(typesDeclarationEClass, TypesDeclaration.class, "TypesDeclaration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTypesDeclaration_Visibility(), this.getVisibilityKind(), "visibility", null, 1, 1, TypesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTypesDeclaration_TypeDefinition(), this.getTypeDefinition(), null, "typeDefinition", null, 1, -1, TypesDeclaration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(typesOrSignalsDeclarationEClass, TypesOrSignalsDeclaration.class, "TypesOrSignalsDeclaration", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unaryMinusEClass, UnaryMinus.class, "UnaryMinus", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unaryPlusEClass, UnaryPlus.class, "UnaryPlus", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unaryOperatorsEClass, UnaryOperators.class, "UnaryOperators", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getUnaryOperators_ExprSignal(), this.getExprSignal(), null, "exprSignal", null, 1, 1, UnaryOperators.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(unaryWhenEClass, UnaryWhen.class, "UnaryWhen", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(unconditionedDependencesEClass, UnconditionedDependences.class, "UnconditionedDependences", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getUnconditionedDependences_Signals(), this.getSignals(), null, "signals", null, 1, 1, UnconditionedDependences.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getUnconditionedDependences_DependenceElementsList(), this.getSignals(), null, "dependenceElementsList", null, 1, -1, UnconditionedDependences.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(varEClass, Var.class, "Var", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(whenEClass, When.class, "When", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(windowEClass, Window.class, "Window", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(xorEClass, Xor.class, "Xor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(constantLogicalKindEEnum, ConstantLogicalKind.class, "ConstantLogicalKind");
		addEEnumLiteral(constantLogicalKindEEnum, ConstantLogicalKind.TRUE_LITERAL);
		addEEnumLiteral(constantLogicalKindEEnum, ConstantLogicalKind.FALSE_LITERAL);

		initEEnum(intervalsKindEEnum, IntervalsKind.class, "IntervalsKind");
		addEEnumLiteral(intervalsKindEEnum, IntervalsKind.LEFT_CLOSED_RIGHT_CLOSED_LITERAL);
		addEEnumLiteral(intervalsKindEEnum, IntervalsKind.LEFT_CLOSED_RIGHT_OPENED_LITERAL);
		addEEnumLiteral(intervalsKindEEnum, IntervalsKind.LEFT_OPENED_RIGHT_CLOSED_LITERAL);
		addEEnumLiteral(intervalsKindEEnum, IntervalsKind.LEFT_OPENED_RIGHT_OPENED_LITERAL);

		initEEnum(modelKindEEnum, ModelKind.class, "ModelKind");
		addEEnumLiteral(modelKindEEnum, ModelKind.PROCESS_LITERAL);
		addEEnumLiteral(modelKindEEnum, ModelKind.FUNCTION_LITERAL);
		addEEnumLiteral(modelKindEEnum, ModelKind.NODE_LITERAL);
		addEEnumLiteral(modelKindEEnum, ModelKind.ACTION_LITERAL);
		addEEnumLiteral(modelKindEEnum, ModelKind.PROCEDURE_LITERAL);
		addEEnumLiteral(modelKindEEnum, ModelKind.AUTOMATON_LITERAL);

		initEEnum(operatorKindEEnum, OperatorKind.class, "OperatorKind");
		addEEnumLiteral(operatorKindEEnum, OperatorKind.NULL_CLOCK_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.NEXT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.ARRAY_RESTRUCTURATION_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.DEFAULT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.WHEN_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.AFTER_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.FROM_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.COUNT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CLOCK_UNION_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CLOCK_DIFFERENCE_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CLOCK_PRODUCT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.IF_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.EXPR_INDEX_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.XOR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.OR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.AND_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.NOT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.EQUAL_EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.LESS_LESS_EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.NOT_EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.GREATER_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.GREATER_OR_EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.LESS_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.LESS_OR_EQUAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.ADD_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.MINUS_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CONCATENATION_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.PRODUCT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.ARRAY_PRODUCT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.DIV_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.MODULO_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.REPETITION_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.POWER_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.COMPLEX_CONSTRUCTOR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CELL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.VAR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.DELAY_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.WINDOW_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.TR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.RECUPERATION_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CLOCK_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.EVENT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.BOOLEAN_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.SHORT_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.INTEGER_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.LONG_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.REAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.DREAL_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.COMPLEX_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.DCOMPLEX_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.CHAR_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.STRING_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.FALSE_LITERAL);
		addEEnumLiteral(operatorKindEEnum, OperatorKind.TRUE_LITERAL);

		initEEnum(processAttributeKindEEnum, ProcessAttributeKind.class, "ProcessAttributeKind");
		addEEnumLiteral(processAttributeKindEEnum, ProcessAttributeKind.SAFE_LITERAL);
		addEEnumLiteral(processAttributeKindEEnum, ProcessAttributeKind.DETERMINISTIC_LITERAL);
		addEEnumLiteral(processAttributeKindEEnum, ProcessAttributeKind.UNSAFE_LITERAL);

		initEEnum(signalIntrinsicTypeEEnum, SignalIntrinsicType.class, "SignalIntrinsicType");
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.UNDEFINED_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.BOOLEAN_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.CHAR_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.COMPLEX_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.DCOMPLEX_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.DREAL_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.EVENT_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.INTEGER_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.LONG_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.REAL_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.SHORT_LITERAL);
		addEEnumLiteral(signalIntrinsicTypeEEnum, SignalIntrinsicType.STRING_LITERAL);

		initEEnum(typeKindEEnum, TypeKind.class, "TypeKind");
		addEEnumLiteral(typeKindEEnum, TypeKind.BUNDLE_LITERAL);
		addEEnumLiteral(typeKindEEnum, TypeKind.STRUCT_LITERAL);

		initEEnum(visibilityKindEEnum, VisibilityKind.class, "VisibilityKind");
		addEEnumLiteral(visibilityKindEEnum, VisibilityKind.PUBLIC_LITERAL);
		addEEnumLiteral(visibilityKindEEnum, VisibilityKind.PRIVATE_LITERAL);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.topcased.org/uuid
		createUuidAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.topcased.org/uuid</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUuidAnnotations() {
		String source = "http://www.topcased.org/uuid";	
		addAnnotation
		  (caseIntervalEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseInterval_LowerBound(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseInterval_UpperBound(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (caseProcessEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseProcess_Identifier(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseProcess_ListCaseBranch(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseProcess_ElseCase(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (caseBranchEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseBranch_EnumerationValues(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (getCaseBranch_ExprProcess(), 
		   source, 
		   new String[] {
			 "uuid", "_2LOfh-5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (compositionEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOfQO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (exprProcessEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOfsO5WEduz9o2pAin6-g"
		   });	
		addAnnotation
		  (identifierEClass, 
		   source, 
		   new String[] {
			 "uuid", "_2LOgFu5WEduz9o2pAin6-g"
		   });
	}

} //SsmePackageImpl
