/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.pop.ssme.DescribedType;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.TypeDescriptionValue;
import org.eclipse.pop.ssme.TypeMorphism;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type Morphism</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.TypeMorphismImpl#getDescribedType <em>Described Type</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.TypeMorphismImpl#getTypeDescriptionValue <em>Type Description Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TypeMorphismImpl extends SignalElementImpl implements TypeMorphism {
	/**
	 * The cached value of the '{@link #getDescribedType() <em>Described Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescribedType()
	 * @generated
	 * @ordered
	 */
	protected DescribedType describedType;

	/**
	 * The cached value of the '{@link #getTypeDescriptionValue() <em>Type Description Value</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeDescriptionValue()
	 * @generated
	 * @ordered
	 */
	protected TypeDescriptionValue typeDescriptionValue;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMorphismImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getTypeMorphism();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DescribedType getDescribedType() {
		return describedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDescribedType(DescribedType newDescribedType, NotificationChain msgs) {
		DescribedType oldDescribedType = describedType;
		describedType = newDescribedType;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE, oldDescribedType, newDescribedType);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescribedType(DescribedType newDescribedType) {
		if (newDescribedType != describedType) {
			NotificationChain msgs = null;
			if (describedType != null)
				msgs = ((InternalEObject)describedType).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE, null, msgs);
			if (newDescribedType != null)
				msgs = ((InternalEObject)newDescribedType).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE, null, msgs);
			msgs = basicSetDescribedType(newDescribedType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE, newDescribedType, newDescribedType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeDescriptionValue getTypeDescriptionValue() {
		return typeDescriptionValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTypeDescriptionValue(TypeDescriptionValue newTypeDescriptionValue, NotificationChain msgs) {
		TypeDescriptionValue oldTypeDescriptionValue = typeDescriptionValue;
		typeDescriptionValue = newTypeDescriptionValue;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE, oldTypeDescriptionValue, newTypeDescriptionValue);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTypeDescriptionValue(TypeDescriptionValue newTypeDescriptionValue) {
		if (newTypeDescriptionValue != typeDescriptionValue) {
			NotificationChain msgs = null;
			if (typeDescriptionValue != null)
				msgs = ((InternalEObject)typeDescriptionValue).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE, null, msgs);
			if (newTypeDescriptionValue != null)
				msgs = ((InternalEObject)newTypeDescriptionValue).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE, null, msgs);
			msgs = basicSetTypeDescriptionValue(newTypeDescriptionValue, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE, newTypeDescriptionValue, newTypeDescriptionValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE:
				return basicSetDescribedType(null, msgs);
			case SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE:
				return basicSetTypeDescriptionValue(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE:
				return getDescribedType();
			case SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE:
				return getTypeDescriptionValue();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE:
				setDescribedType((DescribedType)newValue);
				return;
			case SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE:
				setTypeDescriptionValue((TypeDescriptionValue)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE:
				setDescribedType((DescribedType)null);
				return;
			case SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE:
				setTypeDescriptionValue((TypeDescriptionValue)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.TYPE_MORPHISM__DESCRIBED_TYPE:
				return describedType != null;
			case SsmePackage.TYPE_MORPHISM__TYPE_DESCRIPTION_VALUE:
				return typeDescriptionValue != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		
		long typeNode = API.getNilTree();
		if (getDescribedType() != null) {
			typeNode = getDescribedType().makeAST();
		}
		
		long valeurNode = API.getNilTree();
		if (getTypeDescriptionValue() != null) {
			valeurNode = getTypeDescriptionValue().makeAST();
		}
		
		if (typeNode != PKTrees.ERROR_NODE && valeurNode != PKTrees.ERROR_NODE) {
			result = API.makeTernary(SignalOperators.optype, typeNode, valeurNode, API.getNilTree());
		}
		setASTAttribute(this, result);
		return result;
	}

} //TypeMorphismImpl
