/*******************************************************************************
 * Copyright (c) 2010, 2014 INRIA-CNRS (Espresso/TEA team).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Loic Besnard, Francois Fabre, Thierry Gautier: Initial API and implementation and/or initial documentation
 */

package org.eclipse.pop.ssme.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pop.ssme.Signals;
import org.eclipse.pop.ssme.SsmePackage;
import org.eclipse.pop.ssme.UnconditionedDependences;
import org.eclipse.pop.ssme.polychrony.PKTrees;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.SignalOperators;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Unconditioned Dependences</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.pop.ssme.impl.UnconditionedDependencesImpl#getSignals <em>Signals</em>}</li>
 *   <li>{@link org.eclipse.pop.ssme.impl.UnconditionedDependencesImpl#getDependenceElementsList <em>Dependence Elements List</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UnconditionedDependencesImpl extends SignalElementImpl implements UnconditionedDependences {
	/**
	 * The cached value of the '{@link #getSignals() <em>Signals</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSignals()
	 * @generated
	 * @ordered
	 */
	protected Signals signals;

	/**
	 * The cached value of the '{@link #getDependenceElementsList() <em>Dependence Elements List</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependenceElementsList()
	 * @generated
	 * @ordered
	 */
	protected EList<Signals> dependenceElementsList;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnconditionedDependencesImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SsmePackage.eINSTANCE.getUnconditionedDependences();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signals getSignals() {
		return signals;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSignals(Signals newSignals, NotificationChain msgs) {
		Signals oldSignals = signals;
		signals = newSignals;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS, oldSignals, newSignals);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSignals(Signals newSignals) {
		if (newSignals != signals) {
			NotificationChain msgs = null;
			if (signals != null)
				msgs = ((InternalEObject)signals).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS, null, msgs);
			if (newSignals != null)
				msgs = ((InternalEObject)newSignals).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS, null, msgs);
			msgs = basicSetSignals(newSignals, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS, newSignals, newSignals));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Signals> getDependenceElementsList() {
		if (dependenceElementsList == null) {
			dependenceElementsList = new EObjectContainmentEList<Signals>(Signals.class, this, SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST);
		}
		return dependenceElementsList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS:
				return basicSetSignals(null, msgs);
			case SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST:
				return ((InternalEList<?>)getDependenceElementsList()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS:
				return getSignals();
			case SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST:
				return getDependenceElementsList();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS:
				setSignals((Signals)newValue);
				return;
			case SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST:
				getDependenceElementsList().clear();
				getDependenceElementsList().addAll((Collection<? extends Signals>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS:
				setSignals((Signals)null);
				return;
			case SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST:
				getDependenceElementsList().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SsmePackage.UNCONDITIONED_DEPENDENCES__SIGNALS:
				return signals != null;
			case SsmePackage.UNCONDITIONED_DEPENDENCES__DEPENDENCE_ELEMENTS_LIST:
				return dependenceElementsList != null && !dependenceElementsList.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public long makeAST() {
		PKTrees API = PkPlugin.getTreeAPI();
		long result = PKTrees.ERROR_NODE;
		long signauxSimpleNode = API.getNilTree();
		if (getSignals() != null) signauxSimpleNode = getSignals().makeAST();
		long signauxListNode = API.getNilTree();
		EList<Signals>  l= getDependenceElementsList();
		if ( l != null && ! l.isEmpty())
			if (l.size()>1)
			{	// { x1,...,xn} --> { y1,...ym}--> { z1,...zo}
				signauxListNode = API.makeEmptyList(SignalOperators.opldep);
				for (Signals signals : l)
				{
					long signauxNode = signals.makeAST();
					if (signauxNode != PKTrees.ERROR_NODE) signauxListNode = API.post(signauxListNode, signauxNode);
				}
			}
			else
			{	// { x1,...,xn} --> { y1,...ym}
				Signals signals = l.get(0);
				signauxListNode = signals.makeAST();
			}
		
		if (signauxSimpleNode != PKTrees.ERROR_NODE && signauxListNode != PKTrees.ERROR_NODE) 
			result = API.makeBinary(SignalOperators.opldep, signauxSimpleNode, signauxListNode);
		setASTAttribute(this, result);
		return result;
	}

} //UnconditionedDependencesImpl
