/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.popup.actions;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyDiagnostic;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyMarkerHelper;
import org.eclipse.swt.widgets.Display;

public class CompilationUtils {
    public static final String EXTENSION_SIGNAL_EMF_MODEL = "SSME";
    public static final String EXTENSION_SIGNAL_TEXTUAL_FILE = "SIG";
    public static final String ERROR_SIGNALTOOLBOX_NOT_LOADED = "Cannot access to the Signal ToolBox (not loaded or bad version).";
    public static final String ERROR_GENERATION = "Some errors has been detected during the generation. Check the Problem view and correct them.";
    public static final String ERROR_SCENARIO = "Execute scenario error";
    public static final String ERROR_CODE_GENERATION = "Code Generation error";
    public static final String ERROR_NO_FILE_SELECTED = "No file selected";
    public static final String ERROR_NO_SCENARIO_SELECTED = "No compilation scenario selected";
    public static final String ERROR_FILE_EXTENSION = "The file is neither a Signal model nor a Signal textual file.";
    public static final String ERROR_MORE_THAN_ONE_ROOT_ELEMENT = "The sme file must only have one single root element.";
    public static final String ERROR_NO_ROOT_MODEL = "No root model was found in the Signal model file.";
    public static final String ERROR_INVALID_MODEL = "The model is not valid. Correct these errors before calling compiler functionalities.";
    public static final String ERROR_TREE = "Error during the creation of the abstract syntax tree: too many errors to correct before compiling.";
    public static final String ERROR_GRAPH = "Error during the graph transformation: ";
    public static final String ERROR_NOT_IMPLEMENTED = "Feature not yet implemented:";
    public static final String ERROR_ABSTRACTION = "Error during the abstraction building step";
    public static final String ERROR_BOOLEAN_TO_EVENTS = "Error during the boolean to events transformation step";
    public static final String ERROR_CLOCK_CALCULUS = "Error during the clock calculus step";
    public static final String ERROR_BOOLEANIZING = "Error during the booleanizing operation";
    public static final String ERROR_CYCLE_DETECTION = "Error during the cycle detection operation";
    public static final String ERROR_EVENTS_TO_BOOLEANS = "Error during the events to booleans pruning operation";
    public static final String ERROR_FLATTENING = "Error during the flattening step";
    public static final String ERROR_RETIMING = "Error during the retiming step";
    public static final String ERROR_SEQUENTIALIZING = "Error during the sequentializing operation";
    public static final String ERROR_SIGNAL_UNIFICATION = "Error during the signal unification step";
    public static final String ERROR_C_GENERATION = "Error during the C code generation";
    public static final String ERROR_CPP_GENERATION = "Error during the CPP code generation";
    public static final String ERROR_JAVA_GENERATION = "Error during the Java code generation";
    public static final String ERROR_LUSTRE_GENERATION = "Error during the Lustre code generation";
    public static final String ERROR_PROFILING = "Error during the profiling";
    public static final String ERROR_SIGALI_GENERATION = "Error during the Sigali code generation";
    public static final String ERROR_SIGNAL_GENERATION = "Error during the Signal code generation";
    public static final String ERROR_SIGNAL_ABSTRACTION_GENERATION = "Error during the Signal Abstraction generation";
    public static final String ERROR_SIGNAL_MODEL_GENERATION = "Error during the generation of the Signal model file.";
    public static final String ERROR_SYNDEX_GENERATION = "Error during the SynDEx code generation";
    public static final String ERROR_DELAY_TREE_GENERATION = "Error during the delay Tree generation";
    public static final String ERROR_EVENTS_TO_BOOLEANS_BOOLEANIZING = "Error during the events to Booleans Booleanizing operation";
    public static final String ERROR_CLOCK_ANALYSIS_ARRAYS_ITERATE = "Error during the analysis of the clocks of the arrays/iterates";
    public static final String WARNING_CLUSTERING_TITLE = "Force the clustering ?";
    public static final String WARNING_CLUSTERING_TEXT = "There are some unresolved constraints. Do you want to force the clustering operation ?";
    public static final String WARNING_SEQUENTIALIZING_TITLE = "Force the sequentializing ?";
    public static final String WARNING_SEQUENTIALIZING_TEXT = "There are some unresolved constraints. Do you want to force the sequentializing operation ?";
    public static final String INFO_WAITED_VZERSION = "Waited Signal ToolBox version = ";
    public static final String INFO_SIGNALTOOLBOX_NOT_LOADED = "See Help-> Help contents --> Pop documentation->user guide";
    private String saveLibraryPath;
    private List<IResource> resources;

    public String getSaveLibraryPath() {
        return this.saveLibraryPath;
    }

    public void setSaveLibraryPath(String saveLibraryPath) {
        this.saveLibraryPath = saveLibraryPath;
    }

    public List<IResource> getResources() {
        return this.resources;
    }

    public void setResources(List<IResource> resources) {
        this.resources = resources;
    }

    public void refreshContent() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    for (IResource res : CompilationUtils.this.resources) {
                        res.refreshLocal(2, null);
                    }
                }
                catch (CoreException ce) {
                    CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 0, "Refreshing error.", (Throwable)ce));
                }
            }
        });
    }

    public void refreshErrors(final IFile file) {
        final Diagnostic diagnostic = PolychronyDiagnostic.getUniqueDiagnostics();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PolychronyMarkerHelper.INSTANCE.deleteMarkers((Object)file, true, 0);
                try {
                    for (IResource res : CompilationUtils.this.getResources()) {
                        res.refreshLocal(2, null);
                    }
                }
                catch (CoreException ce) {
                    CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 0, "Refreshing error.", (Throwable)ce));
                }
                if (diagnostic.getSeverity() != 0) {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        PolychronyMarkerHelper.INSTANCE.createMarkers(file, childDiagnostic);
                    }
                }
            }
        });
        PolychronyDiagnostic.clear();
    }

    public Scenario checkFile(File file) {
        Scenario scenario = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource = resourceSet.getResource(fileURI, true);
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof Scenario)) continue;
            scenario = (Scenario)obj;
        }
        return scenario;
    }

    public String getPluginPath(String pluginName) {
        String returnValue = "";
        URL pluginRootUrl = Platform.getBundle((String)pluginName).getEntry("/src");
        try {
            returnValue = new File(FileLocator.toFileURL((URL)pluginRootUrl).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public void addPathSignalLibraryPath(IPath dir) {
        String value = this.saveLibraryPath;
        if (!"".equals(value)) {
            value = String.valueOf(value) + File.pathSeparator;
        }
        value = String.valueOf(value) + dir.toOSString();
        PkPlugin.getServices().setEnv("SIGNAL_LIBRARY_PATH", value);
    }

    public boolean validModel(Resource resource) {
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        boolean result = true;
        for (EObject obj : resource.getContents()) {
            IStatus status = validator.validate(obj);
            boolean bl = result = status.isOK() && result;
        }
        return result;
    }

    public void printBanner() {
        PolychronyConsole.printInfo((String)"\n=============================================\n");
    }
}

