/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.popup.actions;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pop.ssme.RootModel;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.utils.dialogs.FindCompilationScenarioDialog;
import org.eclipse.pop.ssme.compilation.utils.jobs.CompilingMethods;
import org.eclipse.pop.ssme.compilation.utils.jobs.ExecuteScenarioJob;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.BatchCompiling;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.CompilationUtils;
import org.eclipse.pop.ssme.compilation.utils.popup.actions.InteractiveCompiling;
import org.eclipse.pop.ssme.polychrony.ExitStatus;
import org.eclipse.pop.ssme.polychrony.GraphValue;
import org.eclipse.pop.ssme.polychrony.PkPlugin;
import org.eclipse.pop.ssme.polychrony.utils.PolychronyConsole;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateAction
implements IObjectActionDelegate {
    private static final String SCENARIO_EXECUTION = "Execute a compilation scenario";
    private static final String C_GENERATION = "Generate C files";
    private static final String CPP_GENERATION = "Generate CPP files";
    private static final String JAVA_GENERATION = "Generate Java files";
    private static final String SIG_GENERATION = "Generate Signal textual file";
    private static final String SIG_LIS_GENERATION = "Generate Signal textual (LIS) file";
    private static final String SIG_TRA_GENERATION = "Generate Signal textual (TRA) file";
    private static final String SIGNAL_MODEL_GENERATION = "Generate Signal model(SSME) file";
    private static final String INTERACTIVE_COMPILATION = "Interactive Compiling";
    private static final String BATCH_COMPILING = "Batch Compiling";
    private IFile sourceFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        CompilationUtils compilationUtils = new CompilationUtils();
        String actionID = action.getText();
        compilationUtils.setResources(new LinkedList<IResource>());
        if (!PkPlugin.getServices().isSignalToolBoxLoaded()) {
            PolychronyConsole.printDetectedError((String)"Cannot access to the Signal ToolBox (not loaded or bad version).");
            PolychronyConsole.printInfo((String)"See Help-> Help contents --> Pop documentation->user guide");
            PolychronyConsole.printNewLine();
            PolychronyConsole.printInfo((String)("Waited Signal ToolBox version = " + PkPlugin.getServices().getWaitedVersion()));
            PolychronyConsole.printNewLine();
        } else if (this.sourceFile != null) {
            compilationUtils.getResources().add((IResource)this.sourceFile.getParent());
            if (actionID.equals(SCENARIO_EXECUTION)) {
                FindCompilationScenarioDialog dialog = new FindCompilationScenarioDialog(new Shell());
                if (dialog.open() == 0) {
                    Scenario scenario = dialog.getScenario();
                    if (scenario != null) {
                        this.executeScenario(scenario, compilationUtils);
                    } else {
                        MessageDialog.openError((Shell)new Shell(), (String)"Execute scenario error", (String)"No compilation scenario selected");
                    }
                }
            } else {
                String projectPath = compilationUtils.getPluginPath("org.eclipse.pop.ssme.compilation.utils");
                projectPath = String.valueOf(projectPath) + GenerateAction.class.getResource("").getPath();
                boolean isSimpleScenario = true;
                File file = null;
                if (actionID.equals(C_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "CGeneration.ssc");
                } else if (actionID.equals(CPP_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "CPPGeneration.ssc");
                } else if (actionID.equals(JAVA_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "JavaGeneration.ssc");
                } else if (actionID.equals(SIG_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "SIGGeneration.ssc");
                } else if (actionID.equals(SIG_LIS_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "SIGLISGeneration.ssc");
                } else if (actionID.equals(SIG_TRA_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "SIGTRAGeneration.ssc");
                } else if (actionID.equals(SIGNAL_MODEL_GENERATION)) {
                    file = new File(String.valueOf(projectPath) + "SSMEGeneration.ssc");
                } else {
                    isSimpleScenario = false;
                }
                if (isSimpleScenario) {
                    Scenario scenario = compilationUtils.checkFile(file);
                    this.executeScenario(scenario, compilationUtils);
                } else if (actionID.equals(INTERACTIVE_COMPILATION) || actionID.equals(BATCH_COMPILING)) {
                    CompilingMethods compilingMethods = new CompilingMethods();
                    long tree = 0L;
                    boolean isSignalTextualFile = this.sourceFile.getFileExtension().equalsIgnoreCase("SIG");
                    boolean isSignalEMFModel = this.sourceFile.getFileExtension().equalsIgnoreCase("SSME");
                    compilationUtils.printBanner();
                    PolychronyConsole.printInfo((String)("Input file : " + this.sourceFile.getFullPath() + "\n\n"));
                    compilationUtils.setSaveLibraryPath(PkPlugin.getServices().getEnv("SIGNAL_LIBRARY_PATH"));
                    IPath fileLocation = this.sourceFile.getLocation();
                    IPath fileDirectory = fileLocation.removeFileExtension();
                    if (isSignalTextualFile) {
                        tree = PkPlugin.getParser().parseSrcfile(fileLocation.toOSString());
                    } else if (isSignalEMFModel) {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createFileURI((String)fileLocation.toOSString());
                        Resource resource = resourceSet.getResource(fileURI, true);
                        if (resource.getContents().size() == 1) {
                            EObject obj = (EObject)resource.getContents().get(0);
                            if (obj instanceof RootModel) {
                                RootModel rootModel = (RootModel)obj;
                                if (compilationUtils.validModel(resource)) {
                                    PkPlugin.getTraceabilityAPI().clearMap();
                                    tree = rootModel.makeAST();
                                    PkPlugin.getTraceabilityAPI().initializeSSMENodesList();
                                    PkPlugin.getTraceabilityAPI().printInformations(false);
                                    PkPlugin.getTraceabilityAPI().printTree(tree, 0, false);
                                } else {
                                    PolychronyConsole.printDetectedError((String)"The model is not valid. Correct these errors before calling compiler functionalities.");
                                }
                            } else {
                                PolychronyConsole.printDetectedError((String)"No root model was found in the Signal model file.");
                            }
                        } else {
                            PolychronyConsole.printDetectedError((String)"The sme file must only have one single root element.");
                        }
                    }
                    if (tree != -1L) {
                        compilingMethods.generateSignal(tree, fileDirectory);
                        compilationUtils.addPathSignalLibraryPath(fileDirectory);
                        GraphValue graphValue = PkPlugin.getServices().tree2DCG(tree, true, PkPlugin.getTreeAPI().getNilTree(), true, fileDirectory.toOSString(), false, isSignalEMFModel);
                        if (graphValue.isOk()) {
                            if (actionID.equals(INTERACTIVE_COMPILATION)) {
                                new InteractiveCompiling(compilingMethods, tree, this.sourceFile, graphValue, compilationUtils);
                            } else if (actionID.equals(BATCH_COMPILING)) {
                                new BatchCompiling(compilingMethods, tree, this.sourceFile, graphValue, compilationUtils, fileDirectory);
                            }
                            compilationUtils.refreshContent();
                        } else {
                            PkPlugin.getTraceabilityAPI().printErrorsOnModel(tree, false);
                            PolychronyConsole.printDetectedError((String)("Error during the graph transformation: " + ExitStatus.get((int)graphValue.getReturnCode()).getLiteral()));
                            compilationUtils.refreshErrors(this.sourceFile);
                        }
                    } else {
                        PolychronyConsole.printDetectedError((String)"Error during the creation of the abstract syntax tree: too many errors to correct before compiling.");
                    }
                }
            }
        } else {
            MessageDialog.openError((Shell)new Shell(), (String)"Code Generation error", (String)"No file selected");
        }
    }

    public void printBanner(boolean bannouncepk) {
        PolychronyConsole.printInfo((String)"\n=============================================\n");
    }

    public void executeScenario(Scenario scenario, CompilationUtils compilationUtils) {
        ExecuteScenarioJob execute = new ExecuteScenarioJob(this.sourceFile, scenario, compilationUtils);
        execute.setUser(true);
        execute.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.sourceFile = (IFile)((StructuredSelection)selection).getFirstElement();
        }
    }
}

