/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.utils.views;

import java.util.HashMap;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pop.ssme.compilation.Functionality;
import org.eclipse.pop.ssme.compilation.FunctionalityKind;
import org.eclipse.pop.ssme.compilation.Generator;
import org.eclipse.pop.ssme.compilation.GeneratorKind;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.ScenarioItem;
import org.eclipse.pop.ssme.compilation.SsmeCompFactory;
import org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl;
import org.eclipse.pop.ssme.compilation.utils.CompilationUtilsPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class CompilationView
extends ViewPart
implements ISelectionListener {
    private static final String FILE_EXTENSION = "ssc";
    private Group functionalities;
    private Button[] functionality_btn = new Button[FunctionalityKind.VALUES.size()];
    private Group generators;
    private Button[] generator_btn = new Button[GeneratorKind.VALUES.size()];
    private Group scenario;
    private Text descriptionTxt;
    private List scenario_lst;
    private Button displayWarnings_btn;
    private Button load_btn;
    private Button save_btn;
    private Button save_as_btn;
    private Button reset_btn;
    private CompilerSelectionListener listener = new CompilerSelectionListener();
    private String filePath = null;
    private boolean isScenarioSaved = true;

    public void createPartControl(Composite parent) {
        FunctionalityKind val;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        this.functionalities = new Group(composite, 32);
        this.functionalities.setText("Functionalities");
        this.functionalities.setLayout((Layout)new GridLayout(2, true));
        int i = 0;
        while (i < FunctionalityKind.VALUES.size()) {
            this.functionality_btn[i] = new Button((Composite)this.functionalities, 8);
            val = FunctionalityKind.get((int)i);
            this.functionality_btn[i].setText(val.getLiteral());
            this.functionality_btn[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.functionality_btn[i].addSelectionListener((SelectionListener)this.listener);
            ++i;
        }
        this.generators = new Group(composite, 32);
        this.generators.setText("Generators");
        this.generators.setLayout((Layout)new GridLayout(2, true));
        i = 0;
        while (i < GeneratorKind.VALUES.size()) {
            this.generator_btn[i] = new Button((Composite)this.generators, 8);
            val = GeneratorKind.get((int)i);
            this.generator_btn[i].setText(val.getLiteral());
            this.generator_btn[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.generator_btn[i].addSelectionListener((SelectionListener)this.listener);
            ++i;
        }
        this.scenario = new Group(composite, 32);
        this.scenario.setText("Scenario: none");
        Label lbl = new Label((Composite)this.scenario, 0);
        lbl.setText("Description:");
        lbl.setBounds(10, 15, 200, 15);
        this.descriptionTxt = new Text((Composite)this.scenario, 0);
        this.descriptionTxt.setBounds(10, 30, 200, 15);
        this.scenario_lst = new List((Composite)this.scenario, 2564);
        this.scenario_lst.setBounds(10, 50, 200, 140);
        this.displayWarnings_btn = new Button((Composite)this.scenario, 32);
        this.displayWarnings_btn.setText("Display all warnings");
        this.displayWarnings_btn.setBounds(10, 195, 200, 12);
        this.displayWarnings_btn.addSelectionListener((SelectionListener)this.listener);
        Composite buttons = new Composite(composite, 0);
        buttons.setBounds(890, 10, 100, 150);
        buttons.setLayout((Layout)new FillLayout(512));
        this.load_btn = new Button(buttons, 8);
        this.load_btn.setText("Load");
        this.load_btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CompilationView.this.loadScenario();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CompilationView.this.loadScenario();
            }
        });
        this.save_btn = new Button(buttons, 8);
        this.save_btn.setText("Save");
        this.save_btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CompilationView.this.saveScenario(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CompilationView.this.saveScenario(false);
            }
        });
        this.save_as_btn = new Button(buttons, 8);
        this.save_as_btn.setText("Save As");
        this.save_as_btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CompilationView.this.saveScenario(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CompilationView.this.saveScenario(true);
            }
        });
        this.reset_btn = new Button(buttons, 8);
        this.reset_btn.setText("Reset");
        this.reset_btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CompilationView.this.reset();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CompilationView.this.reset();
            }
        });
        this.reset();
    }

    private void reset() {
        this.filePath = null;
        this.isScenarioSaved = true;
        this.scenario.setText("Scenario: none");
        this.descriptionTxt.setText("");
        this.displayWarnings_btn.setSelection(false);
        this.scenario_lst.removeAll();
        this.save_btn.setEnabled(false);
        this.save_as_btn.setEnabled(false);
        this.functionality_btn[0].setEnabled(true);
        this.functionality_btn[1].setEnabled(true);
        this.functionality_btn[2].setEnabled(true);
        this.functionality_btn[3].setEnabled(true);
        this.functionality_btn[4].setEnabled(true);
        this.functionality_btn[5].setEnabled(true);
        this.generator_btn[0].setEnabled(true);
        this.generator_btn[5].setEnabled(true);
        this.generator_btn[3].setEnabled(true);
        this.functionality_btn[6].setEnabled(false);
        this.functionality_btn[7].setEnabled(false);
        this.functionality_btn[8].setEnabled(false);
        this.generator_btn[4].setEnabled(false);
        this.generator_btn[6].setEnabled(false);
        this.generator_btn[7].setEnabled(false);
        this.generator_btn[8].setEnabled(false);
        this.generator_btn[9].setEnabled(false);
        this.generator_btn[10].setEnabled(false);
        this.generator_btn[11].setEnabled(false);
    }

    public void setFocus() {
        this.functionality_btn[0].setFocus();
    }

    public void loadScenario() {
        if (!this.isScenarioSaved) {
            MessageBox messageBox = new MessageBox(this.getSite().getShell(), 196);
            messageBox.setMessage("Do you want to save your scenario before loading the new one ?");
            messageBox.setText("Saving scenario");
            int response = messageBox.open();
            if (response == 64) {
                this.saveScenario(false);
            }
        }
        FileDialog loadDialog = new FileDialog(this.getSite().getShell(), 4096);
        loadDialog.setFilterExtensions(new String[]{"*.ssc"});
        loadDialog.setText("Load Scenario...");
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        loadDialog.setFilterPath(ws.getLocation().toString());
        String path = loadDialog.open();
        if (path != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)path);
            Resource resource = resourceSet.getResource(fileURI, true);
            Scenario scenario_model = null;
            for (EObject obj : resource.getContents()) {
                if (!(obj instanceof Scenario)) continue;
                scenario_model = (Scenario)obj;
            }
            if (scenario_model == null) {
                MessageBox messageBox = new MessageBox(this.getSite().getShell(), 33);
                messageBox.setMessage("The file \"" + path + "\" does not contain a compilation scenario.");
                messageBox.setText("Saving scenario");
                messageBox.open();
            } else {
                this.reset();
                this.filePath = path;
                this.displayWarnings_btn.setSelection(scenario_model.isDisplayWarnings());
                for (ScenarioItem item : scenario_model.getElements()) {
                    FunctionalityKind kind;
                    if (item instanceof FunctionalityImpl) {
                        kind = ((FunctionalityImpl)item).getKind();
                        this.activateButton(this.functionality_btn[kind.getValue()]);
                        continue;
                    }
                    if (!(item instanceof Generator)) continue;
                    kind = ((Generator)item).getKind();
                    this.activateButton(this.generator_btn[kind.getValue()]);
                }
                this.isScenarioSaved = true;
                this.scenario.setText("Scenario: " + fileURI.trimFileExtension().lastSegment());
                if (scenario_model.getDescription() != null) {
                    this.descriptionTxt.setText(scenario_model.getDescription());
                }
            }
        }
    }

    public void saveScenario(boolean force) {
        if (force || this.filePath == null) {
            FileDialog saveDialog = new FileDialog(this.getSite().getShell(), 8192);
            saveDialog.setFilterExtensions(new String[]{"*.ssc"});
            saveDialog.setText("Save Scenario as...");
            IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
            saveDialog.setFilterPath(ws.getLocation().toString());
            this.filePath = saveDialog.open();
            if (this.filePath == null) {
                return;
            }
            if (!this.filePath.endsWith(".ssc")) {
                this.filePath = String.valueOf(this.filePath) + ".ssc";
            }
        }
        Scenario scenario_model = SsmeCompFactory.eINSTANCE.createScenario();
        scenario_model.setDisplayWarnings(this.displayWarnings_btn.getSelection());
        String[] items = this.scenario_lst.getItems();
        int i = 0;
        while (i < items.length) {
            FunctionalityKind func = FunctionalityKind.get((String)items[i]);
            if (func != null) {
                Functionality f = SsmeCompFactory.eINSTANCE.createFunctionality();
                f.setKind(func);
                scenario_model.getElements().add((Object)f);
            } else {
                GeneratorKind gen = GeneratorKind.get((String)items[i]);
                if (gen != null) {
                    Generator g = SsmeCompFactory.eINSTANCE.createGenerator();
                    g.setKind(gen);
                    scenario_model.getElements().add((Object)g);
                } else {
                    CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", "Unrecognized features in the scenario : " + items[i]));
                }
            }
            ++i;
        }
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)this.filePath);
            String filename = fileURI.lastSegment();
            filename = filename.substring(0, filename.length() - 1 - FILE_EXTENSION.length());
            if (this.descriptionTxt.getText() != null) {
                scenario_model.setDescription(this.descriptionTxt.getText());
            } else {
                scenario_model.setDescription(filename);
            }
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)scenario_model);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.save(options);
            this.isScenarioSaved = true;
            this.scenario.setText("Scenario: " + filename);
        }
        catch (Exception exception) {
            CompilationUtilsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.pop.ssme.compilation.utils", 0, "Save Scenario error.", (Throwable)exception));
        }
    }

    private void activateButton(Button btn) {
        this.isScenarioSaved = false;
        this.save_btn.setEnabled(true);
        this.save_as_btn.setEnabled(true);
        if (btn.equals(this.displayWarnings_btn)) {
            return;
        }
        String literal = btn.getText();
        this.scenario_lst.add(btn.getText());
        if (btn.getParent().equals(this.functionalities)) {
            btn.setEnabled(false);
            FunctionalityKind func = FunctionalityKind.get((String)literal);
            if (FunctionalityKind.EVENTS2_BOOLEAN_LITERAL.equals((Object)func)) {
                this.functionality_btn[0].setEnabled(false);
                this.functionality_btn[1].setEnabled(false);
                this.functionality_btn[2].setEnabled(false);
                this.functionality_btn[3].setEnabled(false);
                this.functionality_btn[5].setEnabled(false);
                this.functionality_btn[6].setEnabled(true);
                this.functionality_btn[7].setEnabled(true);
                this.functionality_btn[8].setEnabled(true);
                this.generator_btn[9].setEnabled(true);
                this.generator_btn[11].setEnabled(false);
            } else if (FunctionalityKind.ABSTRACTION_LITERAL.equals((Object)func)) {
                this.functionality_btn[0].setEnabled(false);
                this.functionality_btn[1].setEnabled(false);
                this.functionality_btn[2].setEnabled(false);
                this.functionality_btn[3].setEnabled(false);
                this.functionality_btn[4].setEnabled(false);
                this.functionality_btn[6].setEnabled(true);
                this.functionality_btn[7].setEnabled(true);
                this.functionality_btn[8].setEnabled(true);
                this.generator_btn[4].setEnabled(true);
                this.generator_btn[9].setEnabled(true);
            } else if (FunctionalityKind.SEQUENTIALIZING_LITERAL.equals((Object)func)) {
                this.functionality_btn[6].setEnabled(false);
                this.functionality_btn[8].setEnabled(false);
                this.generator_btn[6].setEnabled(true);
                this.generator_btn[7].setEnabled(true);
                this.generator_btn[8].setEnabled(true);
                this.generator_btn[10].setEnabled(true);
                this.generator_btn[11].setEnabled(true);
            } else if (FunctionalityKind.FLATTENING_LITERAL.equals((Object)func)) {
                this.functionality_btn[7].setEnabled(false);
                this.generator_btn[11].setEnabled(false);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    class CompilerSelectionListener
    implements SelectionListener {
        CompilerSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Button btn = (Button)event.getSource();
            CompilationView.this.activateButton(btn);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            Button btn = (Button)event.getSource();
            CompilationView.this.activateButton(btn);
        }
    }
}

