/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.compilation.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.pop.ssme.compilation.Functionality;
import org.eclipse.pop.ssme.compilation.FunctionalityKind;
import org.eclipse.pop.ssme.compilation.Generator;
import org.eclipse.pop.ssme.compilation.GeneratorKind;
import org.eclipse.pop.ssme.compilation.Scenario;
import org.eclipse.pop.ssme.compilation.SsmeCompFactory;
import org.eclipse.pop.ssme.compilation.SsmeCompPackage;
import org.eclipse.pop.ssme.compilation.impl.FunctionalityImpl;
import org.eclipse.pop.ssme.compilation.impl.GeneratorImpl;
import org.eclipse.pop.ssme.compilation.impl.ScenarioImpl;

public class SsmeCompFactoryImpl
extends EFactoryImpl
implements SsmeCompFactory {
    public static SsmeCompFactory init() {
        try {
            SsmeCompFactory theSsmeCompFactory = (SsmeCompFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.irisa.fr/espresso/SsmeCompilation.ecore");
            if (theSsmeCompFactory != null) {
                return theSsmeCompFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SsmeCompFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createScenario();
            }
            case 1: {
                return this.createFunctionality();
            }
            case 2: {
                return this.createGenerator();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createGeneratorKindFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createFunctionalityKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertGeneratorKindToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertFunctionalityKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Scenario createScenario() {
        ScenarioImpl scenario = new ScenarioImpl();
        return scenario;
    }

    @Override
    public Functionality createFunctionality() {
        FunctionalityImpl functionality = new FunctionalityImpl();
        return functionality;
    }

    @Override
    public Generator createGenerator() {
        GeneratorImpl generator = new GeneratorImpl();
        return generator;
    }

    public GeneratorKind createGeneratorKindFromString(EDataType eDataType, String initialValue) {
        GeneratorKind result = GeneratorKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertGeneratorKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public FunctionalityKind createFunctionalityKindFromString(EDataType eDataType, String initialValue) {
        FunctionalityKind result = FunctionalityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFunctionalityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SsmeCompPackage getSsmeCompPackage() {
        return (SsmeCompPackage)this.getEPackage();
    }

    @Deprecated
    public static SsmeCompPackage getPackage() {
        return SsmeCompPackage.eINSTANCE;
    }
}

