/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.polychrony;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LanguageCode implements Enumerator
{
    UNDEFINED_LITERAL(-1, "undefined", "undefined"),
    C_CODE_LITERAL(0, "C_CODE", "C_CODE"),
    CPP_CODE_LITERAL(1, "CPP_CODE", "CPP_CODE"),
    JAVA_CODE_LITERAL(2, "JAVA_CODE", "JAVA_CODE");

    public static final int UNDEFINED = -1;
    public static final int C_CODE = 0;
    public static final int CPP_CODE = 1;
    public static final int JAVA_CODE = 2;
    private static final LanguageCode[] VALUES_ARRAY;
    public static final List<LanguageCode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LanguageCode[]{UNDEFINED_LITERAL, C_CODE_LITERAL, CPP_CODE_LITERAL, JAVA_CODE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LanguageCode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCode get(int value) {
        switch (value) {
            case -1: {
                return UNDEFINED_LITERAL;
            }
            case 0: {
                return C_CODE_LITERAL;
            }
            case 1: {
                return CPP_CODE_LITERAL;
            }
            case 2: {
                return JAVA_CODE_LITERAL;
            }
        }
        return UNDEFINED_LITERAL;
    }

    private LanguageCode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

