/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pop.ssme.texteditor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SignalEditorScanner
extends RuleBasedScanner {
    private static final Color COLOR_KEYWORD;
    private static final Color COLOR_COMMENT;
    private static final Color COLOR_CONSTANT;
    private static final Color COLOR_OTHER;
    private static final String[] KEYWORDS;

    static {
        Display d = PlatformUI.getWorkbench().getDisplay();
        COLOR_KEYWORD = new Color((Device)d, 127, 0, 85);
        COLOR_COMMENT = new Color((Device)d, 0, 128, 0);
        COLOR_CONSTANT = new Color((Device)d, 0, 0, 255);
        COLOR_OTHER = new Color((Device)d, 0, 0, 0);
        KEYWORDS = new String[]{"action", "after", "and", "array", "assert", "boolean", "bundle", "case", "cell", "char", "complex", "constant", "count", "dcomplex", "default", "defaultvalue", "deterministic", "dreal", "else", "end", "enum", "event", "external", "false", "from", "function", "if", "in", "init", "integer", "iterate", "label", "long", "module", "modulo", "next", "node", "not", "of", "operator", "or", "pragmas", "private", "process", "real", "ref", "safe", "shared", "short", "spec", "statevar", "step", "string", "struct", "then", "to", "tr", "true", "type", "unsafe", "use", "var", "when", "where", "window", "with", "xor"};
    }

    public SignalEditorScanner() {
        Token keyword = new Token((Object)new TextAttribute(COLOR_KEYWORD, null, 1));
        Token comment = new Token((Object)new TextAttribute(COLOR_COMMENT, null, 2));
        Token constant = new Token((Object)new TextAttribute(COLOR_CONSTANT, null, 1));
        Token other = new Token((Object)new TextAttribute(COLOR_OTHER));
        WordRule basicRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
        }, (IToken)other);
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            basicRule.addWord(k, (IToken)keyword);
            ++n2;
        }
        NumberRule numberRule = new NumberRule((IToken)constant);
        SingleLineRule charRule = new SingleLineRule("'", "'", (IToken)constant, '\\', true);
        MultiLineRule stringRule = new MultiLineRule("\"", "\"", (IToken)constant, '\\', true);
        MultiLineRule commentRule = new MultiLineRule("%", "%", (IToken)comment, '\u0000', true);
        this.setRules(new IRule[]{basicRule, commentRule, numberRule, charRule, stringRule});
    }
}

